/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.tool.MutexUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.base.wssc.IBillImageMap;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceConfig;
import com.kingdee.eas.base.wssc.imageNew.interfaces.IBillImage;
import com.kingdee.eas.base.wssc.imageNew.interfaces.impl.BillImageByBillIDImpl;
import com.kingdee.eas.base.wssc.imageNew.util.Configure;
import com.kingdee.eas.base.wssc.imageNew.util.MultiImageConfig;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.el.rec.AchRecordDetailCollection;
import com.kingdee.eas.el.rec.AchRecordDetailFactory;
import com.kingdee.eas.el.rec.AchRecordDetailInfo;
import com.kingdee.eas.el.rec.ArcContentTypeEnum;
import com.kingdee.eas.el.rec.ArcRecordCollection;
import com.kingdee.eas.el.rec.ArcRecordFactory;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.ArcStateEnum;
import com.kingdee.eas.el.rec.ArchFlagEnum;
import com.kingdee.eas.el.rec.ArchSchemeFacadeFactory;
import com.kingdee.eas.el.rec.AttachBillAchDetailCollection;
import com.kingdee.eas.el.rec.AttachBillAchDetailFactory;
import com.kingdee.eas.el.rec.AttachBillAchDetailInfo;
import com.kingdee.eas.el.rec.OperationEnum;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.model.ArchInfos;
import com.kingdee.eas.el.rec.model.BillXmlSrcObj;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.model.ImageInfo;
import com.kingdee.eas.el.rec.model.InvoiceInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.outputmodule.archsys.util.ThreadUtil;
import com.kingdee.eas.el.rec.thread.UploadArchInfosThreadPool;
import com.kingdee.eas.el.rec.thread.UploadBillArchInfosThread;
import com.kingdee.eas.el.rec.tool.ArchRecordUtils;
import com.kingdee.eas.el.rec.tool.DefaultBillHandler;
import com.kingdee.eas.el.rec.tool.ElProject;
import com.kingdee.eas.el.rec.tool.IBillHandler;
import com.kingdee.eas.el.rec.tool.IRefBillHandler;
import com.kingdee.eas.el.rec.tool.KDNoteWebServerHelper;
import com.kingdee.eas.el.rec.tool.PermissionOrgUtil;
import com.kingdee.eas.el.rec.tool.ThreadPoolInitFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ArchUtils {
    public static final String SSC_NUMBER = "EAS";
    public static final String IMAGE_SYSTEM_TYPE_KEY = "image.system.type";
    public static final String IMAGE_SYSTEM_IP = "image.ip";
    public static final String IMAGE_SYSTEM_PORT = "image.port";
    public static final String ERECEIPT_BOSTYPE = "F8FF7C09";
    public static final String ELEBANK_BOSTYPE = "B76C5DF9";
    public static final String RECORD_FILE_NAME = "recordId";
    public static final String RECJOB_BOSTYPE = "3439BEB0";
    public static final String JOBENTRY_BOSTYPE = "F08207A2";
    private static KDNoteWebServerHelper kdNoteWebServerHelper = new KDNoteWebServerHelper();
    private static Logger logger = Logger.getLogger((String)ArchUtils.class.getName());
    private static volatile ImageInfo imageInfo = null;
    public static Set<String> archFlagCache = Collections.newSetFromMap(new ConcurrentHashMap());
    public static Map<String, Integer> archNumCache = new ConcurrentHashMap<String, Integer>();

    public static AchRecordDetailCollection getAchRecordDetailCollectionLimit(Context ctx, SelectorItemCollection selectorItem, FilterItemCollection filterItem, String addSql) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String sql = "select count(a.fid) count from T_REC_AchRecordDetail a left join T_REC_AttachBillAchDetail b on a.fid = b.FAchRecordDetailID ";
        if (StringUtils.isEmpty((String)addSql)) {
            logger.error((Object)"\u53ef\u80fd\u4f1a\u6709\u597d\u591a\u6570\u636e\u8981\u67e5\u51fa\u6765\u4e86\uff0c\u51c6\u5907\u62a5\u9519~");
        }
        if (filterItem != null && filterItem.size() > 0) {
            filter.getFilterItems().addObjectCollection((IObjectCollection)filterItem);
        }
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("id");
        entityViewInfo.setSelector(selectorItemCollection);
        entityViewInfo.setBaseOnSelector(true);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql + addSql));
        int count = 0;
        int criticalCollection = 100000;
        try {
            if (rowSet.next()) {
                count = rowSet.getInt("count");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u6570\u91cf\u62a5\u9519", (Throwable)e);
        }
        IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
        if (manager != null) {
            criticalCollection = manager.getCriticalCollection();
        }
        if (count < criticalCollection) {
            selectorItemCollection.addObjectCollection((IObjectCollection)selectorItem);
            return AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailCollection(entityViewInfo);
        }
        return ArchUtils.getAchRecordDetailCollectionLimit0(ctx, selectorItem, selectorItemCollection, addSql, count, criticalCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AchRecordDetailCollection getAchRecordDetailCollectionLimit0(Context ctx, SelectorItemCollection selectorItem, SelectorItemCollection selectorItemCollection, String addSql, int number, int criticalCollection) throws BOSException {
        AchRecordDetailCollection newAchRecordDetailCollection = new AchRecordDetailCollection();
        EntityViewInfo newEntityViewInfo = new EntityViewInfo();
        selectorItemCollection.addObjectCollection((IObjectCollection)selectorItem);
        newEntityViewInfo.setSelector(selectorItemCollection);
        newEntityViewInfo.setBaseOnSelector(true);
        HashSet<String> idSet = new HashSet<String>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)(" select count(a.fid) count,a.fid from T_REC_AchRecordDetail a left join T_REC_AttachBillAchDetail b on a.fid = b.FAchRecordDetailID " + addSql + " group by a.fid "));
        int count = 0;
        ArrayList<String> numList = new ArrayList<String>(number);
        try {
            while (rowSet.next()) {
                numList.add(rowSet.getString("fid") + "#" + rowSet.getInt("count"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u6570\u91cf\u62a5\u9519", (Throwable)e);
        }
        int size = numList.size();
        String idTmpTable = "";
        for (int i = 0; i < size; ++i) {
            AchRecordDetailCollection subAchRecordDetailCollection;
            String[] value = ((String)numList.get(i)).split("#");
            idSet.add(value[0]);
            if ((count += Integer.parseInt(value[1])) <= criticalCollection) continue;
            if (idSet.size() == 1) {
                logger.error((Object)(value[0] + "\uff1a\u9644\u5c5e\u5355\u636e\u67e5\u8be2\u6570\u91cf\u8d85\u8fc7" + criticalCollection + "\u6761"));
                subAchRecordDetailCollection = ArchUtils.getOverCriticalCollections(ctx, value[0]);
            } else {
                logger.error((Object)("ORM\u67e5\u8be2\u6570\u91cf:" + count));
                idSet.remove(value[0]);
                --i;
                FilterInfo newFilter = new FilterInfo();
                try {
                    idTmpTable = ArchUtils.createIdTmpTable(ctx, idSet);
                    newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)("select fid from " + idTmpTable), CompareType.INNER));
                    newEntityViewInfo.setFilter(newFilter);
                    subAchRecordDetailCollection = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailCollection(newEntityViewInfo);
                }
                finally {
                    if (!StringUtils.isEmpty((String)idTmpTable)) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(idTmpTable);
                    }
                }
            }
            newAchRecordDetailCollection.addCollection(subAchRecordDetailCollection);
            idSet.clear();
            count = 0;
        }
        if (!idSet.isEmpty()) {
            AchRecordDetailCollection subAchRecordDetailCollection;
            FilterInfo newFilter = new FilterInfo();
            if (idSet.size() > 1000) {
                try {
                    idTmpTable = ArchUtils.createIdTmpTable(ctx, idSet);
                    newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)("select fid from " + idTmpTable), CompareType.INNER));
                    newEntityViewInfo.setFilter(newFilter);
                    subAchRecordDetailCollection = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailCollection(newEntityViewInfo);
                }
                finally {
                    if (!StringUtils.isEmpty((String)idTmpTable)) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(idTmpTable);
                    }
                }
            } else {
                newFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                newEntityViewInfo.setFilter(newFilter);
                subAchRecordDetailCollection = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailCollection(newEntityViewInfo);
            }
            newAchRecordDetailCollection.addCollection(subAchRecordDetailCollection);
        }
        return newAchRecordDetailCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AchRecordDetailCollection getOverCriticalCollections(Context ctx, String recordDetailId) throws BOSException {
        EntityViewInfo newEntityViewInfo = new EntityViewInfo();
        newEntityViewInfo.setBaseOnSelector(true);
        AchRecordDetailCollection subAchRecordDetailCollection = new AchRecordDetailCollection();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("id");
        selectorItemCollection.add("state");
        selectorItemCollection.add("billNumber");
        selectorItemCollection.add("billId");
        newEntityViewInfo.setSelector(selectorItemCollection);
        FilterInfo newFilter1 = new FilterInfo();
        newFilter1.getFilterItems().add(new FilterItemInfo("id", (Object)recordDetailId, CompareType.EQUALS));
        newEntityViewInfo.setFilter(newFilter1);
        AchRecordDetailInfo subAchRecordDetailInfo = null;
        AchRecordDetailCollection colls = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailCollection(newEntityViewInfo);
        subAchRecordDetailInfo = colls.get(0);
        newEntityViewInfo = new EntityViewInfo();
        newEntityViewInfo.setBaseOnSelector(true);
        String sql = "select fid from T_REC_AttachBillAchDetail where FAchRecordDetailID = '" + recordDetailId + "' ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        int maxIds = 30000;
        HashSet<String> attachBillSet = new HashSet<String>(maxIds);
        String idTmpTable = "";
        try {
            AttachBillAchDetailCollection attAchDetailCollection;
            FilterInfo newFilter;
            while (rowSet.next()) {
                if (attachBillSet.size() < maxIds) {
                    attachBillSet.add(rowSet.getString("fid"));
                    continue;
                }
                selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add("id");
                selectorItemCollection.add("state");
                selectorItemCollection.add("billNumber");
                selectorItemCollection.add("billId");
                selectorItemCollection.add("arcContent.*");
                newEntityViewInfo.setSelector(selectorItemCollection);
                newFilter = new FilterInfo();
                try {
                    idTmpTable = ArchUtils.createIdTmpTable(ctx, attachBillSet);
                    newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)("select fid from " + idTmpTable), CompareType.INNER));
                    newEntityViewInfo.setFilter(newFilter);
                    attAchDetailCollection = AttachBillAchDetailFactory.getLocalInstance(ctx).getAttachBillAchDetailCollection(newEntityViewInfo);
                    subAchRecordDetailInfo.getAttachBillAchDetails().addCollection(attAchDetailCollection);
                    attachBillSet.clear();
                }
                finally {
                    if (StringUtils.isEmpty((String)idTmpTable)) continue;
                    TempTablePool.getInstance((Context)ctx).releaseTable(idTmpTable);
                }
            }
            if (attachBillSet.size() > 0) {
                selectorItemCollection = new SelectorItemCollection();
                selectorItemCollection.add("id");
                selectorItemCollection.add("state");
                selectorItemCollection.add("billNumber");
                selectorItemCollection.add("billId");
                selectorItemCollection.add("arcContent.*");
                newEntityViewInfo.setSelector(selectorItemCollection);
                newFilter = new FilterInfo();
                if (attachBillSet.size() > 1000) {
                    try {
                        idTmpTable = ArchUtils.createIdTmpTable(ctx, attachBillSet);
                        newFilter.getFilterItems().add(new FilterItemInfo("id", (Object)("select fid from " + idTmpTable), CompareType.INNER));
                        newEntityViewInfo.setFilter(newFilter);
                        attAchDetailCollection = AttachBillAchDetailFactory.getLocalInstance(ctx).getAttachBillAchDetailCollection(newEntityViewInfo);
                        subAchRecordDetailInfo.getAttachBillAchDetails().addCollection(attAchDetailCollection);
                    }
                    finally {
                        if (!StringUtils.isEmpty((String)idTmpTable)) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(idTmpTable);
                        }
                    }
                } else {
                    newFilter.getFilterItems().add(new FilterItemInfo("id", attachBillSet, CompareType.INCLUDE));
                    newEntityViewInfo.setFilter(newFilter);
                    attAchDetailCollection = AttachBillAchDetailFactory.getLocalInstance(ctx).getAttachBillAchDetailCollection(newEntityViewInfo);
                    subAchRecordDetailInfo.getAttachBillAchDetails().addCollection(attAchDetailCollection);
                }
                attachBillSet.clear();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u67e5\u8be2\u539f\u59cb\u51ed\u8bc1\u6570\u636e\u51fa\u9519", e);
        }
        subAchRecordDetailCollection.add(subAchRecordDetailInfo);
        return subAchRecordDetailCollection;
    }

    public static String createIdTmpTable(Context ctx, Set<String> idSet) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        try {
            String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable("create table recorddetailid (fid varchar(44))");
            TempTablePool.getInstance((Context)ctx).createIndex(tempTable, "fid", false, false);
            conn = EJBFactory.getConnection((Context)ctx);
            String sql = "insert into " + tempTable + "(fid) values(?) ";
            stmt = conn.prepareStatement(sql);
            int i = 0;
            for (String id : idSet) {
                stmt.setString(1, id);
                stmt.addBatch();
                if (++i != 10000) continue;
                stmt.executeBatch();
                stmt.clearBatch();
                i = 0;
            }
            stmt.executeBatch();
            String string = tempTable;
            return string;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidate(Context ctx, ArcRecordInfo info, int num) {
        if (!ArcContentTypeEnum.BILL.equals((Object)info.getContentType())) {
            ArchUtils.releaseMutex(info.getArcRecordNum());
            return true;
        }
        String string = info.getArcRecordNum().intern();
        synchronized (string) {
            try {
                boolean b = ArchSchemeFacadeFactory.getLocalInstance(ctx).archFinished(info.getId().toString(), num);
                if (b) {
                    ArchUtils.releaseMutex(info.getArcRecordNum());
                }
                return b;
            }
            catch (EASBizException e) {
                logger.error((Object)(info.getArcRecordNum() + ":\u66f4\u65b0\u5f52\u6863\u603b\u8bb0\u5f55\u5931\u8d25!" + e.getMessage()), (Throwable)e);
                return false;
            }
            catch (BOSException e) {
                logger.error((Object)(info.getArcRecordNum() + ":\u66f4\u65b0\u5f52\u6863\u603b\u8bb0\u5f55\u5931\u8d25!" + e.getMessage()), (Throwable)e);
                return false;
            }
        }
    }

    public static void initArchNumCache(Context ctx, String key, int num, ArcRecordInfo info) throws EASBizException, BOSException {
        info.setArcNum(info.getArcNum() + 1);
        info.setTotalNum(num);
        ArcRecordFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(key), info);
    }

    public static void initArchNumCache(Context ctx, String key, ArchInfos arInfos, OperationEnum operation) throws EASBizException, BOSException {
        ArcRecordInfo info = ArcRecordFactory.getLocalInstance(ctx).getArcRecordInfo((IObjectPK)new ObjectUuidPK(key));
        if (operation == OperationEnum.FIRST_ARC) {
            info.setVoucherNum(arInfos.voucherSize());
            info.setOriginVcNum(arInfos.originVcSize());
        } else if (operation == OperationEnum.AFRESH_ARC) {
            if (arInfos.voucherSize() != 0 || arInfos.originVcSize() != 0) {
                info.setVoucherNum(info.getVoucherNum() + arInfos.afreshVoucherSize());
                info.setOriginVcNum(info.getOriginVcNum() + arInfos.afreshOriginVcSize());
            } else {
                logger.error((Object)("\u91cd\u65b0\u5f52\u6863\u8bbe\u7f6e\u51ed\u8bc1\u603b\u6570\u548c\u603b\u6570\u5931\u8d25 size=0;VoucherNum:" + arInfos.voucherSize() + ";OriginVcNum:" + arInfos.originVcSize()));
            }
        } else if (operation == OperationEnum.FAIL_ARC) {
            // empty if block
        }
        info.setTotalNum(arInfos.size());
        ArcRecordFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(key), info);
    }

    public static List<XmlBase> setArchProperties(Context ctx, String arcRecordId, List<XmlBase> xmlBases, String bosType, Boolean invoice) throws BOSException, EASBizException {
        for (int i = xmlBases.size() - 1; i >= 0; --i) {
            ArchInfo info = (ArchInfo)xmlBases.get(i);
            try {
                ArchUtils.setArchProperties(ctx, info, bosType, invoice, i);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)(info.getBillId() + ":\u8bbe\u7f6e\u5355\u636e\u5c5e\u6027\u5931\u8d25!"), (Throwable)e);
                ArchRecordUtils.writeLog(ctx, info, arcRecordId, e);
                ArcRecordInfo recordInfo = ArcRecordFactory.getLocalInstance(ctx).getArcRecordInfo((IObjectPK)new ObjectUuidPK(arcRecordId));
                ArchUtils.isValidate(ctx, recordInfo, 1);
                xmlBases.remove(i);
            }
        }
        return xmlBases;
    }

    public static List<XmlBase> mutilSetArchProperties(Context ctx, List<XmlBase> xmlBases, String bosType, Boolean invoice) {
        ArrayList<Future<XmlBase>> futures = new ArrayList<Future<XmlBase>>();
        for (int i = 0; i < xmlBases.size(); ++i) {
            ArchInfo info = (ArchInfo)xmlBases.get(i);
            Future<XmlBase> future = UploadArchInfosThreadPool.submit(ctx, info, bosType, invoice, i);
            futures.add(future);
        }
        ArrayList<XmlBase> list = new ArrayList<XmlBase>();
        for (Future future : futures) {
            try {
                list.add((XmlBase)future.get());
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return list;
    }

    public static ArchInfo setArchProperties(Context ctx, ArchInfo info, String bosType, Boolean invoice, int num) throws Exception {
        if (ArchFlagEnum.DELETE == info.getReArchFlag()) {
            return info;
        }
        Date d1 = new Date();
        ArchUtils.setAttatchInfo(ctx, info, bosType, num);
        Date d2 = new Date();
        if (ERECEIPT_BOSTYPE.equals(bosType)) {
            return info;
        }
        ArchUtils.setImageInfo(ctx, info, bosType);
        Date d3 = new Date();
        ArchUtils.setInvoiceInfo(ctx, info, invoice);
        return info;
    }

    public static void setInvoiceInfo(Context ctx, ArchInfo info, Boolean invoice) throws Exception {
        if (!invoice.booleanValue()) {
            return;
        }
        InvoiceInfo invoiceInfo = new InvoiceInfo();
        String url = "";
        try {
            invoiceInfo.setInvoiceSysType("FPY");
            invoiceInfo.setIp("");
            invoiceInfo.setDownloadurl("");
        }
        catch (Exception e) {
            logger.error((Object)(info.getBillId() + "_" + info.getBillNumber() + "\u8bbe\u7f6e\u53d1\u7968\u4fe1\u606f\u5931\u8d25" + e.getMessage()));
        }
        info.setInvoice(invoiceInfo);
    }

    public static void setImageInfo(Context ctx, ArchInfo info, String bosType) throws Exception {
        if (ERECEIPT_BOSTYPE.equals(bosType)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)info.getBillId()));
        HashSet<String> states = new HashSet<String>();
        states.add("2");
        states.add("4");
        filter.getFilterItems().add(new FilterItemInfo("imageState", states, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("imageNumber");
        view.setSelector(selectorItemCollection);
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance((Context)ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        ImageInfo image = null;
        try {
            String port;
            String ip;
            String type;
            if (billImageMapCollection != null && billImageMapCollection.size() > 0) {
                if (Configure.enableMultiImage((Context)ctx)) {
                    BillImageMapInfo imageInfo = BillImageFacadeFactory.getLocalInstance((Context)ctx).getBillImageMapInfo((IBillImage)new BillImageByBillIDImpl(), info.getBillId());
                    type = MultiImageConfig.getPropertiesValue((Context)ctx, (String)imageInfo.getImageSysId(), (String)IMAGE_SYSTEM_TYPE_KEY);
                    ip = MultiImageConfig.getPropertiesValue((Context)ctx, (String)imageInfo.getImageSysId(), (String)IMAGE_SYSTEM_IP);
                    port = MultiImageConfig.getPropertiesValue((Context)ctx, (String)imageInfo.getImageSysId(), (String)IMAGE_SYSTEM_PORT);
                } else {
                    type = WebServiceConfig.getPropertiesValue((Context)ctx, (String)SSC_NUMBER, (String)IMAGE_SYSTEM_TYPE_KEY);
                    ip = WebServiceConfig.getPropertiesValue((Context)ctx, (String)SSC_NUMBER, (String)IMAGE_SYSTEM_IP);
                    port = WebServiceConfig.getPropertiesValue((Context)ctx, (String)SSC_NUMBER, (String)IMAGE_SYSTEM_PORT);
                }
            } else {
                return;
            }
            image = new ImageInfo();
            image.setImageSysType(type);
            image.setIp(ip);
            image.setPort(port);
            billImageMapInfo = billImageMapCollection.get(0);
            image.setImageNumber(billImageMapInfo.getImageNumber());
            info.setImage(image);
        }
        catch (Exception e) {
            throw new Exception("\u8bbe\u7f6e\u5f71\u50cf\u4fe1\u606f\u5931\u8d25! " + e.getMessage(), e);
        }
    }

    public static void setAttatchInfo(Context ctx, ArchInfo info, String bosType, int num) throws Exception {
        try {
            String billNumber = info.getBillNumber();
            Pattern pattern = Pattern.compile("[\\s\\\\/:\\*\\?\\\"<>\\|]");
            if (StringUtils.isEmpty((String)billNumber)) {
                logger.error((Object)("ArchInfo billNumber is null[billId:" + info.getBillId() + "][bosType:" + bosType + "]"));
                info.setBillNumber(ArchUtils.getDefaultNumber());
                billNumber = info.getBillNumber();
            }
            Matcher matcher = pattern.matcher(billNumber);
            billNumber = matcher.replaceAll("X");
            String timeBill = System.currentTimeMillis() + "";
            timeBill = timeBill.substring(timeBill.length() - 6, timeBill.length());
            FileInfo file = new FileInfo(null, billNumber + "_" + num + "_" + timeBill + ".pdf", billNumber + "_" + num + ".pdf");
            info.addFileInfo(file);
            if (ERECEIPT_BOSTYPE.equals(bosType)) {
                return;
            }
            List<FileInfo> files = ArchUtils.getEASAttachment(ctx, info.getBillId(), num, billNumber);
            info.getFileInfos().addAll(files);
        }
        catch (Exception e) {
            throw new Exception("\u8bbe\u7f6e\u5355\u636e\u9644\u4ef6id\u548c\u540d\u79f0\u5931\u8d25! " + e.getMessage(), e);
        }
    }

    public static List<FileInfo> getEASAttachment(Context ctx, String id, int num, String billNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)id));
        view.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("attachment.id");
        selectorItemCollection.add("attachment.name");
        selectorItemCollection.add("attachment.simpleName");
        view.setSelector(selectorItemCollection);
        BoAttchAssoCollection boAttchAssoCollection = BoAttchAssoFactory.getLocalInstance((Context)ctx).getBoAttchAssoCollection(view);
        ArrayList<FileInfo> files = new ArrayList<FileInfo>(boAttchAssoCollection.size());
        for (int i = 0; i < boAttchAssoCollection.size(); ++i) {
            String time = System.currentTimeMillis() + "";
            time = time.substring(time.length() - 6, time.length());
            String name = billNumber + "_" + num + "_" + i + "_" + time;
            AttachmentInfo attachmentInfo = boAttchAssoCollection.get(i).getAttachment();
            String simpleName = ArchUtils.getSimple(attachmentInfo);
            String srcName = ArchUtils.getSrcName(name, attachmentInfo);
            if ("zip".equals(simpleName) || "rar".equals(simpleName)) {
                name = srcName;
            }
            FileInfo attFile = new FileInfo(attachmentInfo.getId().toString(), name + "." + simpleName, srcName + "." + simpleName);
            files.add(attFile);
        }
        return files;
    }

    private static String getSrcName(String name, AttachmentInfo attachmentInfo) {
        String srcName = attachmentInfo.getName();
        if (StringUtils.isEmpty((String)srcName) && StringUtils.isEmpty((String)(srcName = attachmentInfo.getName(LocaleUtils.locale_L1))) && StringUtils.isEmpty((String)(srcName = attachmentInfo.getName(LocaleUtils.locale_L3)))) {
            srcName = name;
        }
        return srcName;
    }

    private static String getSimple(AttachmentInfo attachmentInfo) {
        String simpleName = attachmentInfo.getSimpleName();
        if (!StringUtils.isEmpty((String)simpleName)) {
            Pattern hanziPattern = Pattern.compile("[\u4e00-\u9fa5]");
            Matcher hanziMatcher = hanziPattern.matcher(simpleName);
            simpleName = hanziMatcher.replaceAll("X");
        }
        return simpleName;
    }

    public static InputStream getPrint(Context ctx, ArchInfo info, RecordBaseInfo content) throws RecException {
        return kdNoteWebServerHelper.exportPDF(ctx, info, content.getPrintTemplate(), content.getBillType().getDataProvider(), content.getBillType().getTdQueryPK());
    }

    public static void mutilSetRefArchInfos(Context ctx, ArcRecordInfo recordInfo, List<XmlBase> mainBills, Map<String, RecordBaseInfo> contents, OperationEnum operation) {
        ArrayList<Future<XmlBase>> futures = new ArrayList<Future<XmlBase>>();
        for (XmlBase xmlBase : mainBills) {
            Future<XmlBase> result = UploadArchInfosThreadPool.submit(ctx, xmlBase, contents, recordInfo, operation);
            futures.add(result);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                logger.error((Object)("\u591a\u7ebf\u7a0b\u83b7\u53d6\u5173\u8054\u5355\u636e\u51fa\u73b0\u5f02\u5e38," + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static XmlBase setRefArchInfos(Context ctx, XmlBase xmlBase, Map<String, RecordBaseInfo> contents, IBillHandler billHandle, OperationEnum operation) throws Exception {
        ArchInfo arch = (ArchInfo)xmlBase;
        IObjectValue billInfo = ((BillXmlSrcObj)arch.getData()).getBillInfo();
        ArrayList<String> botpBillList = billHandle.getAllRelationBill(ctx, billInfo, contents);
        Map<String, List<String>> custBillMap = ArchUtils.getAllCustomRelationBill(ctx, billInfo.getString("id"), contents);
        Map<String, RecordBaseInfo> custRecordBaseMap = ArchUtils.getAllCustomRelation(contents);
        Map<String, RecordBaseInfo> botpRecordBaseMap = ArchUtils.getAllBOTPRelation(contents, custRecordBaseMap);
        HashMap<String, RecordBaseInfo> refBill = new HashMap<String, RecordBaseInfo>();
        HashSet<String> billIdSet = new HashSet<String>();
        Set<String> custRecordBaseIdSet = custBillMap.keySet();
        for (String recordBaseId : custRecordBaseIdSet) {
            List<String> cusRefBillIds = custBillMap.get(recordBaseId);
            for (int i = 0; i < cusRefBillIds.size(); ++i) {
                String billId = cusRefBillIds.get(i);
                if (billIdSet.contains(billId)) continue;
                refBill.put(billId, contents.get(recordBaseId));
                billIdSet.add(billId);
            }
        }
        for (int i = 0; i < botpBillList.size(); ++i) {
            String billId = botpBillList.get(i);
            ObjectUuidPK uuidPK = new ObjectUuidPK(billId);
            String bosType = uuidPK.getObjectType().toString();
            if (botpRecordBaseMap == null || botpRecordBaseMap.size() <= 0) continue;
            Set<String> keySet = botpRecordBaseMap.keySet();
            for (String keyId : keySet) {
                RecordBaseInfo info = botpRecordBaseMap.get(keyId);
                if (!bosType.equals(info.getBillType().getBosType()) || billIdSet.contains(billId)) continue;
                refBill.put(billId, info);
                billIdSet.add(billId);
            }
        }
        Set billSet = refBill.keySet();
        for (String bill : billSet) {
            ArchInfo refInfo = ArchUtils.getArchInfo(ctx, bill, arch, operation, arch.getArchInfos());
            if (null == refInfo) continue;
            refInfo.setMainBillID(arch.getBillId());
            refInfo.setMainBillNumber(arch.getBillNumber());
            refInfo.addRefBill(arch);
            RecordBaseInfo content = (RecordBaseInfo)refBill.get(bill);
            refInfo.setRecordBaseId(content.getId().toString());
            refInfo.setDocType(content.getXmlDocType());
            arch.addRefBill(refInfo);
        }
        return arch;
    }

    private static Map<String, RecordBaseInfo> getAllBOTPRelation(Map<String, RecordBaseInfo> contents, Map<String, RecordBaseInfo> custRecordBaseMap) {
        Set<String> bigMapKey = contents.keySet();
        Set<String> smallMapKey = custRecordBaseMap.keySet();
        Sets.SetView differenceSet = Sets.difference(bigMapKey, smallMapKey);
        HashMap result = Maps.newHashMap();
        for (String key : differenceSet) {
            result.put(key, contents.get(key));
        }
        return result;
    }

    private static Map<String, RecordBaseInfo> getAllCustomRelation(Map<String, RecordBaseInfo> contents) {
        HashMap<String, RecordBaseInfo> map = new HashMap<String, RecordBaseInfo>();
        for (String key : contents.keySet()) {
            RecordBaseInfo recordBaseInfo = contents.get(key);
            if (StringUtils.isEmpty((String)recordBaseInfo.getCustomRelationImpl())) continue;
            map.put(recordBaseInfo.getId().toString(), recordBaseInfo);
        }
        return map;
    }

    public static ArrayList<String> getAllBOTPRelationBill(Context ctx, String destObjId, Map<String, RecordBaseInfo> contents) throws Exception {
        ArrayList<String> ObjIdList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)destObjId)) {
            return ObjIdList;
        }
        ArrayList<String[]> upstreamObjIdList = ArchUtils.getUpstreamObjIdByDestID(ctx, destObjId);
        if (null == upstreamObjIdList || upstreamObjIdList.size() == 0) {
            return ObjIdList;
        }
        Iterator<Map.Entry<String, RecordBaseInfo>> iterator = contents.entrySet().iterator();
        HashSet<String> bosTypeSet = new HashSet<String>();
        while (iterator.hasNext()) {
            bosTypeSet.add(iterator.next().getValue().getBillType().getBosType());
        }
        int safetynumber = 10;
        while (safetynumber > 0) {
            ArrayList<String[]> tempObjId = new ArrayList<String[]>();
            ArrayList<String> archObjIdList = ArchUtils.filterObjId(upstreamObjIdList, bosTypeSet);
            ObjIdList.addAll(archObjIdList);
            --safetynumber;
            for (String[] str : upstreamObjIdList) {
                ArrayList<String[]> upstreamObjIdList2 = ArchUtils.getUpstreamObjIdByDestID(ctx, str[0]);
                if (null == upstreamObjIdList2 || upstreamObjIdList2.size() <= 0) continue;
                tempObjId.addAll(upstreamObjIdList2);
            }
            if (null == tempObjId || tempObjId.size() == 0) break;
            upstreamObjIdList = tempObjId;
        }
        return ObjIdList;
    }

    private static ArrayList<String> filterObjId(ArrayList<String[]> upstreamObjIdList, Set<String> bosTypeSet) {
        ArrayList<String> archObjIdlist = new ArrayList<String>();
        for (int i = 0; i < upstreamObjIdList.size(); ++i) {
            if (!bosTypeSet.contains(upstreamObjIdList.get(i)[1])) continue;
            archObjIdlist.add(upstreamObjIdList.get(i)[0]);
        }
        return archObjIdlist;
    }

    public static Map<String, List<String>> getAllCustomRelationBill(Context ctx, String destObjId, Map<String, RecordBaseInfo> contents) throws Exception {
        if (StringUtils.isEmpty((String)destObjId)) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> ownRefBillMap = new HashMap<String, List<String>>();
        for (String key : contents.keySet()) {
            RecordBaseInfo recordBaseInfo = contents.get(key);
            if (StringUtils.isEmpty((String)recordBaseInfo.getCustomRelationImpl())) continue;
            try {
                Class<?> cla = Class.forName(contents.get(key).getCustomRelationImpl());
                IRefBillHandler refBillHandler = (IRefBillHandler)cla.newInstance();
                ArrayList<String> list = refBillHandler.getRefBillInfo(ctx, destObjId);
                if (null == list || list.size() <= 0) continue;
                ownRefBillMap.put(key, list);
            }
            catch (Exception e) {
                throw new Exception("\u901a\u8fc7\u6269\u5c55\u63a5\u53e3\u83b7\u53d6\u5173\u8054\u5355\u636e\u5931\u8d25!" + e.getMessage(), e);
            }
        }
        return ownRefBillMap;
    }

    private static ArrayList<String[]> getUpstreamObjIdByDestID(Context ctx, String destObjId) {
        ArrayList<String[]> srcObjIdList = new ArrayList<String[]>();
        if (StringUtils.isEmpty((String)destObjId)) {
            return srcObjIdList;
        }
        try {
            IRowSet rsToGetDestObjId = DbUtil.executeQuery((Context)ctx, (String)"SELECT FSRCOBJECTID, FSrcEntityID FROM T_BOT_RELATION  WHERE FDESTOBJECTID=?", (Object[])new String[]{destObjId});
            while (rsToGetDestObjId.next()) {
                srcObjIdList.add(new String[]{rsToGetDestObjId.getString("FSRCOBJECTID"), rsToGetDestObjId.getString("FSrcEntityID")});
            }
        }
        catch (SQLException e) {
            logger.error((Object)("destId = " + destObjId + ",result = " + destObjId), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("destId = " + destObjId + ",result = " + destObjId), (Throwable)e);
        }
        return srcObjIdList;
    }

    public static ArchInfo getCurrentPeriodArchInfo(Context ctx, String billId, ArchInfo destArchInfo, ArchInfos archInfos) throws Exception {
        String id;
        boolean main = null == destArchInfo;
        String string = id = main ? BOSUuid.create((BOSObjectType)new AchRecordDetailInfo().getBOSType()).toString() : BOSUuid.create((BOSObjectType)new AttachBillAchDetailInfo().getBOSType()).toString();
        if (main) {
            if (AchRecordDetailFactory.getLocalInstance(ctx).exists("where billId = '" + billId + "'")) {
                return new ArchInfo(ctx, id, billId, main, ArchFlagEnum.UPDATE, archInfos);
            }
            return new ArchInfo(ctx, id, billId, main, ArchFlagEnum.ADDNEW, archInfos);
        }
        return null;
    }

    @Deprecated
    public static ArchInfo getArchInfoOld(Context ctx, String billId, ArchInfo destArchInfo, OperationEnum operation, ArchInfos archInfos) throws Exception {
        String id;
        boolean main = null == destArchInfo;
        String string = id = main ? BOSUuid.create((BOSObjectType)new AchRecordDetailInfo().getBOSType()).toString() : BOSUuid.create((BOSObjectType)new AttachBillAchDetailInfo().getBOSType()).toString();
        if (OperationEnum.FIRST_ARC.equals((Object)operation)) {
            return new ArchInfo(ctx, id, billId, main, ArchFlagEnum.ADDNEW, archInfos);
        }
        if (OperationEnum.AFRESH_ARC.equals((Object)operation)) {
            Timestamp lastUpdateTime = null;
            ArcStateEnum state = null;
            try {
                DataBaseInfo info;
                if (main) {
                    if (AchRecordDetailFactory.getLocalInstance(ctx).exists("where billId = '" + billId + "'")) {
                        info = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailInfo("where billId = '" + billId + "'");
                        lastUpdateTime = info.getLastUpdateTime();
                        state = info.getState();
                        id = info.getId().toString();
                    }
                } else if (AttachBillAchDetailFactory.getLocalInstance(ctx).exists("where originsBillId = '" + destArchInfo.getBillId() + "' and billId = '" + billId + "'")) {
                    info = AttachBillAchDetailFactory.getLocalInstance(ctx).getAttachBillAchDetailInfo("where originsBillId = '" + destArchInfo.getBillId() + "' and billId = '" + billId + "'");
                    lastUpdateTime = info.getLastUpdateTime();
                    state = info.getState();
                    id = info.getId().toString();
                }
            }
            catch (BOSException e) {
                throw new Exception("\u83b7\u53d6ArchInfo\u5f02\u5e38\uff01" + e.getMessage(), e);
            }
            if (null == lastUpdateTime) {
                return new ArchInfo(ctx, id, billId, main, ArchFlagEnum.ADDNEW, archInfos);
            }
            if (ArcStateEnum.ARC_FAIL.equals((Object)state)) {
                return new ArchInfo(ctx, id, billId, main, ArchFlagEnum.UPDATE, archInfos);
            }
            try {
                ObjectUuidPK uuidPK = new ObjectUuidPK(billId);
                IObjectValue _iov = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(uuidPK.getObjectType(), (IObjectPK)uuidPK);
                Timestamp _lastUpdateTime = (Timestamp)_iov.get("lastUpdateTime");
                if (_lastUpdateTime.after(lastUpdateTime)) {
                    return new ArchInfo(ctx, id, billId, main, ArchFlagEnum.UPDATE, archInfos);
                }
            }
            catch (BOSException e) {
                throw new Exception("\u83b7\u53d6ArchInfo\u5f02\u5e38\uff01" + e.getMessage(), e);
            }
            if (ArcStateEnum.ARC_SUCCESS.equals((Object)state) && main) {
                return new ArchInfo(ctx, id, billId, main, null, archInfos);
            }
        } else if (operation == OperationEnum.FAIL_ARC) {
            if (main) {
                if (!AchRecordDetailFactory.getLocalInstance(ctx).exists("where billId = '" + billId + "'")) {
                    ObjectUuidPK billUuidPK = new ObjectUuidPK(billId);
                    boolean existsBill = DynamicObjectFactory.getLocalInstance((Context)ctx).exists(billUuidPK.getObjectType(), (IObjectPK)billUuidPK);
                    if (existsBill) {
                        return new ArchInfo(ctx, id, billId, main, ArchFlagEnum.ADDNEW, archInfos);
                    }
                    return new ArchInfo(ctx, id, billId, main, ArchFlagEnum.DELETE, archInfos);
                }
                AchRecordDetailInfo info = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailInfo("where billId = '" + billId + "'");
                if (ArcStateEnum.ARC_SUCCESS != info.getState()) {
                    return new ArchInfo(ctx, info.getId().toString(), billId, main, ArchFlagEnum.UPDATE, archInfos);
                }
                return new ArchInfo(ctx, info.getId().toString(), billId, main, null, archInfos);
            }
            if (ArchFlagEnum.ADDNEW.equals((Object)destArchInfo.getReArchFlag())) {
                return new ArchInfo(ctx, id, billId, main, ArchFlagEnum.ADDNEW, archInfos);
            }
            if (!AttachBillAchDetailFactory.getLocalInstance(ctx).exists("where originsBillId = '" + destArchInfo.getBillId() + "' and billId = '" + billId + "'")) {
                ObjectUuidPK billUuidPK = new ObjectUuidPK(billId);
                boolean existsBill = DynamicObjectFactory.getLocalInstance((Context)ctx).exists(billUuidPK.getObjectType(), (IObjectPK)billUuidPK);
                if (existsBill) {
                    return new ArchInfo(ctx, id, billId, main, ArchFlagEnum.ADDNEW, archInfos);
                }
                return new ArchInfo(ctx, id, billId, main, ArchFlagEnum.DELETE, archInfos);
            }
            AttachBillAchDetailInfo info = AttachBillAchDetailFactory.getLocalInstance(ctx).getAttachBillAchDetailInfo("where originsBillId = '" + destArchInfo.getBillId() + "' and billId = '" + billId + "'");
            ArchInfo archInfo = !ArcStateEnum.ARC_SUCCESS.equals((Object)info.getState()) ? new ArchInfo(ctx, info.getId().toString(), billId, main, ArchFlagEnum.UPDATE, archInfos) : new ArchInfo(ctx, id, billId, main, null, archInfos);
            archInfo.setBillNumber(info.getBillNumber());
            return archInfo;
        }
        return null;
    }

    public static ArchInfo getArchInfo(Context ctx, String billId, IObjectValue billInfo, Timestamp lastGetBillTime, ArchInfos archInfos) throws Exception {
        ArchInfo archInfo;
        Timestamp billCreateTime = (Timestamp)billInfo.get("createTime");
        if (null == lastGetBillTime || billCreateTime.after(lastGetBillTime)) {
            archInfo = new ArchInfo(ctx, BOSUuid.create((BOSObjectType)new AchRecordDetailInfo().getBOSType()).toString(), billId, true, ArchFlagEnum.ADDNEW, archInfos);
        } else {
            archInfo = ArchUtils.getArchInfoExists(ctx, billId, billInfo, lastGetBillTime, archInfos);
            if (null == archInfo.getReArchFlag()) {
                archInfo.setReArchFlag(ArchFlagEnum.UPDATE);
            }
        }
        archInfo.setBillNumber(billInfo.getString("number"));
        BillXmlSrcObj srcObj = new BillXmlSrcObj();
        srcObj.setBillInfo(billInfo);
        archInfo.setData(srcObj);
        return archInfo;
    }

    public static ArchInfo getArchInfoExists(Context ctx, String billId, IObjectValue billInfo, Timestamp lastGetBillTime, ArchInfos archInfos) throws Exception {
        if (AchRecordDetailFactory.getLocalInstance(ctx).exists("where billId = '" + billId + "'")) {
            AchRecordDetailInfo info = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailInfo("where billId = '" + billId + "'");
            ArcStateEnum state = info.getState();
            String id = info.getId().toString();
            ArchFlagEnum archFlag = ArchFlagEnum.ADDNEW;
            ArchInfo archInfo = new ArchInfo(ctx, id, billId, true, archFlag, archInfos);
            archInfo.setOldState(info.getState());
            Timestamp billLUTime = (Timestamp)billInfo.get("lastUpdateTime");
            if (ArcStateEnum.ARC_SUCCESS.equals((Object)state)) {
                archFlag = null;
                if (lastGetBillTime.before(billLUTime)) {
                    archFlag = ArchFlagEnum.UPDATE;
                    ArchUtils.setDeleteAttachBill(ctx, archInfo, archInfos);
                }
            } else if (ArcStateEnum.REVERSE_ARC.equals((Object)state)) {
                archFlag = ArchFlagEnum.UPDATE;
                ArchUtils.setDeleteAttachBill(ctx, archInfo, archInfos);
            }
            archInfo.setReArchFlag(archFlag);
            return archInfo;
        }
        return new ArchInfo(ctx, BOSUuid.create((BOSObjectType)new AchRecordDetailInfo().getBOSType()).toString(), billId, true, ArchFlagEnum.ADDNEW, archInfos);
    }

    private static void setDeleteAttachBill(Context ctx, ArchInfo archInfo, ArchInfos archInfos) throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)archInfo.getBillId()));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("attachBillAchDetails.id");
        selectorItemCollection.add("attachBillAchDetails.billId");
        AchRecordDetailCollection achRecordDetails = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailCollection(entityViewInfo);
        IBillHandler billHandler = FilingUtils.getBillHandler(ctx, archInfos.getContent());
        for (int i = 0; i < achRecordDetails.size(); ++i) {
            boolean existsBill = billHandler.existsBill(ctx, achRecordDetails.get(i).getBillId());
            if (existsBill) continue;
            ArchInfo refDeleteArchInfo = new ArchInfo(ctx, achRecordDetails.get(i).getId().toString(), achRecordDetails.get(i).getBillId(), false, ArchFlagEnum.DELETE, archInfos);
            archInfo.addRefBill(refDeleteArchInfo);
        }
    }

    public static ArchInfo getArchInfo(Context ctx, String billId, ArchInfo destArchInfo, OperationEnum operation, ArchInfos archInfos) throws Exception {
        if (OperationEnum.FAIL_ARC.equals((Object)operation)) {
            return ArchUtils.getArchInfo(ctx, billId, destArchInfo, archInfos);
        }
        ArchFlagEnum destBillarchFlag = destArchInfo.getReArchFlag();
        if (ArchFlagEnum.ADDNEW.equals((Object)destBillarchFlag) && null == destArchInfo.getOldState()) {
            return new ArchInfo(ctx, BOSUuid.create((BOSObjectType)new AttachBillAchDetailInfo().getBOSType()).toString(), billId, false, ArchFlagEnum.ADDNEW, archInfos);
        }
        ArchInfo archInfo = ArchUtils.getArchInfo(ctx, billId, destArchInfo, archInfos);
        if (null == archInfo.getReArchFlag()) {
            archInfo.setReArchFlag(ArchFlagEnum.UPDATE);
        }
        return archInfo;
    }

    private static ArchInfo getArchInfo(Context ctx, String billId, ArchInfo destArchInfo, ArchInfos archInfos) throws BOSException, EASBizException {
        if (AttachBillAchDetailFactory.getLocalInstance(ctx).exists("where originsBillId = '" + destArchInfo.getBillId() + "' and billId = '" + billId + "'")) {
            AttachBillAchDetailInfo info = AttachBillAchDetailFactory.getLocalInstance(ctx).getAttachBillAchDetailInfo("where originsBillId = '" + destArchInfo.getBillId() + "' and billId = '" + billId + "'");
            ArchFlagEnum destArchFlag = destArchInfo.getReArchFlag();
            ArcStateEnum state = info.getState();
            ArchFlagEnum archFlag = ArchFlagEnum.ADDNEW;
            if (ArcStateEnum.ARC_SUCCESS.equals((Object)state)) {
                archFlag = null;
                if (ArchFlagEnum.UPDATE.equals((Object)destArchFlag) && ArchFlagEnum.ADDNEW.equals((Object)destArchFlag)) {
                    archFlag = ArchFlagEnum.UPDATE;
                }
            }
            ArchInfo archInfo = new ArchInfo(ctx, info.getId().toString(), billId, false, archFlag, archInfos);
            archInfo.setOldState(state);
            return archInfo;
        }
        return new ArchInfo(ctx, BOSUuid.create((BOSObjectType)new AttachBillAchDetailInfo().getBOSType()).toString(), billId, false, ArchFlagEnum.ADDNEW, archInfos);
    }

    public static ArchInfos handDelteArchInfo(Context ctx, ArchInfos archInfos, Map<String, RecordBaseInfo> recordBases, RecordBaseInfo content) throws RecException {
        try {
            ArcRecordCollection arcRecordcols = ArcRecordFactory.getLocalInstance(ctx).getArcRecordCollection("where org = '" + archInfos.getOrg().getId() + "' and content = '" + archInfos.getContent().getId() + "' and periodNum = '" + archInfos.getPeriodInfo().getNumber() + "'");
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("arcRecord", (Object)arcRecordcols.get(0).getId()));
            entityViewInfo.setFilter(filter);
            AchRecordDetailCollection arcRecordDetailcols = AchRecordDetailFactory.getLocalInstance(ctx).getAchRecordDetailCollection(entityViewInfo);
            IBillHandler billHandler = FilingUtils.getBillHandler(ctx, content);
            for (int i = 0; i < arcRecordDetailcols.size(); ++i) {
                AchRecordDetailInfo achRecordDetailInfo = arcRecordDetailcols.get(i);
                String oribillId = achRecordDetailInfo.getBillId();
                boolean existsBill = billHandler.existsBill(ctx, oribillId);
                if (existsBill) continue;
                ArchInfo info = new ArchInfo(ctx, achRecordDetailInfo.getId().toString(), oribillId, true, ArchFlagEnum.DELETE, archInfos);
                info.setDocType(content.getXmlDocType());
                archInfos.setMainBill(info);
                achRecordDetailInfo.setState(ArcStateEnum.ARC_2BE_DELETED);
                AchRecordDetailFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(achRecordDetailInfo.getId().toString()), achRecordDetailInfo);
                AttachBillAchDetailCollection attachBillCol = AttachBillAchDetailFactory.getLocalInstance(ctx).getAttachBillAchDetailCollection("select * ,arcContent.xmlDocType where originsBillId ='" + oribillId + "'");
                for (int j = 0; j < attachBillCol.size(); ++j) {
                    AttachBillAchDetailInfo attachBillAchDetailInfo = attachBillCol.get(j);
                    String attachBill = attachBillAchDetailInfo.getBillId();
                    ObjectUuidPK attachBilluuidPK = new ObjectUuidPK(attachBill);
                    ArchInfo refInfo = new ArchInfo(ctx, attachBillAchDetailInfo.getId().toString(), attachBill, false, ArchFlagEnum.DELETE, archInfos);
                    refInfo.addRefBill(info);
                    info.addRefBill(refInfo);
                    ObjectUuidPK obPk = new ObjectUuidPK(attachBillAchDetailInfo.getId().toString());
                    refInfo.setDocType(attachBillAchDetailInfo.getArcContent().getXmlDocType());
                    attachBillAchDetailInfo.setState(ArcStateEnum.ARC_2BE_DELETED);
                    AttachBillAchDetailFactory.getLocalInstance(ctx).update((IObjectPK)obPk, attachBillAchDetailInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new RecException(RecException.UNKNOWN, e, new Object[]{"\u5904\u7406\u5220\u9664\u6570\u636e\u5f02\u5e38"});
        }
        return archInfos;
    }

    public static Map<String, IObjectValue> getMainBills(Context ctx, RecordBaseInfo content, PeriodInfo period, CompanyOrgUnitInfo org) throws Exception {
        try {
            String bosType = content.getBillType().getBosType();
            IBillHandler billHandle = FilingUtils.getBillHandler(ctx, content);
            Boolean flag = billHandle.canArch(ctx, bosType, period, org);
            if (flag.booleanValue()) {
                return billHandle.getMainBills(ctx, bosType, period, org);
            }
            String logStr = "bosType:" + bosType + ",period:" + period.getLogInfo() + ",org:" + org.getNumber() + " \u4e0d\u80fd\u5f52\u6863;billHandle:[" + billHandle.getClass().getName() + "]";
            logger.error((Object)logStr);
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{logStr});
        }
        catch (Exception e) {
            logger.error((Object)(content.getBillType().getNumber() + "\u5355\u636e\u7684" + org.getNumber() + "\u7ec4\u7ec7\u7684" + period.getNumber() + "\u671f\u95f4\u67e5\u8be2\u4e3b\u5355\u636eids\u65f6,\u51fa\u73b0\u5f02\u5e38!" + e), (Throwable)e);
            throw e;
        }
    }

    public static Map<String, IObjectValue> getCurrentPeriodCanArchMainBills(Context ctx, RecordBaseInfo content, PeriodInfo period, CompanyOrgUnitInfo org, Timestamp beginTime, Timestamp lastUpdateTime) throws Exception {
        try {
            String bosType = content.getBillType().getBosType();
            String[] checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)bosType, IBillHandler.class);
            IBillHandler billHandle = null;
            if (null == checkers || checkers.length == 0) {
                logger.error((Object)(content.getBillType().getNumber() + "\u5355\u636e\u7684" + org.getNumber() + "\u7ec4\u7ec7\u7684" + period.getNumber() + "\u671f\u95f4\u67e5\u8be2\u4e3b\u5355\u636eids\u65f6,\u53d1\u73b0\u5355\u636e\u6ca1\u6709\u5b9e\u73b0com.kingdee.eas.el.rec.tool.IBillHandler\uff01"));
                billHandle = new DefaultBillHandler();
            } else {
                Class<?> cla = Class.forName(checkers[0]);
                billHandle = (IBillHandler)cla.newInstance();
            }
            return billHandle.getCurrentPeriodCanArchMainBills(ctx, bosType, period, org, beginTime, lastUpdateTime);
        }
        catch (Exception e) {
            logger.error((Object)(content.getBillType().getNumber() + "\u5355\u636e\u7684" + org.getNumber() + "\u7ec4\u7ec7\u7684" + period.getNumber() + "\u671f\u95f4\u67e5\u8be2\u4e3b\u5355\u636eids\u65f6,\u51fa\u73b0\u5f02\u5e38!" + e), (Throwable)e);
            throw e;
        }
    }

    public static void saveAttachBillAchDetail(Context ctx, RecordBaseInfo content, List<XmlBase> archInfos, ArcRecordInfo arcRecordInfo) throws Exception {
        ArchUtils.saveAttachBillAchDetail(ctx, content, archInfos, arcRecordInfo, false);
    }

    private static void saveAttachBillAchDetail(Context ctx, RecordBaseInfo content, List<XmlBase> archInfos, ArcRecordInfo arcRecordInfo, boolean reverse) throws Exception {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        CoreBaseCollection attachlcolls = new CoreBaseCollection();
        CoreBaseCollection updateAttachlcolls = new CoreBaseCollection();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        for (int i = archInfos.size() - 1; i >= 0; --i) {
            ArchInfo archInfo = (ArchInfo)archInfos.get(i);
            AttachBillAchDetailInfo attachBillDetailInfo = new AttachBillAchDetailInfo();
            attachBillDetailInfo.setId(BOSUuid.read((String)archInfo.getId()));
            attachBillDetailInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            if (ArchFlagEnum.ADDNEW == archInfo.getReArchFlag() && null == archInfo.getOldState()) {
                attachBillDetailInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                attachBillDetailInfo.setCreator(userInfo);
                attachBillDetailInfo.setLastUpdateUser(userInfo);
                attachBillDetailInfo.setBillId(archInfo.getBillId());
                attachBillDetailInfo.setOriginsBillId(new ArrayList<ArchInfo>(archInfo.getRefInfo()).get(0).getBillId());
                AchRecordDetailInfo achRecordDetailInfo = new AchRecordDetailInfo();
                achRecordDetailInfo.setId(BOSUuid.read((String)new ArrayList<ArchInfo>(archInfo.getRefInfo()).get(0).getId()));
                attachBillDetailInfo.setAchRecordDetail(achRecordDetailInfo);
                attachBillDetailInfo.setBillNumber(archInfo.getBillNumber());
                attachBillDetailInfo.setArcContent(content);
                if (reverse) {
                    achRecordDetailInfo.setState(ArcStateEnum.ARC_FAIL);
                } else {
                    attachBillDetailInfo.setState(ArcStateEnum.ARC_LOADING);
                }
                attachlcolls.add((CoreBaseInfo)attachBillDetailInfo);
                if (attachlcolls.size() <= 5000) continue;
                AttachBillAchDetailFactory.getLocalInstance(ctx).saveBatchData(attachlcolls);
                attachlcolls.clear();
                continue;
            }
            if (ArchFlagEnum.UPDATE == archInfo.getReArchFlag()) {
                attachBillDetailInfo.setState(ArcStateEnum.REVERSE_ARC);
            } else if (ArchFlagEnum.DELETE == archInfo.getReArchFlag()) {
                attachBillDetailInfo.setState(ArcStateEnum.ARC_2BE_DELETED);
            } else if (ArchFlagEnum.ADDNEW == archInfo.getReArchFlag() && null != archInfo.getOldState()) {
                attachBillDetailInfo.setState(ArcStateEnum.ARC_LOADING);
            }
            updateAttachlcolls.add((CoreBaseInfo)attachBillDetailInfo);
            if (updateAttachlcolls.size() <= 5000) continue;
            AttachBillAchDetailFactory.getLocalInstance(ctx).updateBatchPartial(updateAttachlcolls, sic);
            updateAttachlcolls.clear();
        }
        AttachBillAchDetailFactory.getLocalInstance(ctx).saveBatchData(attachlcolls);
        AttachBillAchDetailFactory.getLocalInstance(ctx).updateBatchPartial(updateAttachlcolls, sic);
    }

    public static void saveAttachBillAchDetail2reverse(Context ctx, RecordBaseInfo content, List<XmlBase> archInfos, ArcRecordInfo arcRecordInfo) throws Exception {
        ArchUtils.saveAttachBillAchDetail(ctx, content, archInfos, arcRecordInfo, true);
    }

    public static String getDefaultNumber() throws InterruptedException {
        SimpleDateFormat myFmt = new SimpleDateFormat("yyMMddHHmmssSSS");
        Date date = new Date();
        String number = myFmt.format(date);
        Thread.sleep(1L);
        return number;
    }

    public static void updateAttachDetailNumber(Context ctx, RecordBaseInfo content, List<XmlBase> archInfos, String arcRecordId) throws EASBizException, BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        CoreBaseCollection attachlcolls = new CoreBaseCollection();
        CoreBaseCollection updateAttachlcolls = new CoreBaseCollection();
        String sql = "update T_REC_ATTACHBILLACHDETAIL set fbillnumber = ? where fid = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(archInfos.size());
        for (XmlBase info : archInfos) {
            ArchInfo archInfo = (ArchInfo)info;
            Object[] params = new Object[]{archInfo.getBillNumber(), archInfo.getBillId()};
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
    }

    public static void saveAchRecordDetail(Context ctx, List<XmlBase> archInfos, String arcRecordId) throws Exception {
        ArchUtils.saveAchRecordDetail(ctx, archInfos, arcRecordId, false);
    }

    private static void saveAchRecordDetail(Context ctx, List<XmlBase> archInfos, String arcRecordId, boolean reverse) throws Exception {
        ArcRecordInfo arcRecordInfo = new ArcRecordInfo();
        arcRecordInfo.setId(BOSUuid.read((String)arcRecordId));
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        CoreBaseCollection detailcolls = new CoreBaseCollection();
        CoreBaseCollection updateDetailcolls = new CoreBaseCollection();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        for (XmlBase info : archInfos) {
            ArchInfo mainArchInfo = (ArchInfo)info;
            AchRecordDetailInfo detailInfo = new AchRecordDetailInfo();
            detailInfo.setId(BOSUuid.read((String)mainArchInfo.getId()));
            detailInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            if (ArchFlagEnum.ADDNEW.equals((Object)mainArchInfo.getReArchFlag()) && null == mainArchInfo.getOldState()) {
                IObjectValue voucherType;
                detailInfo.setArcRecord(arcRecordInfo);
                detailInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                detailInfo.setCreator(userInfo);
                detailInfo.setLastUpdateUser(userInfo);
                detailInfo.setBillId(mainArchInfo.getBillId());
                String billNumber = mainArchInfo.getBillNumber();
                if (StringUtils.isEmpty((String)billNumber)) {
                    billNumber = ArchUtils.getDefaultNumber();
                }
                if (null != (voucherType = (IObjectValue)mainArchInfo.getData().get("voucherType"))) {
                    billNumber = "[" + voucherType.get("name") + "]" + billNumber;
                }
                mainArchInfo.setBillNumber(billNumber);
                detailInfo.setBillNumber(billNumber);
                detailInfo.setState(reverse ? ArcStateEnum.ARC_FAIL : ArcStateEnum.ARC_LOADING);
                ArcStateEnum originState = ArcStateEnum.ARC_LOADING;
                if (0 == mainArchInfo.getRefInfo().size()) {
                    originState = ArcStateEnum.ARC_NODATA;
                } else {
                    detailInfo.put("attachBillAchDetails", null);
                }
                detailInfo.setOriginBillState(originState);
                detailcolls.add((CoreBaseInfo)detailInfo);
                if (detailcolls.size() <= 5000) continue;
                AchRecordDetailFactory.getLocalInstance(ctx).saveBatchData(detailcolls);
                detailcolls.clear();
                continue;
            }
            if (ArchFlagEnum.UPDATE.equals((Object)mainArchInfo.getReArchFlag())) {
                detailInfo.setState(ArcStateEnum.REVERSE_ARC);
            } else if (ArchFlagEnum.DELETE.equals((Object)mainArchInfo.getReArchFlag())) {
                detailInfo.setState(ArcStateEnum.ARC_2BE_DELETED);
            } else if (ArchFlagEnum.ADDNEW.equals((Object)mainArchInfo.getReArchFlag()) && null != mainArchInfo.getOldState()) {
                detailInfo.setState(ArcStateEnum.ARC_LOADING);
            }
            updateDetailcolls.add((CoreBaseInfo)detailInfo);
            if (updateDetailcolls.size() <= 5000) continue;
            AchRecordDetailFactory.getLocalInstance(ctx).updateBatchPartial(updateDetailcolls, sic);
            updateDetailcolls.clear();
        }
        AchRecordDetailFactory.getLocalInstance(ctx).saveBatchData(detailcolls);
        AchRecordDetailFactory.getLocalInstance(ctx).updateBatchPartial(updateDetailcolls, sic);
    }

    public static void saveAchRecordDetail2Reverse(Context ctx, List<XmlBase> archInfos, String arcRecordId) throws Exception {
        ArchUtils.saveAchRecordDetail(ctx, archInfos, arcRecordId, true);
    }

    public static void uploadArchInfos(Context ctx, RecordBaseInfo content, PeriodInfo periodInfo, CompanyOrgUnitInfo org, List<XmlBase> archInfos, String taskFlag, String subName, String arcRecordId) {
        if (archInfos == null || archInfos.size() == 0) {
            return;
        }
        ArrayList<XmlBase> addNewArchInfos = new ArrayList<XmlBase>();
        ArrayList<XmlBase> updateArchInfos = new ArrayList<XmlBase>();
        ArrayList<XmlBase> deleteArchInfos = new ArrayList<XmlBase>();
        for (int i = 0; i < archInfos.size(); ++i) {
            ArchInfo arch = (ArchInfo)archInfos.get(i);
            if (ArchFlagEnum.ADDNEW.equals((Object)arch.getReArchFlag())) {
                addNewArchInfos.add(arch);
            }
            if (ArchFlagEnum.UPDATE.equals((Object)arch.getReArchFlag())) {
                updateArchInfos.add(arch);
            }
            if (!ArchFlagEnum.DELETE.equals((Object)arch.getReArchFlag())) continue;
            deleteArchInfos.add(arch);
        }
        if (addNewArchInfos.size() > 0) {
            ArchUtils.upload(ctx, content, periodInfo, org, addNewArchInfos, taskFlag, subName, arcRecordId);
        }
        if (updateArchInfos.size() > 0) {
            ArchUtils.upload(ctx, content, periodInfo, org, updateArchInfos, taskFlag, subName, arcRecordId);
        }
        if (deleteArchInfos.size() > 0) {
            ArchUtils.upload(ctx, content, periodInfo, org, deleteArchInfos, taskFlag, subName, arcRecordId);
        }
    }

    private static void upload(Context ctx, RecordBaseInfo content, PeriodInfo periodInfo, CompanyOrgUnitInfo org, List<XmlBase> archInfos, String taskFlag, String subName, String arcRecordId) {
        int size = ThreadPoolInitFactory.getThreadPoolParam(ctx, "thread.upload.billsize", 100);
        int i = 0;
        ThreadUtil.ThreadInfo threadInfo = ThreadUtil.getLock(taskFlag);
        int times = archInfos.size() / size;
        int forTime = 0;
        if (archInfos.size() % size == 0) {
            threadInfo.addThreadCount(times);
            forTime = times;
        } else {
            threadInfo.addThreadCount(times + 1);
            forTime = times + 1;
        }
        while (i < forTime) {
            ArrayList<XmlBase> bills = new ArrayList<XmlBase>(archInfos.subList(size * i, Math.min(archInfos.size(), size * (i + 1))));
            UploadBillArchInfosThread uploadBillArchInfosThread = new UploadBillArchInfosThread(ctx, org, periodInfo, taskFlag, content, bills, i + "-" + subName);
            uploadBillArchInfosThread.setArcRecordId(arcRecordId);
            UploadArchInfosThreadPool.execute(uploadBillArchInfosThread);
            ++i;
        }
    }

    public static boolean setUsing(String key, String owner) {
        return MutexUtils.setUsing((IMDProject)new ElProject(), (String)key, (String)owner);
    }

    public static void releaseMutex(String key) {
        MutexUtils.releaseMutex((IMDProject)new ElProject(), (String)key);
    }

    public static Set getSubOrg(Context ctx, String longNumber) throws BOSException, EASBizException {
        HashSet<String> corgs = new HashSet<String>();
        Set<String> set = PermissionOrgUtil.getHasPermissionOrg(ctx, ctx.getCaller().toString(), "el_rec_ArchSchemeList_addNew");
        CompanyOrgUnitCollection collection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection("where longNumber like '" + longNumber + "%'");
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                CompanyOrgUnitInfo ouInfo = collection.get(i);
                if (set == null || set.size() == 0 || !set.contains(ouInfo.getId() + "") || !ouInfo.isIsBizUnit()) continue;
                corgs.add(ouInfo.getId().toString());
            }
        }
        return corgs;
    }

    public static String getOwner(String key) {
        return MutexUtils.getOwner((IMDProject)new ElProject(), (String)key);
    }

    public static void currentPeriodInitArchNumCache(Context ctx, String arcRecordId, ArchInfos archInfos, OperationEnum operation) throws EASBizException, BOSException {
        ArcRecordInfo info = ArcRecordFactory.getLocalInstance(ctx).getArcRecordInfo((IObjectPK)new ObjectUuidPK(arcRecordId));
        if (operation == OperationEnum.FIRST_ARC) {
            info.setVoucherNum(info.getVoucherNum() + archInfos.voucherSize());
            info.setOriginVcNum(info.getOriginVcNum() + archInfos.originVcSize());
        }
        info.setTotalNum(info.getTotalNum() + archInfos.size());
        ArcRecordFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(arcRecordId), info);
    }
}

