/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.attachment.AttachmentFtpHandleFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentStorageTypeEnum;
import com.kingdee.eas.base.attachment.app.AttachmentFtpFacadeControllerBean;
import com.kingdee.eas.base.attachment.common.AttachmentHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.tool.FtpUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AttachmentDownloadServer
extends AttachmentFtpFacadeControllerBean {
    Logger logger = Logger.getLogger((String)AttachmentDownloadServer.class.getName());
    private static final String TEMP_FILE = "tempFile";

    public InputStream downloadFile1(Context ctx, String attachmentId) throws EASBizException, BOSException {
        boolean flag = false;
        AttachmentStorageTypeEnum type = AttachmentHelper.getStorageType((Context)ctx, (String)attachmentId);
        HashMap attachmentFTpTmpFilePath = new HashMap();
        InputStream input = null;
        try {
            input = this.getFile(ctx, attachmentId, attachmentFTpTmpFilePath);
            if (attachmentFTpTmpFilePath.size() != 0 && type.equals((Object)AttachmentStorageTypeEnum.FTP)) {
                ctx.put((Object)TEMP_FILE, attachmentFTpTmpFilePath.get("attachmentFTpTmpFilePath"));
            }
            InputStream inputStream = input;
            return inputStream;
        }
        catch (EASBizException e) {
            flag = true;
            throw e;
        }
        catch (Exception e) {
            flag = true;
            throw new BOSException((Throwable)e);
        }
        finally {
            if (flag && AttachmentStorageTypeEnum.FTP.equals((Object)type)) {
                File file;
                String attachmentFTpTmpFilePath2 = (String)ctx.get((Object)"attachmentFTpTmpFilePath");
                if (attachmentFTpTmpFilePath2 != null && attachmentFTpTmpFilePath2.length() != 0 && (file = new File(attachmentFTpTmpFilePath2)).exists()) {
                    file.getAbsoluteFile().delete();
                }
                ctx.remove((Object)TEMP_FILE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downUploadFile(Context ctx, FileInfo fileInfo, FtpUtil ftpUtil) throws Exception {
        File file;
        AttachmentStorageTypeEnum type = AttachmentHelper.getStorageType((Context)ctx, (String)fileInfo.getId());
        HashMap attachmentFTpTmpFilePath = new HashMap();
        InputStream input = null;
        try {
            try {
                input = this.getFile(ctx, fileInfo.getId(), attachmentFTpTmpFilePath);
            }
            catch (Exception e) {
                try {
                    input = this.getFile(ctx, fileInfo.getId(), attachmentFTpTmpFilePath);
                    this.logger.error((Object)"2\u6b21\u83b7\u53d6\u9644\u4ef6\u6210\u529f!");
                }
                catch (Exception e2) {
                    throw new Exception("2\u6b21\u83b7\u53d6\u9644\u4ef6\u5931\u8d25! " + e.getMessage(), e2);
                }
            }
            try {
                ftpUtil.uploadFileByInputStream(fileInfo.getName(), input);
            }
            catch (Exception e) {
                throw new Exception("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25!" + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            File file2;
            FilingUtils.safeClose(input);
            if (AttachmentStorageTypeEnum.FTP.equals((Object)type) && (file2 = new File((String)attachmentFTpTmpFilePath.get("attachmentFTpTmpFilePath"))).exists()) {
                file2.getAbsoluteFile().delete();
            }
            throw throwable;
        }
        FilingUtils.safeClose(input);
        if (AttachmentStorageTypeEnum.FTP.equals((Object)type) && (file = new File((String)attachmentFTpTmpFilePath.get("attachmentFTpTmpFilePath"))).exists()) {
            file.getAbsoluteFile().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getFile(Context ctx, String attachmentId, Map attachmentFTpTmpFilePath) throws BOSException, EASBizException, IOException {
        InputStream input = null;
        com.kingdee.eas.base.attachment.ftp.AttachmentDownloadServer downServer = new com.kingdee.eas.base.attachment.ftp.AttachmentDownloadServer();
        AttachmentStorageTypeEnum type = AttachmentHelper.getStorageType((Context)ctx, (String)attachmentId);
        if (AttachmentStorageTypeEnum.DATABASE.equals((Object)type)) {
            Connection con = null;
            try {
                con = super.getConnection(ctx);
                InputStream inputStream = input = downServer.getContent4Server(attachmentId, con);
                return inputStream;
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        String filePathOnServer = this.getFilePathOnServer(ctx, attachmentId);
        attachmentFTpTmpFilePath.put("attachmentFTpTmpFilePath", filePathOnServer);
        return this.getBufferedInputStream(filePathOnServer);
    }

    private String getFilePathOnServer(Context ctx, String attachmentId) throws EASBizException, BOSException {
        AttachmentStorageTypeEnum type = AttachmentHelper.getStorageType((Context)ctx, (String)attachmentId);
        if (AttachmentStorageTypeEnum.FTP.equals((Object)type)) {
            File tempFile;
            try {
                tempFile = File.createTempFile("attachment", "tmp");
            }
            catch (IOException e) {
                this.logger.error((Object)e);
                return null;
            }
            AttachmentFtpHandleFacadeFactory.getLocalInstance((Context)ctx).download(attachmentId, tempFile.getAbsolutePath());
            this.logger.error((Object)("*******AttachmentFtpFacadeControllerBean***tempFile=" + tempFile.getAbsolutePath()));
            return tempFile.getAbsolutePath();
        }
        if (AttachmentStorageTypeEnum.EASSERVER.equals((Object)type)) {
            AttachmentInfo attachment = AttachmentHelper.getAttachmentInfo((Context)ctx, (String)attachmentId);
            return attachment.getRemotePath();
        }
        return null;
    }

    private InputStream getBufferedInputStream(String localPath) throws IOException {
        FileInputStream in = null;
        BufferedInputStream inputstream = null;
        try {
            this.logger.error((Object)("***AttachmentFtpFacadeControllerBean*****localPath=*" + localPath));
            in = new FileInputStream(localPath);
            inputstream = new BufferedInputStream(in);
            this.logger.error((Object)("***AttachmentFtpFacadeControllerBean**inputstream=" + inputstream.available()));
            return inputstream;
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            FilingUtils.safeClose(inputstream);
            throw e;
        }
    }
}

