/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.TransferDirection;
import com.kingdee.bos.Context;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.tool.KDNoteWebServerHelper;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FTPClient
extends com.enterprisedt.net.ftp.FTPClient {
    private Logger log = Logger.getLogger((String)"com.kingdee.eas.el.rec.tool.FTPClient");
    private static KDNoteWebServerHelper kdNoteWebServerHelper = new KDNoteWebServerHelper();
    private int uploadCount = 0;

    public String put(Context ctx, ArchInfo info, RecordBaseInfo content, String remoteFile) throws Exception {
        FTPTransferType previousType = this.transferType;
        this.chooseTransferMode(remoteFile);
        boolean resetMode = true;
        Throwable e = null;
        try {
            if (this.monitorEx != null) {
                this.monitorEx.transferStarted(TransferDirection.UPLOAD, remoteFile);
            }
            remoteFile = this.putData(ctx, info, content, remoteFile, false);
            this.validateTransfer();
            ++this.uploadCount;
        }
        catch (FTPException ex) {
            e = ex;
            throw ex;
        }
        catch (IOException ex) {
            e = ex;
            resetMode = false;
            this.validateTransferOnError(ex);
            throw ex;
        }
        finally {
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
            if (resetMode) {
                this.resetTransferMode(previousType);
            }
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String putData(Context ctx, ArchInfo info, RecordBaseInfo content, String remoteFile, boolean append) throws Exception {
        block9: {
            long size;
            block8: {
                IOException storedEx = null;
                BufferedOutputStream out = null;
                size = 0L;
                try {
                    remoteFile = this.initPut(remoteFile, append);
                    out = new BufferedOutputStream(new DataOutputStream(this.data.getOutputStream()), this.transferBufferSize * 2);
                    kdNoteWebServerHelper.exportPDF(ctx, info, content.getPrintTemplate(), content.getBillType().getDataProvider(), content.getBillType().getTdQueryPK(), out);
                    this.closeDataSocket(out);
                    if (storedEx == null) break block8;
                }
                catch (IOException ex) {
                    storedEx = ex;
                    this.log.error((Object)"Caught and rethrowing exception in getDataAfterInitGet()", (Throwable)ex);
                    break block9;
                }
                finally {
                    this.closeDataSocket(out);
                    if (storedEx != null) {
                        throw storedEx;
                    }
                    if (this.monitor != null) {
                        this.monitor.bytesTransferred(size);
                    }
                    this.log.debug((Object)("Transferred " + size + " bytes to remote host"));
                }
                throw storedEx;
            }
            if (this.monitor != null) {
                this.monitor.bytesTransferred(size);
            }
            this.log.debug((Object)("Transferred " + size + " bytes to remote host"));
        }
        return remoteFile;
    }

    public int getUploadCount() {
        return super.getUploadCount() + this.uploadCount;
    }

    public void resetUploadCount() {
        super.resetUploadCount();
        this.uploadCount = 0;
    }
}

