/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.tool.FTPClient;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FtpUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.tool.FtpUtil");
    private FTPClient ftpClient = null;
    private String address;
    private int port;
    private String username;
    private String password;
    private String basePath = "";
    private volatile String localCharset = "";
    private String serverCharset = "ISO-8859-1";
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final String OPTS_UTF8 = "OPTS UTF8";

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getLocalCharset() {
        return this.localCharset;
    }

    public void setLocalCharset(String localCharset) {
        this.localCharset = localCharset;
    }

    public String getServerCharset() {
        return this.serverCharset;
    }

    public void setServerCharset(String serverCharset) {
        this.serverCharset = serverCharset;
    }

    public FtpUtil(String address, int port, String username, String password) {
        this.address = address;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public void login() throws Exception {
        this.ftpClient = new FTPClient();
        this.ftpClient.setRemoteHost(this.address);
        this.ftpClient.setRemotePort(this.port);
        this.ftpClient.setControlEncoding(this.serverCharset);
        this.ftpClient.setConnectMode(FTPConnectMode.PASV);
        try {
            this.ftpClient.connect();
            this.ftpClient.login(this.username, this.password);
        }
        catch (Exception e) {
            try {
                this.ftpClient.connect();
                this.ftpClient.login(this.username, this.password);
            }
            catch (Exception e2) {
                throw new Exception("2\u6b21\u767b\u5f55\u5931\u8d25\uff01" + e.getMessage() + "<-->" + e2.getMessage(), e);
            }
        }
        this.ftpClient.setType(FTPTransferType.BINARY);
        if (!this.isPositiveCompletion(this.ftpClient.getLastReply())) {
            this.closeConnect();
            logger.error((Object)"FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
        }
    }

    public void closeConnect() {
        try {
            if (this.ftpClient != null && this.ftpClient.connected()) {
                this.ftpClient.quit();
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u5173\u95edFTP\u8fde\u63a5\u5931\u8d25\uff01");
        }
    }

    @Deprecated
    public int uploadFilesByInputStream(String ftpPath, Map<String, InputStream> files) throws BOSException {
        if (files == null || files.size() == 0) {
            return 0;
        }
        try {
            this.login();
            this.createDirectorys(ftpPath);
            for (Map.Entry<String, InputStream> entry : files.entrySet()) {
                InputStream is = entry.getValue();
                try {
                    this.ftpClient.put(is, this.changeEncoding(entry.getKey()));
                }
                catch (Exception e) {
                    logger.error((Object)(entry.getKey() + ":\u4e0a\u4f20xml\u5931\u8d25\uff01" + e.getMessage()), (Throwable)e);
                    throw e;
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            int n = this.ftpClient.getUploadCount();
            return n;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.closeConnect();
        }
    }

    public int uploadFilesByInputStream(String ftpPath, Map<String, InputStream> files, FtpUtil ftpUtil) throws Exception {
        if (files == null || files.size() == 0) {
            return 0;
        }
        for (Map.Entry<String, InputStream> entry : files.entrySet()) {
            InputStream is = entry.getValue();
            try {
                this.ftpClient.put(is, this.changeEncoding(entry.getKey()));
            }
            catch (Exception e) {
                logger.error((Object)(entry.getKey() + ":\u4e0a\u4f20xml\u5931\u8d25\uff01" + e.getMessage()), (Throwable)e);
                throw e;
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.ftpClient.getUploadCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFileByInputStream(String fileName, InputStream fileIs) throws Exception {
        if (fileIs == null) {
            throw new Exception("\u6587\u4ef6[" + fileName + "]\u4e0d\u5b58\u5728");
        }
        try {
            this.ftpClient.put(fileIs, this.changeEncoding(fileName));
        }
        catch (Exception e) {
            try {
                this.ftpClient.put(fileIs, this.changeEncoding(fileName));
                logger.error((Object)"2\u6b21\u4e0a\u4f20\u6587\u4ef6\u6210\u529f!");
            }
            catch (Exception e2) {
                throw new Exception("2\u6b21\u4e0a\u6587\u4ef6\u5931\u8d25!" + e.getMessage(), e2);
            }
        }
        finally {
            if (fileIs != null) {
                try {
                    fileIs.close();
                }
                catch (IOException e) {
                    throw new Exception("\u4e0a\u4f20\u5355\u636epdf\u5931\u8d25!" + e.getMessage(), e);
                }
            }
        }
    }

    public void uploadFile(Context ctx, ArchInfo info, RecordBaseInfo content, String fileName) throws Exception {
        try {
            this.ftpClient.put(ctx, info, content, this.changeEncoding(fileName));
        }
        catch (Exception e) {
            logger.error((Object)("\u7b2c\u4e00\u6b21\u4e0a\u4f20\u5355\u636epdf\u5931\u8d25!" + e.getMessage()), (Throwable)e);
            try {
                this.ftpClient.put(ctx, info, content, this.changeEncoding(fileName));
            }
            catch (Exception e2) {
                logger.error((Object)("\u7b2c\u4e8c\u6b21\u4e0a\u4f20\u5355\u636epdf\u5931\u8d25!" + e2.getMessage()), (Throwable)e2);
                throw new Exception(e);
            }
        }
    }

    public int getUploadCount() {
        return this.ftpClient.getUploadCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int uploadFilesByByteArray(String ftpPath, Map<String, byte[]> files) throws BOSException {
        if (files == null || files.size() == 0) {
            return 0;
        }
        try {
            this.login();
            this.createDirectorys(ftpPath);
            for (Map.Entry<String, byte[]> entry : files.entrySet()) {
                byte[] bytes = entry.getValue();
                try {
                    this.ftpClient.put(bytes, this.changeEncoding(entry.getKey()));
                }
                catch (Exception e) {
                    logger.error((Object)("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25\uff01" + entry.getKey()));
                    logger.error((Object)e, (Throwable)e);
                }
                finally {
                    bytes = null;
                    entry.setValue(null);
                }
            }
            int n = this.ftpClient.getUploadCount();
            return n;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.closeConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void uploadFileByByteArray(String fileName, byte[] fileByte) throws BOSException {
        if (fileByte == null) {
            return;
        }
        try {
            this.ftpClient.put(fileByte, this.changeEncoding(fileName));
        }
        catch (Exception e) {
            logger.error((Object)("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25\uff01" + fileName));
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            fileByte = null;
        }
    }

    public boolean uploadFile(String ftpPath, String fileName, InputStream is) throws Exception {
        boolean flag = false;
        try {
            this.login();
            this.createDirectorys(ftpPath);
            this.ftpClient.put(is, this.changeEncoding(fileName));
            flag = true;
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        catch (FTPException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.closeConnect();
        }
        return flag;
    }

    public List<String> downloadSmallFiles(String[] filePaths, String charset) throws BOSException {
        ArrayList<String> xmlContents = new ArrayList<String>();
        String tmpCharset = charset != null && !"".equals(charset.trim()) ? charset : this.localCharset;
        try {
            this.login();
            for (String filePath : filePaths) {
                try {
                    if (!this.ftpClient.exists(filePath)) continue;
                    xmlContents.add(new String(this.ftpClient.get(filePath), tmpCharset));
                }
                catch (Exception e) {
                    logger.error((Object)("filepath: " + filePath + "****" + e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.closeConnect();
        }
        return xmlContents;
    }

    public String downloadSmallFile(String filePath, String charset) throws BOSException {
        block10: {
            String tmpCharset = charset != null && !"".equals(charset.trim()) ? charset : (StringUtils.isEmpty((String)this.localCharset) ? "GBK" : this.localCharset);
            try {
                block9: {
                    this.login();
                    try {
                        if (this.ftpClient.exists(filePath)) break block9;
                        String string = null;
                        return string;
                    }
                    catch (Exception e) {
                        logger.error((Object)("filepath: " + filePath + "****" + e.getMessage()));
                        break block10;
                    }
                }
                String string = new String(this.ftpClient.get(filePath), tmpCharset);
                return string;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                this.closeConnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDirectorys(String path) throws IOException, FTPException {
        Class<FtpUtil> clazz = FtpUtil.class;
        synchronized (FtpUtil.class) {
            path = this.changeEncoding(this.basePath + path);
            if (path != null && !"".equals(path.trim()) && !this.isPositiveCompletion(this.ftpClient.sendCommand("CWD " + path))) {
                String[] directorys = path.split("/");
                for (int i = 0; i < directorys.length; ++i) {
                    String directory = directorys[i];
                    if ("".equals(directory) || this.isPositiveCompletion(this.ftpClient.sendCommand("CWD " + directory))) continue;
                    if (this.isPositiveCompletion(this.ftpClient.sendCommand("MKD " + directory))) {
                        if (this.isPositiveCompletion(this.ftpClient.sendCommand("CWD " + directory))) continue;
                        logger.error((Object)("\u5207\u6362\u76ee\u5f55\u5931\u8d25\uff01dir: " + directory));
                        throw new FTPException("\u5207\u6362\u76ee\u5f55\u5931\u8d25\uff01dir: " + directory);
                    }
                    logger.error((Object)("\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff01dir: " + directory));
                    throw new FTPException("\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff01dir: " + directory);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String changeEncoding(String str) {
        String rstr = null;
        try {
            if (StringUtils.isEmpty((String)this.localCharset)) {
                FtpUtil ftpUtil = this;
                synchronized (ftpUtil) {
                    if (StringUtils.isEmpty((String)this.localCharset)) {
                        this.localCharset = this.isPositiveCompletion(this.ftpClient.sendCommand("OPTS UTF8 ON")) ? CHARSET_UTF8 : "GBK";
                    }
                }
            }
            rstr = new String(str.getBytes(this.localCharset), this.serverCharset);
        }
        catch (Exception e) {
            rstr = str;
            logger.error((Object)"\u8f6c\u6362\u7f16\u7801\u51fa\u9519");
        }
        return rstr;
    }

    private boolean isPositiveCompletion(FTPReply reply) {
        try {
            int replyCode = Integer.parseInt(reply.getReplyCode());
            return replyCode >= 200 && replyCode < 300;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }

    public void setFtpClientNull() {
    }
}

