/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolManager;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.DynamicThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolBuilder;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.QueueTypeEnum;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.RejectedExecutionHandlerEnum;
import com.kingdee.eas.el.rec.ArcLogFactory;
import com.kingdee.eas.el.rec.ArcLogInfo;
import com.kingdee.eas.el.rec.ArcSchLogFactory;
import com.kingdee.eas.el.rec.ArcSchLogInfo;
import com.kingdee.eas.el.rec.InterfaceLogFactory;
import com.kingdee.eas.el.rec.InterfaceLogInfo;
import com.kingdee.eas.el.rec.TaskLogFactory;
import com.kingdee.eas.el.rec.TaskLogInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RecLogUtils {
    private static Logger logger = Logger.getLogger(RecLogUtils.class);
    private static volatile ExecutorService executorService = null;

    private static synchronized void getPool(Context ctx) {
        if (executorService == null) {
            ThreadPoolProperties properties;
            String applicationName = "EL_REC";
            String threadPoolName = ctx.getAIS() + "\u65e5\u5fd7\u8bb0\u5f55\u7ebf\u7a0b\u6c60";
            DynamicThreadPoolManager manager = DynamicThreadPoolManager.getInstance();
            DynamicThreadPoolProperties dynamicThreadPoolProperties = manager.getDynamicThreadPoolProperties();
            if (!dynamicThreadPoolProperties.exists(properties = new ThreadPoolBuilder().ctx(ctx).applicationName(applicationName).threadPoolName(threadPoolName).corePoolSize(5).maximumPoolSize(5).queueCapacity(5000).keepAliveTime(Long.valueOf(30000L)).timeUnit(TimeUnit.MILLISECONDS).queueType(QueueTypeEnum.LINKED_BLOCKING_QUEUE).rejectedExecutionType(RejectedExecutionHandlerEnum.CALLER_RUNS_POLICY).getProperties())) {
                dynamicThreadPoolProperties.getExecutors().add(properties);
            }
            manager.createThreadPoolExecutor(dynamicThreadPoolProperties);
            executorService = manager.getThreadPoolExecutor(applicationName, threadPoolName);
        }
    }

    public static void executeLogRecord(Context ctx, CoreBaseInfo info) {
        if (executorService == null) {
            RecLogUtils.getPool(ctx);
        }
        executorService.execute(new RecLogThread(ctx, info, null));
    }

    public static void executeLogRecord(Context ctx, CoreBaseCollection collection) {
        if (executorService == null) {
            RecLogUtils.getPool(ctx);
        }
        executorService.execute(new RecLogThread(ctx, null, collection));
    }

    static class RecLogThread
    extends Thread {
        private Context ctx;
        private CoreBaseInfo info;
        private CoreBaseCollection collection;

        public RecLogThread(Context ctx, CoreBaseInfo info, CoreBaseCollection collection) {
            this.ctx = ctx;
            this.info = info;
            this.collection = collection;
        }

        @Override
        public void run() {
            ICoreBase iCoreBase = this.getICoreBase(this.ctx);
            if (iCoreBase == null) {
                logger.error((Object)"\u4e0d\u652f\u6301\u7684\u5b9e\u4f53\u4fdd\u5b58.");
                return;
            }
            if (this.info != null) {
                this.saveInfo(iCoreBase, this.info);
            } else if (this.collection != null) {
                this.saveCollection(iCoreBase, this.collection);
            }
        }

        private ICoreBase getICoreBase(Context ctx) {
            Object iCoreBase = null;
            try {
                CoreBaseInfo info0 = this.info;
                if (info0 == null && this.collection != null && this.collection.size() > 0) {
                    info0 = this.collection.get(0);
                }
                if (info0 == null) {
                    return null;
                }
                if (info0 instanceof ArcSchLogInfo) {
                    iCoreBase = ArcSchLogFactory.getLocalInstance(ctx);
                } else if (info0 instanceof ArcLogInfo) {
                    iCoreBase = ArcLogFactory.getLocalInstance(ctx);
                } else if (info0 instanceof InterfaceLogInfo) {
                    iCoreBase = InterfaceLogFactory.getLocalInstance(ctx);
                } else if (info0 instanceof TaskLogInfo) {
                    iCoreBase = TaskLogFactory.getLocalInstance(ctx);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return iCoreBase;
        }

        private void saveInfo(ICoreBase iCoreBase, CoreBaseInfo info) {
            try {
                iCoreBase.addnew(info);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        private void saveCollection(ICoreBase iCoreBase, CoreBaseCollection collection) {
            if (collection == null || collection.size() == 0) {
                return;
            }
            try {
                iCoreBase.addnewBatchData(collection);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

