/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.IRefBillHandler;
import com.kingdee.eas.el.rec.tool.RefBillHandlerFK;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class RefBillHandlerFB
implements IRefBillHandler {
    private static Logger logger = Logger.getLogger(RefBillHandlerFK.class);

    @Override
    public ArrayList<String> getRefBillInfo(Context ctx, String destObjId) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ArrayList<String> billList = RefBillHandlerFB.getAllBOTPRelationBill(ctx, destObjId);
            for (String billId : billList) {
                IObjectPK _pk = H.PK(billId);
                BOSUuid _uuid = BOSUuid.read((String)billId);
                String billNumber = "";
                IObjectValue billValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(_uuid.getType(), _pk);
                if (billValue == null || billValue.get("number") == null || StringUtils.isEmpty((String)(billNumber = billValue.get("number").toString())) || !billNumber.contains("BXD-2019-06-18-00000007")) continue;
                list.add(billId);
            }
            return list;
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    public static ArrayList<String> getAllBOTPRelationBill(Context ctx, String destObjId) throws Exception {
        ArrayList<String> ObjIdList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)destObjId)) {
            return ObjIdList;
        }
        ArrayList<String> upstreamObjIdList = RefBillHandlerFB.getUpstreamObjIdByDestID(ctx, destObjId);
        if (null == upstreamObjIdList || upstreamObjIdList.size() == 0) {
            return ObjIdList;
        }
        int safetynumber = 10;
        while (safetynumber > 0) {
            ArrayList<String> tempObjId = new ArrayList<String>();
            ObjIdList.addAll(upstreamObjIdList);
            --safetynumber;
            for (String str : upstreamObjIdList) {
                ArrayList<String> upstreamObjIdList2 = RefBillHandlerFB.getUpstreamObjIdByDestID(ctx, str);
                if (null == upstreamObjIdList2 || upstreamObjIdList2.size() <= 0) continue;
                tempObjId.addAll(upstreamObjIdList2);
            }
            if (null == tempObjId || tempObjId.size() == 0) break;
            upstreamObjIdList = tempObjId;
        }
        return ObjIdList;
    }

    private static ArrayList<String> getUpstreamObjIdByDestID(Context ctx, String destObjId) {
        ArrayList<String> srcObjIdList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)destObjId)) {
            return srcObjIdList;
        }
        try {
            IRowSet rsToGetDestObjId = DbUtil.executeQuery((Context)ctx, (String)"SELECT FSRCOBJECTID FROM T_BOT_RELATION  WHERE FDESTOBJECTID=?", (Object[])new String[]{destObjId});
            while (rsToGetDestObjId.next()) {
                srcObjIdList.add(rsToGetDestObjId.getString("FSRCOBJECTID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("destId = " + destObjId + ",result = " + destObjId), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("destId = " + destObjId + ",result = " + destObjId), (Throwable)e);
        }
        return srcObjIdList;
    }
}

