/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.model.ArchInfo;
import com.kingdee.eas.el.rec.model.BillXmlSrcObj;
import com.kingdee.eas.el.rec.model.ImageInfo;
import com.kingdee.eas.el.rec.model.InvoiceInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.tool.IBillHandler;
import com.kingdee.eas.el.rec.tool.ThreadPoolInitFactory;
import com.kingdee.eas.el.rec.tool.engine.ParsingEngineUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class BillParsingEngineUtil
extends ParsingEngineUtil {
    protected static Logger logger = Logger.getLogger(BillParsingEngineUtil.class);
    public static final String PERIODYEARKEY = "__periodYear";
    public static final String PERIODNUMBERKEY = "__periodNumber";
    public static final String MAINBILLID = "__mainBillID";
    public static final String MAINBILLNUMBER = "__mainBillNumber";
    public static final String ARCHORGID = "__archOrgID";
    public static final String ARCHORGNUMBER = "__archOrgNumber";
    public static final String ARCHORGNAME = "__archOrgName";

    public List<XmlBase> fillXmlBaseData(BOSObjectType bosType, List<XmlBase> xmlBases, RecordBaseInfo info, PeriodInfo periodInfo) throws Exception {
        if (xmlBases != null) {
            HashSet<String> billIDs = new HashSet<String>();
            List<Map<String, Object>> cfgList = this.readConfig(info);
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            for (int i = 1; i < cfgList.size(); ++i) {
                Map<String, Object> rule = cfgList.get(i);
                String srcfield = rule.get("srcfield").toString();
                String[] srcs = srcfield.split(",");
                for (int j = 0; j < srcs.length; ++j) {
                    if (PERIODYEARKEY.equals(srcs[j]) || PERIODNUMBERKEY.equals(srcs[j]) || MAINBILLNUMBER.equals(srcs[j]) || MAINBILLID.equals(srcs[j]) || ARCHORGNUMBER.equals(srcs[j]) || ARCHORGNAME.equals(srcs[j]) || ARCHORGID.equals(srcs[j])) continue;
                    sic.add(new SelectorItemInfo(srcs[j]));
                }
            }
            viewInfo.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            int queryNumber = ThreadPoolInitFactory.getThreadPoolParam(this.ctx, "thread.engine.querynumber", 100);
            IBillHandler billHandler = FilingUtils.getBillHandler(this.ctx, info);
            for (int i = 0; i < xmlBases.size(); ++i) {
                String id = xmlBases.get(i).getDataId();
                billIDs.add(id);
                if ((i + 1) % queryNumber != 0 && i + 1 != xmlBases.size()) continue;
                filter.getFilterItems().add(new FilterItemInfo("id", billIDs, CompareType.INCLUDE));
                IObjectCollection coll = billHandler.getObjectCollection(this.ctx, bosType, viewInfo);
                if (coll != null) {
                    int j;
                    HashMap<String, IObjectValue> resultMap = new HashMap<String, IObjectValue>();
                    for (j = 0; j < coll.size(); ++j) {
                        IObjectValue iOV = coll.getObject(j);
                        resultMap.put(iOV.get("id").toString(), iOV);
                    }
                    for (j = i + 1 == xmlBases.size() ? i / queryNumber * queryNumber : i - queryNumber + 1; j <= i; ++j) {
                        IObjectValue iobj = (IObjectValue)resultMap.get(xmlBases.get(j).getDataId());
                        IObjectValue iobjClone = null;
                        if (iobj != null) {
                            if (iobj.get(MAINBILLID) != null && !iobj.get(MAINBILLID).equals(((ArchInfo)xmlBases.get(j)).getMainBillNumber())) {
                                iobjClone = (IObjectValue)iobj.getClass().newInstance();
                                iobjClone.putAll(iobj);
                                if (iobjClone == null) {
                                    Method method = null;
                                    try {
                                        method = iobj.getClass().getMethod("clone", new Class[0]);
                                        iobjClone = (IObjectValue)method.invoke((Object)iobj, new Object[0]);
                                    }
                                    catch (Exception e) {
                                        logger.error((Object)e);
                                    }
                                }
                            }
                            BillXmlSrcObj srcObj = new BillXmlSrcObj();
                            if (iobjClone == null) {
                                srcObj.setBillInfo(iobj);
                            } else {
                                srcObj.setBillInfo(iobjClone);
                            }
                            iobj.put(PERIODYEARKEY, (Object)periodInfo.getPeriodYear());
                            iobj.put(PERIODNUMBERKEY, (Object)periodInfo.getPeriodNumber());
                            iobj.put(MAINBILLID, (Object)((ArchInfo)xmlBases.get(j)).getMainBillID());
                            iobj.put(MAINBILLNUMBER, (Object)((ArchInfo)xmlBases.get(j)).getMainBillNumber());
                            iobj.put(ARCHORGNUMBER, (Object)((ArchInfo)xmlBases.get(j)).getArchInfos().getOrg().getNumber());
                            iobj.put(ARCHORGNAME, (Object)((ArchInfo)xmlBases.get(j)).getArchInfos().getOrg().getName());
                            iobj.put(ARCHORGID, (Object)((ArchInfo)xmlBases.get(j)).getArchInfos().getOrg().getId().toString());
                            String billNumber = ((ArchInfo)xmlBases.get(j)).getBillNumber();
                            if (!StringUtils.isEmpty((String)billNumber)) {
                                iobj.put("number", (Object)billNumber);
                            }
                            xmlBases.get(j).setData(srcObj);
                            continue;
                        }
                        logger.error((Object)("\u5355\u636eid\u627e\u4e0d\u5230\u6570\u636e\u5e93\u8bb0\u5f55:[" + xmlBases.get(j).getDataId() + "]"));
                    }
                }
                billIDs.clear();
                viewInfo.getFilter().getFilterItems().clear();
            }
        }
        return xmlBases;
    }

    protected Element createImageElement(Element data, ArchInfo archInfo) {
        ImageInfo imageInfo = archInfo.getImage();
        if (imageInfo == null || StringUtils.isEmpty((String)imageInfo.getImageNumber())) {
            return data;
        }
        String[] imagesys = new String[]{"imagesys"};
        Element ele = this.addDestField(imagesys, "", data);
        String[] imagesystype = new String[]{"imagesystype"};
        this.addDestField(imagesystype, imageInfo.getImageSysType(), ele);
        String[] imagesysip = new String[]{"imagesysip"};
        this.addDestField(imagesysip, imageInfo.getIp(), ele);
        String[] imagesysport = new String[]{"imagesysport"};
        this.addDestField(imagesysport, imageInfo.getPort(), ele);
        String[] list = new String[]{"image-list", "image", "imagenumber"};
        this.addDestField(list, imageInfo.getImageNumber(), data);
        return data;
    }

    protected Element createInvoiceElement(Element data, ArchInfo archInfo) {
        InvoiceInfo invoiceInfo = archInfo.getInvoice();
        if (invoiceInfo == null) {
            return data;
        }
        String[] invoicesys = new String[]{"invoicesys"};
        Element ele = this.addDestField(invoicesys, "", data);
        String[] imagesystype = new String[]{"invoicesystype"};
        this.addDestField(imagesystype, invoiceInfo.getInvoiceSysType(), ele);
        String[] invoicesysip = new String[]{"invoicesysip"};
        this.addDestField(invoicesysip, invoiceInfo.getIp(), ele);
        String[] imagesysport = new String[]{"invoicesysport"};
        this.addDestField(imagesysport, invoiceInfo.getPort(), ele);
        return data;
    }

    protected Element createRefBillElement(Element data, ArchInfo archInfo) {
        Set<ArchInfo> refSet = archInfo.getRefInfo();
        String[] ismainbill = new String[]{"ismainbill"};
        this.addDestField(ismainbill, archInfo.getIsMainBill().toString(), data);
        if (refSet == null || refSet.isEmpty()) {
            return data;
        }
        String[] list = new String[]{"refbill-list"};
        Element listEle = this.addDestField(list, "", data);
        String[] refbill = new String[]{"refbill"};
        String[] id = new String[]{"billid"};
        String[] doctype = new String[]{"doctype"};
        for (ArchInfo info : refSet) {
            Element refBillEle = this.addDestField(refbill, "", listEle);
            this.addDestField(id, info.getBillId(), refBillEle);
            this.addDestField(doctype, info.getDocType(), refBillEle);
        }
        return data;
    }

    @Override
    protected Element createOtherElement(Element dataEle, XmlBase info) {
        if (!(info instanceof ArchInfo)) {
            throw new ClassCastException("XmlBase \u5fc5\u987b\u662f" + ArchInfo.class.getSimpleName() + "\u7684\u5b50\u7c7b\u624d\u80fd\u8c03\u7528\u5f53\u524d\u65b9\u6cd5!");
        }
        ArchInfo billArchInfo = (ArchInfo)info;
        this.createImageElement(dataEle, billArchInfo);
        this.createRefBillElement(dataEle, billArchInfo);
        this.createFilesElement(dataEle, info);
        return dataEle;
    }
}

