/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.el.rec.ArcRecordInfo;
import com.kingdee.eas.el.rec.RecException;
import com.kingdee.eas.el.rec.ReportCycleType;
import com.kingdee.eas.el.rec.RptDetailType;
import com.kingdee.eas.el.rec.filing.tools.FilingUtils;
import com.kingdee.eas.el.rec.model.ElTemplateReportInfo;
import com.kingdee.eas.el.rec.model.FileStreamInfo;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.OtherReportFilter;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.engine.HasTemplateReportParsingEngineUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.AdjustImport;
import com.kingdee.eas.fi.gr.cslrpt.app.EliminationImport;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryCollection;
import com.kingdee.eas.tools.datatask.DIETemplateFieldEntryFactory;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.format.UnderlineStyle;
import jxl.write.Boolean;
import jxl.write.Colour;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CslReportParsingEngineUtil
extends HasTemplateReportParsingEngineUtil {
    private static String AdjustQueryPK = "com.kingdee.eas.fi.gr.cslrpt.AdjustQueryForExport";
    private static String AdjustDIETemplateFieldID = "C07sjwEWEADgAAywwKgTMEd1XrM=";
    private static DIETemplateFieldEntryCollection AdjustColumns = null;
    private static String EliminationQueryPK = "com.kingdee.eas.fi.gr.cslrpt.EliminationQueryForExport";
    private static String EliminationDIETemplateFieldID = "C07sjwEWEADgAAzhwKgTMEd1XrM=";
    private static DIETemplateFieldEntryCollection EliminationColumns = null;

    @Override
    protected ReportBaseInfo getReportBaseInfo(Context ctx, OtherReportFilter orFilter, SelectorItemCollection selector) {
        return null;
    }

    @Override
    public InputStream getFileIS(Context ctx, IXmlSrcObj iXmlSrcObj) throws Exception {
        ReportBaseInfo reportInfo = ((ElTemplateReportInfo)iXmlSrcObj).getBaseRepInfo();
        if (reportInfo == null) {
            logger.error((Object)"reportInfo is null");
            return null;
        }
        if (reportInfo.getId() == null) {
            FileStreamInfo fileStreamInfo = this.excel2pdf(iXmlSrcObj, new ByteArrayInputStream(reportInfo.getData()));
            if (fileStreamInfo.isTempFile()) {
                FilingUtils.deleteTempFile((File[])iXmlSrcObj.get("tempFile"));
                iXmlSrcObj.put("tempFile", new File[]{fileStreamInfo.getTempFile()});
            }
            return fileStreamInfo.getInputStream();
        }
        return super.getFileIS(ctx, iXmlSrcObj);
    }

    @Override
    public IXmlSrcObj getReportDataSources(Context ctx, ReportFilter info) throws Exception {
        ElTemplateReportInfo temlateCsl = new ElTemplateReportInfo();
        ArcRecordInfo arcRecordInfo = info.getArcRecordInfo();
        if (RptDetailType.HBBB.equals((Object)arcRecordInfo.getContent().getRptDetailType())) {
            List<Map<String, Object>> cfgList = this.readConfig(arcRecordInfo.getContent());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("startDate"));
            sic.add(new SelectorItemInfo("endDate"));
            sic.add(new SelectorItemInfo("data"));
            for (int i = 1; i < cfgList.size(); ++i) {
                Map<String, Object> rule = cfgList.get(i);
                String srcfield = rule.get("srcfield").toString();
                String[] srcs = srcfield.split(",");
                for (int j = 0; j < srcs.length; ++j) {
                    sic.add(new SelectorItemInfo(srcs[j]));
                }
            }
            TemplateInfo templateInfo = arcRecordInfo.getTemplate();
            if (StringUtils.isBlank((CharSequence)arcRecordInfo.getTemplate().getNumber())) {
                templateInfo = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo(H.PK(arcRecordInfo.getTemplate().getId() + ""));
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("year", (Object)(arcRecordInfo.getPeriodNum() / 100)));
            filter.getFilterItems().add(new FilterItemInfo("period", (Object)(arcRecordInfo.getPeriodNum() % 100)));
            if (arcRecordInfo.getContentType().getValue().equals("qmsReport")) {
                filter.getFilterItems().add(new FilterItemInfo("fastMergeSoluId", (Object)arcRecordInfo.getMergeScheme().getId().toString()));
            } else if (arcRecordInfo.getContentType().getValue().equals("rptsReport")) {
                filter.getFilterItems().add(new FilterItemInfo("fastMergeSoluId", null));
            }
            filter.getFilterItems().add(new FilterItemInfo("template.templateType", (Object)templateInfo.getTemplateType().getValue()));
            if (RptTmpTypeEnum.MANUSCRIPT.getValue() == templateInfo.getTemplateType().getValue()) {
                filter.getFilterItems().add(new FilterItemInfo("auditedStatus", (Object)2));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("committedStatus", (Object)3));
            }
            view.setFilter(filter);
            view.setSelector(sic);
            OrgStructureInfo orgStructureInfo = arcRecordInfo.getMergeUnitGroup();
            if (orgStructureInfo == null) {
                logger.error((Object)"\u5408\u5e76\u62a5\u8868 orgStructureInfo is null");
            }
            if (orgStructureInfo.getTree() == null) {
                try {
                    orgStructureInfo = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo(H.PK(orgStructureInfo.getId()));
                }
                catch (Exception e) {
                    logger.error((Object)("\u518d\u6b21\u83b7\u53d6orgStructureInfo tree\u5931\u8d25[" + orgStructureInfo.getId().toString() + "]" + e), (Throwable)e);
                }
            }
            Class<?> cla = null;
            try {
                cla = Class.forName("com.kingdee.eas.fi.newrpt.util.MergeReportHandlerImp");
            }
            catch (ClassNotFoundException e) {
                throw new RecException(RecException.UNKNOWN, e, new Object[]{e.getMessage() + "\u8bf7\u5347\u7ea7\u5408\u5e76\u62a5\u8868\u8865\u4e01\uff1a850:PT156079;800:PT159530;"});
            }
            Method method = cla.getMethod("getReportInfo", Context.class, OrgStructureInfo.class, TemplateInfo.class, CurrencyInfo.class, EntityViewInfo.class);
            CslReportInfo cslReportInfo = (CslReportInfo)method.invoke(cla.newInstance(), ctx, orgStructureInfo, templateInfo, arcRecordInfo.getCurrency(), view);
            if (null == cslReportInfo) {
                return null;
            }
            temlateCsl.setBaseRepInfo((ReportBaseInfo)cslReportInfo);
            temlateCsl.getBaseRepInfo().getBook();
        } else if (RptDetailType.DXFL.equals((Object)arcRecordInfo.getContent().getRptDetailType()) || RptDetailType.TZFL.equals((Object)arcRecordInfo.getContent().getRptDetailType())) {
            ByteArrayOutputStream adjustEntry = CslReportParsingEngineUtil.AdjustEliminationEntry(ctx, arcRecordInfo.getArcRecordNum(), arcRecordInfo.getMergeUnitGroup(), arcRecordInfo.getContent().getRptDetailType(), arcRecordInfo.getReportCycleType(), arcRecordInfo.getPeriodNum() / 100, arcRecordInfo.getPeriodNum() % 100, arcRecordInfo.getCurrency());
            if (null == adjustEntry) {
                return null;
            }
            ReportBaseInfo reportBaseInfo = new ReportBaseInfo();
            reportBaseInfo.setOrgTree(arcRecordInfo.getMergeUnitGroup().getTree());
            reportBaseInfo.setCurrency(arcRecordInfo.getCurrency());
            reportBaseInfo.setTemplate(arcRecordInfo.getTemplate());
            reportBaseInfo.setYear(arcRecordInfo.getPeriodNum() / 100);
            reportBaseInfo.setPeriod((short)(arcRecordInfo.getPeriodNum() % 100));
            reportBaseInfo.setData(adjustEntry.toByteArray());
            temlateCsl.setBaseRepInfo(reportBaseInfo);
        }
        temlateCsl.getBaseRepInfo().put("exportFileType", (Object)info.getRecordBaseInfo().getExportFileType());
        return temlateCsl;
    }

    private static ByteArrayOutputStream AdjustEliminationEntry(Context ctx, String fileName, OrgStructureInfo orgStructureInfo, RptDetailType type, ReportCycleType reportCycleType, int periodYear, int periodNumber, CurrencyInfo currencyInfo) throws BOSException, SQLException, TaskExternalException, IOException, RowsExceededException, WriteException {
        IQueryExecutor exec = null;
        exec = RptDetailType.TZFL.equals((Object)type) ? QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(AdjustQueryPK)) : QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(EliminationQueryPK));
        RptPeriodTypeEnum periodType = FilingUtils.convertToRptEnum(reportCycleType);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (orgStructureInfo.getTree() == null) {
            try {
                orgStructureInfo = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo(H.PK(orgStructureInfo.getId()));
            }
            catch (Exception e) {
                logger.error((Object)("\u518d\u6b21\u83b7\u53d6orgStructureInfo tree\u5931\u8d25[" + orgStructureInfo.getId().toString() + "]" + e), (Throwable)e);
            }
        }
        filter.getFilterItems().add(new FilterItemInfo("orgBound.id", (Object)orgStructureInfo.getTree().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)periodYear));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)periodNumber));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodType.getValue()));
        filter.getFilterItems().add(new FilterItemInfo("currency.number", (Object)currencyInfo.getNumber()));
        view.setFilter(filter);
        exec.setObjectView(view);
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        String sql = exec.getSQL();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.size() == 0) {
            return null;
        }
        Object adjustImport = null;
        adjustImport = RptDetailType.TZFL.equals((Object)type) ? new AdjustImport() : new EliminationImport();
        ArrayList<Hashtable> list = new ArrayList<Hashtable>();
        while (rs != null && rs.next()) {
            Hashtable exportTransmit = (Hashtable)adjustImport.exportTransmit(rs, ctx);
            list.add(exportTransmit);
        }
        DIETemplateFieldEntryCollection columns = CslReportParsingEngineUtil.getColumns(ctx, type);
        return CslReportParsingEngineUtil.toExcel2007(fileName, columns, list, type);
    }

    private static ByteArrayOutputStream toExcel2007(String fileName, DIETemplateFieldEntryCollection columns, List<Hashtable> list, RptDetailType type) throws RowsExceededException, WriteException, IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFCellStyle style = workBook.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        XSSFSheet sheet = workBook.createSheet();
        workBook.setSheetName(0, "sheet0");
        sheet.setDefaultColumnWidth(30);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, columns.size() - 1));
        XSSFRow rowMerged = sheet.createRow(0);
        Cell mergedCell = rowMerged.createCell(0);
        if (RptDetailType.TZFL.equals((Object)type)) {
            mergedCell.setCellValue((RichTextString)new XSSFRichTextString("\u8c03\u6574\u5206\u5f55"));
        } else {
            mergedCell.setCellValue((RichTextString)new XSSFRichTextString("\u62b5\u6d88\u5206\u5f55"));
        }
        XSSFRow row = sheet.createRow(1);
        for (int i = 0; i < columns.size(); ++i) {
            Cell cell = row.createCell(i);
            XSSFRichTextString text = new XSSFRichTextString(columns.get(i).getName());
            cell.setCellValue((RichTextString)text);
        }
        if (list.size() > 0) {
            int col = 2;
            for (int i = 0; i < list.size(); ++i) {
                XSSFRow row1 = sheet.createRow(col);
                Hashtable info = list.get(i);
                for (int j = 0; j < columns.size(); ++j) {
                    Cell contentCell = row1.createCell(j);
                    Object dataObject = info.get(columns.get(j).getNumber());
                    if (dataObject != null) {
                        if (dataObject instanceof Integer) {
                            contentCell.setCellValue((double)Integer.parseInt(dataObject.toString()));
                            continue;
                        }
                        if (dataObject instanceof Double) {
                            contentCell.setCellValue(Double.parseDouble(dataObject.toString()));
                            continue;
                        }
                        if (dataObject instanceof Long && dataObject.toString().length() == 13) {
                            contentCell.setCellValue(CslReportParsingEngineUtil.getCnDate(new Date(Long.parseLong(dataObject.toString()))));
                            continue;
                        }
                        if (dataObject instanceof Date) {
                            contentCell.setCellValue(CslReportParsingEngineUtil.getCnDate((Date)dataObject));
                            continue;
                        }
                        if (dataObject instanceof java.lang.Boolean) {
                            contentCell.setCellValue(((java.lang.Boolean)dataObject).booleanValue());
                            continue;
                        }
                        contentCell.setCellValue(dataObject.toString());
                        continue;
                    }
                    contentCell.setCellValue("");
                }
                ++col;
            }
        }
        workBook.write((OutputStream)os);
        workBook.close();
        return os;
    }

    private static String getCnDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    private static ByteArrayOutputStream toExcel(String fileName, DIETemplateFieldEntryCollection columns, List<Hashtable> list, RptDetailType type) throws RowsExceededException, WriteException, IOException {
        int i;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WritableWorkbook wbook = Workbook.createWorkbook((OutputStream)os);
        WritableSheet wsheet = wbook.createSheet("sheet0", 0);
        WritableFont wfont = new WritableFont(WritableFont.ARIAL, 16, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
        WritableCellFormat wcfFC = new WritableCellFormat(wfont);
        if (RptDetailType.TZFL.equals((Object)type)) {
            wsheet.addCell((WritableCell)new Label(0, 0, "\u8c03\u6574\u5206\u5f55", (CellFormat)wcfFC));
        } else if (RptDetailType.DXFL.equals((Object)type)) {
            wsheet.addCell((WritableCell)new Label(0, 0, "\u62b5\u6d88\u5206\u5f55", (CellFormat)wcfFC));
        }
        int nCol = 0;
        for (i = 0; i < columns.size(); ++i) {
            wsheet.addCell((WritableCell)new Label(nCol, 1, columns.get(i).getNumber()));
            wsheet.addCell((WritableCell)new Label(nCol, 2, columns.get(i).getName()));
            ++nCol;
        }
        wsheet.mergeCells(0, 0, nCol - 1, 0);
        if (list.size() > 0) {
            for (i = 0; i < list.size(); ++i) {
                int col = 0;
                Hashtable info = list.get(i);
                for (int j = 0; j < columns.size(); ++j) {
                    Object value = null;
                    value = info.get(columns.get(j).getNumber());
                    if (null == value) {
                        wsheet.addCell((WritableCell)new Label(col, i + 3, null));
                    } else if (value instanceof BigDecimal) {
                        wsheet.addCell((WritableCell)new Number(col, i + 3, (value == null ? null : Double.valueOf(((BigDecimal)value).doubleValue())).doubleValue()));
                    } else if (value instanceof Timestamp) {
                        wsheet.addCell((WritableCell)new DateTime(col, i + 3, (java.util.Date)(value == null ? null : (Timestamp)value)));
                    } else if (value instanceof Date) {
                        wsheet.addCell((WritableCell)new DateTime(col, i + 3, (java.util.Date)(value == null ? null : (Date)value)));
                    } else if (value instanceof java.lang.Boolean) {
                        wsheet.addCell((WritableCell)new Boolean(col, i + 3, (value == null ? null : (java.lang.Boolean)value).booleanValue()));
                    } else {
                        wsheet.addCell((WritableCell)new Label(col, i + 3, value == null ? null : value.toString()));
                    }
                    ++col;
                }
            }
        }
        wbook.write();
        wbook.close();
        os.close();
        return os;
    }

    private static DIETemplateFieldEntryCollection getColumns(Context ctx, RptDetailType type) throws BOSException {
        if (RptDetailType.TZFL.equals((Object)type) && null != AdjustColumns) {
            return AdjustColumns;
        }
        if (RptDetailType.DXFL.equals((Object)type) && null != EliminationColumns) {
            return EliminationColumns;
        }
        String templatefieldId = AdjustDIETemplateFieldID;
        if (RptDetailType.DXFL.equals((Object)type)) {
            templatefieldId = EliminationDIETemplateFieldID;
        }
        DIETemplateFieldEntryCollection collection = DIETemplateFieldEntryFactory.getLocalInstance((Context)ctx).getDIETemplateFieldEntryCollection("select number, name where parent = '" + templatefieldId + "' order by SEQ asc");
        if (RptDetailType.TZFL.equals((Object)type)) {
            AdjustColumns = collection;
        } else {
            EliminationColumns = collection;
        }
        return collection;
    }

    @Override
    public List<Map<String, Object>> supportExportFileType() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("name", "EXCEL");
        map1.put("value", "xlsx");
        list.add(map1);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("name", "PDF");
        map2.put("value", "pdf");
        list.add(map2);
        return list;
    }

    @Override
    protected String getDefaultExportFileType() {
        return "xlsx";
    }
}

