/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.el.rec.RecordBaseCollectImplType;
import com.kingdee.eas.el.rec.RecordBaseFactory;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.tool.customer.CustomerFunction;
import com.kingdee.eas.el.rec.tool.engine.BillParsingEngineUtil;
import com.kingdee.eas.el.rec.tool.engine.CslReportParsingEngineUtil;
import com.kingdee.eas.el.rec.tool.engine.SingleReportParsingEngineUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public abstract class ParsingEngineUtil {
    protected static Logger logger = Logger.getLogger(ParsingEngineUtil.class);
    public static final String CREATER = "EAS";
    public static final String TEMP_FILE = "tempFile";
    protected static final String NOTHING = "nothing";
    protected static final String LISTTAG = "-list";
    protected static final String EXPRKEY = "expr";
    public static final Pattern paramReg = Pattern.compile("((#((#)|([\\d])+))|(\\{([^\\\\{\\\\}])*\\}))");
    public static final Pattern functionNameReg = Pattern.compile("[\\w&&[\\D]]([\\w])*");
    public static final Pattern spaceReg = Pattern.compile("([\\s])*");
    public static final Pattern functionReg = Pattern.compile(functionNameReg.pattern() + spaceReg.pattern() + "\\(" + spaceReg.pattern() + paramReg.pattern() + spaceReg.pattern() + "(," + spaceReg.pattern() + paramReg.pattern() + spaceReg.pattern() + ")*\\)");
    protected static Map<String, Map<String, Object>> configCacheMap = new HashMap<String, Map<String, Object>>();
    protected Context ctx = null;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ParsingEngineUtil getInstance(Context ctx, RecordBaseInfo info) throws Exception {
        void var2_7;
        block7: {
            block8: {
                Object var2_2 = null;
                if (info != null && !StringUtils.isEmpty((String)info.getCollectImpl())) break block8;
                if (RecordBaseCollectImplType.ENTITY.equals((Object)info.getCollectImplType())) {
                    BillParsingEngineUtil billParsingEngineUtil = new BillParsingEngineUtil();
                    break block7;
                } else if (RecordBaseCollectImplType.BASEREPORT.equals((Object)info.getCollectImplType())) {
                    SingleReportParsingEngineUtil singleReportParsingEngineUtil = new SingleReportParsingEngineUtil();
                    break block7;
                } else {
                    if (!RecordBaseCollectImplType.CSLREPORT.equals((Object)info.getCollectImplType())) {
                        String msg = "\u9664\u4e86\u5355\u636e\u4e0e\u57fa\u7840\u62a5\u8868,\u5fc5\u987b\u586b\u5199RecordBaseInfo\u7684\u5b9e\u73b0\u7c7binfo:" + info.getId();
                        logger.error((Object)msg);
                        throw new NullPointerException(msg);
                    }
                    CslReportParsingEngineUtil cslReportParsingEngineUtil = new CslReportParsingEngineUtil();
                }
                break block7;
            }
            try {
                ParsingEngineUtil parsingEngineUtil = (ParsingEngineUtil)Class.forName(info.getCollectImpl()).newInstance();
            }
            catch (Exception e) {
                logger.error((Object)("\u521b\u5efa\u89e3\u6790\u5f15\u64ce\u5de5\u5177\u7c7b\u5931\u8d25!info.getCollectImpl():" + info.getCollectImpl()), (Throwable)e);
                throw e;
            }
        }
        var2_7.ctx = ctx;
        return var2_7;
    }

    public Document getXMLFromInfoByConfig(List<XmlBase> infoList, RecordBaseInfo info) throws Exception {
        List<Map<String, Object>> cfgList = this.readConfig(info);
        return this.getXMLFromInfoByConfig(infoList, cfgList);
    }

    public Document getXMLFromInfoByConfig(List<XmlBase> infoList, String configXml) throws Exception {
        StringReader configReader = new StringReader(configXml);
        return this.getXMLFromInfoByConfig(infoList, configReader);
    }

    public Document getXMLFromInfoByConfig(List<XmlBase> infoList, Reader configReader) throws Exception {
        List<Map<String, Object>> cfgList = this.readConfig(configReader);
        return this.getXMLFromInfoByConfig(infoList, cfgList);
    }

    protected Document getXMLFromInfoByConfig(List<XmlBase> infoList, List<Map<String, Object>> cfgList) throws Exception {
        Document outDoc = DocumentHelper.createDocument();
        try {
            Element docInfo = outDoc.addElement("docinfo");
            Map<String, Object> map = cfgList.get(0);
            map = this.decorateHeadMap(infoList, map);
            Element header = this.createHeadElement(map, docInfo);
            if (infoList.get(0).getReArchFlag() != null) {
                String[] reArchFlagtag = new String[]{"rearchflag"};
                this.addDestField(reArchFlagtag, infoList.get(0).getReArchFlag().getValue(), header);
            }
            Element data_listEle = docInfo.addElement("data-list");
            for (int i = 0; i < infoList.size(); ++i) {
                XmlBase info = infoList.get(i);
                if (!info.getDocType().equals(map.get("doctype"))) {
                    throw new Exception("ArchInfo\u7684docType[" + info.getDocType() + "]\u4e0exml\u914d\u7f6edoctype[" + map.get("doctype") + "]\u4e0d\u4e00\u81f4!");
                }
                this.createDataElement(cfgList, data_listEle, info);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw e;
        }
        return outDoc;
    }

    protected Map<String, Object> decorateHeadMap(List<XmlBase> infoList, Map<String, Object> map) {
        for (String key : map.keySet()) {
            Object defaultValue = map.get(key);
            String value = this.decorateHeadText(infoList, key, defaultValue);
            map.put(key, value);
        }
        return map;
    }

    protected String decorateHeadText(List<XmlBase> infoList, String key, Object defaultValue) {
        boolean forEachFlag = true;
        for (int i = 0; i < infoList.size(); ++i) {
            XmlBase xmlBase = infoList.get(i);
            Method[] methods = xmlBase.getClass().getMethods();
            for (int j = 0; j < methods.length; ++j) {
                if (!("get" + this.toUpperCaseFrist(key)).equals(methods[j].getName())) continue;
                try {
                    defaultValue = methods[j].invoke((Object)xmlBase, null);
                    forEachFlag = false;
                    break;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (!forEachFlag) break;
        }
        return (String)defaultValue;
    }

    protected String toUpperCaseFrist(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return "";
        }
        String frist = key.substring(0, 1);
        return frist.toUpperCase() + key.substring(1);
    }

    protected Element createDefaultElement(IXmlSrcObj iobj, Element data, XmlBase info) {
        String[] arr = new String[]{"id"};
        this.addDestField(arr, info.getId(), data);
        String[] billid = new String[]{"billid"};
        if (!StringUtils.isEmpty((String)info.getDataId())) {
            this.addDestField(billid, info.getDataId(), data);
        }
        return data;
    }

    protected Element createHeadElement(Map<String, Object> map, Element docInfo) {
        Element header = docInfo.addElement("header");
        header.addElement("creater").setText(CREATER);
        header.addElement("time").setText(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        for (String key : map.keySet()) {
            Object value = map.get(key);
            String valueStr = value == null ? "" : value.toString();
            header.addElement(key).setText(valueStr);
        }
        return header;
    }

    protected Element createDataElement(List<Map<String, Object>> cfgList, Element data_listEle, XmlBase info) {
        Element data = data_listEle.addElement("data");
        IXmlSrcObj iobj = info.getData();
        this.createDefaultElement(iobj, data, info);
        if (iobj != null) {
            for (int i = 1; i < cfgList.size(); ++i) {
                Map<String, Object> rule = cfgList.get(i);
                this.createDataMappingElement(rule, data, iobj);
            }
        }
        this.createOtherElement(data, info);
        return data;
    }

    protected abstract Element createOtherElement(Element var1, XmlBase var2);

    protected Element createDataMappingElement(Map<String, Object> mapping_rule, Element dataEle, Object iobj) {
        Object srcFieldObj = this.getSrcField(mapping_rule, iobj);
        this.addDestField(mapping_rule, srcFieldObj, dataEle);
        return dataEle;
    }

    protected Element createFilesElement(Element data, XmlBase archInfo) {
        Set<FileInfo> fileInfos = archInfo.getFileInfos();
        if (fileInfos == null || fileInfos.isEmpty()) {
            return data;
        }
        String[] list = new String[]{"file-list"};
        Element listEle = this.addDestField(list, "", data);
        String[] file = new String[]{"file"};
        String[] name = new String[]{"name"};
        String[] srcname = new String[]{"srcname"};
        String[] exception = new String[]{"exception"};
        for (FileInfo fileInfo : fileInfos) {
            Element fileEle = this.addDestField(file, "", listEle);
            this.addDestField(name, fileInfo.getName(), fileEle);
            this.addDestField(srcname, fileInfo.getSrcname(), fileEle);
            if (StringUtils.isEmpty((String)fileInfo.getException())) continue;
            this.addDestField(exception, fileInfo.getException(), fileEle);
        }
        return data;
    }

    protected Object getSrcField(Map<String, Object> rule, Object iobj) {
        String srcfield = rule.get("srcfield").toString();
        String[] srcfieldArr = srcfield.split(",");
        Object formatObj = rule.get("format");
        String format = "";
        JSONObject formatJsonObj = null;
        if (formatObj != null) {
            formatJsonObj = JSONObject.parseObject((String)formatObj.toString());
        }
        return this.getSrcField(srcfieldArr, (Map<String, Object>)formatJsonObj, iobj);
    }

    protected Object getSrcField(String[] srcfieldArr, Map<String, Object> formatMap, Object iobj) {
        Object ret = null;
        Object exprObj = null;
        if (formatMap != null) {
            exprObj = formatMap.get(EXPRKEY);
        }
        String expr = null;
        String signleExpr = null;
        if (exprObj == null) {
            srcfieldArr = srcfieldArr[0].split("\\.");
            ret = CustomerFunction.getSrcFieldBase(srcfieldArr, iobj);
        } else {
            expr = exprObj.toString();
            Matcher matcher = functionReg.matcher(expr);
            boolean find = false;
            find = matcher.find();
            if (!find) {
                throw new RuntimeException("\u683c\u5f0f\u5316\u5185\u5bb9\u914d\u7f6e\u9519\u8bef,\u89e3\u6790\u5931\u8d25expr=\u3010" + expr + "\u3011");
            }
            StringBuffer newExpr = new StringBuffer();
            ArrayList subResults = new ArrayList();
            ArrayList<Object> curResults = new ArrayList<Object>();
            int st_indexOfSubResults = 0;
            int en_indexOfSubResults = 0;
            Matcher paramatcher = null;
            boolean paramFind = false;
            while (find) {
                st_indexOfSubResults = en_indexOfSubResults;
                matcher.appendReplacement(newExpr, "##");
                signleExpr = matcher.group();
                paramatcher = paramReg.matcher(signleExpr);
                paramFind = paramatcher.find();
                while (paramFind) {
                    String param = paramatcher.group();
                    if ("##".equals(param)) {
                        ++en_indexOfSubResults;
                    }
                    paramFind = paramatcher.find();
                }
                Object curResult = this.getSrcFieldBySubFun(srcfieldArr, signleExpr, iobj, subResults.subList(st_indexOfSubResults, en_indexOfSubResults));
                curResults.add(curResult);
                find = matcher.find();
                if (find) continue;
                matcher.appendTail(newExpr);
                expr = newExpr.toString();
                newExpr.delete(0, newExpr.length());
                subResults.clear();
                subResults.addAll(curResults);
                curResults.clear();
                matcher = functionReg.matcher(expr);
                find = matcher.find();
            }
            ret = subResults.get(0);
            try {
                ret = JSONObject.parse((String)ret.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected Object getSrcFieldBySubFun(String[] srcfieldArr, String signleExpr, Object iobj, List<Object> subResults) {
        String functionName = signleExpr.substring(0, signleExpr.indexOf("(")).trim();
        Matcher matcher = paramReg.matcher(signleExpr);
        ArrayList<Object> params = new ArrayList<Object>();
        boolean find = matcher.find();
        int i = 0;
        while (find) {
            String param = matcher.group().trim();
            if ("##".equals(param)) {
                Object tmp = subResults.get(i);
                if (tmp instanceof String) {
                    try {
                        tmp = JSONObject.parse((String)((String)tmp));
                    }
                    catch (Exception e) {
                        tmp = "{" + tmp + "}";
                    }
                }
                params.add(tmp);
                ++i;
            } else if (param.charAt(0) == '#') {
                param = param.substring(1);
                int index = Integer.parseInt(param);
                params.add(srcfieldArr[index]);
            } else {
                params.add(param);
            }
            find = matcher.find();
        }
        return CustomerFunction.getFunctionByName(functionName).execute(iobj, params.toArray());
    }

    protected Element addDestField(Map<String, Object> rule, Object srcObj, Element ele) {
        String destfield = rule.get("destfield").toString();
        String[] destfieldArr = destfield.split("\\.");
        this.addDestField(destfieldArr, srcObj, ele);
        return ele;
    }

    protected Element addDestField(String[] destfieldArr, Object srcObj, Element ele) {
        ArrayList<Integer> _list_index = new ArrayList<Integer>();
        for (int i = 0; i < destfieldArr.length; ++i) {
            if (!destfieldArr[i].endsWith(LISTTAG)) continue;
            _list_index.add(i);
        }
        if (_list_index.isEmpty()) {
            String value = null;
            StringBuffer key = new StringBuffer();
            for (int i = 0; i < destfieldArr.length; ++i) {
                key.append(destfieldArr[i]).append('.');
            }
            String keyStr = key.substring(0, key.length() - 1);
            if (srcObj instanceof Map) {
                Map valueMap = (Map)srcObj;
                Object valueObj = valueMap.get(keyStr);
                value = valueObj == null ? valueMap.get(valueMap.keySet().iterator().next()) + "" : valueObj.toString();
            } else {
                try {
                    value = srcObj.getClass().getMethod("get", String.class).invoke(srcObj, keyStr) + "";
                }
                catch (Exception e) {
                    value = srcObj + "";
                }
            }
            return this.addDestField(destfieldArr, value, ele);
        }
        int end = 0;
        String[][] splitArr = new String[_list_index.size() + 1][];
        int start = 0;
        for (int i = 0; i < _list_index.size(); ++i) {
            if (i > 0) {
                start = (Integer)_list_index.get(i - 1);
            }
            end = (Integer)_list_index.get(i);
            String[] subArr = Arrays.copyOfRange(destfieldArr, start, end + 1);
            splitArr[i] = subArr;
        }
        splitArr[splitArr.length - 1] = Arrays.copyOfRange(destfieldArr, end + 1, destfieldArr.length);
        this.addDestField(splitArr, srcObj, ele);
        return ele;
    }

    protected Element addDestField(String[][] splitArr, Object srcObj, Element ele) {
        Object valueObj = null;
        StringBuffer key = new StringBuffer();
        for (int i = 0; i < splitArr[0].length; ++i) {
            key.append(splitArr[0][i]).append('.');
        }
        String keyStr = key.substring(0, key.length() - 1);
        if (srcObj instanceof Map) {
            Map valueMap = (Map)srcObj;
            valueObj = valueMap.get(keyStr);
            if (valueObj == null) {
                try {
                    valueObj = valueMap.get(valueMap.keySet().iterator().next());
                }
                catch (Exception e) {
                    valueObj = null;
                }
            }
        } else {
            try {
                valueObj = srcObj.getClass().getMethod("get", String.class).invoke(srcObj, keyStr);
            }
            catch (Exception e) {
                valueObj = srcObj + "";
            }
        }
        if (splitArr.length == 1) {
            this.addDestField(splitArr[0], valueObj + "", ele);
        } else {
            Element subEle = this.addDestField(splitArr[0], "", ele);
            String[][] subSplitArr = (String[][])Arrays.copyOfRange(splitArr, 1, splitArr.length);
            List list = new ArrayList<Object>();
            if (valueObj instanceof List) {
                list = (List)valueObj;
            } else {
                list.add(valueObj);
            }
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    this.addDestField(subSplitArr, list.get(i), subEle);
                }
            }
        }
        return ele;
    }

    protected Element addDestField(String[] destfieldArr, String value, Element ele) {
        Element parent = ele;
        Element child = null;
        for (int i = 0; i < destfieldArr.length; ++i) {
            String eleName = destfieldArr[i].toLowerCase();
            child = parent.element(eleName);
            if (child == null) {
                child = parent.addElement(eleName);
            } else if (parent.getName().endsWith(LISTTAG)) {
                boolean addListChild = true;
                Element lisEle = parent;
                List children = lisEle.elements(eleName);
                for (int j = 0; j < children.size() && addListChild; ++j) {
                    child = (Element)children.get(j);
                    for (int k = i + 1; k < destfieldArr.length && addListChild; ++k) {
                        parent = child;
                        if ((child = parent.element(destfieldArr[k].toLowerCase())) != null) continue;
                        addListChild = false;
                        child = parent.addElement(destfieldArr[k].toLowerCase());
                        i = k;
                    }
                }
                if (addListChild) {
                    parent = lisEle;
                    child = parent.addElement(eleName);
                }
            }
            parent = child;
        }
        String string = value = value == null || "null".equals(value) ? "" : value;
        if (child != null) {
            child.setText(value);
        }
        return child;
    }

    /*
     * Unable to fully structure code
     */
    public List<Map<String, Object>> readConfig(RecordBaseInfo info) throws Exception {
        ret = null;
        config = ParsingEngineUtil.configCacheMap.get(info.getId().toString());
        if (config == null) {
            config = new HashMap<String, Object>();
            ParsingEngineUtil.configCacheMap.put(info.getId().toString(), config);
        }
        lastUpdataTimeObj = config.get("lastUpdataTime");
        if (info.getLastUpdateTime() == null) {
            info2 = RecordBaseFactory.getLocalInstance(this.ctx).getRecordBaseInfo("select id, lastUpdateTime where id = '" + info.getId() + "'");
            info.setLastUpdateTime(info2.getLastUpdateTime());
        }
        spdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (lastUpdataTimeObj == null || spdf.parse(lastUpdataTimeObj.toString()).before(info.getLastUpdateTime()) || config.get("config") == null) {
            newUpdateTimeStr = spdf.format(info.getLastUpdateTime());
            xml = info.getOutPutXMLTemplate();
            if (StringUtils.isEmpty((String)xml)) {
                sql = "select FoutPutXMLTemplate from T_REC_RecordBase where fid = ?";
                params = new Object[]{info.getId().toString()};
                try {
                    rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])params);
                    if (!rs.next()) ** GOTO lbl32
                    o = rs.getObject(1);
                    if (o instanceof Clob) {
                        c = (Clob)o;
                        ret = this.readConfig(c.getCharacterStream());
                    }
                    ret = this.readConfig(o.toString());
                }
                catch (Exception e) {
                    ParsingEngineUtil.logger.error((Object)e, (Throwable)e);
                    throw e;
                }
            } else {
                ret = this.readConfig(xml);
            }
lbl32:
            // 4 sources

            config.put("lastUpdataTime", newUpdateTimeStr);
            config.put("config", ret);
        } else {
            ret = (List<Map<String, Object>>)config.get("config");
        }
        return ret;
    }

    public List<Map<String, Object>> readConfig(String xml) throws Exception {
        StringReader in = new StringReader(xml);
        return this.readConfig(in);
    }

    protected List<Map<String, Object>> readConfig(Reader xmlReader) throws Exception {
        ArrayList<Map<String, Object>> ret = null;
        try {
            SAXReader saxReader = new SAXReader();
            Document inDoc = null;
            inDoc = saxReader.read(xmlReader);
            List allEle = inDoc.getRootElement().elements();
            ret = new ArrayList<Map<String, Object>>();
            HashMap<String, String> headMap = new HashMap<String, String>();
            ret.add(headMap);
            for (int i = 0; i < allEle.size(); ++i) {
                Element child = (Element)allEle.get(i);
                if ("rule-list".equals(child.getName())) {
                    List rules = child.elements("rule");
                    for (int j = 0; j < rules.size(); ++j) {
                        Element rule = (Element)rules.get(j);
                        List eles = rule.elements();
                        HashMap<String, String> map = new HashMap<String, String>(eles.size());
                        for (int k = 0; k < eles.size(); ++k) {
                            Element ele = (Element)eles.get(k);
                            map.put(ele.getName(), ele.getTextTrim());
                        }
                        ret.add(map);
                    }
                    continue;
                }
                headMap.put(child.getName(), child.getTextTrim());
            }
        }
        catch (Exception e) {
            logger.error((Object)("xml\u89e3\u6790\u5f02\u5e38\u5f02\u5e38\u4fe1\u606f:" + e));
            throw e;
        }
        finally {
            if (xmlReader != null) {
                try {
                    xmlReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return ret;
    }

    public List<Map<String, Object>> supportExportFileType() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(1);
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("name", "PDF");
        map.put("value", "pdf");
        list.add(map);
        return list;
    }

    protected String getDefaultExportFileType() {
        return "pdf";
    }
}

