/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine;

import com.kingdee.bos.Context;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.model.FileInfo;
import com.kingdee.eas.el.rec.model.FileStreamInfo;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.ReportArchInfo;
import com.kingdee.eas.el.rec.model.XmlBase;
import com.kingdee.eas.el.rec.tool.AttachmentDownloadServer;
import com.kingdee.eas.el.rec.tool.ExcelToPdfUtil;
import com.kingdee.eas.el.rec.tool.IReportHandler;
import com.kingdee.eas.el.rec.tool.engine.ParsingEngineUtil;
import com.kingdee.util.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public abstract class ReportParsingEngineUtil
extends ParsingEngineUtil
implements IReportHandler {
    protected final String EXPORTFILETYPE = "exportFileType";
    protected final String HASTEMPLATE = "hasTemplate";
    protected final String PDF = "pdf";
    protected final String EXCEL = "xls";
    protected final String EXCEL2007 = "xlsx";
    AttachmentDownloadServer attachmentDownloadServer = new AttachmentDownloadServer();

    @Override
    public Map<FileInfo, InputStream> getAttachmentFileISArray(Context ctx, XmlBase xmlBase) throws Exception {
        HashMap<FileInfo, InputStream> result = new HashMap<FileInfo, InputStream>();
        ReportArchInfo archInfo = (ReportArchInfo)xmlBase;
        List<FileInfo> attachmentFileInfos = archInfo.getAttachmentFileInfos();
        for (FileInfo attachmentFileInfo : attachmentFileInfos) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)attachmentFileInfo.getId())) continue;
            try {
                InputStream is = this.attachmentDownloadServer.downloadFile1(ctx, attachmentFileInfo.getId());
                result.put(attachmentFileInfo, is);
            }
            catch (Exception e) {
                attachmentFileInfo.setException("\u9644\u4ef6[" + attachmentFileInfo.getSrcname() + "]\u5b58\u5728\u5f02\u5e38");
                attachmentFileInfo.setE(e);
            }
        }
        return result;
    }

    @Override
    protected Element createOtherElement(Element dataEle, XmlBase info) {
        this.createFilesElement(dataEle, info);
        if (info instanceof ReportArchInfo) {
            List<FileInfo> attachmentFileInfos = ((ReportArchInfo)info).getAttachmentFileInfos();
            if (attachmentFileInfos == null || attachmentFileInfos.isEmpty()) {
                return dataEle;
            }
            String[] list = new String[]{"file-list"};
            Element listEle = dataEle.element(list[0]);
            if (listEle == null) {
                listEle = this.addDestField(list, "", dataEle);
            }
            String[] file = new String[]{"file"};
            String[] name = new String[]{"name"};
            String[] srcname = new String[]{"srcname"};
            String[] exception = new String[]{"exception"};
            for (FileInfo fileInfo : attachmentFileInfos) {
                Element fileEle = this.addDestField(file, "", listEle);
                this.addDestField(name, fileInfo.getName(), fileEle);
                this.addDestField(srcname, fileInfo.getSrcname(), fileEle);
                if (StringUtils.isEmpty((String)fileInfo.getException())) continue;
                this.addDestField(exception, fileInfo.getException(), fileEle);
            }
        }
        return dataEle;
    }

    @Override
    public List<Map<String, Object>> supportExportFileType() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(1);
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("name", "EXCEL");
        map.put("value", "xlsx");
        list.add(map);
        return list;
    }

    protected FileStreamInfo excel2pdf(IXmlSrcObj iXmlSrcObj, InputStream is) throws Exception {
        String defaultExportFileType = this.getDefaultExportFileType();
        String destFileType = (String)iXmlSrcObj.get("exportFileType");
        if (defaultExportFileType.startsWith("xls") && "pdf".equalsIgnoreCase(destFileType)) {
            return ExcelToPdfUtil.excel2Pdf(is, defaultExportFileType);
        }
        return new FileStreamInfo(is);
    }

    protected String getExportFileType(RecordBaseInfo recordBaseInfo) {
        if ("pdf".equalsIgnoreCase(recordBaseInfo.getExportFileType())) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)recordBaseInfo.getPrintTemplate())) {
                return "pdf";
            }
            return this.getEXCEL();
        }
        return this.getEXCEL();
    }

    private String getEXCEL() {
        List<Map<String, Object>> maps = this.supportExportFileType();
        for (int i = 0; i < maps.size(); ++i) {
            if (!maps.get(i).get("name").equals("EXCEL")) continue;
            return (String)maps.get(i).get("value");
        }
        return "xlsx";
    }
}

