/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.arap;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.el.rec.BillTypeFactory;
import com.kingdee.eas.el.rec.BillTypeInfo;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.model.ReverseReportMsgInfo;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.PeriodUtil;
import com.kingdee.eas.el.rec.tool.engine.WithoutEntityReportParsingEngineUtil;
import com.kingdee.eas.el.rec.tool.engine.arap.ArApRptSummaryRptService;
import com.kingdee.eas.el.rec.tool.engine.arap.ArApRptVirtualAgingService;
import com.kingdee.eas.el.rec.tool.engine.arap.param.AccountAgeQueryParam;
import com.kingdee.eas.el.rec.tool.engine.arap.param.SummaryRptQueryParam;
import com.kingdee.eas.framework.report.util.RptParams;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArApReportParsingEngineUtil
extends WithoutEntityReportParsingEngineUtil {
    private Object fillData(Context ctx, ReportFilter info, PeriodCollection perCol, String billTypeNumber) throws Exception {
        Object print = null;
        if ("ArVirtualSumRpt".equals(billTypeNumber)) {
            print = this.fillVirtualSumRptData(ctx, info, perCol, billTypeNumber, true);
        } else if ("ApVirtualSumRpt".equals(billTypeNumber)) {
            print = this.fillVirtualSumRptData(ctx, info, perCol, billTypeNumber, false);
        } else if ("ArVirtualAgingRpt".equals(billTypeNumber)) {
            print = this.fillVirtualAgingRptData(ctx, info, perCol, billTypeNumber, true);
        } else if ("ApVirtualAgingRpt".equals(billTypeNumber)) {
            print = this.fillVirtualAgingRptData(ctx, info, perCol, billTypeNumber, false);
        }
        return print;
    }

    private Object fillVirtualSumRptData(Context ctx, ReportFilter info, PeriodCollection perCol, String billTypeNumber, boolean isAr) throws Exception {
        SummaryRptQueryParam param = new SummaryRptQueryParam();
        ArApRptSummaryRptService service = new ArApRptSummaryRptService(ctx, param);
        service.buildQueryCondition(info, perCol, billTypeNumber, isAr);
        RptParams result = (RptParams)service.executeQuery();
        InputStream print = service.getPrintIS(ctx, result);
        return print;
    }

    private Object fillVirtualAgingRptData(Context ctx, ReportFilter info, PeriodCollection perCol, String billTypeNumber, boolean isAr) throws Exception {
        AccountAgeQueryParam param = new AccountAgeQueryParam();
        ArApRptVirtualAgingService service = new ArApRptVirtualAgingService(ctx, param);
        service.buildQueryCondition(info, perCol, billTypeNumber, isAr);
        RptParams result = (RptParams)service.executeQuery();
        InputStream print = service.getPrintIS(ctx, result);
        return print;
    }

    @Override
    public List<ReverseReportMsgInfo> revokeArch(Context ctx, List<ReportFilter> filterList) throws Exception {
        return null;
    }

    @Override
    public WithoutEntityReportParsingEngineUtil.WithoutEntityXmlSrcobj fillReportDataSources(Context ctx, ReportFilter info, WithoutEntityReportParsingEngineUtil.WithoutEntityXmlSrcobj xmlObj) throws Exception {
        RecordBaseInfo reInfo = info.getRecordBaseInfo();
        BillTypeInfo billType = reInfo.getBillType();
        String billTypeNumber = null;
        if (billType.getNumber() == null) {
            billType = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo(H.PK(billType.getId()));
            reInfo.setBillType(billType);
            billTypeNumber = billType.getNumber();
        } else {
            billTypeNumber = billType.getNumber();
        }
        String oql = "select *, baseCurrency.id,baseCurrency.number, baseCurrency.name where id = '" + info.getOrgId() + "'";
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
        PeriodInfo periodInfo = new PeriodInfo();
        int periodYear = Integer.parseInt(info.getYear());
        int periodNumber = Integer.parseInt(info.getPeriod());
        periodInfo.setPeriodYear(periodYear);
        periodInfo.setPeriodNumber(periodNumber);
        periodInfo.setNumber(periodYear * 100 + periodNumber);
        PeriodCollection perCol = PeriodUtil.transformToPeriods(ctx, periodInfo, info.getReportCycleType(), company);
        xmlObj.put("id", BOSUuid.create((String)billTypeNumber));
        HashMap<String, String> orgMap = new HashMap<String, String>();
        FullOrgUnitInfo org = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(H.PK(info.getOrgId()));
        orgMap.put("number", org.getNumber());
        orgMap.put("name", org.getName());
        orgMap.put("id", info.getOrgId());
        xmlObj.put("reportType", info.getRecordBaseInfo().getName());
        Object obj = this.fillData(ctx, info, perCol, billTypeNumber);
        if (null == obj) {
            return null;
        }
        xmlObj.put("fileOutPutIO", obj);
        xmlObj.put("currency", info.getCurrency() == null ? company.getBaseCurrency().getName() : info.getCurrency().getName());
        return xmlObj;
    }

    @Override
    public List<Map<String, Object>> supportExportFileType() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("name", "EXCEL");
        map1.put("value", "xls");
        list.add(map1);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "PDF");
        map.put("value", "pdf");
        list.add(map);
        return list;
    }

    @Override
    protected String getDefaultExportFileType() {
        return "xls";
    }
}

