/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.arap;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.tool.engine.arap.ArApRptBaseService;
import com.kingdee.eas.el.rec.tool.engine.arap.param.ArApQueryParam;
import com.kingdee.eas.el.rec.tool.engine.arap.param.SummaryRptQueryParam;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArApRptSummaryRptService
extends ArApRptBaseService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.el.rec.tool.engine.arap.ArApRptSummaryRptService");
    SummaryRptQueryParam params;
    Date beginDate = new Date();
    Date endDate = new Date();
    Class clazz = null;
    String tempTable;
    Context ctx = null;

    public ArApRptSummaryRptService(Context ctx, SummaryRptQueryParam params) throws BOSException {
        super(ctx, params);
        this.ctx = ctx;
        try {
            this.clazz = Class.forName("com.kingdee.eas.fi.arap.util.rptService.SummaryRptService");
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected ArApQueryParam buildQueryCondition(ReportFilter info, PeriodCollection perCol, String billTypeNumber, boolean isAr) throws EASBizException, BOSException {
        SummaryRptQueryParam param = (SummaryRptQueryParam)super.buildQueryCondition(info, perCol, billTypeNumber, isAr);
        String companyId = info.getOrgId();
        ArrayList<String> companyIds = new ArrayList<String>();
        companyIds.add(companyId);
        if (companyIds.size() == 1) {
            companyIds.add(companyId);
        }
        param.setCompanyIds(companyIds);
        param.setByPeriod(true);
        PeriodInfo startPeriod = perCol.get(0);
        PeriodInfo endPeriod = perCol.get(perCol.size() - 1);
        param.setByPeriod(true);
        param.setStartPeriodNum(startPeriod.getPeriodNumber());
        param.setStartPeriodYear(startPeriod.getPeriodYear());
        param.setEndPeriodNum(endPeriod.getPeriodNumber());
        param.setEndPeriodYear(endPeriod.getPeriodYear());
        this.beginDate = startPeriod.getBeginDate();
        this.endDate = endPeriod.getEndDate();
        if (!this.isUseWEBDefaultSolution) {
            param.setIsBalZero(true);
            param.setIsBizZero(true);
            param.setExcludeInnerCust(false);
            param.setIncludeBizBill(false);
            this.params = param;
            return param;
        }
        param.setIsBalZero(this.getBoolean("cb_balZero"));
        param.setIsBizZero(this.getBoolean("cb_bizZero"));
        param.setExcludeInnerCust(this.getBoolean("cb_noInnerCust"));
        param.setIncludeBizBill(this.getBoolean("cb_includeBizBill"));
        this.params = param;
        return param;
    }

    protected Object executeQuery() throws EASBizException, BOSException {
        RptParams rptRslt = null;
        if (this.clazz != null) {
            try {
                String tempTable;
                Method methodCreateTempTable = this.clazz.getDeclaredMethod("createTempTable", Map.class);
                Object obj = this.clazz.newInstance();
                HashMap<String, Object> invokparam = new HashMap<String, Object>();
                invokparam.put("ctx", this.ctx);
                invokparam.put("beginDate", this.beginDate);
                invokparam.put("endDate", this.endDate);
                invokparam.put("summaryRptQueryParamMap", JSONUtils.convertObjectToJson((Context)this.ctx, (Object)this.params));
                rptRslt = (RptParams)methodCreateTempTable.invoke(obj, invokparam);
                String[] colModel = this.convertColModel(rptRslt);
                this.setColModel(colModel);
                this.tempTable = tempTable = rptRslt.getString("tempTable");
                this.params.setTempTable(tempTable);
                invokparam.put("summaryRptQueryParamMap", JSONUtils.convertObjectToJson((Context)this.ctx, (Object)this.params));
                Method methodQuery = this.clazz.getDeclaredMethod("query", Map.class);
                invokparam.put("from", 0);
                invokparam.put("length", 1);
                rptRslt = (RptParams)methodQuery.invoke(obj, invokparam);
                int totalRowCount = rptRslt.getInt("totalRowCount");
                invokparam.put("from", 0);
                invokparam.put("length", totalRowCount);
                rptRslt = (RptParams)methodQuery.invoke(obj, invokparam);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
            return rptRslt;
        }
        return null;
    }

    private RptParams getRptParams() throws EASBizException, BOSException {
        RptParams params = new RptParams();
        params.setBoolean("fFirstLoad", true);
        params.setObject("qryParam", (Object)this.params);
        return params;
    }

    @Override
    protected List<Map<String, Object>> convert(RptParams rptParams) {
        ArrayList<Map<String, Object>> gridData = new ArrayList<Map<String, Object>>();
        RptRowSet rs = (RptRowSet)rptParams.getObject("rowset");
        String[] columnNames = rs.getColumnNames();
        while (rs.next()) {
            HashMap<String, Object> rowdata = new HashMap<String, Object>();
            for (String colName : columnNames) {
                rowdata.put(colName.toLowerCase(), rs.getObject(colName));
            }
            if (rowdata.containsKey("fperiodyear") && rowdata.containsKey("fperiodnumber") && this.params.isByPeriod()) {
                String periodYear = rowdata.get("fperiodyear").toString();
                String periodNumber = rowdata.get("fperiodnumber").toString();
                String periodAlias = periodYear + "\u5e74" + periodNumber + "\u671f";
                rowdata.put("fperiod", periodAlias);
            } else {
                String periodStr = "\u4ece" + this.params.getBeginDate() + "\u5230" + this.params.getEndDate();
                rowdata.put("fperiod", periodStr);
            }
            gridData.add(rowdata);
        }
        return gridData;
    }

    @Override
    protected String[] convertColModel(RptParams rptParams) {
        RptTableHeader headers = (RptTableHeader)rptParams.getObject("header");
        String[] labels = (String[])headers.getLabels()[0];
        int colCount = headers.getColumnCount();
        String[] align = new String[]{"left", "center", "right"};
        RptTableColumn _col = null;
        ArrayList cols = new ArrayList();
        Map<String, Boolean> col = null;
        for (int i = 0; i < colCount; ++i) {
            _col = headers.getColumn(i);
            col = new HashMap();
            cols.add(col);
            col.put("id", (Boolean)((Object)("queryGrid_" + _col.getName().toLowerCase())));
            col.put("name", (Boolean)((Object)_col.getName().toLowerCase()));
            col.put("label", (Boolean)((Object)labels[i]));
            col.put("index", (Boolean)((Object)Integer.valueOf(i + 2)));
            col.put("dataBind", (Boolean)((Object)_col.getName().toLowerCase()));
            col.put("hidden", _col.isHided());
            col.put("resizable", true);
            if ("fcurrency,fperiod".contains(_col.getName().toLowerCase())) {
                col.put("rowSpanKey", true);
            }
            col.put("rowspan", "fcurrency,fperiod,fasstacttype,fcussacct".contains(_col.getName().toLowerCase()));
            col.put("settable", !_col.isHided());
            col.put("sortable", false);
            col.put("title", true);
            col.put("width", (Boolean)((Object)Integer.valueOf(_col.getWidth())));
            col.put("widthOrg", (Boolean)((Object)Integer.valueOf(80)));
            col.put("align", (Boolean)((Object)align[_col.getAligment()]));
            col.put("cellEidt", true);
            col.put("csCL", true);
            if (_col.getAligment() != 2) continue;
            col.put("formatter", (Boolean)((Object)"precisionFormatter"));
        }
        col = new HashMap<String, Object>();
        col.put("key", true);
        col.put("id", (Boolean)((Object)"queryGrid_id"));
        col.put("name", (Boolean)((Object)"id"));
        col.put("label", (Boolean)((Object)"id"));
        col.put("index", (Boolean)((Object)Integer.valueOf(1)));
        col.put("dataBind", (Boolean)((Object)"id"));
        col.put("hidden", true);
        col.put("settable", false);
        cols.add(0, col);
        String[] colModels = new String[cols.size()];
        String colModel = "";
        for (int i = 0; i < cols.size(); ++i) {
            col = (Map)cols.get(i);
            colModels[i] = colModel = col.get("name") + "," + col.get("hidden") + "," + (String)col.get("label") + "," + col.get("width") + "," + col.get("align");
        }
        return colModels;
    }

    @Override
    protected String getTitle() {
        String title = "";
        if (this.params == null) {
            return title;
        }
        title = this.params.isArRpt() ? "\u5e94\u6536\u6c47\u603b\u8868" : "\u5e94\u4ed8\u6c47\u603b\u8868";
        return title;
    }

    @Override
    protected void releaseTempTable() throws EASBizException, BOSException {
        if (this.tempTable != null) {
            try {
                Method methodCreateTempTable = this.clazz.getDeclaredMethod("dropPoolTempTable", Map.class);
                Object obj = this.clazz.newInstance();
                HashMap<String, Object> invokparam = new HashMap<String, Object>();
                invokparam.put("ctx", this.ctx);
                invokparam.put("tempTable", this.tempTable);
                methodCreateTempTable.invoke(obj, invokparam);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected String getWEBUIPK() {
        return "com.kingdee.eas.fi.ap.apVirtualSumRptUI";
    }
}

