/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.cas;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.el.rec.BillTypeFactory;
import com.kingdee.eas.el.rec.BillTypeInfo;
import com.kingdee.eas.el.rec.RecordBaseInfo;
import com.kingdee.eas.el.rec.model.FileStreamInfo;
import com.kingdee.eas.el.rec.model.IXmlSrcObj;
import com.kingdee.eas.el.rec.model.ReportFilter;
import com.kingdee.eas.el.rec.model.ReverseReportMsgInfo;
import com.kingdee.eas.el.rec.tool.H;
import com.kingdee.eas.el.rec.tool.PeriodUtil;
import com.kingdee.eas.el.rec.tool.engine.WithoutEntityReportParsingEngineUtil;
import com.kingdee.eas.el.rec.tool.engine.cas.CASBankBalanceService;
import com.kingdee.eas.el.rec.tool.engine.cas.CASBankJournalService;
import com.kingdee.eas.el.rec.tool.engine.cas.CASBankStatementService;
import com.kingdee.eas.el.rec.tool.engine.cas.CASCashJournalService;
import com.kingdee.eas.el.rec.tool.engine.cas.CASRptBaseService;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CASReportParsingEngineUtil
extends WithoutEntityReportParsingEngineUtil {
    @Override
    public List<ReverseReportMsgInfo> revokeArch(Context ctx, List<ReportFilter> filterList) throws Exception {
        return null;
    }

    @Override
    public WithoutEntityReportParsingEngineUtil.WithoutEntityXmlSrcobj fillReportDataSources(Context ctx, ReportFilter info, WithoutEntityReportParsingEngineUtil.WithoutEntityXmlSrcobj xmlObj) throws Exception {
        RecordBaseInfo reInfo = info.getRecordBaseInfo();
        BillTypeInfo billType = reInfo.getBillType();
        String billTypeNumber = null;
        if (billType.getNumber() == null) {
            billType = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo(H.PK(billType.getId()));
            reInfo.setBillType(billType);
            billTypeNumber = billType.getNumber();
        } else {
            billTypeNumber = billType.getNumber();
        }
        String oql = "select *, baseCurrency.id,baseCurrency.number, baseCurrency.name where id = '" + info.getOrgId() + "'";
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
        PeriodInfo periodInfo = new PeriodInfo();
        int periodYear = Integer.parseInt(info.getYear());
        int periodNumber = Integer.parseInt(info.getPeriod());
        periodInfo.setPeriodYear(periodYear);
        periodInfo.setPeriodNumber(periodNumber);
        periodInfo.setNumber(periodYear * 100 + periodNumber);
        PeriodCollection perCol = PeriodUtil.transformToPeriods(ctx, periodInfo, info.getReportCycleType(), company);
        xmlObj.put("id", BOSUuid.create((String)billTypeNumber));
        HashMap<String, String> orgMap = new HashMap<String, String>();
        FullOrgUnitInfo org = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(H.PK(info.getOrgId()));
        orgMap.put("number", org.getNumber());
        orgMap.put("name", org.getName());
        orgMap.put("id", info.getOrgId());
        xmlObj.put("reportType", info.getRecordBaseInfo().getName());
        Object obj = this.fillData(ctx, info, perCol, billTypeNumber, company);
        if (null == obj) {
            return null;
        }
        xmlObj.put("fileOutPutIO", obj);
        xmlObj.put("currency", info.getCurrency() == null ? company.getBaseCurrency().getName() : info.getCurrency().getName());
        xmlObj.put("fileType", "xlsx");
        xmlObj.put("subj", info.getAccountName() == null ? "" : info.getAccountName());
        xmlObj.put("subjno", info.getAccountNumber() == null ? "" : info.getAccountNumber());
        return xmlObj;
    }

    private Object fillData(Context ctx, ReportFilter info, PeriodCollection perCol, String billTypeNumber, CompanyOrgUnitInfo company) throws Exception {
        Object print = null;
        CASRptBaseService service = null;
        Object out = null;
        String exportFileType = this.getExportFileType(info.getRecordBaseInfo());
        if ("CAS_BankJournal".equals(billTypeNumber)) {
            service = new CASBankJournalService();
        } else if ("CAS_CashJournal".equals(billTypeNumber)) {
            service = new CASCashJournalService();
        } else if ("CAS_BankStatement".equals(billTypeNumber)) {
            service = new CASBankStatementService();
        } else if ("CAS_BankBalance".equals(billTypeNumber)) {
            service = new CASBankBalanceService(info);
        } else {
            throw new NullPointerException(billTypeNumber + " is no match");
        }
        service.buildParam(ctx, company, info.getRecordBaseInfo().getBillType().getNumber(), perCol);
        Set set = service.getAllData();
        if (set.isEmpty()) {
            return print;
        }
        print = "CAS_BankJournal".equals(billTypeNumber) && "pdf".equalsIgnoreCase(exportFileType) ? service.getPdfPrint(set, info.getRecordBaseInfo().getPrintTemplate().toString()) : ("CAS_BankBalance".equals(billTypeNumber) && "pdf".equalsIgnoreCase(exportFileType) ? service.getPdfPrint(set, info.getRecordBaseInfo().getPrintTemplate()) : service.getPrint(set));
        return print;
    }

    @Override
    public List<Map<String, Object>> supportExportFileType() {
        List<Map<String, Object>> list = super.supportExportFileType();
        HashMap<String, String> mapPdf = new HashMap<String, String>();
        mapPdf.put("name", "PDF");
        mapPdf.put("value", "pdf");
        list.add(mapPdf);
        return list;
    }

    @Override
    protected String getDefaultExportFileType() {
        return "xlsx";
    }

    @Override
    public WithoutEntityReportParsingEngineUtil.WithoutEntityXmlSrcobj createReportDataSources(Context ctx, ReportFilter info) throws Exception {
        CASWithoutEntityXmlSrcobj casWithoutEntityXmlSrcobj = new CASWithoutEntityXmlSrcobj();
        casWithoutEntityXmlSrcobj.put("exportFileType", info.getRecordBaseInfo().getExportFileType());
        casWithoutEntityXmlSrcobj.put("hasTemplate", !StringUtils.isEmpty((CharSequence)info.getRecordBaseInfo().getPrintTemplate()));
        return casWithoutEntityXmlSrcobj;
    }

    @Override
    protected FileStreamInfo excel2pdf(IXmlSrcObj iXmlSrcObj, InputStream is) throws Exception {
        boolean hasTemplate = (Boolean)iXmlSrcObj.get("hasTemplate");
        if (hasTemplate) {
            return new FileStreamInfo(is);
        }
        return super.excel2pdf(iXmlSrcObj, is);
    }

    public class CASWithoutEntityXmlSrcobj
    extends WithoutEntityReportParsingEngineUtil.WithoutEntityXmlSrcobj {
    }
}

