/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BSSourceEnum;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashMgtInitFacadeFactory;
import com.kingdee.eas.fi.cas.DirectionEnum;
import com.kingdee.eas.fi.cas.ICashMgtInitFacade;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class CASRptBaseService {
    protected Context ctx;
    protected PeriodCollection perCol;
    protected Set currencySet;
    protected Set accountBankSet;
    protected Set accountSet;
    protected Set periodSet;
    protected CompanyOrgUnitInfo company;
    protected String billType;
    protected XSSFWorkbook workbook = null;
    protected XSSFSheet currentSheet = null;
    protected IMetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.cas.JournalQuery");
    private boolean glDc;
    private Logger logger = Logger.getLogger(this.getClass());

    protected void buildParam(Context ctx, CompanyOrgUnitInfo company, String billType, PeriodCollection perCol) throws BOSException, EASBizException {
        AccountBankInfo accountBank;
        int i;
        AccountBankCollection coll;
        String sql;
        this.ctx = ctx;
        HashSet<String> accountBankSet = new HashSet<String>();
        HashSet<String> accountSet = new HashSet<String>();
        HashSet<String> currencySet = new HashSet<String>();
        HashSet<String> periodSet = new HashSet<String>();
        if ("CAS_BankJournal".equals(billType) || "CAS_BankBalance".equals(billType)) {
            sql = "select *,Currency.*,account.* where company.id = '" + company.getId() + "'isClosed = 0 and isCash = 0 and isBank = 1";
            coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(sql);
            for (i = 0; i < coll.size(); ++i) {
                accountBank = coll.get(i);
                CurrencyInfo currency = accountBank.getCurrency();
                AccountViewInfo account = accountBank.getAccount();
                accountBankSet.add(accountBank.getId().toString());
                accountSet.add(account.getId().toString());
            }
        } else if ("CAS_CashJournal".equals(billType)) {
            String acctableid = company.getAccountTable().getId().toString();
            coll = this.getAcctColl(company.getId().toString(), acctableid);
            for (i = 0; i < coll.size(); ++i) {
                AccountViewInfo accountView = coll.get(i);
                accountSet.add(accountView.getId().toString());
            }
        } else if ("CAS_BankStatement".equals(billType)) {
            sql = "select *,Currency.*,account.* where (company.id = '" + company.getId() + "' or agencyCompany.id = '" + company.getId() + "') isClosed = 0 and isSetBankInterface = 1";
            coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(sql);
            for (i = 0; i < coll.size(); ++i) {
                accountBank = coll.get(i);
                AccountViewInfo account = accountBank.getAccount();
                CurrencyInfo currency = accountBank.getCurrency();
                accountBankSet.add(accountBank.getId().toString());
                accountSet.add(account.getId().toString());
                if (currency == null) continue;
                currencySet.add(currency.getId().toString());
            }
        }
        this.accountBankSet = accountBankSet;
        this.accountSet = accountSet;
        this.currencySet = currencySet;
        for (int i2 = 0; i2 < perCol.size(); ++i2) {
            periodSet.add(perCol.get(i2).getId().toString());
        }
        this.periodSet = periodSet;
        this.perCol = perCol;
        this.company = company;
        this.billType = billType;
    }

    protected abstract Set getAllData() throws BOSException;

    protected abstract InputStream getPrint(Set var1);

    protected abstract Object getPdfPrint(Set var1, String var2);

    protected BigDecimal getBeginBalanceNew(CompanyOrgUnitInfo companyInfo, CurrencyInfo currencyInfo, PeriodInfo periodInfo, AccountViewInfo accountView, AccountBankInfo accountBank, int type) throws EASBizException, BOSException {
        PeriodInfo period = null;
        String beginDateStr = "";
        String endDateStr = "";
        if (periodInfo.isIsAdjustPeriod()) {
            period = PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)periodInfo.getEndDate(), (CompanyOrgUnitInfo)companyInfo);
            SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
            beginDateStr = s.format(period.getBeginDate());
            endDateStr = s.format(period.getEndDate());
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(periodInfo.getBeginDate());
            cal.add(2, -1);
            Date beginDate = cal.getTime();
            SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
            beginDateStr = s.format(beginDate);
            cal.set(5, cal.getActualMaximum(5));
            Date endDate = cal.getTime();
            endDateStr = s.format(endDate);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection filterItems = filter.getFilterItems();
            filterItems.add(new FilterItemInfo("beginDate", (Object)beginDate));
            filterItems.add(new FilterItemInfo("endDate", (Object)endDate));
            filterItems.add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId()));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            view.setSelector(sic);
            PeriodCollection pColl = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodCollection(view);
            period = pColl != null && pColl.size() > 0 ? pColl.get(0) : periodInfo;
        }
        StringBuffer sql = new StringBuffer();
        if (type == 2) {
            sql.append("select sum(SubResult) Result from (").append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where FIsInit = 0 and FCurrencyId ='").append(currencyInfo.getId().toString()).append("' and FPeriodId ='").append(period.getId().toString()).append("' and FType= ").append(type).append(" and FAccountBankID ='").append(accountBank.getId().toString()).append("' and FCompanyId='").append(companyInfo.getId().toString()).append("' and FAccountViewId ='").append(accountView.getId().toString()).append("' ").append("union all ").append("select sum(FDebitAmount - FCreditAmount)  SubResult from t_cas_JournalSummary  where FCreateDate >={").append(beginDateStr).append("} and ").append("FCreateDate <={").append(endDateStr).append("} and FCurrencyId ='").append(currencyInfo.getId().toString()).append("' and FAccountViewId ='").append(accountView.getId().toString()).append("' and FCompanyId ='").append(companyInfo.getId().toString()).append("' and FAccountBankId ='").append(accountBank.getId().toString()).append("' and FType = ").append(type).append(") SubQuery");
        } else if (type == 1) {
            sql.append("select sum(SubResult) Result from (").append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where FIsInit = 0 and FCurrencyId ='").append(currencyInfo.getId().toString()).append("' and FPeriodId ='").append(period.getId().toString()).append("' and FType= ").append(type).append(" and FCompanyId='").append(companyInfo.getId().toString()).append("' and FAccountViewId ='").append(accountView.getId().toString()).append("' ").append("union all ").append("select sum(FDebitAmount - FCreditAmount)  SubResult from t_cas_JournalSummary  where FCreateDate >={").append(beginDateStr).append("} and ").append("FCreateDate <={").append(endDateStr).append("} and FCurrencyId ='").append(currencyInfo.getId().toString()).append("' and FAccountViewId ='").append(accountView.getId().toString()).append("' and FCompanyId ='").append(companyInfo.getId().toString()).append("' and FType = ").append(type).append(") SubQuery");
        }
        this.logger.error((Object)("\u83b7\u53d6\u671f\u521d\u4f59\u989d\u7684sql\u662f" + sql.toString()));
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)this.ctx, (String)sql.toString());
        IRowSet rs = null;
        rs = exec.executeSQL();
        try {
            BigDecimal result;
            if (rs != null && rs.next() && (result = rs.getBigDecimal("Result")) != null) {
                return result;
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("\u83b7\u53d6\u671f\u521d\u4f59\u989d\u6267\u884csql\u5931\u8d25" + e));
        }
        return Constants.ZERO;
    }

    protected void CreateFirstRow(XSSFRow xssfRow, String[] head) {
        XSSFCellStyle style = this.workbook.createCellStyle();
        XSSFFont font = this.workbook.createFont();
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_GREEN.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        xssfRow.setHeight(Short.parseShort("800"));
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)9);
        style.setFont((Font)font);
        XSSFCell xssfCell = null;
        for (int i = 0; i < head.length; ++i) {
            xssfCell = xssfRow.createCell(i);
            xssfCell.setCellValue(head[i]);
            xssfCell.setCellStyle((CellStyle)style);
        }
    }

    protected void CreateRow(XSSFRow xssfRow, JournalInfo journal, BankStatementInfo bankstate, BigDecimal balance, BigDecimal rate) {
        block72: {
            XSSFCellStyle style;
            SimpleDateFormat df;
            XSSFCell xssfCell;
            block73: {
                block71: {
                    xssfCell = null;
                    df = new SimpleDateFormat("yyyy-MM-dd");
                    style = this.workbook.createCellStyle();
                    XSSFFont font = this.workbook.createFont();
                    font.setFontName("\u5b8b\u4f53");
                    font.setFontHeightInPoints((short)9);
                    style.setFont((Font)font);
                    if (!"CAS_BankJournal".equals(this.billType)) break block71;
                    block57: for (int i = 0; i < 27; ++i) {
                        xssfCell = xssfRow.createCell(i);
                        xssfCell.setCellStyle((CellStyle)style);
                        switch (i) {
                            case 0: {
                                xssfCell.setCellValue(journal.getCompany().getName());
                                continue block57;
                            }
                            case 1: {
                                xssfCell.setCellValue(df.format(journal.getCreateDate()));
                                continue block57;
                            }
                            case 2: {
                                xssfCell.setCellValue(df.format(journal.getBizDate()));
                                continue block57;
                            }
                            case 3: {
                                xssfCell.setCellValue(journal.getVoucherType() != null ? journal.getVoucherType().getName() : " ");
                                continue block57;
                            }
                            case 4: {
                                xssfCell.setCellValue(journal.getVoucherNumber());
                                continue block57;
                            }
                            case 5: {
                                xssfCell.setCellValue("");
                                continue block57;
                            }
                            case 6: {
                                xssfCell.setCellValue(journal.getOppAccountView() != null ? journal.getOppAccountView().getNumber() + journal.getOppAccountView().getName() : " ");
                                continue block57;
                            }
                            case 7: {
                                xssfCell.setCellValue(journal.getBillType() != null ? journal.getBillType().toString() : " ");
                                continue block57;
                            }
                            case 8: {
                                xssfCell.setCellValue(journal.getBillNumber());
                                continue block57;
                            }
                            case 9: {
                                xssfCell.setCellValue(journal.getDescription());
                                continue block57;
                            }
                            case 10: {
                                xssfCell.setCellValue(journal.getSettlementType() != null ? journal.getSettlementType().getName() : " ");
                                continue block57;
                            }
                            case 11: {
                                xssfCell.setCellValue(journal.getSettlementNumber());
                                continue block57;
                            }
                            case 12: {
                                xssfCell.setCellValue(journal.getDebitAmount() != null ? journal.getDebitAmount().setScale(2, 4).toString() : " ");
                                continue block57;
                            }
                            case 13: {
                                BigDecimal localDebit = null;
                                if (journal.getDebitAmount() != null) {
                                    localDebit = journal.getDebitAmount().multiply(rate).setScale(2, 4);
                                }
                                xssfCell.setCellValue(localDebit != null ? localDebit.toString() : " ");
                                continue block57;
                            }
                            case 14: {
                                xssfCell.setCellValue(journal.getCreditAmount() != null ? journal.getCreditAmount().setScale(2, 4).toString() : " ");
                                continue block57;
                            }
                            case 15: {
                                BigDecimal localCredit = null;
                                if (journal.getCreditAmount() != null) {
                                    localCredit = journal.getCreditAmount().multiply(rate).setScale(2, 4);
                                }
                                xssfCell.setCellValue(localCredit != null ? localCredit.toString() : " ");
                                continue block57;
                            }
                            case 16: {
                                String direction = journal.getAccountView().getDC().getAlias();
                                xssfCell.setCellValue(this.getParamDc(direction, balance));
                                continue block57;
                            }
                            case 17: {
                                xssfCell.setCellValue(this.getParamBalance(balance).toString());
                                continue block57;
                            }
                            case 18: {
                                BigDecimal localbalance = null;
                                if (balance != null) {
                                    localbalance = balance.multiply(rate).setScale(2, 4);
                                }
                                xssfCell.setCellValue(localbalance != null ? this.getParamBalance(localbalance).toString() : "");
                                continue block57;
                            }
                            case 19: {
                                xssfCell.setCellValue(journal.getCashier() != null ? journal.getCashier().getName() : " ");
                                continue block57;
                            }
                            case 20: {
                                xssfCell.setCellValue(journal.getBatchNo());
                                continue block57;
                            }
                            case 21: {
                                if (!journal.getVerifyStatus().equals((Object)VerifyScopeEnum.NOVA)) {
                                    xssfCell.setCellValue("\u662f");
                                    continue block57;
                                }
                                xssfCell.setCellValue("\u5426");
                                continue block57;
                            }
                            case 22: {
                                xssfCell.setCellValue(journal.getSource() != null ? journal.getSource().toString() : " ");
                                continue block57;
                            }
                            case 23: {
                                xssfCell.setCellValue(journal.getOppUnit());
                                continue block57;
                            }
                            case 24: {
                                xssfCell.setCellValue(journal.getOppAcctNumber());
                                continue block57;
                            }
                            case 25: {
                                xssfCell.setCellValue(journal.getOppBank());
                                continue block57;
                            }
                            case 26: {
                                xssfCell.setCellValue(journal.getAssistHgName());
                            }
                        }
                    }
                    break block72;
                }
                if (!"CAS_CashJournal".equals(this.billType)) break block73;
                block58: for (int i = 0; i < 17; ++i) {
                    xssfCell = xssfRow.createCell(i);
                    xssfCell.setCellStyle((CellStyle)style);
                    switch (i) {
                        case 0: {
                            xssfCell.setCellValue(df.format(journal.getCreateDate()));
                            continue block58;
                        }
                        case 1: {
                            xssfCell.setCellValue(df.format(journal.getBizDate()));
                            continue block58;
                        }
                        case 2: {
                            xssfCell.setCellValue(journal.getVoucherType() != null ? journal.getVoucherType().getName() : " ");
                            continue block58;
                        }
                        case 3: {
                            xssfCell.setCellValue(journal.getVoucherNumber());
                            continue block58;
                        }
                        case 4: {
                            xssfCell.setCellValue(journal.getOppAccountView() != null ? journal.getOppAccountView().getNumber() + journal.getOppAccountView().getName() : " ");
                            continue block58;
                        }
                        case 5: {
                            xssfCell.setCellValue(journal.getBillType() != null ? journal.getBillType().toString() : " ");
                            continue block58;
                        }
                        case 6: {
                            xssfCell.setCellValue(journal.getBillNumber());
                            continue block58;
                        }
                        case 7: {
                            xssfCell.setCellValue(journal.getDescription());
                            continue block58;
                        }
                        case 8: {
                            xssfCell.setCellValue(journal.getDebitAmount() != null ? journal.getDebitAmount().setScale(2, 4).toString() : " ");
                            continue block58;
                        }
                        case 9: {
                            BigDecimal localDebit = null;
                            if (journal.getDebitAmount() != null) {
                                localDebit = journal.getDebitAmount().multiply(rate).setScale(2, 4);
                            }
                            xssfCell.setCellValue(localDebit != null ? localDebit.toString() : " ");
                            continue block58;
                        }
                        case 10: {
                            xssfCell.setCellValue(journal.getCreditAmount() != null ? journal.getCreditAmount().setScale(2, 4).toString() : " ");
                            continue block58;
                        }
                        case 11: {
                            BigDecimal localCredit = null;
                            if (journal.getCreditAmount() != null) {
                                localCredit = journal.getCreditAmount().multiply(rate).setScale(2, 4);
                            }
                            xssfCell.setCellValue(localCredit != null ? localCredit.toString() : " ");
                            continue block58;
                        }
                        case 12: {
                            String direction = journal.getAccountView().getDC().getAlias();
                            xssfCell.setCellValue(this.getParamDc(direction, balance));
                            continue block58;
                        }
                        case 13: {
                            xssfCell.setCellValue(this.getParamBalance(balance).toString());
                            continue block58;
                        }
                        case 14: {
                            BigDecimal localbalance = null;
                            if (balance != null) {
                                localbalance = balance.multiply(rate).setScale(2, 4);
                            }
                            xssfCell.setCellValue(localbalance != null ? this.getParamBalance(localbalance).toString() : "");
                            continue block58;
                        }
                        case 15: {
                            xssfCell.setCellValue(journal.getSource() != null ? journal.getSource().toString() : " ");
                            continue block58;
                        }
                        case 16: {
                            xssfCell.setCellValue(journal.getCashier() != null ? journal.getCashier().getName() : " ");
                        }
                    }
                }
                break block72;
            }
            if (!"CAS_BankStatement".equals(this.billType)) break block72;
            block59: for (int i = 0; i < 7; ++i) {
                xssfCell = xssfRow.createCell(i);
                xssfCell.setCellStyle((CellStyle)style);
                switch (i) {
                    case 0: {
                        xssfCell.setCellValue(df.format(bankstate.getCreateDate()));
                        continue block59;
                    }
                    case 1: {
                        xssfCell.setCellValue(bankstate.getDescription());
                        continue block59;
                    }
                    case 2: {
                        xssfCell.setCellValue(bankstate.getDebitAmount() != null ? bankstate.getDebitAmount().setScale(2, 4).toString() : " ");
                        continue block59;
                    }
                    case 3: {
                        xssfCell.setCellValue(bankstate.getCreditAmount() != null ? bankstate.getCreditAmount().setScale(2, 4).toString() : " ");
                        continue block59;
                    }
                    case 4: {
                        xssfCell.setCellValue(balance.toString());
                        continue block59;
                    }
                    case 5: {
                        if (!bankstate.getVerifyStatus().equals((Object)VerifyScopeEnum.NOVA)) {
                            xssfCell.setCellValue("\u662f");
                            continue block59;
                        }
                        xssfCell.setCellValue("\u5426");
                        continue block59;
                    }
                    case 6: {
                        if (bankstate.getSource() != null) {
                            if (BSSourceEnum.MANUAL.equals((Object)bankstate.getSource())) {
                                xssfCell.setCellValue("\u624b\u5de5\u5f55\u5165");
                                continue block59;
                            }
                            if (BSSourceEnum.BYSTTML.equals((Object)bankstate.getSource())) {
                                xssfCell.setCellValue("\u7ed3\u7b97\u4e2d\u5fc3\u5355\u636e\u8f6c\u6362");
                                continue block59;
                            }
                            if (!BSSourceEnum.BE_IMPORT.equals((Object)bankstate.getSource())) continue block59;
                            xssfCell.setCellValue("\u94f6\u4f01\u4e92\u8054\u5bfc\u5165");
                            continue block59;
                        }
                        xssfCell.setCellValue(" ");
                    }
                }
            }
        }
    }

    protected void CreateCountRow(XSSFRow xssfRow, Map map, String billType, BigDecimal rate) {
        block39: {
            XSSFCell xssfCell;
            XSSFCellStyle style;
            SimpleDateFormat df;
            block40: {
                String creditAmount;
                String debitAmount;
                String balance;
                block38: {
                    df = new SimpleDateFormat("yyyy-MM-dd");
                    style = this.workbook.createCellStyle();
                    style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
                    style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    XSSFFont font = this.workbook.createFont();
                    font.setFontName("\u5b8b\u4f53");
                    font.setFontHeightInPoints((short)9);
                    style.setFont((Font)font);
                    xssfCell = null;
                    balance = (String)map.get("balance");
                    debitAmount = (String)map.get("debitAmount");
                    creditAmount = (String)map.get("creditAmount");
                    if (!"CAS_BankJournal".equals(billType)) break block38;
                    block29: for (int i = 0; i < 27; ++i) {
                        xssfCell = xssfRow.createCell(i);
                        xssfCell.setCellStyle((CellStyle)style);
                        switch (i) {
                            case 1: {
                                xssfCell.setCellValue(df.format((Date)map.get("date")));
                                continue block29;
                            }
                            case 10: {
                                xssfCell.setCellValue((String)map.get("description"));
                                continue block29;
                            }
                            case 12: {
                                xssfCell.setCellValue((String)map.get("debitAmount"));
                                continue block29;
                            }
                            case 13: {
                                BigDecimal localDebit = null;
                                if (debitAmount != null && !debitAmount.equals(" ")) {
                                    localDebit = new BigDecimal(debitAmount).multiply(rate).setScale(2, 4);
                                }
                                xssfCell.setCellValue(localDebit != null ? localDebit.toString() : "");
                                continue block29;
                            }
                            case 14: {
                                xssfCell.setCellValue((String)map.get("creditAmount"));
                                continue block29;
                            }
                            case 15: {
                                BigDecimal localCredit = null;
                                if (creditAmount != null && !creditAmount.equals(" ")) {
                                    localCredit = new BigDecimal(creditAmount).multiply(rate).setScale(2, 4);
                                }
                                xssfCell.setCellValue(creditAmount != null ? creditAmount.toString() : "");
                                continue block29;
                            }
                            case 16: {
                                xssfCell.setCellValue((String)map.get("isDebit"));
                                continue block29;
                            }
                            case 17: {
                                xssfCell.setCellValue(balance);
                            }
                            case 18: {
                                BigDecimal localbalance = null;
                                if (balance != null) {
                                    localbalance = new BigDecimal(balance).multiply(rate).setScale(2, 4);
                                }
                                xssfCell.setCellValue(localbalance != null ? localbalance.toString() : "");
                            }
                        }
                    }
                    break block39;
                }
                if (!"CAS_CashJournal".equals(billType)) break block40;
                block30: for (int i = 0; i < 17; ++i) {
                    xssfCell = xssfRow.createCell(i);
                    xssfCell.setCellStyle((CellStyle)style);
                    switch (i) {
                        case 1: {
                            xssfCell.setCellValue(df.format((Date)map.get("date")));
                            continue block30;
                        }
                        case 7: {
                            xssfCell.setCellValue((String)map.get("description"));
                            continue block30;
                        }
                        case 8: {
                            xssfCell.setCellValue((String)map.get("debitAmount"));
                            continue block30;
                        }
                        case 9: {
                            BigDecimal localDebit = null;
                            if (debitAmount != null && !debitAmount.equals(" ")) {
                                localDebit = new BigDecimal(debitAmount).multiply(rate).setScale(2, 4);
                            }
                            xssfCell.setCellValue(localDebit != null ? localDebit.toString() : "");
                            continue block30;
                        }
                        case 10: {
                            xssfCell.setCellValue((String)map.get("creditAmount"));
                            continue block30;
                        }
                        case 11: {
                            BigDecimal localCredit = null;
                            if (creditAmount != null && !creditAmount.equals(" ")) {
                                localCredit = new BigDecimal(creditAmount).multiply(rate).setScale(2, 4);
                            }
                            xssfCell.setCellValue(creditAmount != null ? creditAmount.toString() : "");
                            continue block30;
                        }
                        case 12: {
                            xssfCell.setCellValue((String)map.get("isDebit"));
                            continue block30;
                        }
                        case 13: {
                            xssfCell.setCellValue((String)map.get("balance"));
                            continue block30;
                        }
                        case 14: {
                            BigDecimal localbalance = null;
                            if (balance != null) {
                                localbalance = new BigDecimal(balance).multiply(rate).setScale(2, 4);
                            }
                            xssfCell.setCellValue(localbalance != null ? localbalance.toString() : "");
                        }
                    }
                }
                break block39;
            }
            if (!"CAS_BankStatement".equals(billType)) break block39;
            block31: for (int i = 0; i < 7; ++i) {
                xssfCell = xssfRow.createCell(i);
                xssfCell.setCellStyle((CellStyle)style);
                switch (i) {
                    case 0: {
                        xssfCell.setCellValue(df.format((Date)map.get("date")));
                        continue block31;
                    }
                    case 1: {
                        xssfCell.setCellValue((String)map.get("description"));
                        continue block31;
                    }
                    case 2: {
                        xssfCell.setCellValue((String)map.get("debitAmount"));
                        continue block31;
                    }
                    case 3: {
                        xssfCell.setCellValue((String)map.get("creditAmount"));
                        continue block31;
                    }
                    case 4: {
                        xssfCell.setCellValue((String)map.get("balance"));
                    }
                }
            }
        }
    }

    private AccountViewCollection getAcctColl(String companyId, String acctTableId) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        items.add(new FilterItemInfo("isCash", (Object)"1"));
        ICashMgtInitFacade iCashFacade = null;
        iCashFacade = CashMgtInitFacadeFactory.getLocalInstance((Context)this.ctx);
        return iCashFacade.getAccountViewCollection(companyId, acctTableId, null, view);
    }

    protected BigDecimal getExchange(CompanyOrgUnitInfo company, CurrencyInfo sourceCurrency, CurrencyInfo desCurrency, Date date) throws EASBizException, BOSException {
        if (null == date) {
            date = Calendar.getInstance().getTime();
        }
        Object iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (company.getBaseExchangeTable() == null) {
            throw new BOSException("\u6ca1\u6709\u6c47\u7387\u8868");
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId());
        BigDecimal er = this.getBankJournalExchangeCache((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        if (er == null) {
            throw new BOSException("\u83b7\u53d6\u6c47\u7387\u9519\u8bef");
        }
        return er;
    }

    protected BigDecimal getBankJournalExchangeCache(IObjectPK excTablepk, IObjectPK sourceCurrpk, IObjectPK destCurrpk, Date date) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        if (excTablepk == null) {
            return null;
        }
        if (sourceCurrpk == null) {
            return null;
        }
        if (destCurrpk == null) {
            return null;
        }
        if (destCurrpk.equals((Object)sourceCurrpk)) {
            return CasConstants.ONE;
        }
        String key = excTablepk.toString() + sourceCurrpk + destCurrpk + date.getTime();
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)this.ctx);
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo(excTablepk, sourceCurrpk, destCurrpk, date);
        if (erInfo == null) {
            return null;
        }
        return erInfo.getConvertRate();
    }

    protected ExchangeRateInfo getExRateInfo(CurrencyInfo sourceCurrency, CurrencyInfo desCurrency, CompanyOrgUnitInfo company, Date date) throws BOSException, EASBizException {
        ExchangeTableInfo baseExchangeTable = company.getBaseExchangeTable();
        if (baseExchangeTable == null) {
            throw new BOSException("\u6ca1\u6709\u6c47\u7387\u8868");
        }
        ExchangeRateInfo exRateInfo = null;
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId());
        ObjectUuidPK destCurrpk = new ObjectUuidPK(desCurrency.getId());
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)this.ctx);
        exRateInfo = iExchangRate.getExchangeRateConvertInfo((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, DateTimeUtils.truncateDate((Date)date));
        return exRateInfo;
    }

    public boolean isGlDc() {
        return this.glDc;
    }

    public void setGlDc(boolean glDc) {
        this.glDc = glDc;
    }

    public BigDecimal getParamBalance(BigDecimal balance) {
        if (!this.isGlDc()) {
            return balance.abs();
        }
        return balance;
    }

    public String getParamDc(String dc, BigDecimal balance) {
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        if (this.isGlDc() && dc != null && !dc.equals(direction.getAlias()) && !direction.equals((Object)DirectionEnum.Balance)) {
            return dc;
        }
        return direction.getAlias();
    }
}

