/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.cas.utils;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.el.rec.tool.engine.cas.utils.CASCellData;
import com.kingdee.eas.el.rec.tool.engine.cas.utils.CASExtendPro;
import com.kingdee.eas.el.rec.tool.engine.cas.utils.CASInfoSnapShot;
import com.kingdee.eas.el.rec.tool.engine.cas.utils.CASSingleRow;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;

public class CASTDUtils {
    private static Logger logger = CoreUIObject.getLogger(CASTDUtils.class);
    private static String[] HanDigiStr = new String[]{EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"114_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"115_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"116_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"117_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"118_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"119_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"120_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"121_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"122_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"123_TDUtils")};
    private static String[] HanDiviStr = new String[]{"", EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"124_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"125_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"126_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"127_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"124_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"125_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"126_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"128_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"124_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"125_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"126_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"127_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"124_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"125_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"126_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"128_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"124_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"125_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"126_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"127_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"124_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"125_TDUtils"), EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"126_TDUtils")};

    public void fillRowSetForAdjust(CASInfoSnapShot kdtss, DynamicRowSet drs, UserDefineColumnCollection udcc, int adjustScale) throws SQLException, Exception {
        CASSingleRow[] sr = kdtss.getRowList();
        for (int i = 0; i < sr.length; ++i) {
            drs.moveToInsertRow();
            CASTDUtils.clearRow((IRowSet)drs);
            CASSingleRow row = sr[i];
            this.populateRow(drs, row, udcc, adjustScale);
            drs.insertRow();
        }
    }

    private void populateRow(DynamicRowSet drs, CASSingleRow row, UserDefineColumnCollection udcc, int adjustScale) throws Exception {
        CASCellData[] cds = row.getCells();
        for (int i = 0; i < cds.length; ++i) {
            CASCellData data = cds[i];
            if (data == null) continue;
            this.populateCell(drs, data, adjustScale);
        }
        if (udcc != null) {
            for (int j = 0; j < udcc.size(); ++j) {
                UserDefineColumnInfo info = udcc.getIndex(j);
                drs.updateString(info.getName(), info.getColumnValue());
            }
        }
    }

    private void populateCell(DynamicRowSet drs, CASCellData data, int adjustScale) throws Exception {
        String mappingFiled;
        Object valueType = data.getCellValue();
        String thisValue = null;
        if (valueType != null && data.getCellValue() != null) {
            thisValue = valueType instanceof BigDecimal ? this.dealBigDecimal(data) : (valueType instanceof Date || valueType instanceof java.util.Date ? this.dealDate(data) : (valueType instanceof Enum ? this.dealEnum(data) : (valueType instanceof Integer ? this.dealInteger(data) : this.dealOther(data))));
        }
        if ((mappingFiled = data.getMappingField()) != null) {
            if (thisValue != null && valueType instanceof BigDecimal) {
                BigDecimal amount = new BigDecimal(thisValue.replaceAll(",", ""));
                drs.updateString(data.getMappingField(), CASTDUtils.formatDecimal(amount, adjustScale));
            } else {
                drs.updateString(data.getMappingField(), thisValue);
            }
        }
    }

    public static String formatDecimal(BigDecimal val, int adjustScale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(CASTDUtils.toPattern(adjustScale));
        return decimalFormat.format(val);
    }

    public static String formatDecimal(BigDecimal val) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(CASTDUtils.toPattern(val.scale()));
        return decimalFormat.format(val);
    }

    private static String toPattern(int scale) {
        StringBuffer s = new StringBuffer(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append("0");
        }
        return s.toString();
    }

    private String dealOther(CASCellData data) {
        return data.getCellValue().toString();
    }

    private String dealInteger(CASCellData data) {
        return ((Integer)data.getCellValue()).toString();
    }

    private String dealEnum(CASCellData data) {
        return ((Enum)data.getCellValue()).getAlias();
    }

    private String dealDate(CASCellData data) {
        return Constants.FORMAT_DAY.format(TypeConversionUtils.objToDate((Object)data.getCellValue()));
    }

    private String dealBigDecimal(CASCellData data) throws Exception {
        String thisValue = null;
        BigDecimal dec = TypeConversionUtils.objToBigDecimal((Object)data.getCellValue());
        thisValue = dec.toString();
        CASExtendPro ep = data.getExpro();
        if (ep != null) {
            if (ep.isNumberToChinese()) {
                thisValue = this.NumToRMBStr(dec.doubleValue());
            } else if (ep.getScale() > 0) {
                thisValue = this.formatNumber(dec, ep.getScale());
            }
        }
        return thisValue;
    }

    public String NumToRMBStr(double val) {
        String SignStr = "";
        String TailStr = "";
        if (val < 0.0) {
            val = -val;
            SignStr = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"129_TDUtils");
        }
        if (val > 1.0E14 || val < -1.0E14) {
            return EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"108_TDUtils");
        }
        long temp = Math.round(val * 100.0);
        long integer = temp / 100L;
        long fraction = temp % 100L;
        int jiao = (int)fraction / 10;
        int fen = (int)fraction % 10;
        if (jiao == 0 && fen == 0) {
            TailStr = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"130_TDUtils");
        } else {
            TailStr = HanDigiStr[jiao];
            if (jiao != 0) {
                TailStr = TailStr + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"131_TDUtils");
            }
            if (integer == 0L && jiao == 0) {
                TailStr = "";
            }
            if (fen != 0) {
                TailStr = TailStr + HanDigiStr[fen] + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"132_TDUtils");
            }
        }
        return "\uffe5" + SignStr + this.PositiveIntegerToHanStr(String.valueOf(integer)) + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"133_TDUtils") + TailStr;
    }

    public String PositiveIntegerToHanStr(String NumStr) {
        StringBuffer RMBStr = new StringBuffer();
        boolean lastzero = false;
        boolean hasvalue = false;
        int len = NumStr.length();
        if (len > 15) {
            return EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"109_TDUtils");
        }
        for (int i = len - 1; i >= 0; --i) {
            if (NumStr.charAt(len - i - 1) == ' ') continue;
            int n = NumStr.charAt(len - i - 1) - 48;
            if (n < 0 || n > 9) {
                return EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"110_TDUtils");
            }
            if (n != 0) {
                if (lastzero) {
                    RMBStr.append(HanDigiStr[0]);
                }
                if (n != 1 || i % 4 != 1 || i != len - 1) {
                    RMBStr.append(HanDigiStr[n]);
                }
                RMBStr.append(HanDiviStr[i]);
                hasvalue = true;
            } else if (i % 8 == 0 || i % 8 == 4 && hasvalue) {
                RMBStr.append(HanDiviStr[i]);
            }
            if (i % 8 == 0) {
                hasvalue = false;
            }
            lastzero = n == 0 && i % 4 != 0;
        }
        if (RMBStr.length() == 0) {
            return HanDigiStr[0];
        }
        return RMBStr.toString();
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int n = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= n; ++i) {
            rs.updateString(i, null);
        }
    }

    protected String formatNumber(BigDecimal val, int scale) {
        if (val == null) {
            return "";
        }
        return CASTDUtils.withComma(val.setScale(scale, 4), scale);
    }

    private static String withComma(BigDecimal val, int scale) {
        String pattern = null;
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        return new DecimalFormat(pattern).format(val);
    }
}

