/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.engine.gl.provider;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.el.rec.tool.engine.gl.provider.AbstractGLRptPrintProvider;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptAccountBalancePrintProvider
extends AbstractGLRptPrintProvider {
    private static final Logger logger = Logger.getLogger(GLRptAccountBalancePrintProvider.class);
    public static final String[][] col = new String[][]{{"SysDateTime", ""}, {"CurrentUser", ""}, {"AccountLevel", ""}, {"Company", ""}, {"Currency", ""}, {"Period", ""}, {"FAccountNumber", "accountNumber"}, {"FAccountName", "accountName"}, {"FCurrencyName", "currencyName"}, {"FAsstAccountName0", "FAsstAccountName0"}, {"FAsstAccountName1", "FAsstAccountName1"}, {"FAsstAccountName2", "FAsstAccountName2"}, {"FAsstAccountName3", "FAsstAccountName3"}, {"FAsstAccountName4", "FAsstAccountName4"}, {"FAsstAccountName5", "FAsstAccountName5"}, {"FAsstAccountName6", "FAsstAccountName6"}, {"FAsstAccountName7", "FAsstAccountName7"}, {"measureUnit", "measureUnit"}, {"FYearBeginQty", "FYearBeginQty"}, {"FYearBeginDebitQty", "FYearBeginDebitQty"}, {"FYearBeginDebitFor", "FYearBeginDebitBalanceFor"}, {"FYearBeginDebitLocal", "FYearBeginDebitBalanceLocal"}, {"FYearBeginDebitRpt", "FYearBeginDebitBalanceRpt"}, {"FYearBeginCreditQty", "FYearBeginCreditQty"}, {"FYearBeginCreditFor", "FYearBeginCreditBalanceFor"}, {"FYearBeginCreditLocal", "FYearBeginCreditBalanceLocal"}, {"FYearBeginCreditRpt", "FYearBeginCreditBalanceRpt"}, {"FBeginQty", "FBeginQty"}, {"FBeginDebitQty", "FBeginDebitQty"}, {"FBeginDebitFor", "FBeginDebitBalanceFor"}, {"FBeginDebitLocal", "FBeginDebitBalanceLocal"}, {"FBeginDebitRpt", "FBeginDebitBalanceRpt"}, {"FBeginCreditQty", "FBeginCreditQty"}, {"FBeginCreditFor", "FBeginCreditBalanceFor"}, {"FBeginCreditLocal", "FBeginCreditBalanceLocal"}, {"FBeginCreditRpt", "FBeginCreditBalanceRpt"}, {"FDebitQty", "FDebitQty"}, {"FDebitFor", "FDebitFor"}, {"FDebitLocal", "FDebitLocal"}, {"FDebitRpt", "FDebitRpt"}, {"FCreditQty", "FCreditQty"}, {"FCreditFor", "FCreditFor"}, {"FCreditLocal", "FCreditLocal"}, {"FCreditRpt", "FCreditRpt"}, {"FYearDebitQty", "FYearDebitQty"}, {"FYearDebitFor", "FYearDebitFor"}, {"FYearDebitLocal", "FYearDebitLocal"}, {"FYearDebitRpt", "FYearDebitRpt"}, {"FYearCreditQty", "FYearCreditQty"}, {"FYearCreditFor", "FYearCreditFor"}, {"FYearCreditLocal", "FYearCreditLocal"}, {"FYearCreditRpt", "FYearCreditRpt"}, {"FEndQty", "FEndQty"}, {"FEndDebitQty", "FEndDebitQty"}, {"FEndDebitFor", "FEndDebitBalanceFor"}, {"FEndDebitLocal", "FEndDebitBalanceLocal"}, {"FEndDebitRpt", "FEndDebitBalanceRpt"}, {"FEndCreditQty", "FEndCreditQty"}, {"FEndCreditFor", "FEndCreditBalanceFor"}, {"FEndCreditLocal", "FEndCreditBalanceLocal"}, {"FEndCreditRpt", "FEndCreditBalanceRpt"}};

    public GLRptAccountBalancePrintProvider(Map<String, Object> params) {
        super(params);
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        for (int i = 4; i <= 30; ++i) {
            if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
            rs = this.getRowSet(i);
            break;
        }
        return rs;
    }

    public IRowSet getRowSet(int rowLineCount) {
        DateFormat format = GlUtils.getDateFormat();
        HashMap hmParamValue = new HashMap();
        try {
            hmParamValue = this.getInitParam(this.curCompany);
        }
        catch (EASBizException e1) {
            logger.error((Object)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        boolean isImp = false;
        isImp = hmParamValue.get("GL_059") == null ? true : Boolean.valueOf(hmParamValue.get("GL_059").toString());
        int qtyScale = 2;
        if (hmParamValue.get("GL_002") != null) {
            qtyScale = Integer.parseInt(hmParamValue.get("GL_002").toString());
        }
        boolean showQty = true;
        DynamicRowSet drs = null;
        try {
            CurrencyInfo baseCurrency = this.curCompany.getBaseCurrency();
            baseCurrency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            CurrencyInfo rptCurrency = this.curCompany.getReportCurrency();
            if (rptCurrency != null) {
                rptCurrency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(rptCurrency.getId()));
            }
            String currencyId = (String)this.vars.get("currencyId");
            CurrencyInfo currency = null;
            if (currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC")) {
                currency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            } else if (currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC")) {
                currency = rptCurrency;
            } else if (!currencyId.equalsIgnoreCase("AllCurrency")) {
                currency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            }
            boolean isBaseCurrency = currency != null && baseCurrency.getId().equals((Object)currency.getId());
            boolean isGBaseCy = currencyId.equals("11111111-1111-1111-1111-111111111111DEB58FDC");
            boolean isGRptCy = currencyId.equals("22222222-2222-2222-2222-222222222222DEB58FDC");
            int colCount = col.length;
            drs = this.createDynamicRowSet(colCount);
            this.rs.beforeFirst();
            while (this.rs.next()) {
                drs.moveToInsertRow();
                GLRptAccountBalancePrintProvider.clearRow((IRowSet)drs);
                drs.updateString("SysDateTime", GlUtils.formatDate((DateFormat)format, (Date)new Date()));
                UserInfo user = (UserInfo)this.ctx.get((Object)"UserInfo");
                if (user.getName() != null) {
                    drs.updateString("CurrentUser", user.getName());
                } else {
                    drs.updateString("CurrentUser", user.toString());
                }
                drs.updateString("AccountLevel", (String)this.vars.get("mapAccountLevel"));
                drs.updateString("Company", this.curCompany.getName());
                drs.updateString("Currency", currency.getName());
                drs.updateString("Period", (String)this.vars.get("Period"));
                int precision = 0;
                if (currency == null) {
                    Object currencyPre = this.rs.getObject("currencyPre");
                    if (currencyPre != null) {
                        precision = Integer.parseInt(currencyPre.toString());
                    }
                } else {
                    precision = currency.getPrecision();
                }
                for (int i = 6; i < col.length; ++i) {
                    if (this.rs.indexOf(col[i][1]) == -1 || "FYearBeginQty".equals(col[i][1]) || "FBeginQty".equals(col[i][1]) || "FEndQty".equals(col[i][1])) continue;
                    Object objValue = this.rs.getObject(col[i][1]);
                    if (objValue != null) {
                        if (objValue.getClass() != BigDecimal.class) {
                            String[] a;
                            if (col[i][1].startsWith("FAsstAccountName") && !isImp && (a = objValue.toString().trim().split("\\:")).length > 1) {
                                StringBuffer sbE = new StringBuffer();
                                int r = a.length - 1;
                                for (int k = 0; k <= r; ++k) {
                                    if (k == 0) continue;
                                    sbE.append(a[k]).append(":");
                                }
                                sbE.deleteCharAt(sbE.length() - 1);
                                objValue = sbE.toString();
                            }
                            drs.updateString(col[i][0], objValue.toString());
                            continue;
                        }
                        if (((BigDecimal)objValue).compareTo(new BigDecimal("0")) == 0) {
                            drs.updateString(col[i][0], "");
                            continue;
                        }
                        BigDecimal value = (BigDecimal)objValue;
                        if (col[i][0].toLowerCase(Locale.ENGLISH).endsWith("local")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)value, (int)baseCurrency.getPrecision()));
                            if (!isGBaseCy) continue;
                            drs.updateString(col[i][0].substring(0, col[i][0].length() - 5) + "for", GlUtils.withComma((BigDecimal)((BigDecimal)objValue), (int)baseCurrency.getPrecision()));
                            continue;
                        }
                        if (rptCurrency != null && col[i][0].toLowerCase(Locale.ENGLISH).endsWith("rpt")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)value, (int)rptCurrency.getPrecision()));
                            if (!isGRptCy) continue;
                            drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "for", GlUtils.withComma((BigDecimal)value, (int)rptCurrency.getPrecision()));
                            continue;
                        }
                        if (col[i][0].toLowerCase(Locale.ENGLISH).endsWith("for")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)value, (int)precision));
                            if (!isBaseCurrency) continue;
                            drs.updateString(col[i][0].substring(0, col[i][0].length() - 3) + "local", GlUtils.withComma((BigDecimal)value, (int)precision));
                            continue;
                        }
                        if (col[i][1].endsWith("Qty")) {
                            drs.updateString(col[i][0], GlUtils.withComma((BigDecimal)value, (int)qtyScale));
                            continue;
                        }
                        drs.updateString(col[i][0], value.toString());
                        continue;
                    }
                    drs.updateString(col[i][0], "");
                }
                if (showQty) {
                    drs.updateString("measureUnit", this.rs.getString("measureUnit"));
                    BigDecimal yearBeginQty = this.getBigDecimal(this.rs, "FYearBeginDebitQty").subtract(this.getBigDecimal(this.rs, "FYearBeginCreditQty"));
                    drs.updateString("FYearBeginQty", yearBeginQty.doubleValue() == 0.0 ? "" : GlUtils.withComma((BigDecimal)yearBeginQty, (int)qtyScale));
                    BigDecimal beginQty = this.getBigDecimal(this.rs, "FBeginDebitQty").subtract(this.getBigDecimal(this.rs, "FBeginCreditQty"));
                    drs.updateString("FBeginQty", beginQty.doubleValue() == 0.0 ? "" : GlUtils.withComma((BigDecimal)beginQty, (int)qtyScale));
                    BigDecimal endQty = this.getBigDecimal(this.rs, "FEndDebitQty").subtract(this.getBigDecimal(this.rs, "FEndCreditQty"));
                    drs.updateString("FEndQty", endQty.doubleValue() == 0.0 ? "" : GlUtils.withComma((BigDecimal)endQty, (int)qtyScale));
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return drs;
    }

    private BigDecimal getBigDecimal(GLRptRowSet rs, String field) throws BOSException {
        BigDecimal amount = rs.getBigDecimal(field);
        if (amount == null) {
            return GlUtils.zero;
        }
        return amount;
    }

    private DynamicRowSet createDynamicRowSet(int colCount) throws SQLException {
        DynamicRowSet drs = new DynamicRowSet(colCount);
        for (int i = 0; i < colCount; ++i) {
            ColInfo ci = new ColInfo();
            ci.colType = 12;
            ci.columnName = col[i][0];
            ci.nullable = 1;
            drs.setColInfo(i + 1, ci);
        }
        drs.beforeFirst();
        return drs;
    }

    protected static void clearRow(IRowSet rs) throws Exception {
        int colCount = rs.getRowSetMetaData().getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            rs.updateString(i, null);
        }
    }

    private HashMap getInitParam(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)String.valueOf(company.getId())));
        HashMap<String, ObjectUuidPK> sysParams = new HashMap<String, ObjectUuidPK>();
        sysParams.put("GL_059", comPK);
        sysParams.put("GL_002", comPK);
        return ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(sysParams);
    }
}

