/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.ftp;

import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.kingdee.eas.el.rec.tool.FTPClient;
import java.io.IOException;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.log4j.Logger;

public class FTPClientFactory
extends BasePoolableObjectFactory {
    private static Logger logger = Logger.getLogger(FTPClientFactory.class);
    private static String address;
    private static int port;
    private static String userName;
    private static String passWord;
    private static String serverCharset;
    int tryNumMax = 3;

    public FTPClientFactory(String address, int port, String userName, String passWord) {
        FTPClientFactory.address = address;
        FTPClientFactory.port = port;
        FTPClientFactory.userName = userName;
        FTPClientFactory.passWord = passWord;
    }

    public Object makeObject() throws Exception {
        boolean isFail = true;
        FTPClient ftpClient = null;
        int tryNum = 1;
        while (tryNum <= this.tryNumMax && isFail) {
            try {
                ftpClient = new FTPClient();
                ftpClient.setTimeout(5000);
                ftpClient.setRemoteHost(address);
                ftpClient.setRemotePort(port);
                ftpClient.setControlEncoding(serverCharset);
                ftpClient.setConnectMode(FTPConnectMode.PASV);
                ftpClient.connect();
                ftpClient.login(userName, passWord);
                ftpClient.setType(FTPTransferType.BINARY);
                isFail = false;
            }
            catch (Exception e) {
                logger.error((Object)("\u7b2c" + tryNum + "\u6b21\u767b\u5f55FTP\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
                Thread.sleep(20000L);
                ++tryNum;
            }
        }
        return ftpClient;
    }

    private boolean isPositiveCompletion(FTPReply reply) {
        try {
            int replyCode = Integer.parseInt(reply.getReplyCode());
            return replyCode >= 200 && replyCode < 300;
        }
        catch (Exception e) {
            logger.error((Object)("com.kingdee.eas.el.rec.tool.ftp.FTPClientFactory.isPositiveCompletion" + e.getMessage()));
            return false;
        }
    }

    public void destroyObject(Object obj) throws Exception {
        FTPClient client = (FTPClient)((Object)obj);
        if (client != null && client.connected()) {
            client.quit();
        }
    }

    public boolean validateObject(Object o) {
        FTPClient client = (FTPClient)((Object)o);
        try {
            client.sendServerWakeup();
        }
        catch (IOException e) {
            logger.error((Object)("com.kingdee.eas.el.rec.tool.ftp.FTPClientFactory.validateObject--IOException--" + e.getMessage()));
        }
        catch (FTPException e) {
            logger.error((Object)("com.kingdee.eas.el.rec.tool.ftp.FTPClientFactory.validateObject--FTPException--" + e.getMessage()));
        }
        return true;
    }

    static {
        serverCharset = "ISO-8859-1";
    }
}

