/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.el.rec.tool.ftp;

import com.kingdee.eas.el.rec.thread.UploadArchInfosThreadPool;
import com.kingdee.eas.el.rec.tool.FTPClient;
import com.kingdee.eas.el.rec.tool.ftp.FTPClientFactory;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.log4j.Logger;

public class FTPClientPool
implements ObjectPool {
    private static Logger logger = Logger.getLogger(FTPClientPool.class);
    public BlockingQueue<FTPClient> pool;
    private FTPClientFactory factory;

    public FTPClientPool(int poolSize, FTPClientFactory factory) throws Exception {
        this.factory = factory;
        this.pool = new ArrayBlockingQueue<FTPClient>(poolSize);
        this.initPool(poolSize);
    }

    private void initPool(int maxPoolSize) throws Exception {
        for (int count = 0; count < maxPoolSize; ++count) {
            this.addObject();
        }
    }

    public void resetPool(String address, int port, String userName, String passWord) throws Exception {
        if (this.pool != null) {
            this.close();
        }
        this.factory = new FTPClientFactory(address, port, userName, passWord);
        int threadPoolSize = UploadArchInfosThreadPool.getFileUploadThreadPoolSize();
        this.pool = new ArrayBlockingQueue<FTPClient>(threadPoolSize);
        this.initPool(threadPoolSize);
    }

    public Object borrowObject() throws Exception {
        FTPClient client = this.pool.take();
        if (client == null) {
            throw new RuntimeException("\u4ece\u8fde\u63a5\u6c60\u83b7\u53d6\u8fde\u63a5\u5931\u8d25\uff01");
        }
        return client;
    }

    public void returnObject(Object obj) throws Exception {
        if (obj == null) {
            obj = this.factory.makeObject();
        }
        try {
            this.factory.passivateObject(obj);
            this.pool.offer((FTPClient)((Object)obj));
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public void invalidateObject(Object obj) throws Exception {
        this.pool.remove(obj);
    }

    public void addObject() throws Exception {
        this.pool.offer((FTPClient)((Object)this.factory.makeObject()));
    }

    public int getNumIdle() throws UnsupportedOperationException {
        return 0;
    }

    public int getNumActive() throws UnsupportedOperationException {
        return 0;
    }

    public void clear() throws Exception, UnsupportedOperationException {
        this.pool.clear();
    }

    public void close() throws Exception {
        while (this.pool.iterator().hasNext()) {
            FTPClient client = this.pool.take();
            this.factory.destroyObject((Object)client);
        }
    }

    public void setFactory(PoolableObjectFactory poolableObjectFactory) throws IllegalStateException, UnsupportedOperationException {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public FTPClientFactory getFactory() {
        return this.factory;
    }
}

