/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.emm.mo.EMMManufactureOrderCTL;
import com.kingdee.eas.emm.mo.EMMManufactureOrderFlowCTL;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.MOBirthTypeEnum;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderSyncException;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.MaterialReplaceTypeEnum;
import com.kingdee.eas.mm.mo.OrderStockTransferTypeEnum;
import com.kingdee.eas.mm.mo.PickTypeEnum;
import com.kingdee.eas.mm.mo.app.util.MOMultiMeasureUnitUtil;
import com.kingdee.eas.mm.mo.util.NumericUtil;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class EMMManufactureOrderEXCTL {
    private static String MANUFACTURE_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"MANUFACTURE_INFO");
    private static String BCZYXDDGX_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"BCZYXDDGX_INFO");
    private static String BSBCTJSH_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"BSBCTJSH_INFO");
    private static String SWLXWK_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"SWLXWK_INFO");
    private static String SWLXBSBZSC_INFO = EASResource.getString((String)"com.kingdee.eas.emm.mo.EMMEMMoResource", (String)"SWLXBSBZSC_INFO");

    protected Boolean isEnabledBEEDTime(Context ctx, String storageOrgUnitID) throws BOSException, EASBizException {
        if (storageOrgUnitID == null) {
            return false;
        }
        String isEnabledBEEDTime = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("value"));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)storageOrgUnitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"GMOSBEEDT", CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)ctx).getParamItemCollection(entityViewInfo);
        if (paramItemCollection != null && paramItemCollection.size() > 0 && paramItemCollection.get(0) != null) {
            String string = isEnabledBEEDTime = paramItemCollection.get(0).getValue() == null ? "false" : paramItemCollection.get(0).getValue();
        }
        if (isEnabledBEEDTime == null) {
            isEnabledBEEDTime = "false";
        }
        if ("true".equals(isEnabledBEEDTime)) {
            return true;
        }
        return false;
    }

    protected String[] sortMoIdListByMoLongnumber(Context ctx, String[] toDoIds) throws BOSException {
        String idStr = SQLUtil.arrayToString((Object[])toDoIds);
        StringBuffer ksqlBuf = new StringBuffer();
        ksqlBuf.append(" SELECT  fid  ");
        ksqlBuf.append(" FROM  T_MM_ManufactureOrder  ");
        ksqlBuf.append(" WHERE  fid  IN   (").append(idStr).append(")  ");
        ksqlBuf.append("   ORDER  BY  flongnumber  DESC");
        String[] sortIDs = new String[toDoIds.length];
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ksqlBuf.toString());
        try {
            int i = 0;
            while (rs.next()) {
                sortIDs[i++] = rs.getString("fid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sortIDs;
    }

    public static void syncStock_addRec(Context ctx, IObjectCollection stockCol, IObjectCollection newStockCol, Collection insertKeyCol) throws EASBizException, BOSException {
        int GENERATED_INFO_TAG = -99999;
        IObjectValue entryInfo = null;
        String recKey = "";
        int size = newStockCol.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = newStockCol.getObject(i);
            recKey = EMMManufactureOrderCTL.getRecKeyString(entryInfo);
            if (!insertKeyCol.contains(recKey)) continue;
            if (entryInfo instanceof ManufactureOrderStockInfo) {
                ((ManufactureOrderStockInfo)entryInfo).setSourceBillEntrySeq(-99999);
            }
            stockCol.addObject(entryInfo);
        }
    }

    public static void syncStock_deleteExpectOutput(Context ctx, ManufactureOrderExpectOutputCollection expectOutputCol, Collection deleteKeyCol) throws EASBizException, BOSException {
        ManufactureOrderExpectOutputInfo expectOutputInfo = null;
        String recKey = "";
        for (int index = expectOutputCol.size() - 1; index >= 0; --index) {
            expectOutputInfo = expectOutputCol.get(index);
            recKey = EMMManufactureOrderCTL.getRecKeyString((IObjectValue)expectOutputInfo);
            if (!deleteKeyCol.contains(recKey)) continue;
            EMMManufactureOrderFlowCTL.deleteRecFromExpectOutputCol(ctx, expectOutputCol, expectOutputInfo);
        }
    }

    public static void syncStock_deleteStock(Context ctx, ManufactureOrderStockCollection stockCol, Collection deleteKeyCol) throws EASBizException, BOSException {
        ManufactureOrderStockInfo stockInfo = null;
        String recKey = "";
        for (int index = stockCol.size() - 1; index >= 0; --index) {
            stockInfo = stockCol.get(index);
            recKey = EMMManufactureOrderCTL.getRecKeyString((IObjectValue)stockInfo);
            if (!deleteKeyCol.contains(recKey)) continue;
            EMMManufactureOrderFlowCTL.deleteRecFromStockCol(ctx, stockCol, stockInfo);
        }
    }

    public static void syncStock_updateExpectOutput(Context ctx, ManufactureOrderExpectOutputCollection expectOutputCol, ManufactureOrderExpectOutputCollection newExpectOutputCol, Collection updateKeyCol) throws EASBizException, BOSException {
        int index;
        if (updateKeyCol.size() == 0) {
            return;
        }
        ManufactureOrderExpectOutputInfo newExpectOutputInfo = null;
        ManufactureOrderExpectOutputInfo expectOutputInfo = null;
        String recKey = "";
        HashMap<String, ArrayList> hm = new HashMap<String, ArrayList>();
        ArrayList list = null;
        int size = expectOutputCol.size();
        for (index = 0; index < size; ++index) {
            expectOutputInfo = expectOutputCol.get(index);
            recKey = EMMManufactureOrderCTL.getRecKeyString((IObjectValue)expectOutputInfo);
            if (!updateKeyCol.contains(recKey)) continue;
            if (hm.containsKey(recKey)) {
                list = (ArrayList)hm.get(recKey);
                list.add(expectOutputInfo);
                continue;
            }
            list = new ArrayList();
            list.add(expectOutputInfo);
            hm.put(recKey, list);
        }
        for (index = newExpectOutputCol.size() - 1; index >= 0; --index) {
            newExpectOutputInfo = newExpectOutputCol.get(index);
            recKey = EMMManufactureOrderCTL.getRecKeyString((IObjectValue)newExpectOutputInfo);
            if (!updateKeyCol.contains(recKey) || !hm.containsKey(recKey)) continue;
            list = (ArrayList)hm.get(recKey);
            int size2 = list.size();
            for (int i = 0; i < size2; ++i) {
                expectOutputInfo = (ManufactureOrderExpectOutputInfo)list.get(i);
                if (i == 0) {
                    expectOutputInfo.setOutputType(newExpectOutputInfo.getOutputType());
                    expectOutputInfo.setDefaultWarehous(newExpectOutputInfo.getDefaultWarehous());
                    BigDecimal qty = NumericUtil.emptyToZero((Object)newExpectOutputInfo.getQty());
                    BigDecimal baseQty = NumericUtil.emptyToZero((Object)newExpectOutputInfo.getBaseQty());
                    baseQty = baseQty.max(expectOutputInfo.getFinishedBaseQty()).max(expectOutputInfo.getToStoreBaseQty());
                    expectOutputInfo.setBaseQty(baseQty);
                    if (!StringUtils.equalsIgnoreCase((String)expectOutputInfo.getUnit().getId().toString(), (String)newExpectOutputInfo.getUnit().getId().toString())) {
                        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
                        MultiMeasureUnitInfo mmuInfo = multiUnit.getMultiUnit(expectOutputInfo.getMaterial().getId().toString(), expectOutputInfo.getUnit().getId().toString());
                        qty = baseQty.divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4);
                    } else {
                        qty = qty.max(expectOutputInfo.getFinishedQty()).max(expectOutputInfo.getToStoreQty());
                    }
                    expectOutputInfo.setQty(qty);
                    continue;
                }
                EMMManufactureOrderFlowCTL.deleteRecFromExpectOutputCol(ctx, expectOutputCol, expectOutputInfo);
            }
        }
    }

    public static void syncStock_updateStock(Context ctx, ManufactureOrderStockCollection stockCol, ManufactureOrderStockCollection newStockCol, Collection updateKeyCol) throws EASBizException, BOSException {
        int index;
        if (updateKeyCol.size() == 0) {
            return;
        }
        ManufactureOrderStockInfo newStockInfo = null;
        ManufactureOrderStockInfo stockInfo = null;
        String recKey = "";
        HashMap<String, ArrayList> hm = new HashMap<String, ArrayList>();
        ArrayList list = null;
        int size = stockCol.size();
        for (index = 0; index < size; ++index) {
            stockInfo = stockCol.get(index);
            recKey = EMMManufactureOrderCTL.getRecKeyString((IObjectValue)stockInfo);
            if (!updateKeyCol.contains(recKey)) continue;
            if (hm.containsKey(recKey)) {
                list = (ArrayList)hm.get(recKey);
                list.add(stockInfo);
                continue;
            }
            list = new ArrayList();
            list.add(stockInfo);
            hm.put(recKey, list);
        }
        for (index = newStockCol.size() - 1; index >= 0; --index) {
            newStockInfo = newStockCol.get(index);
            recKey = EMMManufactureOrderCTL.getRecKeyString((IObjectValue)newStockInfo);
            if (!updateKeyCol.contains(recKey) || !hm.containsKey(recKey)) continue;
            list = (ArrayList)hm.get(recKey);
            int size2 = list.size();
            for (int i = 0; i < size2; ++i) {
                stockInfo = (ManufactureOrderStockInfo)list.get(i);
                if (i == 0) {
                    EMMManufactureOrderEXCTL.updateStockInfo(ctx, stockInfo, newStockInfo);
                    continue;
                }
                EMMManufactureOrderFlowCTL.deleteRecFromStockCol(ctx, stockCol, stockInfo);
            }
        }
    }

    protected static void updateStockInfo(Context ctx, ManufactureOrderStockInfo oldStockInfo, ManufactureOrderStockInfo newStockInfo) throws EASBizException, BOSException {
        HashSet<String> destEntityHS = new HashSet<String>();
        destEntityHS.add("500AB75E");
        destEntityHS.add("7606B3CD");
        destEntityHS.add("2239F30A");
        destEntityHS.add("5C2A1F0C");
        destEntityHS.add("76C9F8D8");
        boolean hasDestObject = EMMManufactureOrderCTL.checkEntryHasDestObject(ctx, oldStockInfo.getId().toString(), destEntityHS);
        BigDecimal oldPlannedQty = oldStockInfo.getPlannedQty();
        oldStockInfo.setUnitBaseQty(newStockInfo.getUnitBaseQty());
        oldStockInfo.setBaseQty(newStockInfo.getBaseQty());
        oldStockInfo.setLossBaseQty(newStockInfo.getLossBaseQty());
        oldStockInfo.setUnIssueBaseQty(oldStockInfo.getUnIssueBaseQty().add(newStockInfo.getPlannedBaseQty()).subtract(oldStockInfo.getPlannedBaseQty()));
        oldStockInfo.setPlannedBaseQty(newStockInfo.getPlannedBaseQty());
        oldStockInfo.setUnReceiptBaseQty(oldStockInfo.getPlannedBaseQty().subtract(oldStockInfo.getTotalReceiptBaseQty()));
        if (StringUtils.equalsIgnoreCase((String)newStockInfo.getUnit().getId().toString(), (String)oldStockInfo.getUnit().getId().toString())) {
            oldStockInfo.setUnitQty(newStockInfo.getUnitQty());
            oldStockInfo.setQty(newStockInfo.getQty());
            oldStockInfo.setLossQty(newStockInfo.getLossQty());
            oldStockInfo.setUnIssueQty(oldStockInfo.getUnIssueQty().add(newStockInfo.getPlannedQty()).subtract(oldPlannedQty));
            oldStockInfo.setPlannedQty(newStockInfo.getPlannedQty());
            oldStockInfo.setUnReceiptQty(oldStockInfo.getPlannedQty().subtract(oldStockInfo.getTotalReceiptQty()));
        } else {
            IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)oldStockInfo.getMaterial().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)oldStockInfo.getUnit().getId().toString()));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add("baseConvsRate");
            sic.add("qtyPrecision");
            viewInfo.setSelector(sic);
            MultiMeasureUnitCollection coll = immu.getMultiMeasureUnitCollection(viewInfo);
            MultiMeasureUnitInfo mmuInfo = coll.get(0);
            oldStockInfo.setUnitQty(oldStockInfo.getUnitBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
            oldStockInfo.setQty(oldStockInfo.getBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
            oldStockInfo.setLossQty(oldStockInfo.getLossBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
            oldStockInfo.setUnIssueQty(oldStockInfo.getUnIssueBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
            oldStockInfo.setPlannedQty(oldStockInfo.getPlannedBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
            oldStockInfo.setUnReceiptQty(oldStockInfo.getUnReceiptBaseQty().divide(mmuInfo.getBaseConvsRate(), mmuInfo.getQtyPrecision(), 4));
        }
        oldStockInfo.setLossRatio(newStockInfo.getLossRatio());
        oldStockInfo.setAssociateQty(oldStockInfo.getAssociateQty().add(oldStockInfo.getPlannedQty().subtract(oldPlannedQty)));
        oldStockInfo.setMatReplaceType(newStockInfo.getMatReplaceType());
        oldStockInfo.setAssyLocation(newStockInfo.getAssyLocation());
        oldStockInfo.setBlkSize(newStockInfo.getBlkSize());
        oldStockInfo.setSpecifiedLength(newStockInfo.getSpecifiedLength());
        if (!hasDestObject) {
            oldStockInfo.setProvideType(newStockInfo.getProvideType());
            oldStockInfo.setStorageOrgUnit(newStockInfo.getStorageOrgUnit());
            oldStockInfo.setIssueMode(newStockInfo.getIssueMode());
            oldStockInfo.setPickType(newStockInfo.getPickType());
            oldStockInfo.setWarehouse(newStockInfo.getWarehouse());
            oldStockInfo.setLocation(newStockInfo.getLocation());
            oldStockInfo.setIsStockAllot(newStockInfo.isIsStockAllot());
            oldStockInfo.setReceiptStroageOrgUnit(newStockInfo.getReceiptStroageOrgUnit());
            oldStockInfo.setReceiptStock(newStockInfo.getReceiptStock());
            oldStockInfo.setTransferType(newStockInfo.getTransferType());
            oldStockInfo.setIsBackflush(newStockInfo.isIsBackflush());
        }
    }

    protected void updateTmpReqPlanDataTable(Context ctx, BatchExecuteParamsEntry[] entries, int bizAction) throws Exception {
        int isaddnew = 0;
        int isWriteOff = 0;
        int isRubricWriteOff = 0;
        int isDeletePlan = 0;
        boolean isNowWriteOff = false;
        int fReqSource = 50;
        int fisclose = 0;
        int fisactive = 0;
        if (103 == bizAction) {
            isaddnew = 1;
            isWriteOff = 1;
        }
        if (102 == bizAction || 701 == bizAction) {
            isaddnew = 1;
            isWriteOff = 1;
            isRubricWriteOff = 1;
        }
        if (109 == bizAction || 104 == bizAction) {
            isDeletePlan = 1;
            isRubricWriteOff = 1;
        }
        if (201 == bizAction) {
            fisclose = 1;
        }
        if (303 == bizAction) {
            fisactive = 1;
        }
        if (9901 == bizAction) {
            fisclose = 1;
        }
        if (9902 == bizAction) {
            fisactive = 1;
        }
        if (9903 == bizAction) {
            isaddnew = 1;
            isWriteOff = 1;
            isDeletePlan = 1;
            isRubricWriteOff = 1;
        }
        if (entries != null && entries.length > 0) {
            Object[] array = new IObjectPK[entries.length];
            for (BatchExecuteParamsEntry entry : entries) {
                IObjectPK pk = (IObjectPK)entry.get(0);
                array[i] = pk;
            }
            String IDSet = StringUtils.arrayToString((Object[])array, (String)"','");
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.setLength(0);
            sqlBuffer.append("INSERT INTO T_MM_ReqPlanData ").append("(fID,").append("FSrcOfSourceBillID,FSrcOfSourceEntryID,fSourceBillTypeID,").append("fStorageOrgUnitID,").append("fSourceSUID,").append("fSourceBillID,").append("FSourceEntryID,").append("fsrcSeq,").append("FBILLTYPEID,").append("FSrcNumber,").append("fRequireDate,").append("fMaterialID,").append("fUnitID,").append("fBaseUnitID,").append("fQty,").append("fBaseQty,").append("fOriginType,").append("fOperationType,").append("fCreatorID,").append("fCreateTime,").append("fFailTimes,").append("fProjectID,").append("fTrackNumberID,").append("fIsDirectTransport,").append("Fisaddnew,FisWriteOff,FisOrderToOrder,FaddPlanType,FWriteOffPlanType,FisRubricWriteOff,").append("FisNowWriteOff,FisDeletePlan,fReqSource,fisclose,fisactive) ").append(" SELECT ").append(" newbosid('D02F7535'),").append(" mo.FSourceBillID, ").append(" stock.FSourceBillEntryID, ").append(" mo.FSourceBillTypeId, ").append(" stock.FStorageOrgUnitID, ").append(" mo.FStorageOrgUnitID, ").append(" mo.fId, ").append(" stock.fId, ").append(" stock.fseq, ").append(" mo.fBillTypeId, ").append(" mo.fNumber, ").append(" stock.fdemandTime, ").append(" stock.fmaterialId, ").append(" stock.fUnitId, ").append(" stock.fBaseUnitId, ").append(" stock.fplannedQty, ").append(" stock.fplannedBaseQty, ").append(90).append(", ").append(bizAction).append(", ").append(" case when mo.fAuditorId is null then mo.fLastUpdateUserId else  mo.fAuditorId end , ").append(" now(), ").append(" 0, ").append(" mo.fProjectId, ").append(" mo.FTrackId, ").append(" mo.FIsDirectSend ").append(", (case when stock.FProvideType in (").append(10930).append(",").append(10940).append(") then ").append(isaddnew).append(" else 0  end)  as Fisaddnew ,").append(" (case when stock.FProvideType in (").append(10930).append(",").append(10940).append(") then ").append(isWriteOff).append(" else 0  end)  as FisWriteOff ,").append(" 0 as  FisOrderToOrder, '").append("NcvxPgEcEADgAAiuwKgL09hs+cg=").append("'  as FaddPlanType ,").append(7).append("  as FWriteOffPlanType, ").append(isRubricWriteOff).append(" as FisRubricWriteOff, ").append(0).append(" as FisNowWriteOff ").append(",").append(isDeletePlan).append(" as FisDeletePlan ").append(",").append(50).append(" as fReqSource ").append(",").append(fisclose).append(" as fisclose ").append(",").append(fisactive).append(" as fisactive ").append(" from t_mm_mftorderstock stock inner join t_mm_manufactureorder mo on mo.fid = stock.FParentID").append(" where mo.fid in ('").append(IDSet).append("')");
            sqlBuffer.append("and ((").append(bizAction).append(" not in( 103,109) ");
            sqlBuffer.append(" and mo.fsourcebilltypeid='").append("9XXvbVGlRtym/0qtqeIXXrhE1B8=").append("' ");
            sqlBuffer.append(" ) or (isnull(mo.fsourcebilltypeid,' ')<>'").append("9XXvbVGlRtym/0qtqeIXXrhE1B8=").append("' ");
            sqlBuffer.append(" and (").append(bizAction).append(" <> 102");
            sqlBuffer.append(")))");
            MRPUtil.executeUpdate((Context)ctx, (String)sqlBuffer.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ManufactureOrderStockCollection buildStockPIEx(Context ctx, Map inParam) throws BOSException, EASBizException {
        ManufactureOrderStockCollection stockCol;
        block49: {
            String locStr = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String tableName = (String)inParam.get("TABLENAME");
            StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)inParam.get("STORAGEORG");
            Timestamp beginDate = (Timestamp)inParam.get("BEGINTIME");
            ProductTransactionTypeInfo transInfo = (ProductTransactionTypeInfo)inParam.get("TRANSTYPE");
            boolean reCalc = true;
            if (inParam.get("RECALC") != null) {
                reCalc = (Boolean)inParam.get("RECALC");
            }
            BigDecimal bill_qty = null;
            BigDecimal convertRate = null;
            if (reCalc) {
                bill_qty = (BigDecimal)inParam.get("BILL_QTY");
                convertRate = EMMManufactureOrderEXCTL.calcCconvertRate(ctx, inParam);
            }
            stockCol = new ManufactureOrderStockCollection();
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("select t0.*, ").append("t1.fnumber fmaterialnumber,t1.fname_").append(locStr).append(" fmaterialname,fmodel,").append("t2.fnumber funitnumber,t2.fname_").append(locStr).append(" funitname, ").append("t5.fid fwhid1,t5.fnumber fwhnumber1,t5.FHasLocation FHasLocation1,t5.fname_").append(locStr).append(" fwhname1, ").append("t4.fid fwhid2,t4.fnumber fwhnumber2,t4.FHasLocation FHasLocation2,t4.fname_").append(locStr).append(" fwhname2, ").append("t6.FWpSeq, ").append("t0.FNETWEIGHT FNETWEIGHT,t0.FBlkSize FBlkSize,t0.FSpecifiedLength FSpecifiedLength, ").append("t8.fid fwhid3,t8.fnumber fwhnumber3,t8.fname_").append(locStr).append(" fwhname3, ").append("t9.fid forgid1,t9.fnumber forgnumber1,t9.fname_").append(locStr).append(" forgname1, ").append("t7.FIsStockAllot FIsStockAllot, location.fid flocationid,location.fname_").append(locStr).append(" flocationname, ").append("location.fnumber flocationnumber ").append(", be.FProvideType as FBProvideType, t7.FProvideType as FMProvideType ").append(", be.FSupplyStorageOrgUnitID as FBSupplyStorageOrgUnitID, t7.FSupplyOrgUnit as FMSupplyOrgUnit ").append(", be.FIsStockTransfer FIsStockTransfer ").append(", be.FTransferOrgUnitID FTransferOrgUnitID, t7.FFromInvOrgID as FMFromInvOrgID ").append(", be.FTransferWarehouseID FTransferWarehouseID, t7.FFromWarehouseID as FMFromWarehouseID").append(", be.FDefaultWarehouseID FDefaultWarehouseID, ").append("T3.CFIsLineStoreHouse \"FIsLineStoreHouse\"\r\n").append(" from ").append(tableName).append(" t0 ").append("inner join t_bd_material t1 on t0.fmaterialid = t1.fid ").append("inner join T_BD_MeasureUnit t2 on t0.funitid = t2.fid ").append("left outer join T_MM_MaterialRWP t6 on t0.FRoutingItemID = t6.FID ").append("left outer join t_bd_materialinventory t3 ").append("on t0.fmaterialid = t3.fmaterialid and t3.FOrgUnit = '").append(storageOrgUnit.getId().toString()).append("' ").append("left outer join T_BD_MaterialPlan t7 on t0.fmaterialid = t7.fmaterialid and t7.FOrgUnit = '").append(storageOrgUnit.getId().toString()).append("' ").append("left outer join T_db_WAREHOUSE t8 on t8.fid = t7.FFromWarehouseID ").append("left outer join T_ORG_Storage t9 on t9.fid = t7.FFromInvOrgID ").append("left outer join T_db_WAREHOUSE t4 on t4.fid = t3.FDefaultWarehouseID ").append("left outer join T_db_WAREHOUSE t5 on t5.fid = t0.FBOMDefWarehouseID ").append("left outer join T_mm_bomentry be on be.fid = t0.FBOMEntryID ").append("left outer join T_DB_LOCATION location on location.fid = t0.FLocationID ").append("where t0.FMaterialAttr <> 10020");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
            try {
                MaterialInfo material;
                int firstWP = 1;
                if (inParam.get("ROUTINGID") != null) {
                    sqlBuf.setLength(0);
                    sqlBuf.append("select t1.FFirstWP ").append("from T_MM_StandardRooting t0,T_MM_MaterialRooting t1 ").append("where t0.FMaterialRootingID = t1.FID ").append("and t0.FID = ?");
                    IRowSet rsFirstWP = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString(), (Object[])new Object[]{inParam.get("ROUTINGID")});
                    if (rsFirstWP.next()) {
                        firstWP = rsFirstWP.getInt("FFirstWP");
                    }
                }
                ArrayList<String> materialLst = new ArrayList<String>();
                ArrayList<String> warehouseLst = new ArrayList<String>();
                Object isAfreshExtendObject = inParam.get("isAfreshExtend");
                int lineSeq = 0;
                IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                OrgUnitCollection receiptCompanyOrgCol = iUnitRel.getToUnit(storageOrgUnit.getId().toString(), 4, 1);
                CompanyOrgUnitInfo receiptCompanyOrgUnit = (CompanyOrgUnitInfo)receiptCompanyOrgCol.get(0);
                while (rs.next()) {
                    WarehouseInfo warehouseInfo;
                    ManufactureOrderStockInfo entry;
                    block48: {
                        block53: {
                            StorageOrgUnitInfo supplyStorageOrgUnitInfo;
                            block52: {
                                block47: {
                                    block51: {
                                        String transferWarehouseID;
                                        WarehouseInfo transferWarehouseInfo;
                                        String transferOrgUnitID;
                                        StorageOrgUnitInfo receiptStroageOrgUnit;
                                        String supplyStorageOrgUnitId;
                                        String bomEntryId;
                                        block46: {
                                            block50: {
                                                entry = new ManufactureOrderStockInfo();
                                                bomEntryId = rs.getString("FBomEntryID");
                                                supplyStorageOrgUnitId = null;
                                                if (isAfreshExtendObject == null) break block50;
                                                if (((Boolean)isAfreshExtendObject).booleanValue()) {
                                                    if (!StringUtil.isEmpty((String)bomEntryId)) {
                                                        entry.setProvideType(MaterialProvideTypeEnum.getEnum((int)rs.getInt("FBProvideType")));
                                                        supplyStorageOrgUnitId = rs.getString("FBSupplyStorageOrgUnitID");
                                                        break block46;
                                                    } else {
                                                        entry.setProvideType(MaterialProvideTypeEnum.getEnum((int)rs.getInt("FMProvideType")));
                                                        supplyStorageOrgUnitId = rs.getString("FMSupplyOrgUnit");
                                                    }
                                                    break block46;
                                                } else {
                                                    entry.setProvideType(MaterialProvideTypeEnum.getEnum((int)rs.getInt("FProvideType")));
                                                    supplyStorageOrgUnitId = rs.getString("FSupplyStorageId");
                                                }
                                                break block46;
                                            }
                                            entry.setProvideType(MaterialProvideTypeEnum.getEnum((int)rs.getInt("FBProvideType")));
                                            supplyStorageOrgUnitId = rs.getString("FBSupplyStorageOrgUnitID");
                                        }
                                        supplyStorageOrgUnitInfo = new StorageOrgUnitInfo();
                                        if (supplyStorageOrgUnitId != null && supplyStorageOrgUnitId.length() > 0) {
                                            supplyStorageOrgUnitInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectStringPK(supplyStorageOrgUnitId));
                                        }
                                        entry.setStorageOrgUnit(supplyStorageOrgUnitInfo);
                                        if (!StringUtil.isEmpty((String)bomEntryId)) {
                                            entry.setIsStockAllot(rs.getBoolean("FIsStockTransfer"));
                                            receiptStroageOrgUnit = new StorageOrgUnitInfo();
                                            transferOrgUnitID = rs.getString("FTransferOrgUnitID");
                                            if (!StringUtil.isEmpty((String)transferOrgUnitID)) {
                                                receiptStroageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectStringPK(transferOrgUnitID));
                                                entry.setReceiptStroageOrgUnit(receiptStroageOrgUnit);
                                            }
                                            transferWarehouseInfo = new WarehouseInfo();
                                            transferWarehouseID = rs.getString("FTransferWarehouseID");
                                            if (!StringUtil.isEmpty((String)transferWarehouseID)) {
                                                transferWarehouseInfo = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectStringPK(transferWarehouseID));
                                                entry.setReceiptStock(transferWarehouseInfo);
                                            }
                                        } else {
                                            entry.setIsStockAllot(rs.getBoolean("FIsStockAllot"));
                                            receiptStroageOrgUnit = new StorageOrgUnitInfo();
                                            transferOrgUnitID = rs.getString("FMFromInvOrgID");
                                            if (!StringUtil.isEmpty((String)transferOrgUnitID)) {
                                                receiptStroageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectStringPK(transferOrgUnitID));
                                                entry.setReceiptStroageOrgUnit(receiptStroageOrgUnit);
                                            }
                                            transferWarehouseInfo = new WarehouseInfo();
                                            transferWarehouseID = rs.getString("FMFromWarehouseID");
                                            if (!StringUtil.isEmpty((String)transferWarehouseID)) {
                                                transferWarehouseInfo = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectStringPK(transferWarehouseID));
                                                entry.setReceiptStock(transferWarehouseInfo);
                                            }
                                        }
                                        if (!entry.isIsStockAllot() || entry.getReceiptStroageOrgUnit() == null) break block51;
                                        StorageOrgUnitInfo issueStorageOrgUnit = entry.getReceiptStroageOrgUnit();
                                        if (storageOrgUnit.getId().toString().equals(issueStorageOrgUnit.getId().toString())) {
                                            entry.setTransferType(OrderStockTransferTypeEnum.WAREHOUSE);
                                            break block47;
                                        } else {
                                            OrgUnitCollection issueCompanyOrgCol = iUnitRel.getToUnit(issueStorageOrgUnit.getId().toString(), 4, 1);
                                            CompanyOrgUnitInfo issueCompanyOrgUnit = (CompanyOrgUnitInfo)issueCompanyOrgCol.get(0);
                                            if (receiptCompanyOrgUnit != null && issueCompanyOrgUnit != null && receiptCompanyOrgUnit.getId().toString().equals(issueCompanyOrgUnit.getId().toString())) {
                                                entry.setTransferType(OrderStockTransferTypeEnum.STORAGE);
                                                break block47;
                                            } else {
                                                entry.setTransferType(OrderStockTransferTypeEnum.FINANCE);
                                            }
                                        }
                                        break block47;
                                    }
                                    entry.setTransferType(OrderStockTransferTypeEnum.NULL);
                                }
                                entry.setIssueMode(MaterialIssueModeEnum.getEnum((int)rs.getInt("FIssMode")));
                                entry.setIsBackflush(rs.getBoolean("FIsBackflush"));
                                warehouseInfo = new WarehouseInfo();
                                String defaultWarehouseID = rs.getString("FDefaultWarehouseID");
                                if (defaultWarehouseID != null && defaultWarehouseID.length() > 0) {
                                    warehouseInfo = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectStringPK(defaultWarehouseID));
                                    entry.setWarehouse(warehouseInfo);
                                }
                                if (entry.getProvideType() != MaterialProvideTypeEnum.CURRENTORGPROVIDE && entry.getProvideType() != MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE || entry.getIssueMode() != MaterialIssueModeEnum.PRODUCEISSMODE) break block52;
                                entry.setPickType(PickTypeEnum.INNERORG);
                                break block48;
                            }
                            if (entry.getProvideType() != MaterialProvideTypeEnum.SPANORGPROVIDE) break block53;
                            OrgUnitCollection issueOrgCol = iUnitRel.getToUnit(supplyStorageOrgUnitInfo.getId().toString(), 4, 1);
                            CompanyOrgUnitInfo issueCompanyOrgUnit = (CompanyOrgUnitInfo)issueOrgCol.get(0);
                            if (receiptCompanyOrgUnit == null || issueCompanyOrgUnit == null || receiptCompanyOrgUnit.getId() == null || issueCompanyOrgUnit.getId() == null) {
                                entry.setPickType(PickTypeEnum.OTHERCOMPANY);
                                break block48;
                            } else if (receiptCompanyOrgUnit.getId().toString().equals(issueCompanyOrgUnit.getId().toString())) {
                                entry.setPickType(PickTypeEnum.OTHERSTORAGE);
                                break block48;
                            } else {
                                entry.setPickType(PickTypeEnum.OTHERCOMPANY);
                            }
                            break block48;
                        }
                        entry.setPickType(PickTypeEnum.NULL);
                    }
                    if (rs.getTimestamp("FDemandTime") != null) {
                        entry.setDemandTime(rs.getTimestamp("FDemandTime"));
                    } else {
                        entry.setDemandTime(beginDate);
                    }
                    entry.setBomEntryID(rs.getString("FBomEntryID"));
                    material = new MaterialInfo();
                    material.setId(BOSUuid.read((String)rs.getString("fmaterialid")));
                    material.setName(rs.getString("fmaterialname"));
                    material.setNumber(rs.getString("fmaterialnumber"));
                    material.setModel(rs.getString("fmodel"));
                    entry.setMaterial(material);
                    entry.setNewnetWeight(rs.getBigDecimal("FNETWEIGHT"));
                    entry.setBlkSize(rs.getString("FBlkSize"));
                    entry.setSpecifiedLength(rs.getString("FSpecifiedLength"));
                    MaterialPlanInfo materialPlan = new MaterialPlanInfo();
                    materialPlan.setIsStockAllot(rs.getBoolean("FIsStockAllot"));
                    WarehouseInfo fromWareHouse = null;
                    if (rs.getString("fwhid3") != null) {
                        fromWareHouse = new WarehouseInfo();
                        fromWareHouse.setId(BOSUuid.read((String)rs.getString("fwhid3")));
                        fromWareHouse.setName(rs.getString("fwhname3"));
                        fromWareHouse.setNumber(rs.getString("fwhnumber3"));
                    }
                    materialPlan.setFromWarehouse(fromWareHouse);
                    StorageOrgUnitInfo fromInvOrg = null;
                    if (rs.getString("forgid1") != null) {
                        fromInvOrg = new StorageOrgUnitInfo();
                        fromInvOrg.setId(BOSUuid.read((String)rs.getString("forgid1")));
                        fromInvOrg.setName(rs.getString("forgname1"));
                        fromInvOrg.setNumber(rs.getString("forgnumber1"));
                    }
                    materialPlan.setFromInvOrg(fromInvOrg);
                    MeasureUnitInfo unit = new MeasureUnitInfo();
                    unit.setId(BOSUuid.read((String)rs.getString("funitid")));
                    unit.setName(rs.getString("funitname"));
                    unit.setNumber(rs.getString("funitnumber"));
                    entry.setUnit(unit);
                    MeasureUnitInfo baseunit = new MeasureUnitInfo();
                    baseunit.setId(BOSUuid.read((String)rs.getString("fbaseunitid")));
                    entry.setBaseUnit(baseunit);
                    int prec = rs.getInt("fPrec");
                    if (reCalc) {
                        BigDecimal unitQty = rs.getBigDecimal("funitQty").multiply(convertRate).setScale(8, 4);
                        entry.setUnitQty(unitQty);
                        BigDecimal lossRatio = rs.getBigDecimal("fscrapRate").multiply(new BigDecimal("100.00")).setScale(2, 4);
                        entry.setLossRatio(lossRatio);
                        BigDecimal qty = unitQty.multiply(bill_qty).setScale(prec, 2);
                        entry.setQty(qty);
                        BigDecimal planedQty = qty;
                        planedQty = rs.getInt("FScrapRateExpression") == 10610 ? qty.divide(new BigDecimal("1.0").subtract(rs.getBigDecimal("fscrapRate")), prec, 2) : qty.multiply(new BigDecimal("1.0").add(rs.getBigDecimal("fscrapRate"))).setScale(prec, 2);
                        entry.setPlannedQty(planedQty);
                        entry.setTotalReceiptQty(SCMConstant.BIGDECIMAL_ZERO);
                        entry.setUnReceiptQty(planedQty);
                        entry.setLossQty(planedQty.subtract(qty));
                    } else {
                        entry.setUnitQty(rs.getBigDecimal("funitQty"));
                        entry.setQty(rs.getBigDecimal("fQty").setScale(prec, 2));
                        entry.setPlannedQty(rs.getBigDecimal("fPlannedQty").setScale(prec, 2));
                        entry.setLossQty(rs.getBigDecimal("fscrapQty").setScale(prec, 4));
                        entry.setLossRatio(rs.getBigDecimal("fscrapRate"));
                        entry.setUnReceiptQty(NumericUtil.emptyToZero((Object)entry.getPlannedQty()));
                    }
                    entry.setOriginalPlanQty(entry.getPlannedQty());
                    entry.setScrapExpr(rs.getInt("FScrapRateExpression"));
                    entry.setIsQtyLimit(rs.getBoolean("FIsQuotaControl"));
                    if (rs.getBoolean("FIsQuotaControl")) {
                        entry.setExtraRatio(rs.getBigDecimal("FIssInHightLimit") == null ? BigDecimal.ZERO : rs.getBigDecimal("FIssInHightLimit"));
                        entry.setLackRatio(rs.getBigDecimal("FIssInLowLimit") == null ? BigDecimal.ZERO : rs.getBigDecimal("FIssInLowLimit"));
                    } else {
                        entry.setExtraRatio(new BigDecimal("0.0"));
                        entry.setLackRatio(new BigDecimal("0.0"));
                    }
                    entry.setAssyLocation(rs.getString("FBlueprint"));
                    LocationInfo locInfo = null;
                    if (warehouseInfo != null) {
                        String locationId = rs.getString("flocationid");
                        if (!StringUtils.isEmpty((String)locationId)) {
                            locInfo = new LocationInfo();
                            locInfo.setId(BOSUuid.read((String)locationId));
                            locInfo.setName(rs.getString("flocationname"));
                            locInfo.setNumber(rs.getString("flocationnumber"));
                        } else {
                            if (rs.getBoolean("FIsBackflush") && transInfo != null && transInfo.getDefaultBFLocation() != null && transInfo.getDefaultBFWarehouse().equals((Object)warehouseInfo)) {
                                locInfo = transInfo.getDefaultBFLocation();
                            }
                            if (locInfo == null && warehouseInfo.isHasLocation()) {
                                materialLst.add(rs.getString("fmaterialid"));
                                warehouseLst.add(warehouseInfo.getId().toString());
                            }
                        }
                    }
                    entry.setLocation(locInfo);
                    if (rs.getObject("FWpSeq") != null) {
                        entry.setOperationNo(rs.getInt("FWpSeq"));
                        entry.put("FOriginalWPSeq", (Object)rs.getInt("FWpSeq"));
                    } else if (entry.getBomEntryID() != null && inParam.get(entry.getBomEntryID()) != null) {
                        Object[] opo = (Object[])inParam.get(entry.getBomEntryID());
                        Integer operationNo = (Integer)opo[0];
                        OperationInfo opInfo = (OperationInfo)opo[1];
                        entry.setOperationNo(operationNo.intValue());
                        entry.setOperation(opInfo);
                        entry.put("FOriginalWPSeq", (Object)operationNo);
                    } else {
                        entry.setOperationNo(firstWP);
                        entry.put("FOriginalWPSeq", (Object)firstWP);
                    }
                    BigDecimal zero = SCMConstant.BIGDECIMAL_ZERO;
                    entry.setActIssueQty(zero);
                    entry.setActLossQty(zero);
                    entry.setActureLossRatio(zero);
                    entry.setRejectedQty(zero);
                    entry.setFeedingQty(zero);
                    entry.setMaterialFeedingQty(zero);
                    entry.setScrapQty(zero);
                    entry.setMaterialScrapQty(zero);
                    entry.setWipQty(zero);
                    entry.setTotalDirectReceiveQty(zero);
                    entry.setTotalReceiptBaseQty(zero);
                    entry.setReplaceRatio(SysConstant.BIGZERO);
                    entry.setUnitReplaceQty(SysConstant.BIGZERO);
                    entry.setMatReplaceType(MaterialReplaceTypeEnum.NONE);
                    entry.setIsReplaced(false);
                    entry.put("islineStorehouse", (Object)rs.getInt("FIsLineStoreHouse"));
                    entry.setLineSeq(Integer.toString(++lineSeq * 10));
                    entry.setReplaceGroupFlag(0);
                    stockCol.add(entry);
                }
                HashMap<String, Object> inParam1 = new HashMap<String, Object>();
                inParam1.put("STORAGEORGID", storageOrgUnit.getId().toString());
                inParam1.put("MATERIALIDS", materialLst.toArray());
                inParam1.put("WAREHOUSEIDS", warehouseLst.toArray());
                if (materialLst.size() <= 0) break block49;
                Map retMap = EMMManufactureOrderEXCTL._getDefaultLocation(ctx, inParam1);
                Map locationMap = (Map)retMap.get("location");
                if (locationMap != null && locationMap.size() > 0) {
                    LocationInfo locInfo = null;
                    for (int i = 0; i < stockCol.size(); ++i) {
                        material = stockCol.get(i).getMaterial();
                        WarehouseInfo warehouse = stockCol.get(i).getWarehouse();
                        if (material == null || warehouse == null) continue;
                        String key = material.getId().toString() + warehouse.getId().toString();
                        locInfo = (LocationInfo)locationMap.get(key);
                        stockCol.get(i).setLocation(locInfo);
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        EMMManufactureOrderEXCTL.setBaseUnitQtyForStock(ctx, stockCol);
        return stockCol;
    }

    public static ManufactureOrderStockCollection buildStock(Context ctx, Map inParam) throws BOSException, EASBizException {
        String locStr = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String tableName = (String)inParam.get("TABLENAME");
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)inParam.get("STORAGEORG");
        Timestamp beginDate = (Timestamp)inParam.get("BEGINTIME");
        ProductTransactionTypeInfo transInfo = (ProductTransactionTypeInfo)inParam.get("TRANSTYPE");
        boolean reCalc = true;
        if (inParam.get("RECALC") != null) {
            reCalc = (Boolean)inParam.get("RECALC");
        }
        BigDecimal bill_qty = null;
        BigDecimal convertRate = null;
        if (reCalc) {
            bill_qty = (BigDecimal)inParam.get("BILL_QTY");
            convertRate = EMMManufactureOrderEXCTL.calcCconvertRate(ctx, inParam);
        }
        Map operMap = new HashMap();
        if (inParam.get("OPERMAP") != null) {
            operMap = (Map)inParam.get("OPERMAP");
        }
        ManufactureOrderStockCollection stockCol = new ManufactureOrderStockCollection();
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("select t0.*, ").append("t1.fnumber fmaterialnumber,t1.fname_").append(locStr).append(" fmaterialname,fmodel,").append("t2.fnumber funitnumber,t2.fname_").append(locStr).append(" funitname, ").append("t5.fid fwhid1,t5.fnumber fwhnumber1,t5.FHasLocation FHasLocation1,t5.fname_").append(locStr).append(" fwhname1, ").append("t4.fid fwhid2,t4.fnumber fwhnumber2,t4.FHasLocation FHasLocation2,t4.fname_").append(locStr).append(" fwhname2, ").append("t6.FWpSeq, ").append("t0.FNETWEIGHT FNETWEIGHT,t0.FBlkSize FBlkSize,t0.FSpecifiedLength FSpecifiedLength, ").append("t8.fid fwhid3,t8.fnumber fwhnumber3,t8.fname_").append(locStr).append(" fwhname3, ").append("t9.fid forgid1,t9.fnumber forgnumber1,t9.fname_").append(locStr).append(" forgname1, ").append("t7.FIsStockAllot FIsStockAllot, location.fid flocationid,location.fname_").append(locStr).append(" flocationname, ").append("location.fnumber flocationnumber ").append(", be.FProvideType as FBProvideType, t7.FProvideType as FMProvideType ").append(", be.FSupplyStorageOrgUnitID as FBSupplyStorageOrgUnitID, t7.FSupplyOrgUnit as FMSupplyOrgUnit ").append(", be.FIsStockTransfer FIsStockTransfer ").append(", be.FTransferOrgUnitID FTransferOrgUnitID, t7.FFromInvOrgID as FMFromInvOrgID ").append(", be.FTransferWarehouseID FTransferWarehouseID, t7.FFromWarehouseID as FMFromWarehouseID").append(", be.FDefaultWarehouseID FDefaultWarehouseID ").append(" from ").append(tableName).append(" t0 ").append("inner join t_bd_material t1 on t0.fmaterialid = t1.fid ").append("inner join T_BD_MeasureUnit t2 on t0.funitid = t2.fid ").append("left outer join T_MM_MaterialRWP t6 on t0.FRoutingItemID = t6.FID ").append("left outer join t_bd_materialinventory t3 ").append("on t0.fmaterialid = t3.fmaterialid and t3.FOrgUnit = '").append(storageOrgUnit.getId().toString()).append("' ").append("left outer join T_BD_MaterialPlan t7 on t0.fmaterialid = t7.fmaterialid and t7.FOrgUnit = '").append(storageOrgUnit.getId().toString()).append("' ").append("left outer join T_db_WAREHOUSE t8 on t8.fid = t7.FFromWarehouseID ").append("left outer join T_ORG_Storage t9 on t9.fid = t7.FFromInvOrgID ").append("left outer join T_db_WAREHOUSE t4 on t4.fid = t3.FDefaultWarehouseID ").append("left outer join T_db_WAREHOUSE t5 on t5.fid = t0.FBOMDefWarehouseID ").append("left outer join T_mm_bomentry be on be.fid = t0.FBOMEntryID ").append("left outer join T_DB_LOCATION location on location.fid = t0.FLocationID ").append("where t0.FMaterialAttr <> 10020");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
        try {
            Map retMap;
            Map locationMap;
            int firstWP = 1;
            if (inParam.get("ROUTINGID") != null) {
                sqlBuf.setLength(0);
                sqlBuf.append("select t1.FFirstWP ").append("from T_MM_StandardRooting t0,T_MM_MaterialRooting t1 ").append("where t0.FMaterialRootingID = t1.FID ").append("and t0.FID = ?");
                IRowSet rsFirstWP = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString(), (Object[])new Object[]{inParam.get("ROUTINGID")});
                if (rsFirstWP.next()) {
                    firstWP = rsFirstWP.getInt("FFirstWP");
                }
            }
            ArrayList<String> materialLst = new ArrayList<String>();
            ArrayList<String> warehouseLst = new ArrayList<String>();
            Object isAfreshExtendObject = inParam.get("isAfreshExtend");
            int lineSeq = 0;
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection receiptCompanyOrgCol = iUnitRel.getToUnit(storageOrgUnit.getId().toString(), 4, 1);
            CompanyOrgUnitInfo receiptCompanyOrgUnit = (CompanyOrgUnitInfo)receiptCompanyOrgCol.get(0);
            while (rs.next()) {
                String transferWarehouseID;
                WarehouseInfo transferWarehouseInfo;
                String transferOrgUnitID;
                StorageOrgUnitInfo receiptStroageOrgUnit;
                ManufactureOrderStockInfo entry = new ManufactureOrderStockInfo();
                String bomEntryId = rs.getString("FBomEntryID");
                String supplyStorageOrgUnitId = null;
                if (isAfreshExtendObject != null) {
                    if (((Boolean)isAfreshExtendObject).booleanValue()) {
                        if (!StringUtil.isEmpty((String)bomEntryId)) {
                            entry.setProvideType(MaterialProvideTypeEnum.getEnum((int)rs.getInt("FBProvideType")));
                            supplyStorageOrgUnitId = rs.getString("FBSupplyStorageOrgUnitID");
                        } else {
                            entry.setProvideType(MaterialProvideTypeEnum.getEnum((int)rs.getInt("FMProvideType")));
                            supplyStorageOrgUnitId = rs.getString("FMSupplyOrgUnit");
                        }
                    } else {
                        entry.setProvideType(MaterialProvideTypeEnum.getEnum((int)rs.getInt("FProvideType")));
                        supplyStorageOrgUnitId = rs.getString("FSupplyStorageId");
                    }
                } else {
                    entry.setProvideType(MaterialProvideTypeEnum.getEnum((int)rs.getInt("FBProvideType")));
                    supplyStorageOrgUnitId = rs.getString("FBSupplyStorageOrgUnitID");
                }
                StorageOrgUnitInfo supplyStorageOrgUnitInfo = new StorageOrgUnitInfo();
                if (supplyStorageOrgUnitId != null && supplyStorageOrgUnitId.length() > 0) {
                    supplyStorageOrgUnitInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectStringPK(supplyStorageOrgUnitId));
                }
                entry.setStorageOrgUnit(supplyStorageOrgUnitInfo);
                if (!StringUtil.isEmpty((String)bomEntryId)) {
                    entry.setIsStockAllot(rs.getBoolean("FIsStockTransfer"));
                    receiptStroageOrgUnit = new StorageOrgUnitInfo();
                    transferOrgUnitID = rs.getString("FTransferOrgUnitID");
                    if (!StringUtil.isEmpty((String)transferOrgUnitID)) {
                        receiptStroageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectStringPK(transferOrgUnitID));
                        entry.setReceiptStroageOrgUnit(receiptStroageOrgUnit);
                    }
                    transferWarehouseInfo = new WarehouseInfo();
                    transferWarehouseID = rs.getString("FTransferWarehouseID");
                    if (!StringUtil.isEmpty((String)transferWarehouseID)) {
                        transferWarehouseInfo = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectStringPK(transferWarehouseID));
                        entry.setReceiptStock(transferWarehouseInfo);
                    }
                } else {
                    entry.setIsStockAllot(rs.getBoolean("FIsStockAllot"));
                    receiptStroageOrgUnit = new StorageOrgUnitInfo();
                    transferOrgUnitID = rs.getString("FMFromInvOrgID");
                    if (!StringUtil.isEmpty((String)transferOrgUnitID)) {
                        receiptStroageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectStringPK(transferOrgUnitID));
                        entry.setReceiptStroageOrgUnit(receiptStroageOrgUnit);
                    }
                    transferWarehouseInfo = new WarehouseInfo();
                    transferWarehouseID = rs.getString("FMFromWarehouseID");
                    if (!StringUtil.isEmpty((String)transferWarehouseID)) {
                        transferWarehouseInfo = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectStringPK(transferWarehouseID));
                        entry.setReceiptStock(transferWarehouseInfo);
                    }
                }
                if (entry.isIsStockAllot() && entry.getReceiptStroageOrgUnit() != null) {
                    StorageOrgUnitInfo issueStorageOrgUnit = entry.getReceiptStroageOrgUnit();
                    if (storageOrgUnit.getId().toString().equals(issueStorageOrgUnit.getId().toString())) {
                        entry.setTransferType(OrderStockTransferTypeEnum.WAREHOUSE);
                    } else {
                        OrgUnitCollection issueCompanyOrgCol = iUnitRel.getToUnit(issueStorageOrgUnit.getId().toString(), 4, 1);
                        CompanyOrgUnitInfo issueCompanyOrgUnit = (CompanyOrgUnitInfo)issueCompanyOrgCol.get(0);
                        if (receiptCompanyOrgUnit != null && issueCompanyOrgUnit != null && receiptCompanyOrgUnit.getId().toString().equals(issueCompanyOrgUnit.getId().toString())) {
                            entry.setTransferType(OrderStockTransferTypeEnum.STORAGE);
                        } else {
                            entry.setTransferType(OrderStockTransferTypeEnum.FINANCE);
                        }
                    }
                } else {
                    entry.setTransferType(OrderStockTransferTypeEnum.NULL);
                }
                entry.setIssueMode(MaterialIssueModeEnum.getEnum((int)rs.getInt("FIssMode")));
                entry.setIsBackflush(rs.getBoolean("FIsBackflush"));
                WarehouseInfo warehouseInfo = new WarehouseInfo();
                String defaultWarehouseID = rs.getString("FDefaultWarehouseID");
                if (defaultWarehouseID != null && defaultWarehouseID.length() > 0) {
                    warehouseInfo = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectStringPK(defaultWarehouseID));
                    entry.setWarehouse(warehouseInfo);
                }
                if ((entry.getProvideType() == MaterialProvideTypeEnum.CURRENTORGPROVIDE || entry.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) && entry.getIssueMode() == MaterialIssueModeEnum.PRODUCEISSMODE) {
                    entry.setPickType(PickTypeEnum.INNERORG);
                } else if (entry.getProvideType() == MaterialProvideTypeEnum.SPANORGPROVIDE) {
                    OrgUnitCollection issueOrgCol = iUnitRel.getToUnit(supplyStorageOrgUnitInfo.getId().toString(), 4, 1);
                    CompanyOrgUnitInfo issueCompanyOrgUnit = (CompanyOrgUnitInfo)issueOrgCol.get(0);
                    if (receiptCompanyOrgUnit.getId().toString().equals(issueCompanyOrgUnit.getId().toString())) {
                        entry.setPickType(PickTypeEnum.OTHERSTORAGE);
                    } else {
                        entry.setPickType(PickTypeEnum.OTHERCOMPANY);
                    }
                } else {
                    entry.setPickType(PickTypeEnum.NULL);
                }
                if (rs.getTimestamp("FDemandTime") != null) {
                    entry.setDemandTime(rs.getTimestamp("FDemandTime"));
                } else {
                    entry.setDemandTime(beginDate);
                }
                entry.setBomEntryID(rs.getString("FBomEntryID"));
                MaterialInfo material = new MaterialInfo();
                material.setId(BOSUuid.read((String)rs.getString("fmaterialid")));
                material.setName(rs.getString("fmaterialname"));
                material.setNumber(rs.getString("fmaterialnumber"));
                material.setModel(rs.getString("fmodel"));
                entry.setMaterial(material);
                entry.setNewnetWeight(rs.getBigDecimal("FNETWEIGHT"));
                entry.setBlkSize(rs.getString("FBlkSize"));
                entry.setSpecifiedLength(rs.getString("FSpecifiedLength"));
                MaterialPlanInfo materialPlan = new MaterialPlanInfo();
                materialPlan.setIsStockAllot(rs.getBoolean("FIsStockAllot"));
                WarehouseInfo fromWareHouse = null;
                if (rs.getString("fwhid3") != null) {
                    fromWareHouse = new WarehouseInfo();
                    fromWareHouse.setId(BOSUuid.read((String)rs.getString("fwhid3")));
                    fromWareHouse.setName(rs.getString("fwhname3"));
                    fromWareHouse.setNumber(rs.getString("fwhnumber3"));
                }
                materialPlan.setFromWarehouse(fromWareHouse);
                StorageOrgUnitInfo fromInvOrg = null;
                if (rs.getString("forgid1") != null) {
                    fromInvOrg = new StorageOrgUnitInfo();
                    fromInvOrg.setId(BOSUuid.read((String)rs.getString("forgid1")));
                    fromInvOrg.setName(rs.getString("forgname1"));
                    fromInvOrg.setNumber(rs.getString("forgnumber1"));
                }
                materialPlan.setFromInvOrg(fromInvOrg);
                MeasureUnitInfo unit = new MeasureUnitInfo();
                unit.setId(BOSUuid.read((String)rs.getString("funitid")));
                unit.setName(rs.getString("funitname"));
                unit.setNumber(rs.getString("funitnumber"));
                entry.setUnit(unit);
                MeasureUnitInfo baseunit = new MeasureUnitInfo();
                baseunit.setId(BOSUuid.read((String)rs.getString("fbaseunitid")));
                entry.setBaseUnit(baseunit);
                int prec = rs.getInt("fPrec");
                if (reCalc) {
                    BigDecimal unitQty = rs.getBigDecimal("funitQty").multiply(convertRate).setScale(8, 4);
                    entry.setUnitQty(unitQty);
                    BigDecimal lossRatio = rs.getBigDecimal("fscrapRate").multiply(new BigDecimal("100.00")).setScale(2, 4);
                    entry.setLossRatio(lossRatio);
                    BigDecimal qty = unitQty.multiply(bill_qty).setScale(prec, 2);
                    entry.setQty(qty);
                    BigDecimal planedQty = qty;
                    planedQty = rs.getInt("FScrapRateExpression") == 10610 ? qty.divide(new BigDecimal("1.0").subtract(rs.getBigDecimal("fscrapRate")), prec, 2) : qty.multiply(new BigDecimal("1.0").add(rs.getBigDecimal("fscrapRate"))).setScale(prec, 2);
                    entry.setPlannedQty(planedQty);
                    entry.setTotalReceiptQty(SCMConstant.BIGDECIMAL_ZERO);
                    entry.setUnReceiptQty(planedQty);
                    entry.setLossQty(planedQty.subtract(qty));
                } else {
                    entry.setUnitQty(rs.getBigDecimal("funitQty"));
                    entry.setQty(rs.getBigDecimal("fQty").setScale(prec, 2));
                    entry.setPlannedQty(rs.getBigDecimal("fPlannedQty").setScale(prec, 2));
                    entry.setLossQty(rs.getBigDecimal("fscrapQty").setScale(prec, 4));
                    entry.setLossRatio(rs.getBigDecimal("fscrapRate"));
                    entry.setUnReceiptQty(NumericUtil.emptyToZero((Object)entry.getPlannedQty()));
                }
                entry.setOriginalPlanQty(entry.getPlannedQty());
                entry.setScrapExpr(rs.getInt("FScrapRateExpression"));
                entry.setIsQtyLimit(rs.getBoolean("FIsQuotaControl"));
                if (rs.getBoolean("FIsQuotaControl")) {
                    entry.setExtraRatio(rs.getBigDecimal("FIssInHightLimit"));
                    entry.setLackRatio(rs.getBigDecimal("FIssInLowLimit"));
                } else {
                    entry.setExtraRatio(new BigDecimal("0.0"));
                    entry.setLackRatio(new BigDecimal("0.0"));
                }
                entry.setAssyLocation(rs.getString("FBlueprint"));
                LocationInfo locInfo = null;
                if (warehouseInfo != null) {
                    String locationId = rs.getString("flocationid");
                    if (!StringUtils.isEmpty((String)locationId)) {
                        locInfo = new LocationInfo();
                        locInfo.setId(BOSUuid.read((String)locationId));
                        locInfo.setName(rs.getString("flocationname"));
                        locInfo.setNumber(rs.getString("flocationnumber"));
                    } else {
                        if (rs.getBoolean("FIsBackflush") && transInfo != null && transInfo.getDefaultBFLocation() != null && transInfo.getDefaultBFWarehouse().equals((Object)warehouseInfo)) {
                            locInfo = transInfo.getDefaultBFLocation();
                        }
                        if (locInfo == null && warehouseInfo.isHasLocation()) {
                            materialLst.add(rs.getString("fmaterialid"));
                            warehouseLst.add(warehouseInfo.getId().toString());
                        }
                    }
                }
                entry.setLocation(locInfo);
                if (rs.getObject("FWpSeq") != null) {
                    entry.setOperationNo(rs.getInt("FWpSeq"));
                } else if (entry.getBomEntryID() != null && inParam.get(entry.getBomEntryID()) != null) {
                    Object[] opo = (Object[])inParam.get(entry.getBomEntryID());
                    Integer operationNo = (Integer)opo[0];
                    OperationInfo opInfo = (OperationInfo)opo[1];
                    entry.setOperationNo(operationNo.intValue());
                    entry.setOperation(opInfo);
                } else {
                    entry.setOperationNo(firstWP);
                }
                BigDecimal zero = SCMConstant.BIGDECIMAL_ZERO;
                entry.setActIssueQty(zero);
                entry.setActLossQty(zero);
                entry.setActureLossRatio(zero);
                entry.setRejectedQty(zero);
                entry.setFeedingQty(zero);
                entry.setMaterialFeedingQty(zero);
                entry.setScrapQty(zero);
                entry.setMaterialScrapQty(zero);
                entry.setWipQty(zero);
                entry.setTotalDirectReceiveQty(zero);
                entry.setTotalReceiptBaseQty(zero);
                entry.setReplaceRatio(SysConstant.BIGZERO);
                entry.setUnitReplaceQty(SysConstant.BIGZERO);
                entry.setMatReplaceType(MaterialReplaceTypeEnum.NONE);
                entry.setIsReplaced(false);
                entry.setLineSeq(Integer.toString(++lineSeq * 10));
                entry.setReplaceGroupFlag(0);
                stockCol.add(entry);
            }
            HashMap<String, Object> inParam1 = new HashMap<String, Object>();
            inParam1.put("STORAGEORGID", storageOrgUnit.getId().toString());
            inParam1.put("MATERIALIDS", materialLst.toArray());
            inParam1.put("WAREHOUSEIDS", warehouseLst.toArray());
            if (materialLst.size() > 0 && (locationMap = (Map)(retMap = EMMManufactureOrderEXCTL._getDefaultLocation(ctx, inParam1)).get("location")) != null && locationMap.size() > 0) {
                LocationInfo locInfo = null;
                for (int i = 0; i < stockCol.size(); ++i) {
                    MaterialInfo material = stockCol.get(i).getMaterial();
                    WarehouseInfo warehouse = stockCol.get(i).getWarehouse();
                    if (material == null || warehouse == null) continue;
                    String key = material.getId().toString() + warehouse.getId().toString();
                    locInfo = (LocationInfo)locationMap.get(key);
                    stockCol.get(i).setLocation(locInfo);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        EMMManufactureOrderEXCTL.setBaseUnitQtyForStock(ctx, stockCol);
        return stockCol;
    }

    protected static Map _getDefaultLocation(Context ctx, Map inParam) throws BOSException, EASBizException {
        String storageOrgID = (String)inParam.get("STORAGEORGID");
        Object[] materialIDs = (Object[])inParam.get("MATERIALIDS");
        Object[] warehouseIDs = (Object[])inParam.get("WAREHOUSEIDS");
        HashMap retParam = new HashMap();
        HashMap<String, LocationInfo> locMap = new HashMap<String, LocationInfo>();
        Map wareMap = new HashMap();
        if (storageOrgID == null || materialIDs == null || warehouseIDs == null || materialIDs.length != warehouseIDs.length) {
            return retParam;
        }
        wareMap = EMMManufactureOrderEXCTL.getWarehouse(ctx, warehouseIDs);
        StringBuffer sql = new StringBuffer();
        sql.append("select t0.FMaterialID,t0.FWarehouseID,t1.fid,t1.fnumber,t1.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" fname ").append("  from T_DB_MaterialStorageAssign t0,T_DB_LOCATION t1 ").append("where t1.fid = t0.FLocationID ").append("and t0.FStorageOrgID = '").append(storageOrgID).append("' ").append("and (");
        String conStr = "";
        for (int i = 0; i < materialIDs.length; ++i) {
            sql.append(conStr).append("(t0.FMaterialID = '").append(materialIDs[i].toString()).append("' ").append("and t0.FWarehouseID = '").append(warehouseIDs[i].toString()).append("' ").append("and t0.FIsDefaultLocation = 1)");
            conStr = " or ";
        }
        sql.append(") ");
        IRowSet rsLoc = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rsLoc.next()) {
                LocationInfo locInfo = new LocationInfo();
                locInfo.setId(BOSUuid.read((String)rsLoc.getString("fid")));
                locInfo.setNumber(rsLoc.getString("fnumber"));
                locInfo.setName(rsLoc.getString("fname"));
                String key = rsLoc.getString("FMaterialID") + rsLoc.getString("FWarehouseID");
                locMap.put(key, locInfo);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        retParam.put("location", locMap);
        retParam.put("warehouse", wareMap);
        return retParam;
    }

    private static Map getWarehouse(Context ctx, Object[] warehouseIDs) throws BOSException, EASBizException {
        HashMap<String, WarehouseInfo> warehouse = new HashMap<String, WarehouseInfo>();
        String ids = "'null'";
        for (int i = 0; i < warehouseIDs.length; ++i) {
            ids = ids + " , '" + warehouseIDs[i].toString() + "'";
        }
        WarehouseCollection warehouseCollection = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(" where id in (" + ids + ")");
        for (WarehouseInfo wInfo : warehouseCollection) {
            String key = wInfo.getId().toString();
            warehouse.put(key, wInfo);
        }
        return warehouse;
    }

    protected static BigDecimal calcCconvertRatePIEx(Context ctx, Map inParam) throws BOSException, EASBizException {
        BigDecimal convertRate = new BigDecimal("1.00");
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)inParam.get("STORAGEORG");
        MaterialInfo parentMaterial = (MaterialInfo)inParam.get("MATERIAL");
        MeasureUnitInfo billUnit = (MeasureUnitInfo)inParam.get("BILL_UNIT");
        String prodUnitID = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FProductUnitID from t_bd_materialplan where fmaterialid = ? and forgunit = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{parentMaterial.getId().toString(), storageOrgUnit.getId().toString()});
        try {
            if (rs.next()) {
                prodUnitID = rs.getString("FProductUnitID");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (!prodUnitID.equals(billUnit.getId().toString())) {
            BigDecimal billunit_ConRate = null;
            BigDecimal produnit_ConRate = null;
            sql.setLength(0);
            sql.append("select FBaseConvsRate,FQtyPrecision,FMeasureUnitID ").append("from T_BD_MultiMeasureUnit ").append("where fmaterialid = ? and (FMeasureUnitID = ? or FMeasureUnitID = ?)");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{parentMaterial.getId().toString(), billUnit.getId().toString(), prodUnitID});
            try {
                while (rs.next()) {
                    if (rs.getString("FMeasureUnitID").equals(prodUnitID)) {
                        produnit_ConRate = rs.getBigDecimal("FBaseConvsRate");
                        continue;
                    }
                    billunit_ConRate = rs.getBigDecimal("FBaseConvsRate");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (billunit_ConRate != null && produnit_ConRate != null) {
                convertRate = billunit_ConRate.divide(produnit_ConRate, 8, 4);
            }
        }
        return convertRate;
    }

    private static BigDecimal calcCconvertRate(Context ctx, Map inParam) throws BOSException, EASBizException {
        BigDecimal convertRate = new BigDecimal("1.00");
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)inParam.get("STORAGEORG");
        MaterialInfo parentMaterial = (MaterialInfo)inParam.get("MATERIAL");
        MeasureUnitInfo billUnit = (MeasureUnitInfo)inParam.get("BILL_UNIT");
        String prodUnitID = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FProductUnitID from t_bd_materialplan where fmaterialid = ? and forgunit = ?");
        Object isBOMChangeObject = inParam.get("IsBOMChange");
        if (isBOMChangeObject != null && ((Boolean)isBOMChangeObject).booleanValue() && inParam.get("BOMMaterial") != null) {
            MaterialInfo bomMaterial = (MaterialInfo)inParam.get("BOMMaterial");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{bomMaterial.getId().toString(), storageOrgUnit.getId().toString()});
            try {
                if (rs.next()) {
                    prodUnitID = rs.getString("FProductUnitID");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            convertRate = MOMultiMeasureUnitUtil.getConvertRate((Context)ctx, (String)parentMaterial.getId().toString(), (String)billUnit.getId().toString(), (String)bomMaterial.getId().toString(), (String)prodUnitID);
        } else {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{parentMaterial.getId().toString(), storageOrgUnit.getId().toString()});
            try {
                if (rs.next()) {
                    prodUnitID = rs.getString("FProductUnitID");
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            if (!prodUnitID.equals(billUnit.getId().toString())) {
                BigDecimal billunit_ConRate = null;
                BigDecimal produnit_ConRate = null;
                sql.setLength(0);
                sql.append("select FBaseConvsRate,FQtyPrecision,FMeasureUnitID ").append("from T_BD_MultiMeasureUnit ").append("where fmaterialid = ? and (FMeasureUnitID = ? or FMeasureUnitID = ?)");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{parentMaterial.getId().toString(), billUnit.getId().toString(), prodUnitID});
                try {
                    while (rs.next()) {
                        if (rs.getString("FMeasureUnitID").equals(prodUnitID)) {
                            produnit_ConRate = rs.getBigDecimal("FBaseConvsRate");
                            continue;
                        }
                        billunit_ConRate = rs.getBigDecimal("FBaseConvsRate");
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                if (billunit_ConRate != null && produnit_ConRate != null) {
                    convertRate = billunit_ConRate.divide(produnit_ConRate, 8, 4);
                }
            }
        }
        return convertRate;
    }

    protected static void setBaseUnitQtyForStockPIEx(Context ctx, ManufactureOrderStockCollection stockCol) throws BOSException {
        if (stockCol == null || stockCol.size() == 0) {
            return;
        }
        ManufactureOrderStockInfo stockInfo = null;
        HashSet<String> keySet = new HashSet<String>();
        String materialId = null;
        String unitId = null;
        String mmuKey = null;
        int filterIndex = 0;
        StringBuffer maskString = new StringBuffer();
        HashMap<String, MultiMeasureUnitInfo> mmuMap = new HashMap<String, MultiMeasureUnitInfo>();
        FilterInfo filter = new FilterInfo();
        int size = stockCol.size();
        for (int index = 0; index < size; ++index) {
            stockInfo = stockCol.get(index);
            materialId = stockInfo.getMaterial().getId().toString();
            unitId = stockInfo.getUnit().getId().toString();
            mmuKey = materialId + "!" + unitId;
            if (keySet.contains(mmuKey)) continue;
            filter.appendFilterItem("material", (Object)materialId);
            filter.appendFilterItem("measureUnit", (Object)unitId);
            keySet.add(mmuKey);
            if (filterIndex == 0) {
                maskString.append("(#").append(filterIndex++).append(" and #").append(filterIndex++).append(")");
                continue;
            }
            maskString.append(" or (#").append(filterIndex++).append(" and #").append(filterIndex++).append(")");
        }
        EntityViewInfo view = new EntityViewInfo();
        filter.setMaskString(maskString.toString());
        view.setFilter(filter);
        view.getSelector().add("material");
        view.getSelector().add("measureUnit");
        view.getSelector().add("baseConvsRate");
        view.getSelector().add("qtyPrecision");
        MultiMeasureUnitCollection mmuCol = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
        int size2 = mmuCol.size();
        for (int i = 0; i < size2; ++i) {
            MultiMeasureUnitInfo mmuInfo = mmuCol.get(i);
            mmuKey = mmuInfo.getMaterial().getId().toString() + "!" + mmuInfo.getMeasureUnit().getId().toString();
            mmuMap.put(mmuKey, mmuInfo);
        }
        int size3 = stockCol.size();
        for (int index = 0; index < size3; ++index) {
            stockInfo = stockCol.get(index);
            materialId = stockInfo.getMaterial().getId().toString();
            unitId = stockInfo.getUnit().getId().toString();
            mmuKey = materialId + "!" + unitId;
            MultiMeasureUnitInfo mmuInfo = (MultiMeasureUnitInfo)mmuMap.get(mmuKey);
            stockInfo.setUnitBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getUnitQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(mmuInfo.getQtyPrecision(), 4));
            stockInfo.setBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(mmuInfo.getQtyPrecision(), 4));
            stockInfo.setPlannedBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getPlannedQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(mmuInfo.getQtyPrecision(), 4));
            stockInfo.setLossBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getLossQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(mmuInfo.getQtyPrecision(), 4));
            stockInfo.setUnReceiptBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getUnReceiptQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(mmuInfo.getQtyPrecision(), 4));
        }
    }

    private static void setBaseUnitQtyForStock(Context ctx, ManufactureOrderStockCollection stockCol) throws BOSException {
        MultiMeasureUnitInfo mmuInfo;
        if (stockCol == null || stockCol.size() == 0) {
            return;
        }
        ManufactureOrderStockInfo stockInfo = null;
        HashSet<String> keySet = new HashSet<String>();
        String materialId = null;
        String unitId = null;
        String mmuKey = null;
        int filterIndex = 0;
        StringBuffer maskString = new StringBuffer();
        HashMap<String, MultiMeasureUnitInfo> mmuMap = new HashMap<String, MultiMeasureUnitInfo>();
        FilterInfo filter = new FilterInfo();
        int size = stockCol.size();
        for (int index = 0; index < size; ++index) {
            stockInfo = stockCol.get(index);
            materialId = stockInfo.getMaterial().getId().toString();
            unitId = stockInfo.getUnit().getId().toString();
            mmuKey = materialId + "!" + unitId;
            if (keySet.contains(mmuKey)) continue;
            filter.appendFilterItem("material", (Object)materialId);
            filter.appendFilterItem("measureUnit", (Object)unitId);
            keySet.add(mmuKey);
            if (filterIndex == 0) {
                maskString.append("(#").append(filterIndex++).append(" and #").append(filterIndex++).append(")");
                continue;
            }
            maskString.append(" or (#").append(filterIndex++).append(" and #").append(filterIndex++).append(")");
        }
        EntityViewInfo view = new EntityViewInfo();
        filter.setMaskString(maskString.toString());
        view.setFilter(filter);
        view.getSelector().add("material");
        view.getSelector().add("measureUnit");
        view.getSelector().add("baseConvsRate");
        view.getSelector().add("qtyPrecision");
        MultiMeasureUnitCollection mmuCol = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
        int size2 = mmuCol.size();
        for (int i = 0; i < size2; ++i) {
            mmuInfo = mmuCol.get(i);
            mmuKey = mmuInfo.getMaterial().getId().toString() + "!" + mmuInfo.getMeasureUnit().getId().toString();
            mmuMap.put(mmuKey, mmuInfo);
        }
        size2 = stockCol.size();
        for (int index = 0; index < size2; ++index) {
            stockInfo = stockCol.get(index);
            materialId = stockInfo.getMaterial().getId().toString();
            unitId = stockInfo.getUnit().getId().toString();
            mmuKey = materialId + "!" + unitId;
            mmuInfo = (MultiMeasureUnitInfo)mmuMap.get(mmuKey);
            if (stockInfo.getUnitQty().scale() > mmuInfo.getQtyPrecision()) {
                stockInfo.setUnitBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getUnitQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(stockInfo.getUnitQty().scale(), 4));
            } else {
                stockInfo.setUnitBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getUnitQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(mmuInfo.getQtyPrecision(), 4));
            }
            stockInfo.setBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(mmuInfo.getQtyPrecision(), 4));
            stockInfo.setPlannedBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getPlannedQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(mmuInfo.getQtyPrecision(), 4));
            stockInfo.setLossBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getLossQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(mmuInfo.getQtyPrecision(), 4));
            stockInfo.setUnReceiptBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getUnReceiptQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(mmuInfo.getQtyPrecision(), 4));
            stockInfo.setPickExtraBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getPickExtraQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(mmuInfo.getQtyPrecision(), 4));
            stockInfo.setPickLackBaseQty(NumericUtil.emptyToZero((Object)stockInfo.getPickLackQty()).multiply(mmuInfo.getBaseConvsRate()).setScale(mmuInfo.getQtyPrecision(), 4));
        }
    }

    protected static void checkCanUpdate(Context ctx, ManufactureOrderInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        if (info.getBaseStatus() == null) {
            return;
        }
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) || info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) || info.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) || info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            if (info.getTechnics() != null && info.getTechnics().size() > 0) {
                for (int i = 0; i < info.getTechnics().size(); ++i) {
                    if (!EMMManufactureOrderEXCTL.isOpenBaseStatus(info.getTechnics().get(i))) continue;
                    throw new BOSException(MANUFACTURE_INFO + "[" + info.getNumber() + "]" + BCZYXDDGX_INFO);
                }
            }
        } else {
            throw new BOSException(MANUFACTURE_INFO + "[" + info.getNumber() + "]" + BSBCTJSH_INFO);
        }
        if (info.getTransactionType() == null) {
            throw new BOSException(MANUFACTURE_INFO + "[" + info.getNumber() + "]" + SWLXWK_INFO);
        }
        ProductTransactionTypeInfo ptInfo = ProductTransactionTypeFactory.getLocalInstance((Context)ctx).getProductTransactionTypeInfo((IObjectPK)new ObjectUuidPK(info.getTransactionType().getId()));
        if (!ptInfo.getBizType().getId().toString().equals("vGXRx5fFSsCYz9Zv7CzzgyQHQ1w=")) {
            throw new BOSException(MANUFACTURE_INFO + "[" + info.getNumber() + "]" + SWLXBSBZSC_INFO);
        }
    }

    protected static boolean isOpenBaseStatus(ManufactureOrderTechnicsInfo entryInfo) {
        boolean istrue = false;
        if (entryInfo != null && entryInfo.getBaseStatus() != null && (entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.OPEN) || entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.COMPLETION) || entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.MOSTCOMPLETION) || entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.Fault_stop) || entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.Fault_handing) || entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.Fault_handed) || entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.Fault_finished) || entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.WGDJ) || entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.UNQuality))) {
            istrue = true;
        }
        return istrue;
    }

    public static boolean checkBeforeSyncStock(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ManufactureOrderInfo moInfo = (ManufactureOrderInfo)model;
        EMMManufactureOrderEXCTL.checkCanUpdate(ctx, moInfo);
        if (moInfo.getBomID() == null || moInfo.getBomID() == "") {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.BOMISNULL_CANNOTSYNCSTOCK);
        }
        IBom ibom = BomFactory.getLocalInstance((Context)ctx);
        BomInfo bomInfo = ibom.getBomInfo((IObjectPK)new ObjectUuidPK(moInfo.getBomID()));
        if (!bomInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.BOMUNAUDITED_CANNOTSYNCSTOCK);
        }
        if (moInfo.getMaterial() == null) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.MATERIALISNULL_CANNOTSYNCSTOCK);
        }
        if (moInfo.getTransactionType() == null) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.TRANSACTIONTYPEISNULL_CANNOTSYNCSTOCK);
        }
        if (moInfo.getBizType() != null && moInfo.getBizType().getId().toString().equals("yRPu9BAfSRuIIEu9QnyxviQHQ1w=")) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.RETURNEDPRODUCT_CANNOTSYNCSTOCK);
        }
        if (moInfo.getTotalSplitBaseQty().compareTo(SysConstant.BIGZERO) > 0) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.MOSPLITED_CANNOTSYNCSTOCK);
        }
        if (moInfo.getBirthType() == MOBirthTypeEnum.SPLIT) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.FROMSPLIT_CANNOTSYNCSTOCK);
        }
        ManufactureOrderStockCollection stockCol = moInfo.getStocks();
        ManufactureOrderStockInfo stockInfo = null;
        boolean isReplaced = false;
        int size = stockCol.size();
        for (int index = 0; index < size; ++index) {
            stockInfo = stockCol.get(index);
            if (!stockInfo.isIsReplaced()) continue;
            isReplaced = true;
            break;
        }
        if (isReplaced) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.MATERIALREPLACED_CANNOTSYNCSTOCK);
        }
        return true;
    }
}

