/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.emm.mo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.IManufactureStrategy;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyFactory;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.emm.mo.EMMManufactureOrderCTL;
import com.kingdee.eas.emm.mo.EMMManufactureOrderEXCTL;
import com.kingdee.eas.emm.mo.EMMManufactureOrderFacadeFactory;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.CSEntrustTypeEnum;
import com.kingdee.eas.mm.basedata.ControlStrategyFactory;
import com.kingdee.eas.mm.basedata.ControlStrategyInfo;
import com.kingdee.eas.mm.basedata.IBom;
import com.kingdee.eas.mm.basedata.OprTimeUnitEnum;
import com.kingdee.eas.mm.basedata.ScheduleTypeEnum;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.MMCommonUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.ResourceUtils;
import com.kingdee.eas.mm.mo.MOBirthTypeEnum;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderExpectOutputInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderSyncException;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.mo.app.MOFinish;
import com.kingdee.eas.mm.planning.app.mrp.MRPUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class EMMManufactureOrderFlowCTL {
    private static final String REGEX_L = "\\{";
    private static final String REGEX_R = "\\}";

    public static String getMessage(Context ctx, String key, String[] parameters) {
        String message = EMMManufactureOrderFlowCTL.getString(ctx, key);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parameters.length; ++i) {
            sb.setLength(0);
            message = message.replaceAll(sb.append(REGEX_L).append(i).append(REGEX_R).toString(), parameters[i]);
        }
        return message;
    }

    public static String getString(Context ctx, String resourceName) {
        String path = "com.kingdee.eas.mm.mo.ManufactureOrderResource";
        String strTemp = ResourceBase.getString((String)path, (String)resourceName, (Locale)ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }

    public static void submitBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        MaterialInfo[] materialInfos = new MaterialInfo[col.size()];
        StorageOrgUnitInfo[] storageOrgUnit = new StorageOrgUnitInfo[col.size()];
        if (col != null && col.size() > 0) {
            String msg = null;
            HashMap crossOrgMap = new HashMap();
            HashSet<String> crossOrgSet = new HashSet<String>();
            for (int i = 0; i < col.size(); ++i) {
                ManufactureOrderTechnicsInfo entry;
                int j;
                ManufactureOrderInfo mo = (ManufactureOrderInfo)col.getObject(i);
                if (mo.getBaseStatus().equals((Object)BillBaseStatusEnum.ALTERING)) {
                    EMMManufactureOrderFlowCTL.synchronizeMOInfo(ctx, mo);
                }
                materialInfos[i] = mo.getMaterial();
                storageOrgUnit[i] = mo.getStorageOrgUnit();
                MaterialInfo materialInfo = materialInfos[i];
                StorageOrgUnitInfo stor = storageOrgUnit[i];
                String materialID = materialInfo.getId().toString();
                String storageOrgUnitID = stor.getId().toString();
                String key = materialID + storageOrgUnitID;
                String id = null;
                id = mo.getId() == null ? "NEWID" : mo.getId().toString();
                if (batchResults.isToDo(id)) {
                    ManufactureOrderTechnicsCollection tecCol = mo.getTechnics();
                    MMCommonUtils.objectValueSort((IObjectCollection)tecCol, (boolean)true, (String)"operationNo");
                    for (j = 0; j < tecCol.size(); ++j) {
                        entry = tecCol.get(j);
                        ControlStrategyInfo cInfo = null;
                        if (entry.getControlStrategy() != null) {
                            cInfo = ControlStrategyFactory.getLocalInstance((Context)ctx).getControlStrategyInfo((IObjectPK)new ObjectUuidPK(entry.getControlStrategy().getId()));
                        }
                        if (cInfo != null && cInfo.getEntrustType() != null && cInfo.getEntrustType().equals((Object)CSEntrustTypeEnum.INNERCOOPERATE)) {
                            if (j > 0 && !mo.getTechnics().get(j - 1).isIsReportPoint()) {
                                msg = EMMManufactureOrderFlowCTL.getString(ctx, "OUTWP_LAS_OR_NEXT_ISNOT_REPORPOINT");
                                batchResults.addError(id, msg);
                            }
                            if (j < mo.getTechnics().size() - 1 && !mo.getTechnics().get(j + 1).isIsReportPoint()) {
                                msg = EMMManufactureOrderFlowCTL.getString(ctx, "OUTWP_LAS_OR_NEXT_ISNOT_REPORPOINT");
                                batchResults.addError(id, msg);
                            }
                        }
                        if (entry.getAdminOrgUnit() != null) continue;
                        msg = EMMManufactureOrderFlowCTL.getString(ctx, "TECH_ADMIN_ORG_MUST_NOT_NULL");
                        batchResults.addError(id, msg);
                    }
                }
                if (batchResults.isToDo(id)) {
                    ManufactureOrderStockCollection stockCol = mo.getStocks();
                    for (j = 0; j < stockCol.size(); ++j) {
                        List<String> seqList;
                        entry = stockCol.get(j);
                        if (entry.getProvideType() != MaterialProvideTypeEnum.SPANORGPROVIDE && entry.getProvideType() != MaterialProvideTypeEnum.SPANORGDIRECTPROVIDE) continue;
                        String keyID = entry.getMaterial().getId().toString() + "_" + entry.getStorageOrgUnit().getId().toString();
                        if (crossOrgMap.containsKey(keyID)) {
                            seqList = (List)crossOrgMap.get(keyID);
                            seqList.add(String.valueOf(entry.getProvideType().getValue()));
                        } else {
                            seqList = new ArrayList();
                            seqList.add(String.valueOf(entry.getProvideType().getValue()));
                            crossOrgMap.put(keyID, seqList);
                        }
                        if (crossOrgSet.contains(keyID)) continue;
                        crossOrgSet.add(keyID);
                    }
                }
                SCMEntryDataVO vo = new SCMEntryDataVO();
                SCMEntryDataVO voResult = new SCMEntryDataVO();
                vo.setMaterialInfos(materialInfos);
                vo.setStorageOrgUnitInfos(storageOrgUnit);
                vo.setIsLoadingMaterialPlan(true);
                vo.setIsLoadingMaterialInventory(true);
                vo.setIsLoadingMaterialInfo(false);
                voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(vo);
                MaterialInventoryInfo materialInv = (MaterialInventoryInfo)voResult.getMaterialInventoryInfos().get(key);
                if (materialInv.isIsLotNumber() && mo.getLot() == null) {
                    msg = EMMManufactureOrderFlowCTL.getString(ctx, "LOT_NOT_NULL");
                }
                IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
                IMaterialPlan iMaterialPlan = MaterialPlanFactory.getLocalInstance((Context)ctx);
                MaterialPlanInfo planInfo = iMaterialPlan.getPlanInfo(materialID, storageOrgUnitID);
                MaterialInfo material = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                if (planInfo != null) {
                    boolean isConfig = planInfo.isIsConfigable();
                    if (isConfig && mo.getProject() == null && mo.getTrackNumber() == null) {
                        msg = EMMManufactureOrderFlowCTL.getMessage(ctx, "PROJECT_TRACKNUM_NOT_NULL", new String[]{material.getName()});
                        batchResults.addError(id, msg);
                    }
                    if ((mo.getSourceBillType() != null && !"9XXvbVGlRtym/0qtqeIXXrhE1B8=".equals(mo.getSourceBillType().getId().toString()) || mo.getSourceBillType() == null) && planInfo.getManufactureStrategy() != null) {
                        String strategy = planInfo.getManufactureStrategy().getId().toString();
                        IManufactureStrategy ims = ManufactureStrategyFactory.getLocalInstance((Context)ctx);
                        ManufactureStrategyInfo msi = (ManufactureStrategyInfo)ims.getValue((IObjectPK)new ObjectUuidPK(strategy));
                        if (strategy.equals("GE2FIa4GQ6uhdx0RDGuibtg0uEU=") || strategy.equals("qAXoUB/uBg/gQKjAYj0WQ9g0uEU=")) {
                            if (planInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM && mo.getProject() == null) {
                                msg = EMMManufactureOrderFlowCTL.getMessage(ctx, "ETO_PROJECT_NOT_NULL", new String[]{material.getName(), msi.getNumber()});
                                batchResults.addError(id, msg);
                            } else if (planInfo.getIsolatedRule() == IsolatedRuleEnum.ITEM_TRACKNO) {
                                if (mo.getProject() == null) {
                                    msg = EMMManufactureOrderFlowCTL.getMessage(ctx, "ETO_PROJECT_NOT_NULL", new String[]{material.getName(), msi.getNumber()});
                                    batchResults.addError(id, msg);
                                }
                                if (mo.getTrackNumber() == null) {
                                    msg = EMMManufactureOrderFlowCTL.getMessage(ctx, "MTO_TRACKNUMBER_NOT_NULL", new String[]{material.getName(), msi.getNumber()});
                                    batchResults.addError(id, msg);
                                }
                            }
                        } else if ((strategy.equals("fpPxtypCS/ihJ30GjB/UJtg0uEU=") || strategy.equals("qAXoUB/tBg/gQKjAYj0WQ9g0uEU=") || strategy.equals("qAYbemEdG9ngQKjAYj0V1dg0uEU=") || strategy.equals("qAYfaBzTrmLgQKjAYj0f3dg0uEU=")) && mo.getTrackNumber() == null) {
                            msg = EMMManufactureOrderFlowCTL.getMessage(ctx, "MTO_TRACKNUMBER_NOT_NULL", new String[]{material.getName(), msi.getNumber()});
                            batchResults.addError(id, msg);
                        }
                    }
                }
                if (!batchResults.isToDo(id)) continue;
                ScheduleTypeEnum scheduleType = mo.getScheduleType();
                if (scheduleType != null && scheduleType.getValue() != 10) {
                    boolean hasCalendar;
                    boolean isSupplyClassTerm = EMMManufactureOrderCTL.isSupplyClassTerm(ctx, mo);
                    if (!isSupplyClassTerm) {
                        msg = EMMManufactureOrderFlowCTL.getString(ctx, "Not_SupplyClassTerm");
                        batchResults.addError(id, msg);
                    }
                    if (!(hasCalendar = EMMManufactureOrderCTL.hasProjectCalendar(ctx, mo.getStorageOrgUnit().getId().toString()))) {
                        msg = EMMManufactureOrderFlowCTL.getString(ctx, "Not_FACTORYCALENDAR");
                        batchResults.addError(id, msg);
                    }
                }
                Set outSet = MMUtils.getCrossOrgMaterialSupplyOrgSet((Context)ctx, crossOrgSet);
                for (String materialOrg : outSet) {
                    String[] array = materialOrg.split("_");
                    String sqlMaterialName = "select fname_" + SysContext.getSysContext().getLocale() + " as name from T_BD_Material where fid='" + array[0] + "'";
                    String sqlOrgName = "select fname_" + SysContext.getSysContext().getLocale() + " as name from T_ORG_Storage where fid='" + array[1] + "'";
                    String materialName = "";
                    String orgName = "";
                    IRowSet rs_m = DbUtil.executeQuery((Context)ctx, (String)sqlMaterialName);
                    IRowSet rs_o = DbUtil.executeQuery((Context)ctx, (String)sqlOrgName);
                    try {
                        while (rs_m != null && rs_m.next()) {
                            materialName = rs_m.getString("name");
                        }
                        while (rs_o != null && rs_o.next()) {
                            orgName = rs_o.getString("name");
                        }
                    }
                    catch (SQLException e) {
                        throw new SQLDataException(e);
                    }
                    List tmpList = (List)crossOrgMap.get(materialOrg);
                    for (int k = 0; k < tmpList.size(); ++k) {
                        String provideTypeName = MaterialProvideTypeEnum.getEnum((int)Integer.parseInt(tmpList.get(k).toString())).getAlias();
                        String msgInfo = ResourceUtils.getMessageForServer((String)"com.kingdee.eas.mm.mo.ManufactureOrderResource", (String)"MID_AUDIT_CHECK", (String[])new String[]{provideTypeName, materialName, orgName});
                        batchResults.addError(id, msgInfo);
                    }
                }
            }
        }
    }

    public static void synchronizeMOInfo(Context ctx, ManufactureOrderInfo mo) throws EASBizException, BOSException {
        ManufactureOrderInfo dbData = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(mo.getId()));
        EMMManufactureOrderFlowCTL.synchronizeHeadData(mo, dbData);
        ManufactureOrderStockCollection stockCol = mo.getStocks();
        ManufactureOrderStockCollection dbStockCol = dbData.getStocks();
        block0: for (int i = 0; i < stockCol.size(); ++i) {
            ManufactureOrderStockInfo stockInfo = stockCol.get(i);
            for (int j = 0; j < dbStockCol.size(); ++j) {
                ManufactureOrderStockInfo dbStockData = dbStockCol.get(j);
                if (!dbStockData.getId().equals((Object)stockInfo.getId())) continue;
                EMMManufactureOrderFlowCTL.synchronizeStockData(stockInfo, dbStockData);
                continue block0;
            }
        }
        ManufactureOrderTechnicsCollection technicsCol = mo.getTechnics();
        ManufactureOrderTechnicsCollection dbTechnicsCol = dbData.getTechnics();
        block2: for (int i = 0; i < technicsCol.size(); ++i) {
            ManufactureOrderTechnicsInfo technicsInfo = technicsCol.get(i);
            for (int j = 0; j < dbTechnicsCol.size(); ++j) {
                ManufactureOrderTechnicsInfo dbTechnicsData = dbTechnicsCol.get(j);
                if (!dbTechnicsData.getId().equals((Object)technicsInfo.getId())) continue;
                EMMManufactureOrderFlowCTL.synchronizeTechnicsData(technicsInfo, dbTechnicsData);
                continue block2;
            }
        }
        ManufactureOrderExpectOutputCollection outputCol = mo.getExpectOutputs();
        ManufactureOrderExpectOutputCollection dbOutputCol = dbData.getExpectOutputs();
        block4: for (int i = 0; i < outputCol.size(); ++i) {
            ManufactureOrderExpectOutputInfo outputInfo = outputCol.get(i);
            for (int j = 0; j < dbOutputCol.size(); ++j) {
                ManufactureOrderExpectOutputInfo dbOutputData = dbOutputCol.get(j);
                if (!dbOutputData.getId().equals((Object)outputInfo.getId())) continue;
                EMMManufactureOrderFlowCTL.synchronizeExpectOutputData(outputInfo, dbOutputData);
                continue block4;
            }
        }
    }

    private static void synchronizeExpectOutputData(ManufactureOrderExpectOutputInfo outputInfo, ManufactureOrderExpectOutputInfo dbOutputData) {
        outputInfo.setFinishedQty(outputInfo.getFinishedQty());
        outputInfo.setFinishedBaseQty(outputInfo.getFinishedBaseQty());
        outputInfo.setPassQty(outputInfo.getPassQty());
        outputInfo.setPassBaseQty(outputInfo.getPassBaseQty());
        outputInfo.setScrapQty(outputInfo.getScrapQty());
        outputInfo.setScrapBaseQty(outputInfo.getScrapBaseQty());
        outputInfo.setToStoreQty(outputInfo.getToStoreQty());
        outputInfo.setToStoreBaseQty(outputInfo.getToStoreBaseQty());
        outputInfo.setAssociateQty(outputInfo.getAssociateQty());
    }

    private static void synchronizeStockData(ManufactureOrderStockInfo stockInfo, ManufactureOrderStockInfo dbStockData) {
        stockInfo.setActIssueQty(dbStockData.getActIssueQty());
        stockInfo.setActIssueBaseQty(dbStockData.getActIssueBaseQty());
        stockInfo.setRejectedQty(dbStockData.getRejectedQty());
        stockInfo.setRejectedBaseQty(dbStockData.getRejectedBaseQty());
        stockInfo.setUnIssueQty(dbStockData.getUnIssueQty());
        stockInfo.setUnIssueBaseQty(dbStockData.getUnIssueBaseQty());
        stockInfo.setScrapQty(dbStockData.getScrapQty());
        stockInfo.setScrapBaseQty(dbStockData.getScrapBaseQty());
        stockInfo.setMaterialScrapQty(dbStockData.getMaterialScrapQty());
        stockInfo.setMaterialScrapBaseQty(dbStockData.getMaterialScrapBaseQty());
        stockInfo.setFeedingQty(dbStockData.getFeedingQty());
        stockInfo.setFeedingBaseQty(dbStockData.getFeedingBaseQty());
        stockInfo.setMaterialFeedingQty(dbStockData.getMaterialFeedingQty());
        stockInfo.setMaterialFeedingBaseQty(dbStockData.getMaterialFeedingBaseQty());
        stockInfo.setTotalDirectReceiveQty(dbStockData.getTotalDirectReceiveQty());
        stockInfo.setTotalDirectReceiveBaseQty(dbStockData.getTotalDirectReceiveBaseQty());
        stockInfo.setTotalReceiptQty(dbStockData.getTotalReceiptQty());
        stockInfo.setTotalReceiptBaseQty(dbStockData.getTotalReceiptBaseQty());
        stockInfo.setUnReceiptQty(dbStockData.getUnReceiptQty());
        stockInfo.setUnReceiptBaseQty(dbStockData.getUnReceiptBaseQty());
        stockInfo.setToStoreQty(dbStockData.getToStoreQty());
        stockInfo.setToStoreBaseQty(dbStockData.getToStoreBaseQty());
        stockInfo.setTotalDSTransferQty(dbStockData.getTotalDSTransferQty());
        stockInfo.setTotalDSTransferBaseQty(dbStockData.getTotalDSTransferBaseQty());
        stockInfo.setAssociateQty(dbStockData.getAssociateQty());
    }

    private static void synchronizeTechnicsData(ManufactureOrderTechnicsInfo technicsInfo, ManufactureOrderTechnicsInfo dbTechnicsData) {
        technicsInfo.setTotalSplitQty(dbTechnicsData.getTotalSplitQty());
        technicsInfo.setTotalSplitBaseQty(dbTechnicsData.getTotalSplitBaseQty());
        technicsInfo.setTotalDispatchQty(dbTechnicsData.getTotalDispatchQty());
        technicsInfo.setTotalDispatchBaseQty(dbTechnicsData.getTotalDispatchBaseQty());
        technicsInfo.setUnDispatchQty(dbTechnicsData.getUnDispatchQty());
        technicsInfo.setUnDispatchBaseQty(dbTechnicsData.getUnDispatchBaseQty());
        technicsInfo.setFinishedQty(dbTechnicsData.getFinishedQty());
        technicsInfo.setFinishedBaseQty(dbTechnicsData.getFinishedBaseQty());
        technicsInfo.setRepReportQty(dbTechnicsData.getRepReportQty());
        technicsInfo.setRepReportBaseQty(dbTechnicsData.getRepReportBaseQty());
        technicsInfo.setTestQty(dbTechnicsData.getTestQty());
        technicsInfo.setTestBaseQty(dbTechnicsData.getTestBaseQty());
        technicsInfo.setPassQty(dbTechnicsData.getPassQty());
        technicsInfo.setPassBaseQty(dbTechnicsData.getPassBaseQty());
        technicsInfo.setConcessionQty(dbTechnicsData.getConcessionQty());
        technicsInfo.setConcessionBaseQty(dbTechnicsData.getConcessionBaseQty());
        technicsInfo.setScrapQty(dbTechnicsData.getScrapQty());
        technicsInfo.setScrapBaseQty(dbTechnicsData.getScrapBaseQty());
        technicsInfo.setTotalManufactureScrapQty(dbTechnicsData.getTotalManufactureScrapQty());
        technicsInfo.setTotalManufactureScrapBaseQty(dbTechnicsData.getTotalManufactureScrapBaseQty());
        technicsInfo.setTotalMaterialScrapQty(dbTechnicsData.getTotalMaterialScrapQty());
        technicsInfo.setTotalMaterialScrapBaseQty(dbTechnicsData.getTotalMaterialScrapBaseQty());
        technicsInfo.setRepairQty(dbTechnicsData.getRepairQty());
        technicsInfo.setRepairBaseQty(dbTechnicsData.getRepairBaseQty());
        technicsInfo.setIntoQty(dbTechnicsData.getIntoQty());
        technicsInfo.setIntoBaseQty(dbTechnicsData.getIntoBaseQty());
        technicsInfo.setRepMoveInQty(dbTechnicsData.getRepMoveInQty());
        technicsInfo.setRepMoveInBaseQty(dbTechnicsData.getRepMoveInBaseQty());
        technicsInfo.setOutQty(dbTechnicsData.getOutQty());
        technicsInfo.setOutBaseQty(dbTechnicsData.getOutBaseQty());
        technicsInfo.setRepMoveOutQty(dbTechnicsData.getRepMoveOutQty());
        technicsInfo.setRepMoveOutBaseQty(dbTechnicsData.getRepMoveOutBaseQty());
        technicsInfo.setAssociateQty(dbTechnicsData.getAssociateQty());
    }

    private static void synchronizeHeadData(ManufactureOrderInfo mo, ManufactureOrderInfo dbData) {
        mo.setTotalSplitQty(dbData.getTotalSplitQty());
        mo.setTotalSplitBaseQty(dbData.getTotalSplitBaseQty());
        mo.setToStroreQty(dbData.getToStroreQty());
        mo.setToStoreBaseQty(dbData.getToStoreBaseQty());
        mo.setFinishedQty(dbData.getFinishedQty());
        mo.setFinishedBaseQty(dbData.getFinishedBaseQty());
        mo.setPassQty(dbData.getPassQty());
        mo.setPassBaseQty(dbData.getPassBaseQty());
        mo.setConcessionQty(dbData.getConcessionQty());
        mo.setConcessionBaseQty(dbData.getConcessionBaseQty());
        mo.setScrapQty(dbData.getScrapQty());
        mo.setScrapBaseQty(dbData.getScrapBaseQty());
        mo.setRepairQty(dbData.getRepairQty());
        mo.setRepairBaseQty(dbData.getRepairBaseQty());
        mo.setTotalDirectSendQty(dbData.getTotalDirectSendQty());
        mo.setTotalDirectSendBaseQty(dbData.getTotalDirectSendBaseQty());
        mo.setTestedQty(dbData.getTestedQty());
        mo.setTestedBaseQty(dbData.getTestedBaseQty());
        mo.setUnToStoreQty(dbData.getUnToStoreQty());
        mo.setUnToStoreBaseQty(dbData.getUnToStoreBaseQty());
        mo.setUnTestedQty(dbData.getUnToStoreQty());
        mo.setUnTestedBaseQty(dbData.getUnToStoreBaseQty());
        mo.setUnRepairQty(dbData.getUnRepairQty());
        mo.setUnRepairBaseQty(dbData.getUnRepairBaseQty());
    }

    private BigDecimal transferTime(OprTimeUnitEnum unit, BigDecimal time) {
        if (unit != null && unit.getValue() == 3) {
            return time.divide(new BigDecimal(60), 2, 4);
        }
        if (unit != null && unit.getValue() == 4) {
            return time.divide(new BigDecimal(3600), 2, 4);
        }
        return time;
    }

    private void unReleasedBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    private void updateCostObject(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    @Deprecated
    public static void updateReqPlanData(Context ctx, BatchExecuteParamsEntry[] entries, int bizAction) throws Exception {
        if (entries == null || entries.length > 0) {
            // empty if block
        }
    }

    protected boolean checkBeforeSyncStock(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ManufactureOrderInfo moInfo = (ManufactureOrderInfo)model;
        if (moInfo.getBaseStatus().getValue() != 2 && moInfo.getBaseStatus().getValue() != 4 && moInfo.getBaseStatus().getValue() != 5) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.STATUSINVALID_CANNOTSYNCSTOCK);
        }
        if (moInfo.getBomID() == null || moInfo.getBomID() == "") {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.BOMISNULL_CANNOTSYNCSTOCK);
        }
        IBom ibom = BomFactory.getLocalInstance((Context)ctx);
        BomInfo bomInfo = ibom.getBomInfo((IObjectPK)new ObjectUuidPK(moInfo.getBomID()));
        if (!bomInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.BOMUNAUDITED_CANNOTSYNCSTOCK);
        }
        if (moInfo.getMaterial() == null) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.MATERIALISNULL_CANNOTSYNCSTOCK);
        }
        if (moInfo.getTransactionType() == null) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.TRANSACTIONTYPEISNULL_CANNOTSYNCSTOCK);
        }
        if (moInfo.getBizType() != null && moInfo.getBizType().getId().toString().equals("yRPu9BAfSRuIIEu9QnyxviQHQ1w=")) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.RETURNEDPRODUCT_CANNOTSYNCSTOCK);
        }
        if (moInfo.getTotalSplitBaseQty().compareTo(SysConstant.BIGZERO) > 0) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.MOSPLITED_CANNOTSYNCSTOCK);
        }
        if (moInfo.getBirthType() == MOBirthTypeEnum.SPLIT) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.FROMSPLIT_CANNOTSYNCSTOCK);
        }
        ManufactureOrderStockCollection stockCol = moInfo.getStocks();
        ManufactureOrderStockInfo stockInfo = null;
        boolean isReplaced = false;
        int size = stockCol.size();
        for (int index = 0; index < size; ++index) {
            stockInfo = stockCol.get(index);
            if (!stockInfo.isIsReplaced()) continue;
            isReplaced = true;
            break;
        }
        if (isReplaced) {
            throw new ManufactureOrderSyncException(ManufactureOrderSyncException.MATERIALREPLACED_CANNOTSYNCSTOCK);
        }
        return true;
    }

    public static void dealWithMOFinish(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "CREATE TABLE FORMOFINISH(FSourceBillID VARCHAR(44))";
        String tableName = null;
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql = "INSERT INTO " + tableName + "(FSourceBillID) values (?)";
        DBUtil.executeUpdate((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        MOFinish.autoFinish((Context)ctx, (String)tableName, (boolean)true);
        EMMManufactureOrderCTL.releaseTempTable(ctx, tableName);
    }

    protected void deleteBatchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    protected static void deleteRecFromExpectOutputCol(Context ctx, ManufactureOrderExpectOutputCollection expectOutputCol, ManufactureOrderExpectOutputInfo expectOutputInfo) throws EASBizException, BOSException {
        HashSet<String> destEntityHS = new HashSet<String>();
        destEntityHS.add("FA1292B4");
        destEntityHS.add("DFBE5164");
        boolean isHasDest = EMMManufactureOrderCTL.checkEntryHasDestObject(ctx, expectOutputInfo.getId().toString(), destEntityHS);
        if (!isHasDest) {
            expectOutputCol.removeObject((IObjectValue)expectOutputInfo);
        } else {
            BigDecimal updateQty = expectOutputInfo.getFinishedQty();
            updateQty = updateQty.max(expectOutputInfo.getToStoreQty());
            expectOutputInfo.setQty(updateQty);
        }
    }

    protected static void deleteRecFromStockCol(Context ctx, ManufactureOrderStockCollection stockCol, ManufactureOrderStockInfo stockInfo) throws EASBizException, BOSException {
        HashSet<String> destEntityHS = new HashSet<String>();
        destEntityHS.add("500AB75E");
        destEntityHS.add("7606B3CD");
        destEntityHS.add("2239F30A");
        destEntityHS.add("5C2A1F0C");
        destEntityHS.add("76C9F8D8");
        boolean isHasDest = EMMManufactureOrderCTL.checkEntryHasDestObject(ctx, stockInfo.getId().toString(), destEntityHS);
        if (!isHasDest) {
            stockCol.removeObject((IObjectValue)stockInfo);
        } else {
            BigDecimal plannedQty = stockInfo.getPlannedQty();
            BigDecimal plannedBaseQty = stockInfo.getPlannedBaseQty();
            stockInfo.setPlannedQty(new BigDecimal(0));
            stockInfo.setPlannedBaseQty(new BigDecimal(0));
            stockInfo.setUnIssueQty(stockInfo.getUnIssueQty().subtract(plannedQty));
            stockInfo.setUnIssueBaseQty(stockInfo.getUnIssueBaseQty().subtract(plannedBaseQty));
            stockInfo.setUnReceiptQty(stockInfo.getPlannedQty().subtract(stockInfo.getTotalReceiptQty()));
            stockInfo.setUnReceiptBaseQty(stockInfo.getPlannedBaseQty().subtract(stockInfo.getTotalReceiptBaseQty()));
            stockInfo.setAssociateQty(stockInfo.getPlannedQty().subtract(stockInfo.getAssociateQty()));
        }
    }

    public static ManufactureOrderExpectOutputCollection getExpectOutPutForSync(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManufactureOrderInfo moInfo = (ManufactureOrderInfo)model;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("MATERIAL", moInfo.getMaterial());
        param.put("BASEUNIT", moInfo.getBaseUnit());
        param.put("STORAGEORG", moInfo.getStorageOrgUnit());
        param.put("BILL_QTY", moInfo.getQty());
        param.put("BILL_UNIT", moInfo.getUnit());
        param.put("BEGINTIME", moInfo.getPlanBeginDate());
        param.put("ENDTIME", moInfo.getPlanEndDate());
        param.put("SPLIT_QTY", new BigDecimal(0));
        BomInfo bom = new BomInfo();
        bom.setId(BOSUuid.read((String)moInfo.getBomID()));
        param.put("BOM", bom);
        if (moInfo.getRouting() != null) {
            param.put("ROUTINGID", moInfo.getRouting().getId().toString());
        } else {
            param.put("ROUTINGID", null);
        }
        HashMap<String, String> retData = new HashMap<String, String>();
        retData.put("LOTNUMBER", moInfo.getLot());
        retData.put("TECHNICS", (String)moInfo.getTechnics());
        EMMManufactureOrderCTL.getExpectOutput(ctx, param, retData);
        ManufactureOrderExpectOutputCollection expectOutputs = (ManufactureOrderExpectOutputCollection)retData.get("EXPECTOUTPUTS");
        Iterator iter = null;
        ManufactureOrderTechnicsCollection techCol = moInfo.getTechnics();
        iter = techCol.iterator();
        HashMap<Integer, ManufactureOrderTechnicsInfo> techMap = new HashMap<Integer, ManufactureOrderTechnicsInfo>();
        while (iter.hasNext()) {
            ManufactureOrderTechnicsInfo techInfo = (ManufactureOrderTechnicsInfo)iter.next();
            techMap.put(new Integer(techInfo.getOperationNo()), techInfo);
        }
        if (moInfo.getBirthType() == MOBirthTypeEnum.REFORM) {
            int reformOper;
            int firstEffectOperNO = reformOper = EMMManufactureOrderFlowCTL.getSplitOperNo(ctx, moInfo.getId().toString());
            int size = techCol.size();
            for (int i = 0; i < size; ++i) {
                if (techCol.get(i).getOperationNo() < reformOper) continue;
                firstEffectOperNO = techCol.get(i).getOperationNo();
                break;
            }
            iter = expectOutputs.iterator();
            while (iter.hasNext()) {
                ManufactureOrderExpectOutputInfo expectOutputInfo = (ManufactureOrderExpectOutputInfo)iter.next();
                if (expectOutputInfo.getOperationNo() >= firstEffectOperNO) continue;
                iter.remove();
            }
        }
        EMMManufactureOrderFlowCTL.updateExpectOutputOper(ctx, expectOutputs, 0, moInfo.getLastOperNo(), techMap);
        return expectOutputs;
    }

    protected static void updateExpectOutputOper(Context ctx, ManufactureOrderExpectOutputCollection moExpectOutPutCol, int startOperNO, int defaultOperNo, Map techMap) throws EASBizException, BOSException {
        ManufactureOrderExpectOutputInfo entryInfo = null;
        int size = moExpectOutPutCol.size();
        for (int i = 0; i < size; ++i) {
            ManufactureOrderTechnicsInfo techInfo;
            entryInfo = (ManufactureOrderExpectOutputInfo)moExpectOutPutCol.getObject(i);
            int operationNo = entryInfo.getOperationNo();
            if (operationNo <= startOperNO) continue;
            if (techMap.containsKey(new Integer(operationNo))) {
                techInfo = (ManufactureOrderTechnicsInfo)techMap.get(new Integer(operationNo));
                entryInfo.setOperation(techInfo.getOperation());
                continue;
            }
            entryInfo.setOperationNo(defaultOperNo);
            techInfo = (ManufactureOrderTechnicsInfo)techMap.get(new Integer(defaultOperNo));
            entryInfo.setOperation(techInfo.getOperation());
        }
    }

    public static ManufactureOrderStockCollection getLatestStockForSync(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManufactureOrderInfo moInfo = (ManufactureOrderInfo)model;
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (moInfo.getRouting() != null) {
            param.put("ROUTINGID", moInfo.getRouting().getId().toString());
        } else {
            param.put("ROUTINGID", null);
        }
        param.put("STORAGEORG", moInfo.getStorageOrgUnit());
        param.put("BASEUNIT", moInfo.getBaseUnit());
        param.put("BILL_UNIT", moInfo.getUnit());
        param.put("BILL_QTY", moInfo.getQty());
        param.put("BEGINTIME", moInfo.getPlanBeginDate());
        param.put("ENDTIME", moInfo.getPlanEndDate());
        BomInfo bom = new BomInfo();
        bom.setId(BOSUuid.read((String)moInfo.getBomID()));
        param.put("BOM", bom);
        param.put("projectID", moInfo.getProject());
        param.put("trackID", moInfo.getTrackNumber());
        param.put("MATERIAL", moInfo.getMaterial());
        param.put("TRANSTYPE", moInfo.getTransactionType());
        param.put("RECALC", Boolean.TRUE);
        ManufactureOrderStockCollection stocks = EMMManufactureOrderFacadeFactory.getLocalInstance(ctx).bomExpand(param);
        Iterator iter = null;
        ManufactureOrderTechnicsCollection techCol = moInfo.getTechnics();
        iter = techCol.iterator();
        HashMap<Integer, ManufactureOrderTechnicsInfo> techMap = new HashMap<Integer, ManufactureOrderTechnicsInfo>();
        while (iter.hasNext()) {
            ManufactureOrderTechnicsInfo techInfo = (ManufactureOrderTechnicsInfo)iter.next();
            techMap.put(new Integer(techInfo.getOperationNo()), techInfo);
        }
        int firstEffectOperNO = 0;
        if (moInfo.getBirthType() == MOBirthTypeEnum.REFORM) {
            int reformOper = EMMManufactureOrderFlowCTL.getSplitOperNo(ctx, moInfo.getId().toString());
            int size = techCol.size();
            for (int i = 0; i < size; ++i) {
                if (techCol.get(i).getOperationNo() < reformOper) continue;
                firstEffectOperNO = techCol.get(i).getOperationNo();
                break;
            }
            iter = stocks.iterator();
            while (iter.hasNext()) {
                ManufactureOrderStockInfo stockInfo = (ManufactureOrderStockInfo)iter.next();
                if (stockInfo.getOperationNo() >= firstEffectOperNO) continue;
                iter.remove();
            }
        } else {
            firstEffectOperNO = moInfo.getFirstOperNo();
        }
        EMMManufactureOrderFlowCTL.updateStockOper(ctx, stocks, 0, firstEffectOperNO, techMap);
        return stocks;
    }

    protected static void updateStockOper(Context ctx, ManufactureOrderStockCollection moStockCol, int startOperNO, int defaultOperNo, Map techMap) throws EASBizException, BOSException {
        ManufactureOrderStockInfo stockInfo = null;
        int size = moStockCol.size();
        for (int i = 0; i < size; ++i) {
            ManufactureOrderTechnicsInfo techInfo;
            stockInfo = (ManufactureOrderStockInfo)moStockCol.getObject(i);
            int operationNo = stockInfo.getOperationNo();
            if (operationNo <= startOperNO) continue;
            if (techMap.containsKey(new Integer(operationNo))) {
                techInfo = (ManufactureOrderTechnicsInfo)techMap.get(new Integer(operationNo));
                stockInfo.setOperation(techInfo.getOperation());
                stockInfo.setWorkcenter(techInfo.getWorkcenter());
                continue;
            }
            stockInfo.setOperationNo(defaultOperNo);
            techInfo = (ManufactureOrderTechnicsInfo)techMap.get(new Integer(defaultOperNo));
            stockInfo.setOperation(techInfo.getOperation());
            stockInfo.setWorkcenter(techInfo.getWorkcenter());
        }
    }

    public static void getStateList(Context ctx, IObjectCollection newStockCol, IObjectCollection oldStockCol, Collection insertKeyCol, Collection updateKeyCol, Collection deleteKeyCol) throws EASBizException, BOSException {
        boolean find;
        String recKey2 = "";
        HashSet<String> newStockSet = new HashSet<String>();
        HashSet<String> oldStockSet = new HashSet<String>();
        IObjectValue model2 = null;
        Iterator iter = null;
        Iterator oldIter = null;
        for (IObjectValue model2 : newStockCol) {
            recKey2 = EMMManufactureOrderCTL.getRecKeyString(model2);
            newStockSet.add(recKey2);
        }
        for (IObjectValue model2 : oldStockCol) {
            recKey2 = EMMManufactureOrderCTL.getRecKeyString(model2);
            oldStockSet.add(recKey2);
        }
        iter = newStockSet.iterator();
        String oldRecKey2 = "";
        while (iter.hasNext()) {
            find = false;
            recKey2 = (String)iter.next();
            for (String oldRecKey2 : oldStockSet) {
                if (!recKey2.equals(oldRecKey2)) continue;
                find = true;
                break;
            }
            if (!find) {
                insertKeyCol.add(recKey2);
                continue;
            }
            updateKeyCol.add(recKey2);
        }
        oldIter = oldStockSet.iterator();
        while (oldIter.hasNext()) {
            find = false;
            oldRecKey2 = (String)oldIter.next();
            for (String recKey2 : newStockSet) {
                if (!recKey2.equals(oldRecKey2)) continue;
                find = true;
                break;
            }
            if (find) continue;
            deleteKeyCol.add(oldRecKey2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ManufactureOrderStockCollection getZBIndustrybomExpand(Context ctx, Map inParam) throws BOSException, EASBizException {
        ManufactureOrderStockCollection manufactureOrderStockCollection;
        String locStr = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sqlBuf = new StringBuffer();
        ManufactureOrderStockCollection materialStock = new ManufactureOrderStockCollection();
        String bomID = ((BomInfo)inParam.get("BOM")).getId().toString();
        BomInfo bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectStringPK(bomID));
        BOMTypeEnum type = bomInfo.getBomType();
        String routingID = (String)inParam.get("ROUTINGID");
        StorageOrgUnitInfo storageOrgUnit = (StorageOrgUnitInfo)inParam.get("STORAGEORG");
        String storageOrgId = storageOrgUnit.getId().toString();
        String beginDate = MRPUtil.dateToString((Date)((Timestamp)inParam.get("BEGINTIME")), (String)"yyyy-MM-dd");
        String expandTablName = EMMManufactureOrderFlowCTL.createTempTable(ctx);
        String tmpTable = null;
        String projectID = "999999999";
        String trackID = "999999999";
        if (inParam.get("projectID") != null) {
            projectID = ((ProjectInfo)inParam.get("projectID")).getId().toString();
        }
        if (inParam.get("trackID") != null) {
            trackID = ((TrackNumberInfo)inParam.get("trackID")).getId().toString();
        }
        try {
            sqlBuf.setLength(0);
            sqlBuf.append("insert into ").append(expandTablName).append(" ").append("\r\n").append("(FID,FNETWEIGHT,FBlkSize,FSpecifiedLength,FBomEntryID,fmaterialid,funitid,fbaseunitid,fPrec,FReplaceMode,").append("FIssMode,FIsBackFlush,FIsQuotaControl,FIssInHightLimit,FIssInLowLimit,FBlueprint,FBOMDefWarehouseID,").append("FRoutingItemID,FMaterialAttr,flevel,funitQty,fscrapRate,FScrapRateExpression,FTrackNumberID,FProjectID,FSupplyStorageId,FLocationID) ").append("\r\n").append("select newbosid('12345678'), t1.FNetWeight,t1.FBlkSize,t1.FSpecifiedLength,t1.FID,t1.fmaterialid,t1.funitid,t1.fbaseunitid,t21.FQtyPrecision,t1.FReplaceMode,").append("t1.FIssMode,t1.FIsBackFlush,t2.FIsQuotaControl,t2.FIssInHightLimit,t2.FIssInLowLimit,").append("t1.FBlueprint_").append(locStr).append(",t1.FDefaultWarehouseID,");
            if (routingID != null) {
                sqlBuf.append("t3.FRoutingItemID,").append("\r\n");
            } else {
                sqlBuf.append("null,").append("\r\n");
            }
            sqlBuf.append("t2.FMaterialAttr,1,").append("case when t1.FConsumeType = 20 then ").append("to_decimal(to_decimal(1.0/t0.FProductQty,21,8) * t1.FConsumeFixQty,21,8) ").append("else ").append("\r\n").append("to_decimal(to_decimal(to_decimal(to_decimal(t0.FPRODUCTBASEQTY/t1.fbaseproductrate,21,8)/t1.FBASERATE,21,8)*(t1.FPROPORTION * 0.01),21,8) / t0.FPRODUCTQTY,21,8) ").append("end,").append("\r\n").append("to_decimal(t1.FScrapRatio/100,21,8),t2.FScrapRateExpression ,'").append(trackID).append("','").append(projectID).append("',t1.FSupplyStorageOrgUnitID,t1.FLocationID ").append("\r\n").append("from t_mm_bom t0 ").append("\r\n").append("inner join t_mm_bomentry t1 on t0.fid = t1.fparentid ").append("\r\n").append("inner join T_BD_MultiMeasureUnit t21 on t1.fmaterialid = t21.fmaterialid and t1.funitid = t21.FMeasureUnitID ").append("\r\n").append("inner join t_bd_materialplan t2 on t1.fmaterialid = t2.fmaterialid ").append("\r\n").append("and t2.forgunit = '").append(storageOrgId).append("' ").append("\r\n");
            if (routingID != null) {
                sqlBuf.append("left outer join (").append("select t31.FRoutingItemID,t31.fbomitemid ").append("from t_mm_pbomentry t31 inner join t_mm_pbom t32 on t31.fparentid = t32.fid ").append("where t32.froutingid = '").append(routingID).append("' ");
                if (type.getValue() != 40) {
                    sqlBuf.append(" and isnull(t32.FTrackNumberID, '999999999')= '").append(trackID).append("' ");
                    sqlBuf.append(" and isnull(t32.FProjectID, '999999999') = '").append(projectID).append("'");
                }
                sqlBuf.append(") t3 on t3.fbomitemid = t1.fid ");
            }
            sqlBuf.append("where t1.FEffectiveDate <=ADD_DAYS(to_date('").append(beginDate).append("') , t1.FLeadtime )").append("\r\n").append("and t1.FDisableDate > ADD_DAYS (to_date('").append(beginDate).append("') , t1.FLeadtime ) ").append("\r\n").append("and t1.FOutputType in (10710,10740) ").append("\r\n").append("and t0.fid = '").append(bomID).append("' ");
            int rows = MRPUtil.executeUpdate((Context)ctx, (String)sqlBuf.toString());
            int level = 1;
            String pbomid = new String();
            if (routingID != null) {
                sqlBuf.setLength(0);
                sqlBuf.append("select fid  ");
                sqlBuf.append("from  t_mm_pbom  ");
                sqlBuf.append("where froutingid = '").append(routingID).append("' ");
                sqlBuf.append(" and fbomid = '").append(bomID).append("' ");
                if (type.getValue() != 40) {
                    sqlBuf.append(" and isnull(FTrackNumberID, '999999999')= '").append(trackID).append("' ");
                    sqlBuf.append(" and isnull(FProjectID, '999999999') = '").append(projectID).append("'");
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString());
                try {
                    while (rs.next()) {
                        pbomid = rs.getString("fid");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            tmpTable = EMMManufactureOrderCTL.createTempTable2(ctx);
            while (rows > 0 && level <= 99) {
                StringBuffer sb2 = new StringBuffer();
                sb2.append(" insert into ").append(tmpTable).append("\r\n").append(" (FID,FMaterialID,FTrackNumberID,FProjectID,FLocationID,FStorageOrgUnitID) ").append("\r\n").append(" select FID,FMaterialID,FTrackNumberID,FProjectID,FLocationID, ").append("'").append(storageOrgId).append("' from ").append(expandTablName).append(" where flevel = ").append(level).append(" and FMaterialAttr = 10020 ");
                MRPUtil.executeUpdate((Context)ctx, (String)sb2.toString());
                BOMExtend2FacadeFactory.getLocalInstance((Context)ctx).getBomByTmpTab(tmpTable);
                sqlBuf.setLength(0);
                sqlBuf.append("insert into ").append(expandTablName).append(" ").append("\r\n").append("(FID,FNETWEIGHT,FBlkSize,FSpecifiedLength,FBomEntryID,fmaterialid,funitid,fbaseunitid,fPrec,FReplaceMode,").append("FIssMode,FIsBackFlush,FIsQuotaControl,FIssInHightLimit,FIssInLowLimit,FBlueprint,FBOMDefWarehouseID,").append("FRoutingItemID,FMaterialAttr,flevel,funitQty,fscrapRate,FScrapRateExpression,FTrackNumberID,FProjectID,FSupplyStorageId,FLocationID) ").append("\r\n").append("select newbosid('12345678'),t1.FNETWEIGHT,t1.FBlkSize,t1.FSpecifiedLength,t1.FID,t1.fmaterialid,t1.funitid,t1.fbaseunitid,t21.FQtyPrecision,t1.FReplaceMode,").append("t1.FIssMode,t1.FIsBackFlush,t2.FIsQuotaControl,t2.FIssInHightLimit,t2.FIssInLowLimit,").append("t1.FBlueprint_").append(locStr).append(",t1.FDefaultWarehouseID,");
                if (routingID != null) {
                    sqlBuf.append("t3.FRoutingItemID,").append("\r\n");
                } else {
                    sqlBuf.append("null,").append("\r\n");
                }
                sqlBuf.append("t2.FMaterialAttr,").append(level + 1).append(",").append("case when t1.FConsumeType = 20 then ").append("to_decimal( to_decimal(1.0 /t0.FProductQty * t1.FConsumeFixQty,21,8)* t4.funitQty,21,8) ").append("else ").append("\r\n").append("to_decimal(to_decimal(to_decimal(to_decimal(to_decimal(t0.FPRODUCTBASEQTY/t1.fbaseproductrate,21,8)/t1.FBASERATE,21,8)*(t1.FPROPORTION * 0.01),21,8) / t0.FPRODUCTQTY,21,8) * t4.funitQty,21,8) ").append("end,").append("\r\n").append("case when t4.FScrapRateExpression = 10610 then ").append("\r\n").append("round(to_decimal(to_decimal(t1.FScrapRatio/(t0.fyield/100),21,8)/(100-(t4.fscrapRate*100)),21,8 ),4) ").append("\r\n").append("else round(to_decimal(to_decimal(t1.FScrapRatio*(100+t4.fscrapRate*100),21,8)/10000/to_decimal((t0.fyield/100),21,8),21,8),4) ").append("\r\n").append("end,t2.FScrapRateExpression,t4.FTrackNumberID,t4.FProjectID,t1.FSupplyStorageOrgUnitID,t1.FLocationID ").append("\r\n").append("from t_mm_bom t0 ").append("\r\n").append("inner join t_mm_bomentry t1 on t0.fid = t1.fparentid ").append("\r\n").append("inner join T_BD_MultiMeasureUnit t21 on t1.fmaterialid = t21.fmaterialid and t1.funitid = t21.FMeasureUnitID ").append("\r\n").append("inner join t_bd_materialplan t2 on t1.fmaterialid = t2.fmaterialid ").append("\r\n").append("and t2.forgunit = '").append(storageOrgId).append("' ").append("\r\n");
                if (routingID != null) {
                    sqlBuf.append("left outer join (").append("select t31.FRoutingItemID,t31.fbomitemid ").append("from t_mm_pbomentry t31 inner join t_mm_pbom t32 on t31.fparentid = t32.fid ").append(" inner join  t_mm_bom t0 on t0.fid = t32.fbomid ").append("where t32.fid = '").append(pbomid).append("' ");
                    sqlBuf.append(") t3 on t3.fbomitemid = t1.fid ").append("\r\n");
                }
                sqlBuf.append("inner join ").append(expandTablName).append(" t4 on t0.fmaterialid = t4.fmaterialid  ").append("inner join ").append(tmpTable).append(" t10 on t10.fid = t4.FID ").append("where t1.FEffectiveDate <= ADD_DAYS(to_date('").append(beginDate).append("') , t1.FLeadtime ) ").append("\r\n").append("and t1.FDisableDate > ADD_DAYS(to_date('").append(beginDate).append("') , t1.FLeadtime ) ").append("\r\n").append("and t1.FOutputType in (10710,10740) ").append("\r\n").append("and t0.FSTORAGEORGUNITID = ? ").append("\r\n").append(" and t0.FID = t10.FBomID");
                rows = MRPUtil.executeUpdate((Context)ctx, (String)sqlBuf.toString(), (Object[])new Object[]{storageOrgId});
                ++level;
                MRPUtil.executeUpdate((Context)ctx, (String)("delete from " + tmpTable));
            }
            if (level > 99) {
                throw new BomException(BomException.CYCLE);
            }
            inParam.put("TABLENAME", expandTablName);
            manufactureOrderStockCollection = materialStock = EMMManufactureOrderEXCTL.buildStock(ctx, inParam);
        }
        catch (Throwable throwable) {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            if (expandTablName != null) {
                pool.releaseTable(expandTablName);
            }
            if (tmpTable != null) {
                pool.releaseTable(tmpTable);
            }
            throw throwable;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (expandTablName != null) {
            pool.releaseTable(expandTablName);
        }
        if (tmpTable != null) {
            pool.releaseTable(tmpTable);
        }
        return manufactureOrderStockCollection;
    }

    protected static int getSplitOperNo(Context ctx, String id) throws EASBizException, BOSException {
        int operNo = 0;
        String sql_getSplitOperNo = "SELECT distinct FSplitOperationNo FROM T_MM_MOSplitRecord WHERE FChildId = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT distinct FSplitOperationNo FROM T_MM_MOSplitRecord WHERE FChildId = ?", (Object[])new Object[]{id});
        try {
            if (rs.next()) {
                operNo = rs.getInt("FSplitOperationNo");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return operNo;
    }

    public static String createTempTable(Context ctx) throws BOSException, EASBizException {
        String expandTablName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            StringBuffer sqlBuf = new StringBuffer();
            sqlBuf.append("create table bomexpand (").append("\r\n").append("fid varchar(44) not null,").append("\r\n").append("fmaterialid varchar(44) null,").append("\r\n").append("funitid varchar(44) null,").append("\r\n").append("fbaseunitid varchar(44) null,").append("\r\n").append("funitQty numeric(21,8) not null default 0,").append("\r\n").append("fQty numeric(21,8) not null default 0,").append("\r\n").append("fPlannedQty numeric(21,8) not null default 0,").append("\r\n").append("fscrapQty numeric(21,8) not null default 0,").append("\r\n").append("fscrapRate numeric(21,8) not null default 0,").append("\r\n").append("FScrapRateExpression int null,").append("\r\n").append("FRoutingItemID varchar(44) null ,").append("\r\n").append("FMaterialAttr int  not null default 0,").append("\r\n").append("flevel int  not null default 0, ").append("\r\n").append("fPrec int  not null default 0, ").append("\r\n").append("FIssMode int  null, ").append("\r\n").append("FIsBackFlush int  null, ").append("\r\n").append("FIsQuotaControl int  null, ").append("\r\n").append("FIssInHightLimit numeric(21,8) null, ").append("\r\n").append("FIssInLowLimit numeric(21,8) null, ").append("\r\n").append("FBlueprint nvarchar(256) null, ").append("\r\n").append("FReplaceMode int null, ").append("\r\n").append("FBOMDefWarehouseID varchar(44) null, ").append("\r\n").append("FBomEntryID varchar(44) null, ").append("\r\n").append("FProvideType int, ").append("\r\n").append("FDemandTime datetime null ,").append("\r\n").append("FTrackNumberID varchar(44) null,").append("\r\n").append("FProjectID varchar(44) null, ").append("\r\n").append("FSupplyStorageId varchar(44) null, ").append("\r\n").append("FLocationID varchar(44) null ,").append("\r\n").append("FNetWeight numeric(21,8) null, ").append("\r\n").append("FBlkSize nvarchar(255) null, ").append("\r\n").append("FSpecifiedLength nvarchar(255) null ").append("\r\n").append(")");
            expandTablName = pool.createTempTable(sqlBuf.toString());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        return expandTablName;
    }

    public boolean updateFixedWorkingTime(Context ctx) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        StringBuffer temp = new StringBuffer();
        temp.append(" (select distinct rwp.cffixedworkingtime time1,rwp.cffixedworkingtime*Technics.Fqty totalFixedWorkTime ");
        temp.append("  from T_MM_ManufactureOrder order1,  T_MM_MFTOrderTechnics Technics,   T_MM_StandardRooting  rooting, T_MM_MaterialRWP      rwp ");
        temp.append(" where order1.fid = Technics.Fparentid and order1.froutingID = rooting.fid ");
        temp.append("  and rooting.fMaterialRootingId = rwp.fparentid and Technics.Foperationno = rwp.fwpseq ");
        temp.append(" and (Technics.Cffixedworkingtime is null or technics.cffixedworkingtime = 0 ) and (rwp.cffixedworkingtime is not null or rwp.cffixedworkingtime > 0) and a.fid = Technics.fid) ");
        sb.append("UPDATE T_MM_MFTORDERTECHNICS A\r\n");
        sb.append("SET (\r\n");
        sb.append("CFFIXEDWORKINGTIME,\r\n");
        sb.append("CFTOTFIXEDWORKTIME\r\n");
        sb.append(")=(\r\n");
        sb.append("SELECT\r\n");
        sb.append("TOP 1\r\n");
        sb.append("ISNULL(RWP.CFFIXEDWORKINGTIME,0) CFFIXEDWORKINGTIME,\r\n");
        sb.append("ISNULL(RWP.CFFIXEDWORKINGTIME,0) * ISNULL(A.FQTY,0) CFTOTFIXEDWORKTIME\r\n");
        sb.append("FROM T_MM_MFTORDERTECHNICS MOT\r\n");
        sb.append("INNER JOIN T_MM_MANUFACTUREORDER MO ON MO.FID=MOT.FPARENTID\r\n");
        sb.append("INNER JOIN T_MM_STANDARDROOTING SR ON SR.FID=MO.FROUTINGID\r\n");
        sb.append("INNER JOIN T_MM_MATERIALRWP RWP ON\r\n");
        sb.append("1=1\r\n");
        sb.append("AND RWP.FPARENTID=SR.FMATERIALROOTINGID\r\n");
        sb.append("AND RWP.FWPSEQ=MOT.FOPERATIONNO\r\n");
        sb.append("WHERE\r\n");
        sb.append("1=1\r\n");
        sb.append("AND MOT.FID=A.FID\r\n");
        sb.append("AND ISNULL(RWP.CFFIXEDWORKINGTIME,0)>0\r\n");
        sb.append(")\r\n");
        sb.append("WHERE\r\n");
        sb.append("1=1\r\n");
        sb.append("AND A.FID IN (\r\n");
        sb.append("SELECT\r\n");
        sb.append("MOT.FID\r\n");
        sb.append("FROM T_MM_MANUFACTUREORDER MO\r\n");
        sb.append("INNER JOIN T_MM_MFTORDERTECHNICS MOT ON MOT.FPARENTID=MO.FID\r\n");
        sb.append("INNER JOIN T_MM_STANDARDROOTING SR ON SR.FID=MO.FROUTINGID\r\n");
        sb.append("INNER JOIN T_MM_MATERIALRWP RWP ON\r\n");
        sb.append("1=1\r\n");
        sb.append("AND RWP.FPARENTID=SR.FMATERIALROOTINGID\r\n");
        sb.append("AND RWP.FWPSEQ=MOT.FOPERATIONNO\r\n");
        sb.append("WHERE\r\n");
        sb.append("1=1\r\n");
        sb.append("AND ISNULL(MOT.CFFIXEDWORKINGTIME,0)=0\r\n");
        sb.append("AND ISNULL(RWP.CFFIXEDWORKINGTIME,0)>0\r\n");
        sb.append(")\r\n");
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

