/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.common.utils;

import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

public class DateUtil {
    public static Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static long dateDiff(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        return date2ms - date1ms;
    }

    public static Date stringToDate(String s) {
        Date d = null;
        if (EmptyUtil.isEmpty((String)s)) {
            d = DateUtil.getDayBegin();
        } else {
            try {
                d = Constants.FORMAT_DAY.parse(s);
            }
            catch (ParseException e) {
                try {
                    d = new SimpleDateFormat().parse(s);
                }
                catch (ParseException e1) {
                    d = DateUtil.getDayBegin();
                }
            }
        }
        return d;
    }

    public static Date stringToDateFormat(String s, DateFormat dateFormat) {
        Date d = null;
        if (EmptyUtil.isEmpty((String)s)) {
            d = DateUtil.getDayBegin();
        } else {
            try {
                d = dateFormat.parse(s);
            }
            catch (ParseException e) {
                try {
                    d = new SimpleDateFormat().parse(s);
                }
                catch (ParseException e1) {
                    d = DateUtil.getDayBegin();
                }
            }
        }
        return d;
    }

    public static String DateToString(Date s) {
        return Constants.FORMAT_DAY.format(s);
    }

    public static String DateToString(Date s, DateFormat format) {
        return format.format(s);
    }

    public static Date addInteger(Date date, int dateType, int amount) {
        Date myDate = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(dateType, amount);
            myDate = calendar.getTime();
        }
        return myDate;
    }

    public static Date addDay(Date date, int dayAmount) {
        return DateUtil.addInteger(date, 5, dayAmount);
    }

    public static Date addMonth(Date date, int dayAmount) {
        return DateUtil.addInteger(date, 2, dayAmount);
    }

    public static Date addYear(Date date, int dayAmount) {
        return DateUtil.addInteger(date, 1, dayAmount);
    }

    public static int getMonth(Date start, Date end) throws ParseException {
        if (start.after(end)) {
            Date t = start;
            start = end;
            end = t;
        }
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        Calendar temp = Calendar.getInstance();
        temp.setTime(end);
        temp.add(5, 1);
        int year = endCalendar.get(1) - startCalendar.get(1);
        int month = endCalendar.get(2) - startCalendar.get(2);
        if (startCalendar.get(5) == 1 && temp.get(5) == 1) {
            return year * 12 + month + 1;
        }
        if (startCalendar.get(5) != 1 && temp.get(5) == 1) {
            return year * 12 + month;
        }
        if (startCalendar.get(5) == 1 && temp.get(5) != 1) {
            return year * 12 + month;
        }
        return year * 12 + month - 1 < 0 ? 0 : year * 12 + month;
    }

    public static Date getYearFirstDate(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        Date dates = calendar.getTime();
        return dates;
    }

    public static Date getYearLastDate(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date dates = calendar.getTime();
        return dates;
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        return cal.getTime();
    }

    public static Date getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return cal.getTime();
    }

    public static List getWeekList(Date start, Date end) {
        long CONST_WEEK = 604800000L;
        ArrayList weekList = new ArrayList();
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(start);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(end);
        Date now = new Date();
        Calendar nowCal = Calendar.getInstance();
        nowCal.setTime(now);
        int dayOfWeek = startCal.get(7);
        startCal.add(5, -(dayOfWeek - 1));
        dayOfWeek = endCal.get(7);
        endCal.add(5, 7 - (dayOfWeek - 1));
        int total = (int)((endCal.getTimeInMillis() - startCal.getTimeInMillis()) / CONST_WEEK);
        for (int i = 0; i < total; ++i) {
            HashMap<String, Object> week = new HashMap<String, Object>();
            week.put("index", String.valueOf(i + 1));
            week.put("title", "\u7b2c" + (i + 1) + "\u5468");
            startCal.add(5, 1);
            Date beginDate = startCal.getTime();
            startCal.add(5, 6);
            Date endDate = startCal.getTime();
            week.put("beginDate", beginDate);
            week.put("endDate", endDate);
            weekList.add(week);
        }
        return weekList;
    }

    public static List getYearList(Date start, Date end) {
        ArrayList yearList = new ArrayList();
        int beginYear = DateUtil.getYear(start);
        int endYear = DateUtil.getYear(end);
        for (int i = beginYear; i <= endYear; ++i) {
            HashMap<String, Object> week = new HashMap<String, Object>();
            week.put("index", i + "");
            week.put("title", i + "\u5e74");
            Date beginDate = i == beginYear ? start : DateUtil.getYearFirstDate(i);
            Date endDate = i == endYear ? end : DateUtil.getYearLastDate(i);
            week.put("beginDate", beginDate);
            week.put("endDate", endDate);
            yearList.add(week);
        }
        return yearList;
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static List getMonthList(Date start, Date end) throws ParseException {
        ArrayList monthList = new ArrayList();
        int beginYear = DateUtil.getYear(start);
        int beginMonth = DateUtil.getMonth(start);
        int diff = DateUtil.getMonth(start, end);
        for (int i = 0; i <= diff; ++i) {
            if (i > 0 && ++beginMonth > 12) {
                beginMonth = 1;
                ++beginYear;
            }
            Date beginDate = DateUtil.getFirstDayOfMonth(beginYear, beginMonth);
            Date endDate = DateUtil.getLastDayOfMonth(beginYear, beginMonth);
            HashMap<String, Object> week = new HashMap<String, Object>();
            week.put("index", beginYear + "-" + beginMonth);
            week.put("title", beginYear + "-" + beginMonth);
            week.put("beginDate", beginDate);
            week.put("endDate", endDate);
            monthList.add(week);
        }
        return monthList;
    }

    public static int getWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        return calendar.get(3);
    }
}

