/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.common.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZipUtil {
    protected static byte[] buf = new byte[1024];

    private ZipUtil() {
    }

    private static void recurseFiles(JarOutputStream jos, File file, String pathName) throws IOException, FileNotFoundException {
        if (file.isDirectory()) {
            String sPathName = pathName + file.getName() + "/";
            jos.putNextEntry(new JarEntry(sPathName));
            String[] fileNames = file.list();
            if (fileNames != null) {
                for (int i = 0; i < fileNames.length; ++i) {
                    ZipUtil.recurseFiles(jos, new File(file, fileNames[i]), sPathName);
                }
            }
        } else {
            int len;
            JarEntry jarEntry = new JarEntry(pathName + file.getName());
            FileInputStream fin = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(fin);
            jos.putNextEntry(jarEntry);
            while ((len = in.read(buf)) >= 0) {
                jos.write(buf, 0, len);
            }
            in.close();
            jos.closeEntry();
        }
    }

    public static void makeDirectoryToZip(File directory, File zipFile, String zipFolderName, int level) throws IOException, FileNotFoundException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(zipFile);
        }
        catch (Exception e) {
            new File(zipFile.getParent()).mkdirs();
            zipFile.createNewFile();
            fos = new FileOutputStream(zipFile);
        }
        JarOutputStream jos = new JarOutputStream((OutputStream)fos, new Manifest());
        jos.setLevel(ZipUtil.checkZipLevel(level));
        String[] fileNames = directory.list();
        if (fileNames != null) {
            for (int i = 0; i < fileNames.length; ++i) {
                ZipUtil.recurseFiles(jos, new File(directory, fileNames[i]), zipFolderName == null ? "" : zipFolderName);
            }
        }
        jos.close();
    }

    public static int checkZipLevel(int level) {
        if (level < 0 || level > 9) {
            return 7;
        }
        return level;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        String s = "ssxxxsss";
        Pattern pa = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = pa.matcher(s);
        System.out.println(s + " is " + m.find());
    }
}

