/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.basedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.ClassTeamFactory;
import com.kingdee.eas.mm.basedata.ClassTeamInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OperationScheduleUtils {
    private static String RESURL = "com.kingdee.eas.industry.emm.mm.basedata.EMMEMBaseResource";
    private static String CZBZXX_FAIL = EASResource.getString((String)RESURL, (String)"CZBZXX_FAIL");
    private static String JSSJ_FAIL = EASResource.getString((String)RESURL, (String)"JSSJ_FAIL");
    private static String GXCSSJ_FAIL = EASResource.getString((String)RESURL, (String)"GXCSSJ_FAIL");
    public static final long dayTime = 86400000L;
    public static final SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat sdfDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat sdfTime = new SimpleDateFormat("HH:mm:ss");

    public static List cteAddItem(Timestamp startTime, Timestamp endTime, List ctes) {
        List returnCTEs;
        List list = returnCTEs = ctes == null ? new ArrayList() : ctes;
        if (startTime == null || endTime == null) {
            return returnCTEs;
        }
        if (startTime.compareTo(endTime) > 0) {
            return returnCTEs;
        }
        if (returnCTEs.size() == 0) {
            returnCTEs.add(new Object[]{startTime, endTime, endTime.getTime() - startTime.getTime()});
        } else {
            int count = returnCTEs.size();
            for (int index = count - 1; index >= 0; --index) {
                if (returnCTEs.get(index) == null || !(returnCTEs.get(index) instanceof Object[])) {
                    returnCTEs.remove(index);
                    continue;
                }
                Object[] objs = (Object[])returnCTEs.get(index);
                if (objs.length != 3) {
                    returnCTEs.remove(index);
                    continue;
                }
                if (!(objs[0] != null && Timestamp.class.getName().equals(objs[0].getClass().getName()) && objs[1] != null && Timestamp.class.getName().equals(objs[1].getClass().getName()) && objs[2] != null && Long.class.getName().equals(objs[2].getClass().getName()))) {
                    returnCTEs.remove(index);
                    continue;
                }
                Timestamp tStartTime = (Timestamp)objs[0];
                Timestamp tEndTime = (Timestamp)objs[1];
                long workTime = Long.valueOf(objs[2].toString());
                if (tStartTime.compareTo(tEndTime) > 0) {
                    returnCTEs.remove(index);
                    continue;
                }
                if (tEndTime.getTime() - tStartTime.getTime() != workTime) {
                    returnCTEs.remove(index);
                    continue;
                }
                if (startTime.compareTo(tStartTime) >= 0 && startTime.compareTo(tEndTime) <= 0 && endTime.compareTo(tStartTime) >= 0 && endTime.compareTo(tEndTime) <= 0) {
                    return returnCTEs;
                }
                if (startTime.compareTo(tStartTime) >= 0 && startTime.compareTo(tEndTime) <= 0) {
                    returnCTEs.remove(index);
                    returnCTEs.add(new Object[]{tStartTime, endTime, endTime.getTime() - tStartTime.getTime()});
                    break;
                }
                if (endTime.compareTo(tStartTime) >= 0 && endTime.compareTo(tEndTime) <= 0) {
                    returnCTEs.remove(index);
                    returnCTEs.add(new Object[]{startTime, tEndTime, tEndTime.getTime() - startTime.getTime()});
                    break;
                }
                returnCTEs.add(new Object[]{startTime, endTime, endTime.getTime() - startTime.getTime()});
                break;
            }
        }
        return returnCTEs;
    }

    public static List cteSort(List ctes) {
        cteComparator comp = new cteComparator();
        Collections.sort(ctes, comp);
        return ctes;
    }

    public static long getCTWorkTime(List ctes) {
        long workTime = 0L;
        if (ctes == null || ctes.size() == 0) {
            return workTime;
        }
        int count = ctes.size();
        for (int index = count - 1; index >= 0; --index) {
            if (ctes.get(index) == null || !(ctes.get(index) instanceof Object[])) {
                ctes.remove(index);
                continue;
            }
            Object[] objs = (Object[])ctes.get(index);
            if (objs.length != 3) {
                ctes.remove(index);
                continue;
            }
            if (!(objs[0] != null && Timestamp.class.getName().equals(objs[0].getClass().getName()) && objs[1] != null && Timestamp.class.getName().equals(objs[1].getClass().getName()) && objs[2] != null && Long.class.getName().equals(objs[2].getClass().getName()))) {
                ctes.remove(index);
                continue;
            }
            Timestamp tStartTime = (Timestamp)objs[0];
            Timestamp tEndTime = (Timestamp)objs[1];
            long tWorkTime = Long.valueOf(objs[2].toString());
            if (tStartTime.compareTo(tEndTime) > 0) {
                ctes.remove(index);
                continue;
            }
            if (tEndTime.getTime() - tStartTime.getTime() != tWorkTime) {
                ctes.remove(index);
                continue;
            }
            workTime += tWorkTime;
        }
        return workTime;
    }

    public static Timestamp getScheduleTime(Context ctx, Timestamp paramTime, long workTime, String ctID, String fcID, Map ctMaps) throws BOSException {
        if (paramTime == null) {
            return null;
        }
        Timestamp returnTime = new Timestamp(paramTime.getTime());
        if (workTime == 0L) {
            return returnTime;
        }
        try {
            Map ctMap = null;
            List ctes = null;
            long ctWorkTime = 0L;
            long workTimeDays = 0L;
            long days = 0L;
            long remainderWorkTime = 0L;
            StringBuffer sql = new StringBuffer();
            IRowSet rs = null;
            if (ctMaps != null && ctMaps.containsKey(ctID) && (ctMap = (Map)ctMaps.get(ctID)).get("ClassTeamWorkTime") != null && Long.class.getName().equals(ctMap.get("ClassTeamWorkTime").getClass().getName())) {
                ctWorkTime = Long.valueOf(ctMap.get("ClassTeamWorkTime").toString());
            }
            if (ctWorkTime == 0L) {
                ctWorkTime = 86400000L;
            }
            if (workTime > 0L) {
                workTimeDays = (workTime - workTime % ctWorkTime) / ctWorkTime;
            } else if (workTime < 0L) {
                workTimeDays = (workTime * -1L - workTime * -1L % ctWorkTime) / ctWorkTime;
            }
            if (workTimeDays > 0L) {
                sql.setLength(0);
                sql.append("Select\r\n");
                sql.append("FWorkDate \"FWorkDate\"\r\n");
                sql.append("From T_MM_FactoryCalendarEntry \r\n");
                sql.append("Where\r\n");
                sql.append("FParentID='").append(fcID).append("'\r\n");
                sql.append("And (\r\n");
                sql.append("FDateType=").append(1).append("\r\n");
                sql.append("Or FDateType=").append(4).append("\r\n");
                sql.append(")\r\n");
                if (workTime > 0L) {
                    sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')>='").append(sdfDate.format(returnTime)).append("'\r\n");
                    sql.append("Order By\r\n");
                    sql.append("FWorkDate ASC\r\n");
                } else if (workTime < 0L) {
                    sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')<='").append(sdfDate.format(returnTime)).append("'\r\n");
                    sql.append("Order By\r\n");
                    sql.append("FWorkDate DESC\r\n");
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs == null || rs.size() == 0) {
                    String strInfo = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.basedata.EMMEMBaseResource", (String)"JSHDCSSJ_INFO", (Object[])new Object[]{sdfDateTime.format(returnTime)});
                    throw new EASBizException(new NumericExceptionSubItem(JSSJ_FAIL, strInfo));
                }
                while (rs.next()) {
                    if (days == workTimeDays) {
                        returnTime.setTime(sdfDateTime.parse(sdfDate.format(rs.getDate("FWorkDate")) + " " + sdfTime.format(returnTime)).getTime());
                        break;
                    }
                    ++days;
                }
                if (days < workTimeDays) {
                    String strInfo = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.basedata.EMMEMBaseResource", (String)"JSHDCSSJ_INFO", (Object[])new Object[]{sdfDateTime.format(returnTime)});
                    throw new EASBizException(new NumericExceptionSubItem(JSSJ_FAIL, strInfo));
                }
            }
            if (workTime > 0L) {
                remainderWorkTime = workTime % ctWorkTime;
            } else if (workTime < 0L) {
                remainderWorkTime = workTime * -1L % ctWorkTime;
            }
            if (ctMap.get("ClassTeamEntryCollection") != null && ArrayList.class.getName().equals(ctMap.get("ClassTeamEntryCollection").getClass().getName())) {
                ctes = (List)ctMap.get("ClassTeamEntryCollection");
                Timestamp ctStartTime = (Timestamp)ctMap.get("ClassTeamStartTime");
                Timestamp ctEndTime = (Timestamp)ctMap.get("ClassTeamEndTime");
                ctStartTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(ctStartTime)).getTime());
                ctEndTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(ctEndTime)).getTime());
                if (ctes != null && ctes.size() > 0 && remainderWorkTime > 0L) {
                    long cteWorkTime;
                    Timestamp cteEndTime;
                    Timestamp cteStartTime;
                    Object[] objs;
                    int index;
                    if (workTime > 0L) {
                        for (index = 0; index < ctes.size() && remainderWorkTime > 0L; ++index) {
                            if (ctes.get(index) == null || !(ctes.get(index) instanceof Object[]) || (objs = (Object[])ctes.get(index)).length != 3 || objs[0] == null || !Timestamp.class.getName().equals(objs[0].getClass().getName()) || objs[1] == null || !Timestamp.class.getName().equals(objs[1].getClass().getName()) || objs[2] == null || !Long.class.getName().equals(objs[2].getClass().getName())) continue;
                            cteStartTime = new Timestamp(((Timestamp)objs[0]).getTime());
                            cteEndTime = new Timestamp(((Timestamp)objs[1]).getTime());
                            cteWorkTime = Long.valueOf(objs[2].toString());
                            if (cteStartTime.compareTo(cteEndTime) > 0 || cteEndTime.getTime() - cteStartTime.getTime() != cteWorkTime) continue;
                            cteStartTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(cteStartTime)).getTime());
                            cteEndTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(cteEndTime)).getTime());
                            if (returnTime.compareTo(cteEndTime) >= 0) continue;
                            if (returnTime.compareTo(cteStartTime) <= 0) {
                                if (cteWorkTime > remainderWorkTime) {
                                    returnTime.setTime(cteStartTime.getTime() + remainderWorkTime);
                                    remainderWorkTime = 0L;
                                    break;
                                }
                                remainderWorkTime -= cteWorkTime;
                                returnTime.setTime(cteEndTime.getTime());
                                continue;
                            }
                            if (cteEndTime.getTime() - returnTime.getTime() >= remainderWorkTime) {
                                returnTime.setTime(returnTime.getTime() + remainderWorkTime);
                                remainderWorkTime = 0L;
                                break;
                            }
                            remainderWorkTime -= cteEndTime.getTime() - returnTime.getTime();
                            returnTime.setTime(cteEndTime.getTime());
                        }
                        if (remainderWorkTime > 0L) {
                            returnTime.setTime(ctStartTime.getTime() + 86400000L);
                            for (index = 0; index < ctes.size() && remainderWorkTime > 0L; ++index) {
                                if (ctes.get(index) == null || !(ctes.get(index) instanceof Object[]) || (objs = (Object[])ctes.get(index)).length != 3 || objs[0] == null || !Timestamp.class.getName().equals(objs[0].getClass().getName()) || objs[1] == null || !Timestamp.class.getName().equals(objs[1].getClass().getName()) || objs[2] == null || !Long.class.getName().equals(objs[2].getClass().getName())) continue;
                                cteStartTime = new Timestamp(((Timestamp)objs[0]).getTime());
                                cteEndTime = new Timestamp(((Timestamp)objs[1]).getTime());
                                cteWorkTime = Long.valueOf(objs[2].toString());
                                if (cteStartTime.compareTo(cteEndTime) > 0 || cteEndTime.getTime() - cteStartTime.getTime() != cteWorkTime) continue;
                                cteStartTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(cteStartTime)).getTime());
                                cteEndTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(cteEndTime)).getTime());
                                if (returnTime.compareTo(cteEndTime) >= 0) continue;
                                if (returnTime.compareTo(cteStartTime) <= 0) {
                                    if (cteWorkTime > remainderWorkTime) {
                                        returnTime.setTime(cteStartTime.getTime() + remainderWorkTime);
                                        remainderWorkTime = 0L;
                                        break;
                                    }
                                    remainderWorkTime -= cteWorkTime;
                                    returnTime.setTime(cteEndTime.getTime());
                                    continue;
                                }
                                if (cteEndTime.getTime() - returnTime.getTime() >= remainderWorkTime) {
                                    returnTime.setTime(returnTime.getTime() + remainderWorkTime);
                                    remainderWorkTime = 0L;
                                    break;
                                }
                                remainderWorkTime -= cteEndTime.getTime() - returnTime.getTime();
                                returnTime.setTime(cteEndTime.getTime());
                            }
                        }
                    } else if (workTime < 0L) {
                        for (index = ctes.size() - 1; index >= 0 && remainderWorkTime > 0L; --index) {
                            if (ctes.get(index) == null || !(ctes.get(index) instanceof Object[]) || (objs = (Object[])ctes.get(index)).length != 3 || objs[0] == null || !Timestamp.class.getName().equals(objs[0].getClass().getName()) || objs[1] == null || !Timestamp.class.getName().equals(objs[1].getClass().getName()) || objs[2] == null || !Long.class.getName().equals(objs[2].getClass().getName())) continue;
                            cteStartTime = new Timestamp(((Timestamp)objs[0]).getTime());
                            cteEndTime = new Timestamp(((Timestamp)objs[1]).getTime());
                            cteWorkTime = Long.valueOf(objs[2].toString());
                            if (cteStartTime.compareTo(cteEndTime) > 0 || cteEndTime.getTime() - cteStartTime.getTime() != cteWorkTime) continue;
                            cteStartTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(cteStartTime)).getTime());
                            cteEndTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(cteEndTime)).getTime());
                            if (returnTime.compareTo(cteStartTime) <= 0) continue;
                            if (returnTime.compareTo(cteEndTime) >= 0) {
                                if (cteWorkTime > remainderWorkTime) {
                                    returnTime.setTime(cteEndTime.getTime() - remainderWorkTime);
                                    remainderWorkTime = 0L;
                                    break;
                                }
                                remainderWorkTime -= cteWorkTime;
                                returnTime.setTime(cteStartTime.getTime());
                                continue;
                            }
                            if (returnTime.getTime() - cteStartTime.getTime() >= remainderWorkTime) {
                                returnTime.setTime(returnTime.getTime() - remainderWorkTime);
                                remainderWorkTime = 0L;
                                break;
                            }
                            remainderWorkTime -= returnTime.getTime() - cteStartTime.getTime();
                            returnTime.setTime(cteStartTime.getTime());
                        }
                        if (remainderWorkTime > 0L) {
                            returnTime.setTime(ctEndTime.getTime() - 86400000L);
                            for (index = ctes.size() - 1; index >= 0 && remainderWorkTime > 0L; --index) {
                                if (ctes.get(index) == null || !(ctes.get(index) instanceof Object[]) || (objs = (Object[])ctes.get(index)).length != 3 || objs[0] == null || !Timestamp.class.getName().equals(objs[0].getClass().getName()) || objs[1] == null || !Timestamp.class.getName().equals(objs[1].getClass().getName()) || objs[2] == null || !Long.class.getName().equals(objs[2].getClass().getName())) continue;
                                cteStartTime = new Timestamp(((Timestamp)objs[0]).getTime());
                                cteEndTime = new Timestamp(((Timestamp)objs[1]).getTime());
                                cteWorkTime = Long.valueOf(objs[2].toString());
                                if (cteStartTime.compareTo(cteEndTime) > 0 || cteEndTime.getTime() - cteStartTime.getTime() != cteWorkTime) continue;
                                cteStartTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(cteStartTime)).getTime());
                                cteEndTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(cteEndTime)).getTime());
                                if (returnTime.compareTo(cteStartTime) <= 0) continue;
                                if (returnTime.compareTo(cteEndTime) >= 0) {
                                    if (cteWorkTime > remainderWorkTime) {
                                        returnTime.setTime(cteEndTime.getTime() - remainderWorkTime);
                                        remainderWorkTime = 0L;
                                        break;
                                    }
                                    remainderWorkTime -= cteWorkTime;
                                    returnTime.setTime(cteStartTime.getTime());
                                    continue;
                                }
                                if (returnTime.getTime() - cteStartTime.getTime() >= remainderWorkTime) {
                                    returnTime.setTime(returnTime.getTime() - remainderWorkTime);
                                    remainderWorkTime = 0L;
                                    break;
                                }
                                remainderWorkTime -= returnTime.getTime() - cteStartTime.getTime();
                                returnTime.setTime(cteStartTime.getTime());
                            }
                        }
                    }
                } else {
                    returnTime.setTime(returnTime.getTime() + remainderWorkTime);
                }
            } else {
                returnTime.setTime(returnTime.getTime() + workTime);
            }
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("FWorkDate \"FWorkDate\"\r\n");
            sql.append("From T_MM_FactoryCalendarEntry \r\n");
            sql.append("Where\r\n");
            sql.append("FParentID='").append(fcID).append("'\r\n");
            sql.append("And (\r\n");
            sql.append("FDateType=").append(1).append("\r\n");
            sql.append("Or FDateType=").append(4).append("\r\n");
            sql.append(")\r\n");
            if (workTime > 0L) {
                sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')>='").append(sdfDate.format(returnTime)).append("'\r\n");
                sql.append("Order By\r\n");
                sql.append("FWorkDate ASC\r\n");
            } else if (workTime < 0L) {
                sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')<='").append(sdfDate.format(returnTime)).append("'\r\n");
                sql.append("Order By\r\n");
                sql.append("FWorkDate DESC\r\n");
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null || rs.size() == 0) {
                String strInfo = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.basedata.EMMEMBaseResource", (String)"JSHDCSSJ_INFO", (Object[])new Object[]{sdfDateTime.format(returnTime)});
                throw new EASBizException(new NumericExceptionSubItem(JSSJ_FAIL, strInfo));
            }
            while (rs.next()) {
                if (rs.getDate("FWorkDate") == null) continue;
                returnTime.setTime(sdfDateTime.parse(sdfDate.format(rs.getDate("FWorkDate")) + " " + sdfTime.format(returnTime)).getTime());
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnTime;
    }

    public static Map reloadCT(Context ctx, String ctID, Map ctMaps) throws BOSException, EASBizException {
        HashMap returnCTMaps = new HashMap();
        if (ctMaps != null) {
            returnCTMaps.putAll(ctMaps);
        }
        if (returnCTMaps.containsKey(ctID)) {
            return returnCTMaps;
        }
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("number"));
        ClassTeamInfo ctInfo = ClassTeamFactory.getLocalInstance((Context)ctx).getClassTeamInfo((IObjectPK)new ObjectUuidPK(ctID), selectorItemCollection);
        if (ctInfo == null) {
            return returnCTMaps;
        }
        String ctNumber = ctInfo.getNumber() == null ? "" : ctInfo.getNumber();
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("CTE.FNumber \"FCTENumber\",\r\n");
        sql.append("CTE.FStartTime \"FCTEStartTime\",\r\n");
        sql.append("CTE.FEndTime \"FCTEndTime\",\r\n");
        sql.append("CTE.FStartRestTime \"FCTERestStartTime\",\r\n");
        sql.append("CTE.FEndRestTime \"FCTERestEndTime\"\r\n");
        sql.append("From T_MM_ClassTeamEntry CTE\r\n");
        sql.append("Where\r\n");
        sql.append("CTE.FParentID='").append(ctID).append("'\r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs == null || rs.size() == 0) {
            String strInfo = EASResource.getString((String)RESURL, (String)"BZMYSZFL_INFO", (Object[])new Object[]{ctNumber});
            throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
        }
        int index = 0;
        List ctes = new ArrayList();
        try {
            while (rs.next()) {
                ++index;
                String cteNumber = rs.getString("FCTENumber");
                Timestamp cteStartTime = rs.getTimestamp("FCTEStartTime");
                Timestamp cteEndTime = rs.getTimestamp("FCTEndTime");
                Timestamp cteRStartTime = rs.getTimestamp("FCTERestStartTime");
                Timestamp cteREndTime = rs.getTimestamp("FCTERestEndTime");
                if (cteNumber == null) {
                    String strInfo = EASResource.getString((String)RESURL, (String)"BCMYSZBM_INFO", (Object[])new Object[]{ctNumber, index});
                    throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
                }
                if (cteStartTime == null) {
                    String strInfo = EASResource.getString((String)RESURL, (String)"BCMYSZKSSJ_INFO", (Object[])new Object[]{ctNumber, cteNumber});
                    throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
                }
                if (cteEndTime == null) {
                    String strInfo = EASResource.getString((String)RESURL, (String)"BCMYSZJSSJ_INFO", (Object[])new Object[]{ctNumber, cteNumber});
                    throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
                }
                if (cteStartTime.compareTo(cteEndTime) > 0) {
                    String strInfo = EASResource.getString((String)RESURL, (String)"BCKSSJDYJSSJ_INFO", (Object[])new Object[]{ctNumber, cteNumber});
                    throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
                }
                if (cteRStartTime != null && cteREndTime != null) {
                    if (cteRStartTime.compareTo(cteREndTime) > 0) {
                        String strInfo = EASResource.getString((String)RESURL, (String)"BCXXKSSJDYXXJSSJ_INFO", (Object[])new Object[]{ctNumber, cteNumber});
                        throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
                    }
                    if (cteRStartTime.compareTo(cteStartTime) <= 0 && cteREndTime.compareTo(cteEndTime) >= 0) {
                        String strInfo = EASResource.getString((String)RESURL, (String)"BCSJWQZXXSJDN_INFO", (Object[])new Object[]{ctNumber, cteNumber});
                        throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
                    }
                    if (cteREndTime.compareTo(cteStartTime) <= 0 || cteRStartTime.compareTo(cteEndTime) >= 0) {
                        cteRStartTime = null;
                        cteREndTime = null;
                    } else if (cteRStartTime.compareTo(cteStartTime) <= 0 && cteREndTime.compareTo(cteStartTime) >= 0) {
                        cteStartTime.setTime(cteREndTime.getTime());
                        cteRStartTime = null;
                        cteREndTime = null;
                    } else if (cteRStartTime.compareTo(cteEndTime) < 0 && cteREndTime.compareTo(cteEndTime) > 0) {
                        cteEndTime.setTime(cteRStartTime.getTime());
                        cteRStartTime = null;
                        cteREndTime = null;
                    }
                } else {
                    cteRStartTime = null;
                    cteREndTime = null;
                }
                if (cteRStartTime != null && cteREndTime != null && cteRStartTime.compareTo(cteREndTime) < 0) {
                    ctes = OperationScheduleUtils.cteAddItem(cteStartTime, cteRStartTime, ctes);
                    ctes = OperationScheduleUtils.cteAddItem(cteREndTime, cteEndTime, ctes);
                    continue;
                }
                ctes = OperationScheduleUtils.cteAddItem(cteStartTime, cteEndTime, ctes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long ctWorkTime = OperationScheduleUtils.getCTWorkTime(ctes);
        if (ctWorkTime == 0L) {
            String strInfo = EASResource.getString((String)RESURL, (String)"BZGZSCWL_INFO", (Object[])new Object[]{ctNumber});
            throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
        }
        ctes = OperationScheduleUtils.cteSort(ctes);
        Timestamp ctStartTime = null;
        Timestamp ctEndTime = null;
        int count = ctes == null || ctes.size() == 0 ? 0 : ctes.size();
        int validRow = 0;
        for (index = count - 1; index >= 0; --index) {
            if (ctes.get(index) == null || !(ctes.get(index) instanceof Object[])) {
                ctes.remove(index);
                continue;
            }
            Object[] objs = (Object[])ctes.get(index);
            if (objs.length != 3) {
                ctes.remove(index);
                continue;
            }
            if (!(objs[0] != null && Timestamp.class.getName().equals(objs[0].getClass().getName()) && objs[1] != null && Timestamp.class.getName().equals(objs[1].getClass().getName()) && objs[2] != null && Long.class.getName().equals(objs[2].getClass().getName()))) {
                ctes.remove(index);
                continue;
            }
            Timestamp cteStartTime = new Timestamp(((Timestamp)objs[0]).getTime());
            Timestamp cteEndTime = new Timestamp(((Timestamp)objs[1]).getTime());
            long cteWorkTime = Long.valueOf(objs[2].toString());
            if (cteStartTime.compareTo(cteEndTime) > 0) {
                ctes.remove(index);
                continue;
            }
            if (cteEndTime.getTime() - cteStartTime.getTime() != cteWorkTime) {
                ctes.remove(index);
                continue;
            }
            if (++validRow == 1) {
                ctEndTime = new Timestamp(cteEndTime.getTime());
            }
            if (ctStartTime == null) {
                ctStartTime = new Timestamp(cteStartTime.getTime());
                continue;
            }
            if (ctStartTime.compareTo(cteStartTime) <= 0) continue;
            ctStartTime.setTime(cteStartTime.getTime());
        }
        HashMap<String, Object> ctMap = new HashMap<String, Object>();
        ctMap.put("ClassTeamNumber", ctNumber);
        ctMap.put("ClassTeamWorkTime", ctWorkTime);
        ctMap.put("ClassTeamEntryCollection", ctes);
        ctMap.put("ClassTeamStartTime", ctStartTime);
        ctMap.put("ClassTeamEndTime", ctEndTime);
        returnCTMaps.put(ctID, ctMap);
        return returnCTMaps;
    }

    public static Map reloadCTNew(Context ctx, String ctID, Map ctMaps) throws BOSException, EASBizException {
        HashMap returnCTMaps = new HashMap();
        if (ctMaps != null) {
            returnCTMaps.putAll(ctMaps);
        }
        if (returnCTMaps.containsKey(ctID)) {
            return returnCTMaps;
        }
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("number"));
        ClassTeamInfo ctInfo = ClassTeamFactory.getLocalInstance((Context)ctx).getClassTeamInfo((IObjectPK)new ObjectUuidPK(ctID), selectorItemCollection);
        if (ctInfo == null) {
            return returnCTMaps;
        }
        String ctNumber = ctInfo.getNumber() == null ? "" : ctInfo.getNumber();
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("CTE.FNumber \"FCTENumber\",\r\n");
        sql.append("CTE.FStartTime \"FCTEStartTime\",\r\n");
        sql.append("CTE.FEndTime \"FCTEndTime\",\r\n");
        sql.append("CTE.FStartRestTime \"FCTERestStartTime\",\r\n");
        sql.append("CTE.FEndRestTime \"FCTERestEndTime\"\r\n");
        sql.append("From T_MM_ClassTeamEntry CTE\r\n");
        sql.append("Where\r\n");
        sql.append("CTE.FParentID='").append(ctID).append("'\r\n");
        sql.append("order by CTE.FStartTime ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs == null || rs.size() == 0) {
            String strInfo = EASResource.getString((String)RESURL, (String)"BZMYSZFL_INFO", (Object[])new Object[]{ctNumber});
            throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
        }
        int index = 0;
        List ctes = new ArrayList();
        long deviation = 0L;
        try {
            while (rs.next()) {
                String strInfo;
                ++index;
                String cteNumber = rs.getString("FCTENumber");
                Timestamp cteStartTime = rs.getTimestamp("FCTEStartTime");
                Timestamp cteEndTime = rs.getTimestamp("FCTEndTime");
                Timestamp cteRStartTime = rs.getTimestamp("FCTERestStartTime");
                Timestamp cteREndTime = rs.getTimestamp("FCTERestEndTime");
                if (cteNumber == null) {
                    strInfo = EASResource.getString((String)RESURL, (String)"BCMYSZBM_INFO", (Object[])new Object[]{ctNumber, index});
                    throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
                }
                if (cteStartTime == null) {
                    strInfo = EASResource.getString((String)RESURL, (String)"BCMYSZKSSJ_INFO", (Object[])new Object[]{ctNumber, cteNumber});
                    throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
                }
                if (cteEndTime == null) {
                    strInfo = EASResource.getString((String)RESURL, (String)"BCMYSZJSSJ_INFO", (Object[])new Object[]{ctNumber, cteNumber});
                    throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
                }
                if (index == 1 && cteStartTime != null) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date d1 = df.parse("1970-1-1 00:00:00");
                    deviation = cteStartTime.getTime() - d1.getTime();
                }
                cteStartTime = new Timestamp(cteStartTime.getTime() - deviation);
                if ((cteEndTime = new Timestamp(cteEndTime.getTime() - deviation)).getDate() == 31) {
                    cteEndTime = new Timestamp(cteEndTime.getTime() + 86400000L);
                }
                if (cteStartTime.compareTo(cteEndTime) > 0) {
                    strInfo = EASResource.getString((String)RESURL, (String)"BCKSSJDYJSSJ_INFO", (Object[])new Object[]{ctNumber, cteNumber});
                    throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
                }
                if (cteRStartTime != null && cteREndTime != null) {
                    cteRStartTime = new Timestamp(cteRStartTime.getTime() - deviation);
                    if ((cteREndTime = new Timestamp(cteREndTime.getTime() - deviation)).getDate() == 31) {
                        cteREndTime = new Timestamp(cteREndTime.getTime() + 86400000L);
                    }
                    if (cteRStartTime.getDate() == 31) {
                        cteRStartTime = new Timestamp(cteRStartTime.getTime() + 86400000L);
                    }
                    if (cteRStartTime.compareTo(cteREndTime) > 0) {
                        strInfo = EASResource.getString((String)RESURL, (String)"BCXXKSSJDYXXJSSJ_INFO", (Object[])new Object[]{ctNumber, cteNumber});
                        throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
                    }
                    if (cteRStartTime.compareTo(cteStartTime) <= 0 && cteREndTime.compareTo(cteEndTime) >= 0) {
                        strInfo = EASResource.getString((String)RESURL, (String)"BCSJWQZXXSJDN_INFO", (Object[])new Object[]{ctNumber, cteNumber});
                        throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
                    }
                    if (cteREndTime.compareTo(cteStartTime) <= 0 || cteRStartTime.compareTo(cteEndTime) >= 0) {
                        cteRStartTime = null;
                        cteREndTime = null;
                    } else if (cteRStartTime.compareTo(cteStartTime) <= 0 && cteREndTime.compareTo(cteStartTime) >= 0) {
                        cteStartTime.setTime(cteREndTime.getTime());
                        cteRStartTime = null;
                        cteREndTime = null;
                    } else if (cteRStartTime.compareTo(cteEndTime) < 0 && cteREndTime.compareTo(cteEndTime) > 0) {
                        cteEndTime.setTime(cteRStartTime.getTime());
                        cteRStartTime = null;
                        cteREndTime = null;
                    }
                } else {
                    cteRStartTime = null;
                    cteREndTime = null;
                }
                if (cteRStartTime != null && cteREndTime != null && cteRStartTime.compareTo(cteREndTime) < 0) {
                    ctes = OperationScheduleUtils.cteAddItem(cteStartTime, cteRStartTime, ctes);
                    ctes = OperationScheduleUtils.cteAddItem(cteREndTime, cteEndTime, ctes);
                    continue;
                }
                ctes = OperationScheduleUtils.cteAddItem(cteStartTime, cteEndTime, ctes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long ctWorkTime = OperationScheduleUtils.getCTWorkTime(ctes);
        if (ctWorkTime == 0L) {
            String strInfo = EASResource.getString((String)RESURL, (String)"BZGZSCWL_INFO", (Object[])new Object[]{ctNumber});
            throw new EASBizException(new NumericExceptionSubItem(CZBZXX_FAIL, strInfo));
        }
        ctes = OperationScheduleUtils.cteSort(ctes);
        Timestamp ctStartTime = null;
        Timestamp ctEndTime = null;
        int count = ctes == null || ctes.size() == 0 ? 0 : ctes.size();
        int validRow = 0;
        for (index = count - 1; index >= 0; --index) {
            if (ctes.get(index) == null || !(ctes.get(index) instanceof Object[])) {
                ctes.remove(index);
                continue;
            }
            Object[] objs = (Object[])ctes.get(index);
            if (objs.length != 3) {
                ctes.remove(index);
                continue;
            }
            if (!(objs[0] != null && Timestamp.class.getName().equals(objs[0].getClass().getName()) && objs[1] != null && Timestamp.class.getName().equals(objs[1].getClass().getName()) && objs[2] != null && Long.class.getName().equals(objs[2].getClass().getName()))) {
                ctes.remove(index);
                continue;
            }
            Timestamp cteStartTime = new Timestamp(((Timestamp)objs[0]).getTime());
            Timestamp cteEndTime = new Timestamp(((Timestamp)objs[1]).getTime());
            long cteWorkTime = Long.valueOf(objs[2].toString());
            if (cteStartTime.compareTo(cteEndTime) > 0) {
                ctes.remove(index);
                continue;
            }
            if (cteEndTime.getTime() - cteStartTime.getTime() != cteWorkTime) {
                ctes.remove(index);
                continue;
            }
            if (++validRow == 1) {
                ctEndTime = new Timestamp(cteEndTime.getTime());
            }
            if (ctStartTime == null) {
                ctStartTime = new Timestamp(cteStartTime.getTime());
                continue;
            }
            if (ctStartTime.compareTo(cteStartTime) <= 0) continue;
            ctStartTime.setTime(cteStartTime.getTime());
        }
        HashMap<String, Object> ctMap = new HashMap<String, Object>();
        ctMap.put("ClassTeamNumber", ctNumber);
        ctMap.put("ClassTeamWorkTime", ctWorkTime);
        ctMap.put("ClassTeamEntryCollection", ctes);
        ctMap.put("ClassTeamStartTime", ctStartTime);
        ctMap.put("ClassTeamEndTime", ctEndTime);
        ctMap.put("deviation", deviation);
        returnCTMaps.put(ctID, ctMap);
        return returnCTMaps;
    }

    public static Timestamp timeUpdate(Context ctx, Timestamp paramTime, int updateWay, String ctID, String fcID, Map ctMaps) throws BOSException {
        if (paramTime == null) {
            return null;
        }
        if (updateWay != 0 && updateWay != 1) {
            return paramTime;
        }
        Timestamp returnTime = new Timestamp(paramTime.getTime());
        try {
            Map ctMap = null;
            Timestamp ctStartTime = null;
            Timestamp ctEndTime = null;
            List ctes = null;
            if (ctMaps != null && ctMaps.containsKey(ctID)) {
                ctMap = (Map)ctMaps.get(ctID);
            }
            if (ctMap != null) {
                if (ctMap.containsKey("ClassTeamNumber") && ctMap.get("ClassTeamNumber") != null) {
                    ctMap.get("ClassTeamNumber").toString();
                }
                if (ctMap.get("ClassTeamEntryCollection") != null && ArrayList.class.getName().equals(ctMap.get("ClassTeamEntryCollection").getClass().getName())) {
                    ctes = (List)ctMap.get("ClassTeamEntryCollection");
                }
                if (ctMap.containsKey("ClassTeamStartTime") && ctMap.get("ClassTeamStartTime") != null && Timestamp.class.getName().equals(ctMap.get("ClassTeamStartTime").getClass().getName())) {
                    ctStartTime = new Timestamp(((Timestamp)ctMap.get("ClassTeamStartTime")).getTime());
                }
                if (ctMap.containsKey("ClassTeamEndTime") && ctMap.get("ClassTeamEndTime") != null && Timestamp.class.getName().equals(ctMap.get("ClassTeamEndTime").getClass().getName())) {
                    ctEndTime = new Timestamp(((Timestamp)ctMap.get("ClassTeamEndTime")).getTime());
                }
                ctStartTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(ctStartTime)).getTime());
                ctEndTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(ctEndTime)).getTime());
            }
            if (ctes != null && ctes.size() > 0 && ctStartTime != null && ctEndTime != null) {
                Timestamp updateTime = null;
                for (int index = 0; index < ctes.size(); ++index) {
                    Object[] objs;
                    if (ctes.get(index) == null || !(ctes.get(index) instanceof Object[]) || (objs = (Object[])ctes.get(index)).length != 3 || objs[0] == null || !Timestamp.class.getName().equals(objs[0].getClass().getName()) || objs[1] == null || !Timestamp.class.getName().equals(objs[1].getClass().getName()) || objs[2] == null || !Long.class.getName().equals(objs[2].getClass().getName())) continue;
                    Timestamp cteStartTime = new Timestamp(((Timestamp)objs[0]).getTime());
                    Timestamp cteEndTime = new Timestamp(((Timestamp)objs[1]).getTime());
                    long cteWorkTime = Long.valueOf(objs[2].toString());
                    if (cteStartTime.compareTo(cteEndTime) > 0 || cteEndTime.getTime() - cteStartTime.getTime() != cteWorkTime) continue;
                    cteStartTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(cteStartTime)).getTime());
                    cteEndTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(cteEndTime)).getTime());
                    if (updateWay == 0) {
                        if (returnTime.compareTo(cteEndTime) >= 0) {
                            if (returnTime.compareTo(ctEndTime) < 0) continue;
                            updateTime = new Timestamp(ctStartTime.getTime() + 86400000L);
                            break;
                        }
                        if (returnTime.compareTo(cteStartTime) < 0) {
                            updateTime = new Timestamp(cteStartTime.getTime());
                            break;
                        }
                        updateTime = new Timestamp(returnTime.getTime());
                        break;
                    }
                    if (updateWay != 1) break;
                    if (returnTime.compareTo(cteEndTime) > 0) {
                        updateTime = new Timestamp(cteEndTime.getTime());
                        continue;
                    }
                    if (returnTime.compareTo(cteStartTime) <= 0) {
                        if (returnTime.compareTo(ctStartTime) > 0) break;
                        updateTime = new Timestamp(ctEndTime.getTime() - 86400000L);
                        break;
                    }
                    updateTime = new Timestamp(returnTime.getTime());
                    break;
                }
                if (updateTime == null) {
                    returnTime = null;
                } else {
                    returnTime.setTime(updateTime.getTime());
                }
            }
            if (returnTime == null) {
                return null;
            }
            if (fcID == null || fcID.trim().length() == 0) {
                return returnTime;
            }
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("FWorkDate \"FWorkDate\"\r\n");
            sql.append("From T_MM_FactoryCalendarEntry \r\n");
            sql.append("Where\r\n");
            sql.append("FParentID='").append(fcID).append("'\r\n");
            sql.append("And (\r\n");
            sql.append("FDateType=").append(1).append("\r\n");
            sql.append("Or FDateType=").append(4).append("\r\n");
            sql.append(")\r\n");
            sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')='").append(sdfDate.format(returnTime)).append("'\r\n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null || rs.size() == 0) {
                if (updateWay == 0) {
                    if (ctStartTime != null) {
                        returnTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(ctStartTime)).getTime());
                    } else {
                        returnTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " 00:00:00").getTime());
                    }
                } else if (updateWay == 1) {
                    if (ctEndTime != null) {
                        returnTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " " + sdfTime.format(ctEndTime)).getTime());
                    } else {
                        returnTime.setTime(sdfDateTime.parse(sdfDate.format(returnTime) + " 23:59:59").getTime());
                    }
                }
            }
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("FWorkDate \"FWorkDate\"\r\n");
            sql.append("From T_MM_FactoryCalendarEntry \r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And FParentID='").append(fcID).append("'\r\n");
            sql.append("And FWorkDate Is Not Null\r\n");
            sql.append("And (\r\n");
            sql.append("FDateType=").append(1).append("\r\n");
            sql.append("Or FDateType=").append(4).append("\r\n");
            sql.append(")\r\n");
            if (updateWay == 0) {
                sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')>='").append(sdfDate.format(returnTime)).append("'\r\n");
                sql.append("Order By\r\n");
                sql.append("FWorkDate ASC\r\n");
            } else if (updateWay == 1) {
                sql.append("And To_CHAR(FWorkDate,'YYYY-MM-DD')<='").append(sdfDate.format(returnTime)).append("'\r\n");
                sql.append("Order By\r\n");
                sql.append("FWorkDate DESC\r\n");
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null || rs.size() == 0) {
                String strInfo = EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.basedata.EMMEMBaseResource", (String)"CSHDCSSJ_INFO", (Object[])new Object[]{sdfDateTime.format(returnTime)});
                throw new EASBizException(new NumericExceptionSubItem(GXCSSJ_FAIL, strInfo));
            }
            rs.next();
            returnTime.setTime(sdfDateTime.parse(sdfDate.format(rs.getDate("FWorkDate")) + " " + sdfTime.format(returnTime)).getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnTime;
    }

    public static class cteComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            try {
                if (o1 == null || !(o1 instanceof Object[]) || o2 == null || !(o2 instanceof Object[])) {
                    throw new BOSException("Object Is Null Or Object Not Is Object[]");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Object[] objs1 = null;
            Object[] objs2 = null;
            objs1 = (Object[])o1;
            objs2 = (Object[])o2;
            try {
                if (objs1.length != 3) {
                    throw new BOSException("Object Length Not Equal 3");
                }
                if (objs2.length != 3) {
                    throw new BOSException("Object Length Not Equal 3");
                }
                if (!(objs1[0] != null && Timestamp.class.getName().equals(objs1[0].getClass().getName()) && objs1[1] != null && Timestamp.class.getName().equals(objs1[1].getClass().getName()) && objs1[2] != null && Long.class.getName().equals(objs1[2].getClass().getName()))) {
                    throw new BOSException("Object Content Invalid");
                }
                if (!(objs2[0] != null && Timestamp.class.getName().equals(objs2[0].getClass().getName()) && objs2[1] != null && Timestamp.class.getName().equals(objs2[1].getClass().getName()) && objs2[2] != null && Long.class.getName().equals(objs2[2].getClass().getName()))) {
                    throw new BOSException("Object Content Invalid");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Timestamp startTime1 = (Timestamp)objs1[0];
            Timestamp startTime2 = (Timestamp)objs2[0];
            if (startTime1.compareTo(startTime2) >= 0) {
                return 1;
            }
            return 0;
        }
    }
}

