/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.cm.util.SCMGroupClientUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.industry.emm.mm.basedata.EquipmentInfo;
import com.kingdee.eas.industry.emm.mm.basedata.IEquipment;
import com.kingdee.eas.industry.emm.mm.basedata.client.AbstractEquipmentEditUI;
import com.kingdee.eas.mm.basedata.MMBasedataStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class EquipmentEditUI
extends AbstractEquipmentEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EquipmentEditUI.class);
    private String RESURL = "com.kingdee.eas.industry.emm.mm.EMMEMAnalyResource";
    private String SBBKYXG_INFO = EASResource.getString((String)this.RESURL, (String)"SBBKYXG_INFO");
    private String BM_NAME = EASResource.getString((String)this.RESURL, (String)"BM_NAME");
    private String MC_NAME = EASResource.getString((String)this.RESURL, (String)"MC_NAME");
    private String CUZZ_NAME = EASResource.getString((String)this.RESURL, (String)"CUZZ_NAME");
    private String XLSBCNDY_NAME = EASResource.getString((String)this.RESURL, (String)"XLSBCNDY_NAME");
    private String RCNBNCG_INFO = EASResource.getString((String)this.RESURL, (String)"RCNBNCG_INFO");

    public EquipmentEditUI() throws Exception {
        this.setUITitle(this.XLSBCNDY_NAME);
        this.prmtstorageOrgUnit.setEnabled(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IEquipment ie = (IEquipment)this.getBizInterface();
        if (ie.exists("where id = '" + this.editData.getId().toString() + "' and status = " + 20)) {
            throw new EASBizException(new NumericExceptionSubItem("", MMBasedataStatusEnum.OPEN.getAlias() + this.SBBKYXG_INFO));
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        if (UIRuleUtil.isNull((String)this.txtNumber.getText())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.BM_NAME});
        }
        if (UIRuleUtil.isNull((Object)this.txtName.getItemDataByLang(new LanguageInfo(SysContext.getSysContext().getLocale())))) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.MC_NAME});
        }
        if (UIRuleUtil.isNull((Object)this.prmtstorageOrgUnit.getData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this.CUZZ_NAME});
        }
        super.beforeStoreFields(arg0);
    }

    @Override
    public void loadFields() {
        Object o;
        super.loadFields();
        if (this.getOprtState() == "ADDNEW" || this.getOprtState() == "EDIT") {
            this.status.setSelectedItem((Object)MMBasedataStatusEnum.SAVED);
        }
        if (this.getOprtState() == "VIEW" && (o = this.status.getSelectedItem()) != null && MMBasedataStatusEnum.class.isInstance(o)) {
            if (MMBasedataStatusEnum.OPEN.equals(o)) {
                this.actionCancel.setEnabled(true);
                this.actionCancelCancel.setEnabled(false);
            } else {
                this.actionCancel.setEnabled(false);
                this.actionCancelCancel.setEnabled(true);
            }
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.actionSave.setVisible(false);
        this.setUITitle(this.XLSBCNDY_NAME);
        this.txtcapacity.setHorizontalAlignment(4);
        this.setEntityViewInfo();
    }

    @Override
    protected IObjectValue createNewData() {
        EquipmentInfo objectValue = new EquipmentInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage")).getBoolean("isBizUnit")) {
            objectValue.put("storageOrgUnit", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage")));
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        BigDecimal capacity = this.txtcapacity.getBigDecimalValue();
        if (capacity != null && capacity.compareTo(new BigDecimal("24")) > 0) {
            MsgBox.showWarning((String)this.RCNBNCG_INFO);
            SysUtil.abort();
        }
    }

    private void setEntityViewInfo() throws EASBizException, BOSException {
        FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (String)"Equipment_addNew");
        StorageOrgUnitInfo info = null;
        StorageOrgUnitInfo storageOrgInfo = SysContext.getSysContext().getCurrentStorageUnit();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        ArrayList<String> numberLs = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            info = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(collection.get(i).getId().toString()));
            keys.add(collection.get(i).getId().toString());
            String number = info.getNumber();
            numberLs.add(number);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtstorageOrgUnit.setEntityViewInfo(view);
    }
}

