/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.industry.emm.mm.client.AbstractCompleteQuotaAnalysisFilterUI;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.zjbom.PdmEasCarnoEqualSetCollection;
import com.kingdee.eas.zjbom.PdmEasCarnoEqualSetFactory;
import com.kingdee.eas.zjbom.PdmEasCarnoEqualSetInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class CompleteQuotaAnalysisFilterUI
extends AbstractCompleteQuotaAnalysisFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CompleteQuotaAnalysisFilterUI.class);
    private static final long serialVersionUID = -3501360113373445368L;
    private String RESURL = "com.kingdee.eas.industry.emm.mm.basedata.EMMEMBaseResource";
    private String DCWL_ISNOTNULL = EASResource.getString((String)this.RESURL, (String)"DCWL_ISNOTNULL");
    private String XMH_ISNOTNULL = EASResource.getString((String)this.RESURL, (String)"XMH_ISNOTNULL");
    private String KSGZH_ISNOTNULL = EASResource.getString((String)this.RESURL, (String)"KSGZH_ISNOTNULL");
    private String JSGZH_ISNOTNULL = EASResource.getString((String)this.RESURL, (String)"JSGZH_ISNOTNULL");
    private String MBCH_ISNOTNULL = EASResource.getString((String)this.RESURL, (String)"MBCH_ISNOTNULL");
    private String PC_ISNOTNULL = EASResource.getString((String)this.RESURL, (String)"PC_ISNOTNULL");
    private String QXZSJFZTJFS_INFO = EASResource.getString((String)this.RESURL, (String)"QXZSJFZTJFS_INFO");
    protected DocumentListener batchDocumentListener = null;
    protected PreChangeListener f7PreChangeListener = null;
    protected SelectorListener f7SelectorListener = null;

    public CompleteQuotaAnalysisFilterUI() throws Exception {
        this.isReport = true;
        this.getElementsInfo();
    }

    public void clear() {
        super.getFilterManager().clearAll();
        this.setDefaultValue();
        this.rbPurchaseData.setSelected(true);
        this.txtTopProcess.setEnabled(false);
    }

    public void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement topMaterialElement = new SingleFilterElement("topMaterial", (Component)this.prmtTopMaterial);
        topMaterialElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.DCWL_ISNOTNULL));
        elements.add((FilterElement)topMaterialElement);
        elements.add((FilterElement)new SingleFilterElement("batch", (Component)this.txtBatch));
        SingleFilterElement projectNumberElement = new SingleFilterElement("project.number", (Component)this.prmtProject);
        projectNumberElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.XMH_ISNOTNULL));
        elements.add((FilterElement)projectNumberElement);
        SingleFilterElement startTraceNumberElement = new SingleFilterElement("startTrace.number", (Component)this.prmtStartTrace);
        startTraceNumberElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.KSGZH_ISNOTNULL));
        elements.add((FilterElement)startTraceNumberElement);
        SingleFilterElement endTraceNumberElement = new SingleFilterElement("endTrace.number", (Component)this.prmtEndTrace);
        endTraceNumberElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.JSGZH_ISNOTNULL));
        elements.add((FilterElement)endTraceNumberElement);
        SingleFilterElement targetTraceNumberElement = new SingleFilterElement("targetTrace.number", (Component)this.prmtTargetTrace);
        targetTraceNumberElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, this.MBCH_ISNOTNULL));
        elements.add((FilterElement)targetTraceNumberElement);
        if (this.txtTopProcess.isEditable()) {
            SingleFilterElement topProcessElement = new SingleFilterElement("topProcess", (Component)this.txtTopProcess);
            elements.add((FilterElement)topProcessElement);
        }
        SingleFilterElement materialAttributeElement = new SingleFilterElement("materialAttribute", (Component)this.comboMaterialAttribute);
        elements.add((FilterElement)materialAttributeElement);
        SingleFilterElement purchaseDataElement = new SingleFilterElement("purchaseData", (Component)this.rbPurchaseData);
        elements.add((FilterElement)purchaseDataElement);
        SingleFilterElement manufactureDataElement = new SingleFilterElement("manufactureData", (Component)this.rbManufactureData);
        elements.add((FilterElement)manufactureDataElement);
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.addListener();
    }

    public boolean verify() {
        boolean result = super.verify();
        String batch = this.txtBatch.getText();
        if (batch == null) {
            MsgBox.showWarning((String)this.PC_ISNOTNULL);
            return false;
        }
        if (batch.trim().length() == 0) {
            MsgBox.showWarning((String)this.PC_ISNOTNULL);
            return false;
        }
        if (!this.rbPurchaseData.isSelected() && !this.rbManufactureData.isSelected()) {
            MsgBox.showWarning((String)this.QXZSJFZTJFS_INFO);
            return false;
        }
        return result;
    }

    protected void addListener() {
        if (this.f7PreChangeListener == null) {
            this.f7PreChangeListener = new PreChangeListener(){

                public void preChange(PreChangeEvent e) {
                    try {
                        CompleteQuotaAnalysisFilterUI.this.f7PreChange(e);
                    }
                    catch (Exception exc) {
                        CompleteQuotaAnalysisFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStartTrace.addPreChangeListener(this.f7PreChangeListener);
        this.prmtEndTrace.addPreChangeListener(this.f7PreChangeListener);
        this.prmtTargetTrace.addPreChangeListener(this.f7PreChangeListener);
        if (this.f7SelectorListener == null) {
            this.f7SelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        CompleteQuotaAnalysisFilterUI.this.f7WillShow(e);
                    }
                    catch (Exception exc) {
                        CompleteQuotaAnalysisFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStartTrace.addSelectorListener(this.f7SelectorListener);
        this.prmtEndTrace.addSelectorListener(this.f7SelectorListener);
        this.prmtTargetTrace.addSelectorListener(this.f7SelectorListener);
        if (this.batchDocumentListener == null) {
            this.batchDocumentListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    try {
                        CompleteQuotaAnalysisFilterUI.this.txtBatchDataChange(documentEvent);
                    }
                    catch (BOSException e) {
                        CompleteQuotaAnalysisFilterUI.this.handUIException(e);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    try {
                        CompleteQuotaAnalysisFilterUI.this.txtBatchDataChange(documentEvent);
                    }
                    catch (BOSException e) {
                        CompleteQuotaAnalysisFilterUI.this.handUIException(e);
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    try {
                        CompleteQuotaAnalysisFilterUI.this.txtBatchDataChange(documentEvent);
                    }
                    catch (BOSException e) {
                        CompleteQuotaAnalysisFilterUI.this.handUIException(e);
                    }
                }
            };
        }
        this.txtBatch.getDocument().addDocumentListener(this.batchDocumentListener);
    }

    protected void f7PreChange(PreChangeEvent e) throws BOSException {
        if (!KDBizPromptBox.class.getName().equals(e.getSource().getClass().getName())) {
            return;
        }
        String f7Name = ((KDBizPromptBox)e.getSource()).getName();
        if (this.prmtStartTrace.getName().equals(f7Name) || this.prmtEndTrace.getName().equals(f7Name) || this.prmtTargetTrace.getName().equals(f7Name)) {
            this.resetTraceEntityViewInfo(f7Name);
        }
    }

    protected void f7WillShow(SelectorEvent e) throws BOSException {
        if (!KDBizPromptBox.class.getName().equals(e.getSource().getClass().getName())) {
            return;
        }
        String f7Name = ((KDBizPromptBox)e.getSource()).getName();
        if (this.prmtStartTrace.getName().equals(f7Name) || this.prmtEndTrace.getName().equals(f7Name) || this.prmtTargetTrace.getName().equals(f7Name)) {
            this.resetTraceEntityViewInfo(f7Name);
        }
    }

    protected void rbButtonChanged(ActionEvent e) throws Exception {
        if (this.rbPurchaseData.isSelected()) {
            this.txtTopProcess.setEnabled(false);
        } else {
            this.txtTopProcess.setEnabled(true);
        }
    }

    @Override
    protected void rbManufactureDataSelected_actionPerformed(ActionEvent e) throws Exception {
        this.rbButtonChanged(e);
    }

    @Override
    protected void rbPurchaseDataSelected_actionPerformed(ActionEvent e) throws Exception {
        this.rbButtonChanged(e);
    }

    protected void resetTraceEntityViewInfo(String f7Name) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        ProjectInfo projectInfo = this.prmtProject.getValue() != null && this.prmtProject.getValue() instanceof ProjectInfo ? (ProjectInfo)this.prmtProject.getValue() : null;
        String projectNumber = null;
        if (projectInfo != null) {
            projectNumber = projectInfo.getNumber();
        } else {
            String string = projectNumber = this.prmtProject.getValue() != null ? this.prmtProject.getValue().toString() : null;
        }
        if (projectNumber != null && projectNumber.toString().trim().length() > 0) {
            sql.append("Select\r\n");
            sql.append("PC.FTrackNumberID\r\n");
            sql.append("From T_MM_Project P\r\n");
            sql.append("Inner Join T_MM_ProjectCar PC On PC.FProjectID=P.FID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And P.FNumber='").append(projectNumber).append("'");
            sql.append("Group By\r\n");
            sql.append("PC.FTrackNumberID\r\n");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        }
        if (filterInfo.getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
            entityViewInfo.setFilter(filterInfo);
        }
        if (this.prmtStartTrace.getName().equals(f7Name)) {
            this.prmtStartTrace.setEntityViewInfo(entityViewInfo);
            this.prmtStartTrace.getQueryAgent().resetRuntimeEntityView();
        } else if (this.prmtEndTrace.getName().equals(f7Name)) {
            this.prmtEndTrace.setEntityViewInfo(entityViewInfo);
            this.prmtEndTrace.getQueryAgent().resetRuntimeEntityView();
        } else if (this.prmtTargetTrace.getName().equals(f7Name)) {
            this.prmtTargetTrace.setEntityViewInfo(entityViewInfo);
            this.prmtTargetTrace.getQueryAgent().resetRuntimeEntityView();
        }
    }

    protected void txtBatchDataChange(DocumentEvent documentEvent) throws BOSException {
        String batch = this.txtBatch.getText();
        if (batch != null && batch.trim().length() > 0) {
            PdmEasCarnoEqualSetInfo pdmEasCarnoEqualSetInfo;
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("PMno");
            selectorItemCollection.add("EasCarno.id");
            selectorItemCollection.add("EasCarno.number");
            selectorItemCollection.add("EasCarno.name");
            selectorItemCollection.add("Easbegintracknumber.id");
            selectorItemCollection.add("Easbegintracknumber.number");
            selectorItemCollection.add("Easbegintracknumber.name");
            selectorItemCollection.add("Easendtracknumber.id");
            selectorItemCollection.add("Easendtracknumber.number");
            selectorItemCollection.add("Easendtracknumber.name");
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("Batch", (Object)batch, CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            entityViewInfo.setSelector(selectorItemCollection);
            PdmEasCarnoEqualSetCollection pdmEasCarnoEqualSetCollection = PdmEasCarnoEqualSetFactory.getRemoteInstance().getPdmEasCarnoEqualSetCollection(entityViewInfo);
            if (pdmEasCarnoEqualSetCollection != null && pdmEasCarnoEqualSetCollection.size() > 0 && (pdmEasCarnoEqualSetInfo = pdmEasCarnoEqualSetCollection.get(0)) != null) {
                String topMaterialNumber = pdmEasCarnoEqualSetInfo.getPMno();
                if (topMaterialNumber != null && topMaterialNumber.trim().length() > 0) {
                    SelectorItemCollection materialSelectorItemCollection = new SelectorItemCollection();
                    materialSelectorItemCollection.add("id");
                    materialSelectorItemCollection.add("number");
                    materialSelectorItemCollection.add("name");
                    filterInfo.getFilterItems().clear();
                    filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)topMaterialNumber, CompareType.EQUALS));
                    entityViewInfo.setFilter(filterInfo);
                    entityViewInfo.setSelector(materialSelectorItemCollection);
                    MaterialCollection materialCollection = MaterialFactory.getRemoteInstance().getMaterialCollection(entityViewInfo);
                    if (materialCollection != null) {
                        MaterialInfo materialInfo = materialCollection.get(0);
                        this.prmtTopMaterial.setValue((Object)materialInfo);
                    }
                }
                this.prmtProject.setValue((Object)pdmEasCarnoEqualSetInfo.getEasCarno());
                this.prmtStartTrace.setValue((Object)pdmEasCarnoEqualSetInfo.getEasbegintracknumber());
                this.prmtEndTrace.setValue((Object)pdmEasCarnoEqualSetInfo.getEasendtracknumber());
            }
        }
    }
}

