/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.mm.client.AbstractCompleteQuotaAnalysisQueryUI;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.zjbom.PdmEasCarnoEqualSetCollection;
import com.kingdee.eas.zjbom.PdmEasCarnoEqualSetFactory;
import com.kingdee.eas.zjbom.PdmEasCarnoEqualSetInfo;
import java.awt.event.ActionEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class CompleteQuotaAnalysisQueryUI
extends AbstractCompleteQuotaAnalysisQueryUI {
    private static String RESURL = "com.kingdee.eas.industry.emm.mm.basedata.EMMEMBaseResource";
    private static String XMH_ISNOTNULL = EASResource.getString((String)RESURL, (String)"XMH_ISNOTNULL");
    private static String KSGZH_ISNOTNULL = EASResource.getString((String)RESURL, (String)"KSGZH_ISNOTNULL");
    private static String JSGZH_ISNOTNULL = EASResource.getString((String)RESURL, (String)"JSGZH_ISNOTNULL");
    private static String QXZSJFZTJFS_INFO = EASResource.getString((String)RESURL, (String)"QXZSJFZTJFS_INFO");
    private static String CPBM_ISNOTNULL = EASResource.getString((String)RESURL, (String)"CPBM_ISNOTNULL");
    private static String MBGZH_ISNOTNULL = EASResource.getString((String)RESURL, (String)"MBGZH_ISNOTNULL");
    public static final String PARAM_BATCH = "batch";
    public static final String PARAM_ENDTRACENUMBER = "endTrace.number";
    public static final String PARAM_MANUFACTUREDATA = "manufactureData";
    public static final String PARAM_MATERIALATTRIBUTE = "materialAttribute";
    public static final String PARAM_PROJECTNUMBER = "project.number";
    public static final String PARAM_PURCHASEDATA = "purchaseData";
    public static final String PARAM_STARTTRACENUMBER = "startTrace.number";
    public static final String PARAM_TARGETTRACENUMBER = "targetTrace.number";
    public static final String PARAM_TOPMATERIAL = "topMaterial";
    public static final String PARAM_TOPPROCESS = "topProcess";
    private static final Logger logger = CoreUIObject.getLogger(CompleteQuotaAnalysisQueryUI.class);
    private static final long serialVersionUID = 8310741051537677225L;
    protected DocumentListener batchDocumentListener = null;
    protected PreChangeListener f7PreChangeListener = null;
    protected SelectorListener f7SelectorListener = null;

    public void clear() {
        this.rbPurchaseData.setSelected(true);
        this.txtTopProcess.setEnabled(false);
    }

    public RptParams getCustomCondition() {
        RptParams rp = new RptParams();
        rp.setObject(PARAM_TOPMATERIAL, this.prmtTopMaterial.getValue());
        rp.setString(PARAM_BATCH, this.txtBatch.getText());
        rp.setObject(PARAM_PROJECTNUMBER, this.prmtProject.getValue());
        rp.setObject(PARAM_STARTTRACENUMBER, this.prmtStartTrace.getValue());
        rp.setObject(PARAM_ENDTRACENUMBER, this.prmtEndTrace.getValue());
        rp.setObject(PARAM_TARGETTRACENUMBER, this.prmtTargetTrace.getValue());
        rp.setString(PARAM_TOPPROCESS, this.txtTopProcess.getText());
        rp.setObject(PARAM_MATERIALATTRIBUTE, this.comboMaterialAttribute.getSelectedItem());
        rp.setBoolean(PARAM_PURCHASEDATA, this.rbPurchaseData.isSelected());
        rp.setBoolean(PARAM_MANUFACTUREDATA, this.rbManufactureData.isSelected());
        return rp;
    }

    public void onInit(RptParams arg0) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtBatch.setRequired(false);
        this.addListener();
    }

    public void setCustomCondition(RptParams params) {
        if (params == null) {
            params = new RptParams();
        }
        try {
            if (params.containsKey(PARAM_TOPMATERIAL) && params.getObject(PARAM_TOPMATERIAL) != null) {
                this.prmtTopMaterial.setValue(params.getObject(PARAM_TOPMATERIAL));
            }
            if (params.containsKey(PARAM_BATCH) && params.getString(PARAM_BATCH) != null) {
                this.txtBatch.setText(params.getString(PARAM_BATCH));
            }
            if (params.containsKey(PARAM_PROJECTNUMBER) && params.getObject(PARAM_PROJECTNUMBER) != null) {
                this.prmtProject.setValue(params.getObject(PARAM_PROJECTNUMBER));
            }
            if (params.containsKey(PARAM_STARTTRACENUMBER) && params.getObject(PARAM_STARTTRACENUMBER) != null) {
                this.prmtStartTrace.setValue(params.getObject(PARAM_STARTTRACENUMBER));
            }
            if (params.containsKey(PARAM_ENDTRACENUMBER) && params.getObject(PARAM_ENDTRACENUMBER) != null) {
                this.prmtEndTrace.setValue(params.getObject(PARAM_ENDTRACENUMBER));
            }
            if (params.containsKey(PARAM_TARGETTRACENUMBER) && params.getObject(PARAM_TARGETTRACENUMBER) != null) {
                this.prmtTargetTrace.setValue(params.getObject(PARAM_TARGETTRACENUMBER));
            }
            if (params.containsKey(PARAM_TOPPROCESS) && params.getString(PARAM_TOPPROCESS) != null) {
                this.txtTopProcess.setText(params.getString(PARAM_TOPPROCESS));
            }
            if (params.containsKey(PARAM_MATERIALATTRIBUTE) && params.getObject(PARAM_MATERIALATTRIBUTE) != null) {
                this.comboMaterialAttribute.setSelectedItem(params.getObject(PARAM_MATERIALATTRIBUTE));
            }
            if (params.containsKey(PARAM_PURCHASEDATA)) {
                this.rbPurchaseData.setSelected(params.getBoolean(PARAM_PURCHASEDATA));
            }
            if (params.containsKey(PARAM_MANUFACTUREDATA)) {
                this.rbManufactureData.setSelected(params.getBoolean(PARAM_MANUFACTUREDATA));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean verify() {
        boolean result = super.verify();
        if (this.prmtProject.getValue() == null) {
            MsgBox.showWarning((String)XMH_ISNOTNULL);
            return false;
        }
        if (this.prmtTopMaterial.getValue() == null) {
            MsgBox.showWarning((String)CPBM_ISNOTNULL);
            return false;
        }
        if (this.prmtStartTrace.getValue() == null) {
            MsgBox.showWarning((String)KSGZH_ISNOTNULL);
            return false;
        }
        if (this.prmtTargetTrace.getValue() == null) {
            MsgBox.showWarning((String)MBGZH_ISNOTNULL);
            return false;
        }
        if (this.prmtEndTrace.getValue() == null) {
            MsgBox.showWarning((String)JSGZH_ISNOTNULL);
            return false;
        }
        if (!this.rbPurchaseData.isSelected() && !this.rbManufactureData.isSelected()) {
            MsgBox.showWarning((String)QXZSJFZTJFS_INFO);
            return false;
        }
        return result;
    }

    protected void addListener() {
        if (this.f7PreChangeListener == null) {
            this.f7PreChangeListener = new PreChangeListener(){

                public void preChange(PreChangeEvent e) {
                    try {
                        CompleteQuotaAnalysisQueryUI.this.f7PreChange(e);
                    }
                    catch (Exception exc) {
                        CompleteQuotaAnalysisQueryUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStartTrace.addPreChangeListener(this.f7PreChangeListener);
        this.prmtEndTrace.addPreChangeListener(this.f7PreChangeListener);
        this.prmtTargetTrace.addPreChangeListener(this.f7PreChangeListener);
        if (this.f7SelectorListener == null) {
            this.f7SelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        CompleteQuotaAnalysisQueryUI.this.f7WillShow(e);
                    }
                    catch (Exception exc) {
                        CompleteQuotaAnalysisQueryUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtStartTrace.addSelectorListener(this.f7SelectorListener);
        this.prmtEndTrace.addSelectorListener(this.f7SelectorListener);
        this.prmtTargetTrace.addSelectorListener(this.f7SelectorListener);
        if (this.batchDocumentListener == null) {
            this.batchDocumentListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    try {
                        CompleteQuotaAnalysisQueryUI.this.txtBatchDataChange(documentEvent);
                    }
                    catch (BOSException e) {
                        CompleteQuotaAnalysisQueryUI.this.handUIException(e);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    try {
                        CompleteQuotaAnalysisQueryUI.this.txtBatchDataChange(documentEvent);
                    }
                    catch (BOSException e) {
                        CompleteQuotaAnalysisQueryUI.this.handUIException(e);
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    try {
                        CompleteQuotaAnalysisQueryUI.this.txtBatchDataChange(documentEvent);
                    }
                    catch (BOSException e) {
                        CompleteQuotaAnalysisQueryUI.this.handUIException(e);
                    }
                }
            };
        }
        this.txtBatch.getDocument().addDocumentListener(this.batchDocumentListener);
    }

    protected void f7PreChange(PreChangeEvent e) throws BOSException {
        if (!KDBizPromptBox.class.getName().equals(e.getSource().getClass().getName())) {
            return;
        }
        String f7Name = ((KDBizPromptBox)e.getSource()).getName();
        if (this.prmtStartTrace.getName().equals(f7Name) || this.prmtEndTrace.getName().equals(f7Name) || this.prmtTargetTrace.getName().equals(f7Name)) {
            this.resetTraceEntityViewInfo(f7Name);
        }
    }

    protected void f7WillShow(SelectorEvent e) throws BOSException {
        if (!KDBizPromptBox.class.getName().equals(e.getSource().getClass().getName())) {
            return;
        }
        String f7Name = ((KDBizPromptBox)e.getSource()).getName();
        if (this.prmtStartTrace.getName().equals(f7Name) || this.prmtEndTrace.getName().equals(f7Name) || this.prmtTargetTrace.getName().equals(f7Name)) {
            this.resetTraceEntityViewInfo(f7Name);
        }
    }

    protected void rbButtonChanged(ActionEvent e) throws Exception {
        if (this.rbPurchaseData.isSelected()) {
            this.txtTopProcess.setEnabled(false);
        } else {
            this.txtTopProcess.setEnabled(true);
        }
    }

    @Override
    protected void rbManufactureDataSelected_actionPerformed(ActionEvent e) throws Exception {
        this.rbButtonChanged(e);
    }

    @Override
    protected void rbPurchaseDataSelected_actionPerformed(ActionEvent e) throws Exception {
        this.rbButtonChanged(e);
    }

    protected void resetTraceEntityViewInfo(String f7Name) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        ProjectInfo projectInfo = this.prmtProject.getValue() != null && this.prmtProject.getValue() instanceof ProjectInfo ? (ProjectInfo)this.prmtProject.getValue() : null;
        String projectNumber = null;
        if (projectInfo != null) {
            projectNumber = projectInfo.getNumber();
        } else {
            String string = projectNumber = this.prmtProject.getValue() != null ? this.prmtProject.getValue().toString() : null;
        }
        if (projectNumber != null && projectNumber.toString().trim().length() > 0) {
            sql.append("Select\r\n");
            sql.append("PC.FTrackNumberID\r\n");
            sql.append("From T_MM_Project P\r\n");
            sql.append("Inner Join T_MM_ProjectCar PC On PC.FProjectID=P.FID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And P.FNumber='").append(projectNumber).append("'");
            sql.append("Group By\r\n");
            sql.append("PC.FTrackNumberID\r\n");
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        }
        if (filterInfo.getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
            entityViewInfo.setFilter(filterInfo);
        }
        if (this.prmtStartTrace.getName().equals(f7Name)) {
            this.prmtStartTrace.setEntityViewInfo(entityViewInfo);
            this.prmtStartTrace.getQueryAgent().resetRuntimeEntityView();
        } else if (this.prmtEndTrace.getName().equals(f7Name)) {
            this.prmtEndTrace.setEntityViewInfo(entityViewInfo);
            this.prmtEndTrace.getQueryAgent().resetRuntimeEntityView();
        } else if (this.prmtTargetTrace.getName().equals(f7Name)) {
            this.prmtTargetTrace.setEntityViewInfo(entityViewInfo);
            this.prmtTargetTrace.getQueryAgent().resetRuntimeEntityView();
        }
    }

    protected void txtBatchDataChange(DocumentEvent documentEvent) throws BOSException {
        String batch = this.txtBatch.getText();
        if (batch != null && batch.trim().length() > 0) {
            PdmEasCarnoEqualSetInfo pdmEasCarnoEqualSetInfo;
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("PMno");
            selectorItemCollection.add("EasCarno.id");
            selectorItemCollection.add("EasCarno.number");
            selectorItemCollection.add("EasCarno.name");
            selectorItemCollection.add("Easbegintracknumber.id");
            selectorItemCollection.add("Easbegintracknumber.number");
            selectorItemCollection.add("Easbegintracknumber.name");
            selectorItemCollection.add("Easendtracknumber.id");
            selectorItemCollection.add("Easendtracknumber.number");
            selectorItemCollection.add("Easendtracknumber.name");
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("Batch", (Object)batch, CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            entityViewInfo.setSelector(selectorItemCollection);
            PdmEasCarnoEqualSetCollection pdmEasCarnoEqualSetCollection = PdmEasCarnoEqualSetFactory.getRemoteInstance().getPdmEasCarnoEqualSetCollection(entityViewInfo);
            if (pdmEasCarnoEqualSetCollection != null && pdmEasCarnoEqualSetCollection.size() > 0 && (pdmEasCarnoEqualSetInfo = pdmEasCarnoEqualSetCollection.get(0)) != null) {
                String topMaterialNumber = pdmEasCarnoEqualSetInfo.getPMno();
                if (topMaterialNumber != null && topMaterialNumber.trim().length() > 0) {
                    SelectorItemCollection materialSelectorItemCollection = new SelectorItemCollection();
                    materialSelectorItemCollection.add("id");
                    materialSelectorItemCollection.add("number");
                    materialSelectorItemCollection.add("name");
                    filterInfo.getFilterItems().clear();
                    filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)topMaterialNumber, CompareType.EQUALS));
                    entityViewInfo.setFilter(filterInfo);
                    entityViewInfo.setSelector(materialSelectorItemCollection);
                    MaterialCollection materialCollection = MaterialFactory.getRemoteInstance().getMaterialCollection(entityViewInfo);
                    if (materialCollection != null) {
                        MaterialInfo materialInfo = materialCollection.get(0);
                        this.prmtTopMaterial.setValue((Object)materialInfo);
                    }
                }
                this.prmtProject.setValue((Object)pdmEasCarnoEqualSetInfo.getEasCarno());
                this.prmtStartTrace.setValue((Object)pdmEasCarnoEqualSetInfo.getEasbegintracknumber());
                this.prmtEndTrace.setValue((Object)pdmEasCarnoEqualSetInfo.getEasendtracknumber());
            }
        }
    }
}

