/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.mo.util;

import com.kingdee.eas.industry.emm.mm.mo.util.DefinedUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jxl.Cell;
import jxl.JXLException;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelDate {
    private String fileName;

    public ExcelDate(String fileName) {
        this.fileName = fileName;
    }

    public ExcelDate() {
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String[][] getDate(int num) throws IOException, JXLException {
        FileInputStream is = new FileInputStream(this.fileName);
        Workbook rwb = Workbook.getWorkbook((InputStream)is);
        Sheet rs = rwb.getSheet(num);
        int cLen = rs.getColumns();
        int rLen = rs.getRows();
        String[][] eDate = new String[rLen][cLen];
        for (int i = 0; i < rLen; ++i) {
            for (int j = 0; j < cLen; ++j) {
                String temp;
                eDate[i][j] = temp = rs.getCell(j, i).getContents();
            }
        }
        return eDate;
    }

    public String[][] getData2(int num) throws IOException, JXLException {
        FileInputStream is = new FileInputStream(this.fileName);
        Workbook rwb = Workbook.getWorkbook((InputStream)is);
        Sheet rs = rwb.getSheet(num);
        int cLen = rs.getColumns();
        int rLen = rs.getRows();
        String[][] eDate = new String[rLen + 1][cLen];
        for (int i = 0; i < rLen; ++i) {
            for (int j = 0; j < cLen; ++j) {
                String temp;
                eDate[i][j] = temp = rs.getCell(j, i).getContents();
            }
        }
        eDate[rLen][0] = "";
        eDate[rLen][3] = "";
        eDate[rLen][7] = "";
        eDate[rLen][6] = "";
        return eDate;
    }

    public String[][] getData(int num, int fromRow, int colCount) throws IOException, JXLException {
        FileInputStream is = new FileInputStream(this.fileName);
        Workbook rwb = Workbook.getWorkbook((InputStream)is);
        Sheet rs = rwb.getSheet(num);
        int rLen = rs.getRows();
        String[][] eDate = new String[rLen - fromRow][colCount];
        for (int i = fromRow; i < rLen; ++i) {
            for (int j = 0; j < colCount; ++j) {
                System.out.print("\n i=" + i + " j=" + j);
                Cell cell = rs.getCell(j, i);
                eDate[i - fromRow][j] = cell.getContents();
            }
        }
        rwb.close();
        return eDate;
    }

    public String[][] getData2(int num, int fromRow, int colCount) throws IOException, JXLException {
        if (this.fileName.toLowerCase().endsWith("xls")) {
            return this.loadXls(num, fromRow, colCount);
        }
        if (this.fileName.toLowerCase().endsWith("xlsx")) {
            return this.loadXls(num, fromRow, colCount);
        }
        return null;
    }

    public String[][] loadXls(int num, int fromRow, int colCount) {
        String[][] eDate = null;
        try {
            FileInputStream input = new FileInputStream(this.fileName);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)input);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(num);
            int rLen = sheet.getLastRowNum() + 1;
            int col = sheet.getRow(0).getPhysicalNumberOfCells();
            if (col < colCount) {
                colCount = col;
            }
            eDate = new String[rLen - fromRow][colCount];
            HSSFRow row = null;
            HSSFCell cell = null;
            int dateCol = -1;
            for (int i = fromRow; i < rLen; ++i) {
                row = sheet.getRow(i);
                for (int j = 0; j < colCount; ++j) {
                    cell = row.getCell(j);
                    if (cell == null) {
                        eDate[i - fromRow][j] = null;
                        continue;
                    }
                    if (cell.toString().equals("\u5b8c\u6210\u65f6\u95f4")) {
                        dateCol = j;
                    }
                    eDate[i - fromRow][j] = i > 0 && j == dateCol && !DefinedUtil.isNullOrZeroString((String)cell.toString().trim()) ? row.getCell(j).getDateCellValue().toLocaleString() : cell.toString();
                }
            }
            ((InputStream)input).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return eDate;
    }

    public List getData3(int num) throws IOException, JXLException {
        FileInputStream is = new FileInputStream(this.fileName);
        Workbook rwb = Workbook.getWorkbook((InputStream)is);
        Sheet rs = rwb.getSheet(num);
        int rLen = rs.getRows();
        int col = rs.getColumns();
        ArrayList colList = new ArrayList();
        for (int i = 1; i < rLen; ++i) {
            if (rs.getCell(0, i).getContents() == null || rs.getCell(0, i).getContents().trim().length() == 0) continue;
            HashMap<String, String> tmp = new HashMap<String, String>();
            for (int j = 0; j < col; ++j) {
                Cell cell = rs.getCell(j, i);
                tmp.put(rs.getCell(j, 0).getContents().trim(), cell.getContents().trim());
            }
            colList.add(tmp);
        }
        rwb.close();
        ((InputStream)is).close();
        return colList;
    }
}

