/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.pm.report.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.mm.pm.report.DeliveryPlanReportFacadeFactory;
import com.kingdee.eas.industry.emm.mm.pm.report.client.AbstractDeliveryPlanReportUI;
import com.kingdee.eas.industry.emm.mm.pm.report.client.DeliveryPlanReportFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DeliveryPlanReportUI
extends AbstractDeliveryPlanReportUI {
    private static final Logger logger = CoreUIObject.getLogger(DeliveryPlanReportUI.class);
    String orgunit = null;
    String project = null;

    public DeliveryPlanReportUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.enableExportExcel(this.tblMain);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.tblMain.checkParsed();
        KDTSortManager sortManager = new KDTSortManager(this.tblMain);
        sortManager.setSortAuto(true);
        sortManager.setClickCount(1);
        for (int i = 0; i < this.tblMain.getColumnCount(); ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        this.tblMain.getHeadMergeManager().setMergeMode(3);
        this.pkBizDateFrom.setDatePattern("yyyy-MM");
        this.pkBizDateTo.setDatePattern("yyyy-MM");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void tableDataRequest(KDTDataRequestEvent arg0) {
        this.buildHead();
        try {
            Map allMap;
            RptParams rptParams = DeliveryPlanReportFacadeFactory.getRemoteInstance().query(this.params);
            if (rptParams != null && rptParams.containsKey("allMap") && (allMap = (Map)rptParams.getObject("allMap")) != null && allMap.size() > 0) {
                for (String projectName : allMap.keySet()) {
                    IRow addQtyRow = this.tblMain.addRow();
                    IRow addCarRow = this.tblMain.addRow();
                    addQtyRow.getCell("project").setValue((Object)projectName);
                    addCarRow.getCell("project").setValue((Object)projectName);
                    addQtyRow.getCell("nodeDesc").setValue((Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0321"));
                    addCarRow.getCell("nodeDesc").setValue((Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0322"));
                    this.tblMain.getMergeManager().mergeBlock(addQtyRow.getRowIndex(), 0, addCarRow.getRowIndex(), 0);
                    HashMap<String, Integer> sumMap = new HashMap<String, Integer>();
                    Map detailRsMap = (Map)allMap.get(projectName);
                    if (detailRsMap != null && detailRsMap.size() > 0) {
                        for (String detailKey : detailRsMap.keySet()) {
                            Map detailMap = (Map)detailRsMap.get(detailKey);
                            String colName = (String)detailMap.get("colName");
                            Integer qty = (Integer)detailMap.get("qty");
                            String trackNo = (String)detailMap.get("trackNo");
                            addQtyRow.getCell(colName).setValue((Object)qty);
                            addCarRow.getCell(colName).setValue((Object)trackNo);
                            String yearStr = String.valueOf(detailMap.get("year"));
                            if (sumMap.containsKey(yearStr)) {
                                Integer yearQty = (Integer)sumMap.get(yearStr);
                                sumMap.put(yearStr, yearQty + qty);
                                continue;
                            }
                            sumMap.put(yearStr, qty);
                        }
                    }
                    if (sumMap == null || sumMap.size() <= 0) continue;
                    for (String yearStr : sumMap.keySet()) {
                        String projectKey = yearStr + "project";
                        String carKey = yearStr + "car";
                        Integer yearQty = (Integer)sumMap.get(yearStr);
                        if (addQtyRow.getCell(projectKey) != null) {
                            addQtyRow.getCell(projectKey).setValue((Object)yearQty);
                        }
                        if (addQtyRow.getCell(carKey) == null) continue;
                        addQtyRow.getCell(carKey).setValue((Object)(yearQty * 6));
                    }
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void buildHead() {
        this.tblMain.checkParsed();
        this.tblMain.setEnabled(false);
        IRow headRow = this.tblMain.addHeadRow();
        IColumn addColumn = this.tblMain.addColumn();
        addColumn.setKey("project");
        headRow.getCell("project").setValue((Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0323"));
        addColumn = this.tblMain.addColumn();
        addColumn.setKey("nodeDesc");
        headRow.getCell("nodeDesc").setValue((Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0324"));
        IRow headRow2 = this.tblMain.addHeadRow();
        this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
        Date bizDateFrom = (Date)this.params.getObjectElement("bizDateFrom");
        Date bizDateTo = (Date)this.params.getObjectElement("bizDateTo");
        try {
            bizDateFrom = DateTimeUtils.parseDate((String)DateTimeUtils.format((Date)bizDateFrom), (String)"yyyy-MM");
            bizDateTo = DateTimeUtils.parseDate((String)DateTimeUtils.format((Date)bizDateTo), (String)"yyyy-MM");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int mergeIndex = 2;
        while (bizDateFrom.compareTo(bizDateTo) <= 0) {
            int fromYear = DateTimeUtils.getYear((Date)bizDateFrom);
            int fromMonth = DateTimeUtils.getMonth((Date)bizDateFrom);
            addColumn = this.tblMain.addColumn();
            String colKey = fromYear + "_" + fromMonth;
            addColumn.setKey(colKey);
            headRow.getCell(colKey).setValue((Object)(fromYear + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0325")));
            headRow2.getCell(colKey).setValue((Object)(fromMonth + EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0326")));
            if (fromMonth == 12 || bizDateFrom.compareTo(bizDateTo) == 0) {
                addColumn = this.tblMain.addColumn();
                String fromYearProject = String.valueOf(fromYear) + "project";
                addColumn.setKey(fromYearProject);
                headRow2.getCell(fromYearProject).setValue((Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0327"));
                addColumn = this.tblMain.addColumn();
                String fromYearCar = String.valueOf(fromYear) + "car";
                addColumn.setKey(fromYearCar);
                headRow2.getCell(fromYearCar).setValue((Object)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0328"));
                this.tblMain.getHeadMergeManager().mergeBlock(0, mergeIndex, 0, addColumn.getColumnIndex());
                mergeIndex = this.tblMain.getColumnCount();
                addColumn.getStyleAttributes().setHided(true);
            }
            bizDateFrom = DateTimeUtils.addMonth((Date)bizDateFrom, (int)1);
        }
        int columnCount = this.tblMain.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            IColumn column = this.tblMain.getColumn(i);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"center"));
        }
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new DeliveryPlanReportFilterUI();
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return DeliveryPlanReportFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    @Override
    protected void initUIP() {
        super.initUIP();
    }

    protected void query() {
        this.params.getString("title");
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.pm.EMMEMMmpmResource", (String)"0EMMPM-0329"));
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
        Date bizDateFrom = (Date)this.params.getObjectElement("bizDateFrom");
        Date bizDateTo = (Date)this.params.getObjectElement("bizDateTo");
        this.pkBizDateFrom.setValue((Object)bizDateFrom);
        this.pkBizDateTo.setValue((Object)bizDateTo);
        Object projectObj = this.params.getObjectElement("projectObj");
        Object storageOrg = this.params.getObjectElement("storageOrg");
        this.prmtProject.setValue(projectObj);
        this.prmtorgUnit.setValue(storageOrg);
        String trackNo = (String)this.params.getObjectElement("trackNo");
        String nodeDesc = (String)this.params.getObjectElement("nodeDesc");
        this.txttrackNo.setText(trackNo);
        this.txtnodeDesc.setText(nodeDesc);
    }
}

