/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.restruct;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillEntryFactory;
import com.kingdee.eas.industry.emm.mm.restruct.RestructReqBillEntryInfo;
import com.kingdee.eas.scm.common.app.bizprocess.processor.AbstractSCMBusinessProcessor;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;

public class RestructReqBillWbOtherInwarehsProcessor
extends AbstractSCMBusinessProcessor {
    private static final long serialVersionUID = 1915910658763467462L;

    public RestructReqBillWbOtherInwarehsProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public RestructReqBillWbOtherInwarehsProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public RestructReqBillWbOtherInwarehsProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        for (int n = 0; n < objCol.size(); ++n) {
            OtherInWarehsBillInfo info = (OtherInWarehsBillInfo)objCol.getObject(n);
            OtherInWarehsBillEntryCollection colls = info.getEntry();
            for (int i = 0; i < colls.size(); ++i) {
                OtherInWarehsBillEntryInfo entryinfo = colls.get(i);
                String sourceid = entryinfo.getSourceBillEntryId();
                if (sourceid == null) {
                    return;
                }
                BigDecimal amout = entryinfo.getQty();
                boolean isExist = false;
                if (sourceid == null || "".equals(sourceid) || !(isExist = RestructReqBillEntryFactory.getLocalInstance(this.ctx).exists((IObjectPK)new ObjectUuidPK(sourceid)))) continue;
                RestructReqBillEntryInfo _info = RestructReqBillEntryFactory.getLocalInstance(this.ctx).getRestructReqBillEntryInfo((IObjectPK)new ObjectUuidPK(sourceid));
                BigDecimal tmpQty = _info.getRevokedqty();
                if (this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) {
                    _info.setRevokedqty(tmpQty.add(amout.multiply(new BigDecimal(-1))));
                } else {
                    if (tmpQty.add(amout).compareTo(_info.getRevokeqty()) == 1) {
                        throw new EASBizException(new NumericExceptionSubItem("\u63d0\u793a", "\u5df2\u62a5\u5e9f\u6570\u91cf\u4e0d\u5141\u8bb8\u5927\u4e8e\u8ba1\u5212\u62a5\u5e9f\u6570\u91cf\uff01"));
                    }
                    _info.setRevokedqty(tmpQty.add(amout));
                }
                RestructReqBillEntryFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)_info);
            }
        }
    }
}

