/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.sc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.industry.emm.common.client.IndustryClientUtils;
import com.kingdee.eas.industry.emm.mm.sc.MonthScRequestEntryInfo;
import com.kingdee.eas.industry.emm.mm.sc.MonthScRequestFactory;
import com.kingdee.eas.industry.emm.mm.sc.MonthScRequestInfo;
import com.kingdee.eas.industry.emm.mm.sc.client.AbstractMonthScRequestEditUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class MonthScRequestEditUI
extends AbstractMonthScRequestEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MonthScRequestEditUI.class);

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getStatus() == BillBaseStatusEnum.AUDITED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0079"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtrequestPerson.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        F7ContextManager f7m = new F7ContextManager((Component)((Object)this), OrgType.Storage);
        IndustryClientUtils.registerBizMaterialF7ForTable((KDTable)this.kdtEntrys, (String)"material");
        this.setFilterForProposer();
        this.btnAudit.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
        final KDBizPromptBox prmtOperation = (KDBizPromptBox)this.kdtEntrys.getColumn("scOpertion").getEditor().getComponent();
        prmtOperation.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent arg0) {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                if (MonthScRequestEditUI.this.prmtstorageOrgUnit.getData() == null) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)"xxxxxxxxxx"));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)((StorageOrgUnitInfo)MonthScRequestEditUI.this.prmtstorageOrgUnit.getData()).getId().toString()));
                }
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)20));
                ev.setFilter(filter);
                prmtOperation.setEntityViewInfo(ev);
                prmtOperation.getQueryAgent().resetRuntimeEntityView();
            }
        });
        this.actionAddNew.setVisible(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        SCMClientUtils.changeColumnPrecision((KDTable)this.kdtEntrys, (String[])new String[]{"qty"}, (int)0, (boolean)false);
        SCMClientUtils.changeColumnPrecision((KDTable)this.kdtEntrys, (String[])new String[]{"price", "hisPrice", "conPrice"}, (int)2, (boolean)false);
    }

    @Override
    public void kdtEntrys_Changed(int rowIndex, int colIndex) throws Exception {
        super.kdtEntrys_Changed(rowIndex, colIndex);
        if ("material".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            this.kdtEntrys.getCell(rowIndex, "unit").setValue(UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.kdtEntrys.getCell(rowIndex, "material").getValue()), (String)"baseUnit"));
        }
        if ("conPrice".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey()) || "qty".equalsIgnoreCase(this.kdtEntrys.getColumn(colIndex).getKey())) {
            BigDecimal qty = this.kdtEntrys.getCell(rowIndex, "qty").getValue() == null ? BigDecimal.ZERO : (BigDecimal)this.kdtEntrys.getCell(rowIndex, "qty").getValue();
            BigDecimal price = this.kdtEntrys.getCell(rowIndex, "conPrice").getValue() == null ? BigDecimal.ZERO : (BigDecimal)this.kdtEntrys.getCell(rowIndex, "conPrice").getValue();
            BigDecimal amount = qty.multiply(price).setScale(4);
            this.kdtEntrys.getCell(rowIndex, "amount").setValue((Object)amount);
        }
    }

    private void setFilterForProposer() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("CU", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId(), CompareType.EQUALS));
        view.setFilter(tmpFilter);
        AdminOrgUnitCollection adminOrgUnitCol = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollection(view);
        if (adminOrgUnitCol.size() > 0) {
            StringBuffer strBuffer = new StringBuffer();
            EntityViewInfo view2 = new EntityViewInfo();
            FilterInfo tmpFilter2 = new FilterInfo();
            for (int i = 0; i < adminOrgUnitCol.size(); ++i) {
                strBuffer.append(adminOrgUnitCol.get(i).getId()).append(",");
            }
            strBuffer.deleteCharAt(strBuffer.length() - 1);
            tmpFilter2.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)strBuffer.toString(), CompareType.INCLUDE));
            view2.setFilter(tmpFilter2);
            this.prmtrequestPerson.setEntityViewInfo(view2);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return MonthScRequestFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new MonthScRequestEntryInfo();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.status.getSelectedItem() != BillBaseStatusEnum.SUBMITED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0000"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ((ICoreBillBase)this.getBizInterface()).passAudit((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBillBaseInfo)this.editData);
        this.editData = (MonthScRequestInfo)this.getValue((IObjectPK)pk);
        if (this.editData.getStatus() == BillBaseStatusEnum.AUDITED) {
            this.setOprtState(OprtState.VIEW);
        } else {
            this.setOprtState(OprtState.EDIT);
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        this.btnEdit.setEnabled(false);
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.status.getSelectedItem() != BillBaseStatusEnum.AUDITED) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0001"));
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ((ICoreBillBase)this.getBizInterface()).unpassAudit((IObjectPK)pk, (CoreBillBaseInfo)this.editData);
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        this.btnEdit.setEnabled(true);
    }

    @Override
    protected IObjectValue createNewData() {
        MonthScRequestInfo objectValue = new MonthScRequestInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage")).getBoolean("isBizUnit")) {
            objectValue.put("storageOrgUnit", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"Storage")));
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator(userInfo);
        objectValue.setBizDate(new Date());
        objectValue.setRequestDate(new Date());
        PersonInfo curPerson = userInfo.getPerson();
        objectValue.setRequestPerson((PersonInfo)(curPerson != null ? curPerson : null));
        return objectValue;
    }

    @Override
    protected void beforeStoreFields(ActionEvent arg0) throws Exception {
        if (UIRuleUtil.isNull((Object)this.pkBizDate.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0080")});
        }
        if (UIRuleUtil.isNull((String)this.txtprojectName.getText())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0081")});
        }
        if (UIRuleUtil.isNull((Object)this.prmtrequestPerson.getData())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0082")});
        }
        if (UIRuleUtil.isNull((Object)this.pkrequestDate.getValue())) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0083")});
        }
        super.beforeStoreFields(arg0);
    }
}

