/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.mm.sc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.common.util.UITitleTranUtil;
import com.kingdee.eas.industry.emm.mm.sc.IYearScRequestBill;
import com.kingdee.eas.industry.emm.mm.sc.YearScRequestBillFactory;
import com.kingdee.eas.industry.emm.mm.sc.YearScRequestBillInfo;
import com.kingdee.eas.industry.emm.mm.sc.client.AbstractYearScRequestBillListUI;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class YearScRequestBillListUI
extends AbstractYearScRequestBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(YearScRequestBillListUI.class);
    protected boolean isSubmitting;

    public YearScRequestBillListUI() throws Exception {
        String title = UITitleTranUtil.getTranTileByXML((String)((Object)((Object)this)).getClass().getName());
        if (title != null && !"".equals(title)) {
            super.setUITitle(title);
        }
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAudit.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
        this.btnSubmit.setVisible(false);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        IYearScRequestBill ice = (IYearScRequestBill)this.getBizInterface();
        this.checkSelected();
        this.checkAction("audit");
        ArrayList ids = this.getSelectedIdValues();
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            ice.passAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), null);
        }
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        IYearScRequestBill ice = (IYearScRequestBill)this.getBizInterface();
        this.checkSelected();
        this.checkAction("unAudit");
        ArrayList ids = this.getSelectedIdValues();
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            ice.unpassAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)), null);
        }
        this.refreshList();
    }

    protected void checkAction(String action) throws Exception {
        this.checkSelected();
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String billStatus = row.getCell("status").getValue().toString().trim();
                if ("audit".equals(action)) {
                    this.checkAudit(billStatus);
                    continue;
                }
                if ("edit".equals(action)) {
                    this.checkEdit(billStatus);
                    continue;
                }
                if ("remove".equals(action)) {
                    this.checkRemove(billStatus);
                    continue;
                }
                if ("unAudit".equals(action)) {
                    this.checkUnAudit(billStatus);
                    continue;
                }
                if (!"submit".equals(action)) continue;
                this.checkSubmit(billStatus);
            }
        }
    }

    private void checkAudit(String billStatus) {
        if (!billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0084"));
            SysUtil.abort();
        }
    }

    private void checkSubmit(String billStatus) {
        if (!billStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) && !billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0085"));
            SysUtil.abort();
        }
    }

    private void checkEdit(String billStatus) {
        if (!billStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) && !billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0086"));
            SysUtil.abort();
        }
    }

    private void checkRemove(String billStatus) {
        if (!billStatus.equalsIgnoreCase(BillBaseStatusEnum.TEMPORARILYSAVED.toString()) && !billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.SUBMITED.toString())) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0087"));
            SysUtil.abort();
        }
    }

    private void checkUnAudit(String billStatus) {
        if (!billStatus.trim().equalsIgnoreCase(BillBaseStatusEnum.AUDITED.toString())) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.industry.emm.mm.sc.EMMEMMnscResource", (String)"0EMMSC-0088"));
            SysUtil.abort();
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return YearScRequestBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        YearScRequestBillInfo objectValue = new YearScRequestBillInfo();
        return objectValue;
    }
}

