/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.project.fcs.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.industry.emm.project.fcs.PriceModeEnum;
import com.kingdee.eas.industry.emm.project.fcs.client.AbstractSOPMaterialABCFilterUI;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.ISOPPermissionFacade;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPPermissionFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPlanVersionFactory;
import com.kingdee.eas.mm.planning.SOPPlanVersionInfo;
import com.kingdee.eas.mm.planning.SOPSysParams;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class SOPMaterialABCFilterUI
extends AbstractSOPMaterialABCFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(SOPMaterialABCFilterUI.class);
    DataChangeListener storageOrgUnitDataChanged = null;
    private static final String SALE_PERMISSION = "mm_sopsaleplan_view";
    private static final String PRODUCT_PERMISSION = "mm_sopprodplan_view";
    private SOPPeriod curPeriod;
    private SOPPeriod[] periods;
    private CustomerParams cp = null;
    private int horizon = 0;
    private ISOPFacade sopFacade = null;
    private SOPSysParams SOPParams;

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.prmtPlannedVersion.setValue(this.getDefaultPlanVersion());
        this.combPriceMode.setSelectedItem((Object)PriceModeEnum.StandPrice);
    }

    private Object getDefaultPlanVersion() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        viewInfo.setSelector(selectors);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)"000", CompareType.EQUALS));
        filterInfo.setMaskString("#0");
        viewInfo.setFilter(filterInfo);
        Object[] reqTypes = null;
        try {
            CoreBaseCollection c = SOPPlanVersionFactory.getRemoteInstance().getCollection(viewInfo);
            reqTypes = c.toArray();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return reqTypes[0];
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtstorageOrgUnit;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public SOPMaterialABCFilterUI() throws Exception {
        this.aPercent.setPrecision(4);
        this.aPercent.setMaximumValue((Comparable)new Double(1.0));
        this.aPercent.setMinimumValue((Comparable)new Double(0.0));
        this.bPercent.setPrecision(4);
        this.bPercent.setMaximumValue((Comparable)new Double(1.0));
        this.bPercent.setMinimumValue((Comparable)new Double(0.0));
        this.cPercent.setPrecision(4);
        this.cPercent.setMaximumValue((Comparable)new Double(1.0));
        this.cPercent.setMinimumValue((Comparable)new Double(0.0));
        this.isReport = true;
    }

    @Override
    protected void prmtstorageOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtstorageOrgUnit_dataChanged(e);
    }

    protected OrgUnitInfo getOrgUnitInfo(Object dataObject) {
        if (dataObject == null) {
            return null;
        }
        FullOrgUnitInfo info = null;
        if (dataObject instanceof FullOrgUnitInfo) {
            info = (FullOrgUnitInfo)dataObject;
        } else if (dataObject instanceof FullOrgUnitInfo[]) {
            info = ((FullOrgUnitInfo[])dataObject)[0];
        } else if (dataObject instanceof OrgUnitInfo[]) {
            info = ((OrgUnitInfo[])dataObject)[0];
        } else if (dataObject instanceof OrgUnitInfo) {
            info = (OrgUnitInfo)dataObject;
        } else if (dataObject instanceof Object[]) {
            if ((Object[])dataObject != null) {
                Object object1 = ((Object[])dataObject)[0];
                if (object1 instanceof FullOrgUnitInfo) {
                    info = (FullOrgUnitInfo)object1;
                } else if (object1 instanceof OrgUnitInfo) {
                    info = (OrgUnitInfo)object1;
                } else if (object1 instanceof StorageOrgUnitInfo) {
                    info = (StorageOrgUnitInfo)object1;
                }
            }
        } else if (dataObject instanceof StorageOrgUnitInfo) {
            info = (StorageOrgUnitInfo)dataObject;
        }
        return info;
    }

    public boolean verify() {
        boolean bRet = true;
        if (this.prmtstorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)"\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
            this.prmtstorageOrgUnit.requestFocus();
            return false;
        }
        if (this.prmtPlannedVersion.getValue() == null) {
            MsgBox.showInfo((String)"\u8ba1\u5212\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a");
            this.prmtPlannedVersion.requestFocus();
            return false;
        }
        if (this.combPriceMode.getSelectedItem() == null) {
            MsgBox.showInfo((String)"\u53d6\u4ef7\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
            this.combPriceMode.requestFocus();
            return false;
        }
        OrgUnitInfo stotageInfo = this.getOrgUnitInfo(this.prmtstorageOrgUnit.getValue());
        SOPPlanVersionInfo planVersionInfo = (SOPPlanVersionInfo)this.prmtPlannedVersion.getValue();
        if (!this.prmtPlannedVersion.getText().equals(planVersionInfo.getName())) {
            MsgBox.showError((String)"\u8ba1\u5212\u7248\u672c\u540d\u79f0\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728");
            return false;
        }
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        if (this.aPercent.getText().length() <= 0) {
            MsgBox.showError((String)"A\u7c7b\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.aPercent.requestFocus();
            return false;
        }
        a = this.aPercent.getNumberValue().doubleValue();
        if (this.bPercent.getText().length() <= 0) {
            MsgBox.showError((String)"B\u7c7b\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.bPercent.requestFocus();
            return false;
        }
        b = this.bPercent.getNumberValue().doubleValue();
        if (this.cPercent.getText().length() <= 0) {
            MsgBox.showError((String)"C\u7c7b\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.cPercent.requestFocus();
            return false;
        }
        c = this.cPercent.getNumberValue().doubleValue();
        double sumPercent = (double)Math.round((a + b + c) * 1000.0) / 1000.0;
        if (!new Double(sumPercent).equals(new Double(1.0))) {
            MsgBox.showError((String)"A\u7c7b\u6bd4\u4f8b+B\u7c7b\u6bd4\u4f8b+C\u7c7b\u6bd4\u4f8b\u4e0d\u7b49\u4e8e1\uff01");
            this.aPercent.requestFocus();
            return false;
        }
        return bRet;
    }

    private EntityViewInfo getMainOrgUnitFilter(Set set) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(this.getPropertyOfMainBizOrg(), (Object)set, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private Map isFilterPermission(String[] str, OrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        ISOPPermissionFacade sopPermFacade = SOPPermissionFacadeFactory.getRemoteInstance();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Map permMap = sopPermFacade.checkPermissions(userPK.toString(), orgUnitInfo.getId().toString(), str);
        return permMap;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtstorageOrgUnit.removeDataChangeListener(this.storageOrgUnitDataChanged);
        OrgUnitInfo[] sop = this.getMainOrgs();
        HashSet<String> filterSet = new HashSet<String>();
        String[] str = new String[]{SALE_PERMISSION, PRODUCT_PERMISSION};
        for (int i = 0; i < sop.length; ++i) {
            OrgUnitInfo info = sop[i];
            Map filterMap = this.isFilterPermission(str, info);
            Boolean str1 = (Boolean)filterMap.get(str[0]);
            Boolean str2 = (Boolean)filterMap.get(str[1]);
            if (!str1.booleanValue() && !str2.booleanValue()) continue;
            filterSet.add(info.getId().toString());
        }
        this.prmtstorageOrgUnit.setEntityViewInfo(this.getMainOrgUnitFilter(filterSet));
        this.storageOrgUnitDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                SOPMaterialABCFilterUI.this.prmtProductionOrgUnit_dataChanged(e);
            }
        };
        this.prmtstorageOrgUnit.addDataChangeListener(this.storageOrgUnitDataChanged);
        this.setMaterialFilter();
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtmaterialNumFrom, this.prmtmaterialNumTo, this.prmtPlannedVersion});
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtstorageOrgUnit, (OrgType)OrgType.Storage, null);
        this.prmtmaterialNumFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (SOPMaterialABCFilterUI.this.prmtstorageOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\uff01");
                    SOPMaterialABCFilterUI.this.prmtstorageOrgUnit.requestFocus();
                    e.setCanceled(true);
                }
            }
        });
        this.prmtmaterialNumTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (SOPMaterialABCFilterUI.this.prmtstorageOrgUnit.getValue() == null) {
                    MsgBox.showInfo((String)"\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\uff01");
                    SOPMaterialABCFilterUI.this.prmtstorageOrgUnit.requestFocus();
                    e.setCanceled(true);
                }
            }
        });
        this.prmtSupplyOrgUnit.setEnabledMultiSelection(true);
        this.setSupplyOrgUnitFilter();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("StoragergUnit", (Component)this.prmtstorageOrgUnit);
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("supplyOrgUnit", (Component)this.prmtSupplyOrgUnit));
        elements.add((FilterElement)new SingleFilterElement("beginMaterial", (Component)this.prmtmaterialNumFrom));
        elements.add((FilterElement)new SingleFilterElement("endMaterial", (Component)this.prmtmaterialNumTo));
        MMUtils.filterRangF7Helper((Component)this.prmtmaterialNumFrom, (Component)this.prmtmaterialNumTo);
        elements.add((FilterElement)new SingleFilterElement("planVersion", (Component)this.prmtPlannedVersion));
        elements.add((FilterElement)new SingleFilterElement("numOfPeriod", (Component)this.sprNumberOfTerm));
        elements.add((FilterElement)new SingleFilterElement("SOPPlanTerm", (Component)this.cmbSOPPlanTerm){

            protected String getNumber(Object obj) {
                if (obj instanceof KDComboBox && ((KDComboBox)obj).getSelectedItem() instanceof SOPPeriod) {
                    return ((KDComboBox)obj).getSelectedItem().toString();
                }
                return super.getNumber(obj);
            }
        });
        SingleFilterElement element = null;
        element = new SingleFilterElement("aPercent", (Component)this.aPercent);
        element.setDefaultValue((Object)new Double(0.7));
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("bPercent", (Component)this.bPercent);
        element.setDefaultValue((Object)new Double(0.2));
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("cPercent", (Component)this.cPercent);
        element.setDefaultValue((Object)new Double(0.1));
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("priceMode", (Component)this.combPriceMode);
        elements.add((FilterElement)element);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
    }

    private void prmtProductionOrgUnit_dataChanged(DataChangeEvent e) {
        Object newValue = e.getNewValue();
        if (newValue == null || e.getOldValue() == e.getNewValue()) {
            if (newValue == null) {
                this.prmtmaterialNumFrom.setValue(null);
                this.prmtmaterialNumTo.setValue(null);
            }
            return;
        }
        OrgUnitInfo orgInfo = this.getOrgUnitInfo(e.getNewValue());
        if (orgInfo != null) {
            if (this.SOPParams == null) {
                try {
                    if (this.sopFacade == null) {
                        this.sopFacade = SOPFacadeFactory.getRemoteInstance();
                    }
                    this.SOPParams = this.sopFacade.getSOPSysParams(orgInfo.getId().toString());
                    if (this.SOPParams == null) {
                        MsgBox.showInfo((String)"SOP\u53c2\u6570\u4e0d\u5b58\u5728");
                        SysUtil.abort();
                    }
                }
                catch (EASBizException e1) {
                    this.handUIException(e1);
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
            }
            this.prmtmaterialNumFrom.setValue(null);
            this.prmtmaterialNumTo.setValue(null);
            this.loadPlanPeriod();
        }
    }

    private void setMaterialFilter() {
        String queryInfo = UIHelper.getMaterialPlanQueryForSopFilter((int)this.f7Manager.getF7DisplayMode());
        this.setBizMaterialF7(this.prmtmaterialNumFrom, false, queryInfo);
        this.setBizMaterialF7(this.prmtmaterialNumTo, false, queryInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        OrgUnitInfo stotageInfo = this.getOrgUnitInfo(this.prmtstorageOrgUnit.getValue());
        if (stotageInfo == null) {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)" ", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)stotageInfo.getId(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("Status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("plan.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtmaterialNumTo.setEntityViewInfo(view);
        this.prmtmaterialNumFrom.setEntityViewInfo(view);
    }

    private void setSupplyOrgUnitFilter() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmtSupplyOrgUnit.setEntityViewInfo(viewInfo);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        OrgUnitInfo stotageInfo = this.getOrgUnitInfo(this.prmtstorageOrgUnit.getValue());
        pp.addCustomerParam("storageOrgUnit.id", stotageInfo.getId().toString());
        pp.addCustomerParam("storageOrgUnit.name", stotageInfo.getName().toString());
        String supplyOrgUnit = null;
        if (this.prmtSupplyOrgUnit.getText() != null && !this.prmtSupplyOrgUnit.getText().equals("")) {
            supplyOrgUnit = ((OrgUnitInfo)this.prmtSupplyOrgUnit.getValue()).getNumber();
        }
        pp.addCustomerParam("supplyOrgUnit.number", supplyOrgUnit);
        SOPPlanVersionInfo planVersionInfo = (SOPPlanVersionInfo)this.prmtPlannedVersion.getValue();
        pp.addCustomerParam("planVersion.id", planVersionInfo.getId().toString());
        if (planVersionInfo.getName() == null) {
            planVersionInfo.setName("");
        }
        pp.addCustomerParam("planVersion.name", planVersionInfo.getName().toString());
        pp.addCustomerParam("planVersion.isActivation", String.valueOf(planVersionInfo.isActivation()));
        SOPPeriod selectePeriod = (SOPPeriod)this.cmbSOPPlanTerm.getSelectedItem();
        pp.putDate("selectePeriod.beginDate", selectePeriod.getBeginDate().getTime());
        pp.putDate("selectePeriod.endDate", selectePeriod.getEndDate().getTime());
        pp.putInt("selectePeriod.year", selectePeriod.getYear());
        pp.putInt("selectePeriod.number", selectePeriod.getNumber());
        pp.putInt("selectePeriod.paramMonthStartDay", selectePeriod.getParamMonthStartDay());
        pp.putInt("numOfPeriod", Integer.parseInt(this.sprNumberOfTerm.getValue().toString()));
        pp.addCustomerParam("priceMode", this.combPriceMode.getSelectedItem().toString());
        return pp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    private void loadPlanPeriod() {
        OrgUnitInfo info = this.getOrgUnitInfo(this.prmtstorageOrgUnit.getValue());
        if (info != null) {
            this.horizon = this.SOPParams.getSOPMonthHorizon();
            try {
                if (this.sopFacade == null) {
                    this.sopFacade = SOPFacadeFactory.getRemoteInstance();
                }
                this.curPeriod = this.sopFacade.getCurrentPeriod(SOPEditModeEnum.MONTHLY, info.getId().toString());
                this.periods = this.curPeriod.periodRange(this.horizon);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.cmbSOPPlanTerm.removeAllItems();
            this.cmbSOPPlanTerm.addItems((Object[])this.periods);
            this.cmbSOPPlanTerm.setSelectedItem((Object)this.periods[this.horizon - 1]);
            this.SetSpinnerMaxMin((JSpinner)this.sprNumberOfTerm, 1, this.horizon);
            this.sprNumberOfTerm.setValue((Object)new Integer(this.horizon));
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        if (this.cp.getCustomerParam("prmtSupplyOrgUnit") != null && this.cp.getCustomerParam("prmtSupplyOrgUnit").length() != 0) {
            String supplyOrgUnit = this.cp.getCustomerParam("prmtSupplyOrgUnit");
            this.prmtSupplyOrgUnit.setText(supplyOrgUnit);
        }
        if (this.cp.getCustomerParam("prmtPlannedVersion") != null) {
            SOPPlanVersionInfo planVersionInfo = new SOPPlanVersionInfo();
            planVersionInfo.setActivation(this.cp.getBoolean("planVersion.isActivation"));
            planVersionInfo.setName(this.cp.getCustomerParam("planVersion.name"));
            planVersionInfo.setNumber(this.cp.getCustomerParam("prmtPlannedVersion"));
            planVersionInfo.setId(BOSUuid.read((String)this.cp.getCustomerParam("planVersion.id")));
            this.prmtPlannedVersion.setValue((Object)planVersionInfo);
            StorageOrgUnitInfo storageInfo = new StorageOrgUnitInfo();
            storageInfo.setId(BOSUuid.read((String)this.cp.getCustomerParam("storageOrgUnit.id")));
            storageInfo.setName(this.cp.getCustomerParam("storageOrgUnit.name"));
            storageInfo.setNumber(this.cp.getCustomerParam("prmtstorageOrgUnit"));
            this.prmtstorageOrgUnit.setValue((Object)storageInfo);
            if (this.SOPParams == null) {
                try {
                    if (this.sopFacade == null) {
                        this.sopFacade = SOPFacadeFactory.getRemoteInstance();
                    }
                    this.SOPParams = this.sopFacade.getSOPSysParams(storageInfo.getId().toString());
                    if (this.SOPParams == null) {
                        MsgBox.showInfo((String)"SOP\u53c2\u6570\u4e0d\u5b58\u5728");
                        SysUtil.abort();
                    }
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
            SOPEditModeEnum editmode = null;
            if (Integer.parseInt(this.cp.getCustomerParam("cmbEditMode").toString()) == 20) {
                editmode = SOPEditModeEnum.MONTHLY;
                this.horizon = this.SOPParams.getSOPMonthHorizon();
            }
            if (Integer.parseInt(this.cp.getCustomerParam("cmbEditMode").toString()) == 10) {
                editmode = SOPEditModeEnum.WEEKLY;
                this.horizon = this.SOPParams.getSOPMonthHorizon();
            }
            if (this.curPeriod == null) {
                try {
                    if (this.sopFacade == null) {
                        this.sopFacade = SOPFacadeFactory.getRemoteInstance();
                    }
                    this.curPeriod = this.sopFacade.getCurrentPeriod(editmode, storageInfo.getId().toString());
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
            Object selectePeriod = new SOPPeriod();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.cp.getDate("selectePeriod.beginDate"));
            selectePeriod.setBeginDate(calendar);
            calendar.setTime(this.cp.getDate("selectePeriod.endDate"));
            selectePeriod.setEndDate(calendar);
            selectePeriod.setNumber(this.cp.getInt("selectePeriod.number"));
            selectePeriod.setYear(this.cp.getInt("selectePeriod.year"));
            selectePeriod.setParamMonthStartDay(this.cp.getInt("selectePeriod.paramMonthStartDay"));
            selectePeriod.setType(editmode);
            Object[] periods = null;
            try {
                periods = this.curPeriod.periodRange(this.horizon);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.cmbSOPPlanTerm.removeAllItems();
            this.cmbSOPPlanTerm.addItems(periods);
            Object minPeriod = periods[0];
            Object maxPeriod = periods[this.horizon + this.horizon - 2];
            if (maxPeriod.toNumber() < selectePeriod.toNumber()) {
                selectePeriod = maxPeriod;
            }
            if (minPeriod.toNumber() > selectePeriod.toNumber()) {
                selectePeriod = minPeriod;
            }
            this.cmbSOPPlanTerm.setSelectedItem(selectePeriod);
            this.SetSpinnerMaxMin((JSpinner)this.sprNumberOfTerm, 1, this.horizon);
            int numOfPeriod = this.cp.getInt("numOfPeriod");
            if (numOfPeriod > this.horizon) {
                numOfPeriod = this.horizon;
            }
            this.sprNumberOfTerm.setValue((Object)new Integer(numOfPeriod));
            this.prmtmaterialNumFrom.setText(this.cp.getCustomerParam("prmtmaterialNumFrom"));
            this.prmtmaterialNumTo.setText(this.cp.getCustomerParam("prmtmaterialNumTo"));
        }
    }

    private void SetSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel) {
            if (max >= min) {
                ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            }
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }
}

