/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.scm.inv.client;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.scm.inv.ReNewMaterialReqTemEntryInfo;
import com.kingdee.eas.industry.emm.scm.inv.ReNewMaterialReqTemFactory;
import com.kingdee.eas.industry.emm.scm.inv.ReNewMaterialReqTemInfo;
import com.kingdee.eas.industry.emm.scm.inv.client.AbstractReNewMaterialReqTemEditUI;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ReNewMaterialReqTemEditUI
extends AbstractReNewMaterialReqTemEditUI
implements DataChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(ReNewMaterialReqTemEditUI.class);
    private String RESURL = "com.kingdee.eas.industry.emm.reworkprocess.EMMEMReworkprocess";
    public static final String MATERIALNUM = "materialNum";
    public static final String MATERIALNAME = "materialName";
    public static final String REQCLASS = "reqClass";
    public static final String BASEUNIT = "baseUnit";
    public static final String QTY = "qty";
    public static final String MODEL = "model";
    protected F7ContextManager f7Manager = null;
    protected KDBizPromptBox prmtEntryMaterial = new KDBizPromptBox();
    protected KDBizPromptBox prmtReqClass = new KDBizPromptBox();
    protected SCMFetchData scmFetchData = new SCMFetchData();
    protected static int defaultQtyPrecision = 2;
    protected KDFormattedTextField qtyField = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReNewMaterialReqTemFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        ReNewMaterialReqTemEntryInfo reNewReqEntryInfo = new ReNewMaterialReqTemEntryInfo();
        reNewReqEntryInfo.setQty(new BigDecimal("0.00"));
        return reNewReqEntryInfo;
    }

    @Override
    protected IObjectValue createNewData() {
        ReNewMaterialReqTemInfo objectValue = new ReNewMaterialReqTemInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setBizDate(new Date());
        objectValue.setCreateTime(new Timestamp(new Date().getTime()));
        ReNewMaterialReqTemEntryInfo entryInfo = (ReNewMaterialReqTemEntryInfo)this.createNewDetailData(this.kdtEntrys);
        objectValue.getEntrys().add(entryInfo);
        return objectValue;
    }

    public void onLoad() throws Exception {
        if (this.isFirstOnload()) {
            this.f7Manager = new F7ContextManager((Component)((Object)this), OrgType.Storage);
        }
        super.onLoad();
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.iniDataAndTabelEntry();
    }

    public void iniDataAndTabelEntry() {
        SCMClientUtils.setBizMaterialF7WhithParam((KDBizPromptBox)this.prmtmaterial, null, (OrgType)OrgType.Storage, (boolean)false, null);
        this.prmtmaterial.setRequired(true);
        this.pkBizDate.setRequired(true);
        this.txtNumber.setEditable(false);
        this.qtyField = new KDFormattedTextField(1);
        this.qtyField.setPrecision(defaultQtyPrecision);
        this.qtyField.setNegatived(false);
        KDTDefaultCellEditor qtyEditor = new KDTDefaultCellEditor((JTextField)this.qtyField);
        this.f7Manager.registerBizMaterialF7(this.prmtEntryMaterial, this.kdtEntrys.getColumn(MATERIALNUM), null, null, true);
        this.initReqClassF7();
        this.kdtEntrys.getColumn(MATERIALNUM).setRequired(true);
        this.kdtEntrys.getColumn(QTY).setRequired(true);
        this.kdtEntrys.getColumn(MATERIALNAME).getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn(BASEUNIT).getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn(MODEL).getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn(QTY).setEditor((ICellEditor)qtyEditor);
    }

    public void initReqClassF7() {
        this.prmtReqClass.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7WorkcenterQuery");
        this.prmtReqClass.setVisible(true);
        this.prmtReqClass.setEditable(true);
        this.prmtReqClass.setDisplayFormat("$number$");
        this.prmtReqClass.setEditFormat("$number$");
        this.prmtReqClass.setCommitFormat("$number$");
        EntityViewInfo entityInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)20, CompareType.EQUALS));
        entityInfo.setFilter(filterInfo);
        this.prmtReqClass.setEntityViewInfo(entityInfo);
        KDTDefaultCellEditor kdtEntrys_reqClass_CellEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtReqClass);
        this.kdtEntrys.getColumn(REQCLASS).setEditor((ICellEditor)kdtEntrys_reqClass_CellEditor);
        ObjectValueRender kdtEntrys_reqClass_OVR = new ObjectValueRender();
        kdtEntrys_reqClass_OVR.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntrys.getColumn(REQCLASS).setRenderer((IBasicRender)kdtEntrys_reqClass_OVR);
    }

    protected void insertLine(KDTable table) {
        super.insertLine(table);
    }

    public void validataPageData() {
        if (this.prmtmaterial.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.EMMEMScmResource", (String)"0EMMSCM-0008"));
            this.prmtmaterial.requestFocus();
            SysUtil.abort();
        }
        if (this.pkBizDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.EMMEMScmResource", (String)"0EMMSCM-0009"));
            this.pkBizDate.requestFocus();
            SysUtil.abort();
        }
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            BigDecimal qty;
            IRow curRow = this.kdtEntrys.getRow(i);
            String strInfo = EASResource.getString((String)this.RESURL, (String)"DXH_INFO", (Object[])new Object[]{i + 1});
            if (curRow.getCell(MATERIALNUM).getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)(strInfo + EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.EMMEMScmResource", (String)"0EMMSCM-0010")));
                this.kdtEntrys.getEditManager().editCellAt(curRow.getRowIndex(), this.kdtEntrys.getColumnIndex(MATERIALNUM));
                SysUtil.abort();
            }
            if (curRow.getCell(QTY).getValue() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)(strInfo + EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.EMMEMScmResource", (String)"0EMMSCM-0011")));
                this.kdtEntrys.getEditManager().editCellAt(curRow.getRowIndex(), this.kdtEntrys.getColumnIndex(QTY));
                SysUtil.abort();
            }
            if ((qty = (BigDecimal)curRow.getCell(QTY).getValue()).compareTo(BigDecimal.ZERO) != 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)(strInfo + EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.EMMEMScmResource", (String)"0EMMSCM-0012")));
            this.kdtEntrys.getEditManager().editCellAt(curRow.getRowIndex(), this.kdtEntrys.getColumnIndex(QTY));
            SysUtil.abort();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.validataPageData();
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.validataPageData();
        super.actionSubmit_actionPerformed(e);
    }

    protected void initListener() {
        this.prmtEntryMaterial.addDataChangeListener((DataChangeListener)this);
        super.initListener();
    }

    public void dataChanged(DataChangeEvent e) {
        if (e.getSource().equals(this.prmtEntryMaterial)) {
            this.materialChange(e);
        }
    }

    protected void materialChange(DataChangeEvent e) {
        Object newValue = e.getNewValue();
        KDTSelectBlock ksb = this.kdtEntrys.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        int endRow = this.getDetailTable().getRowCount() - 1;
        if (ksb == null) {
            return;
        }
        if (newValue == null) {
            return;
        }
        if (!(newValue instanceof MaterialInfo[]) && !(newValue instanceof Object[])) {
            return;
        }
        MaterialInfo[] materialInfos = null;
        if (newValue instanceof MaterialInfo[]) {
            materialInfos = (MaterialInfo[])newValue;
        } else if (newValue instanceof Object[]) {
            Object[] objects = (Object[])newValue;
            if (objects.length == 0) {
                return;
            }
            materialInfos = new MaterialInfo[objects.length];
            System.arraycopy(objects, 0, materialInfos, 0, objects.length);
        } else {
            return;
        }
        int length = materialInfos.length;
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                if (materialInfos[i] == null) {
                    return;
                }
                IRow curRow = null;
                if (i < length - 1) {
                    this.addLine(this.kdtEntrys);
                }
                if (i == 0) {
                    IRow igeginRow = this.kdtEntrys.getRow(beginRow);
                    this.saveMaterial(igeginRow, materialInfos[i]);
                    continue;
                }
                curRow = this.kdtEntrys.getRow(endRow + i);
                this.saveMaterial(curRow, materialInfos[i]);
            }
        }
    }

    protected void saveMaterial(IRow row, MaterialInfo materialInfo) {
        if (materialInfo != null) {
            row.getCell(MATERIALNUM).setValue((Object)materialInfo);
            row.getCell(MATERIALNAME).setValue((Object)materialInfo.getName());
            row.getCell(MODEL).setValue((Object)materialInfo.getModel());
            try {
                MeasureUnitInfo baseUnitInfo = this.scmFetchData.getBaseUnit(materialInfo.getId().toString());
                row.getCell(BASEUNIT).setValue((Object)baseUnitInfo);
                int qtyPrecision = baseUnitInfo.getQtyPrecision();
                BigDecimal qty = (BigDecimal)row.getCell(QTY).getValue();
                if (qty != null) {
                    row.getCell(QTY).setValue((Object)qty.setScale(qtyPrecision));
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }
}

