/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.client.BomFilterUI;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProConfigBomFilterUI
extends BomFilterUI {
    private String RESURL = "com.kingdee.eas.mm.basedata.EMMEMBasedataResource";
    private String XMUHBWK_NAME = EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"XMHBNWK_NAME");
    private static final long serialVersionUID = -20404291384113957L;
    protected KDCheckBox expandAllNextBOM;

    public ProConfigBomFilterUI() throws Exception {
        this.init();
    }

    public ProConfigBomFilterUI(String order) throws Exception {
        super(order);
        this.init();
        this.setUITitle(com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"EM_XMPZBOMTJCX"));
    }

    protected void init() {
        this.expandAllNextBOM = new KDCheckBox();
        this.expandAllNextBOM.setName("");
        this.expandAllNextBOM.setText(com.kingdee.bos.util.EASResource.getString((String)"com.kingdee.eas.mm.basedata.EMMEMBasedataResource", (String)"EM_ZKSYXCBOM"));
    }

    public void initBomFilterUILayout() {
        super.initBomFilterUILayout();
        this.lblMaterialTo.setVisible(false);
        this.expandAllNextBOM.setBounds(new Rectangle(250, 54, 190, 19));
        this.add((Component)this.expandAllNextBOM, new KDLayout.Constraints(250, 54, 190, 19, 0));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        CompositeFilterElement elements = (CompositeFilterElement)this.getFilterManager().getElement();
        elements.add((FilterElement)new SingleFilterElement("material.number", (Component)this.prmptMaterialFrom));
        elements.add((FilterElement)new SingleFilterElement("expandAllNextBOM", (Component)this.expandAllNextBOM));
        this.cmbBomType.setSelectedItem((Object)BOMTypeEnum.ProConfigBOM);
        SingleFilterElement bomTypeElement = new SingleFilterElement("bomType", (Component)this.cmbBomType);
        bomTypeElement.setDefaultValue((Object)BOMTypeEnum.ProConfigBOM);
        elements.add((FilterElement)bomTypeElement);
        this.cmbBomType.setEnabled(false);
        this.prmtProject.setRequired(true);
    }

    public boolean verify() {
        try {
            if (this.getProjectID() == null || "".equals(this.getProjectID())) {
                MsgBox.showWarning((String)this.XMUHBWK_NAME);
                SysUtil.abort();
            }
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        return super.verify();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        if (filter == null) {
            return filter;
        }
        this.removeFilterItem(filter, "expandAllNextBOM");
        if (this.expandAllNextBOM != null && this.expandAllNextBOM.isSelected()) {
            try {
                String projectID = this.getProjectID();
                Set materialIds = this.getMaterialIDs();
                Set bomids = BomFactory.getRemoteInstance().expandBOM(projectID, materialIds);
                if (bomids != null && bomids.size() > 0) {
                    FilterInfo filter_id = new FilterInfo();
                    filter_id.getFilterItems().add(new FilterItemInfo("id", (Object)bomids, CompareType.INCLUDE));
                    this.removeFilterItem(filter, "material.number");
                    filter.setMaskString(null);
                    filter.mergeFilter(filter_id, "and");
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return filter;
    }

    protected boolean removeFilterItem(FilterInfo filter, String ... propertyName) {
        FilterItemCollection items = filter.getFilterItems();
        ArrayList<FilterItemInfo> removes = new ArrayList<FilterItemInfo>();
        List<String> ppns = Arrays.asList(propertyName);
        for (int i = 0; i < items.size(); ++i) {
            String ppn = items.get(i).getPropertyName();
            if (!ppns.contains(ppn)) continue;
            removes.add(items.get(i));
        }
        boolean re = false;
        for (int i = 0; i < removes.size(); ++i) {
            re = items.remove((FilterItemInfo)removes.get(i));
        }
        filter.setMaskString(null);
        return re;
    }

    protected String getProjectID() throws BOSException {
        Object o = this.prmtProject.getValue();
        if (o == null) {
            o = this.prmtProject.getText();
        }
        String projectID = null;
        if (o != null) {
            ProjectCollection pc;
            ProjectInfo pi = null;
            if (Object[].class.isInstance(o)) {
                Object[] os = (Object[])o;
                if (os.length > 0) {
                    pi = (ProjectInfo)os[0];
                }
            } else if (ProjectInfo.class.isInstance(o)) {
                pi = (ProjectInfo)o;
            } else if (String.class.isInstance(o) && (pc = ProjectFactory.getRemoteInstance().getProjectCollection("where number = '" + o + "'")) != null && pc.size() > 0) {
                pi = pc.get(0);
            }
            if (pi != null) {
                projectID = pi.getId().toString();
            }
        }
        return projectID;
    }

    protected Set getMaterialIDs() throws BOSException {
        Object o = this.prmptMaterialFrom.getValue();
        if (o == null) {
            o = this.prmptMaterialFrom.getText();
        }
        String id = null;
        if (o != null) {
            MaterialInfo mi = null;
            if (MaterialInfo.class.isInstance(o)) {
                mi = (MaterialInfo)o;
            } else if (String.class.isInstance(o)) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("id"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", o));
                MaterialCollection mc = MaterialFactory.getRemoteInstance().getMaterialCollection(evi);
                if (mc != null && mc.size() > 0) {
                    mi = mc.get(0);
                }
            }
            if (mi != null) {
                id = mi.getId().toString();
            }
        }
        if (id == null) {
            return null;
        }
        HashSet<String> ids = new HashSet<String>();
        ids.add(id);
        return ids;
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.expandAllNextBOM.setSelected(false);
    }

    protected void bomTypeChanged(ItemEvent e) {
        super.bomTypeChanged(e);
        this.prmtProject.setRequired(true);
    }
}

