/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.mo.DirectMaterialVector;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.List;

public class DirectMaterialSingleton {
    private static DirectMaterialSingleton instance;
    private Context ctx;
    private static List<Integer> list;

    private DirectMaterialSingleton(Context _ctx) {
        this.ctx = _ctx;
        this.initDirectMaterialSingletion();
    }

    private void initDirectMaterialSingletion() {
        String sql = "select CFMATERIALID,cfprojectid,CFTRACKID ,cfsupplierid from CT_DIR_DirectFeedingmMaterial where CFISZJ = 1 AND CFSTATUS = 1 ";
        try {
            IRowSet rsA = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rsA.next()) {
                String materialid = rsA.getString("CFMATERIALID");
                String projectid = rsA.getString("cfprojectid");
                String trackid = rsA.getString("CFTRACKID");
                String supplierid = rsA.getString("cfsupplierid");
                DirectMaterialVector vector = new DirectMaterialVector(materialid, projectid, trackid, supplierid);
                list.add(vector.hashCode());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static synchronized DirectMaterialSingleton getInstance(Context _ctx) {
        if (instance == null) {
            instance = new DirectMaterialSingleton(_ctx);
        }
        return instance;
    }

    public boolean isDirectMaterial(String materialid, String projectid, String trackid, String supplierid) throws BOSException, EASBizException {
        DirectMaterialVector vector = new DirectMaterialVector(materialid, projectid, trackid, supplierid);
        boolean isDirectMaterial = false;
        if (list.contains(vector.hashCode())) {
            isDirectMaterial = true;
        }
        return isDirectMaterial;
    }

    public boolean isDirectMaterial(String materialid, String projectid, String trackid) throws BOSException, EASBizException {
        DirectMaterialVector vector = new DirectMaterialVector(materialid, projectid, trackid, null);
        boolean isDirectMaterial = false;
        if (list.contains(vector.hashCode())) {
            isDirectMaterial = true;
        }
        return isDirectMaterial;
    }

    public void clear() {
        instance = null;
        list.clear();
    }

    static {
        list = new ArrayList<Integer>();
    }
}

