/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.IsolatedRuleEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.mm.basedata.ManufactureStrategyGroup;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.client.BomF7ListUI;
import com.kingdee.eas.mm.project.ProjectInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class BomF7ListUIPIEx
extends BomF7ListUI {
    private static final long serialVersionUID = 4668367154287735170L;
    private StorageOrgUnitInfo mainOrgInfo = null;
    private Map materialPlanMap = new HashMap();

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        Integer status = new Integer(4);
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)status, CompareType.EQUALS));
        String storageOrgUnitId = this.mainOrgInfo.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        MaterialInfo materialInfo = (MaterialInfo)this.prmtmaterial.getValue();
        if (materialInfo == null || materialInfo.getId() == null) {
            return filter;
        }
        String materialId = materialInfo.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        boolean isSelected = this.chkOrderBomCheckProTra.isSelected();
        if (isSelected) {
            try {
                filter = this.getFilterInfo(filter, materialId);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            HashSet<Integer> bomTypeSet = new HashSet<Integer>();
            bomTypeSet.add(new Integer(40));
            bomTypeSet.add(new Integer(45));
            bomTypeSet.add(new Integer(50));
            bomTypeSet.add(new Integer(80));
            filter.getFilterItems().add(new FilterItemInfo("bomType", bomTypeSet, CompareType.INCLUDE));
        }
        return filter;
    }

    public void onLoad() throws Exception {
        this.mainOrgInfo = (StorageOrgUnitInfo)this.getUIContext().get("ORG");
        super.onLoad();
    }

    private FilterInfo getFilterInfo(FilterInfo filter, String materialId) throws BOSException {
        MaterialPlanInfo plan = this.getMaterialPlan(materialId);
        if (plan == null) {
            return filter;
        }
        String strategyId = "NUnM+gEcEADgAA3cwKgL09g0uEU=";
        if (plan.getManufactureStrategy() != null) {
            strategyId = plan.getManufactureStrategy().getId().toString();
        }
        String trackId = null;
        if (this.prmtTrack.getValue() != null && this.prmtTrack.getValue() instanceof TrackNumberInfo) {
            trackId = ((TrackNumberInfo)this.prmtTrack.getValue()).getId().toString();
        }
        if (ManufactureStrategyGroup.getProjectTrackOrderBomStrategyIdSet().contains(strategyId)) {
            FilterInfo f1 = new FilterInfo();
            Integer bomType = new Integer(40);
            f1.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
            FilterInfo f3 = new FilterInfo();
            bomType = new Integer(50);
            f3.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
            f1.mergeFilter(f3, "or");
            FilterInfo f4 = new FilterInfo();
            bomType = new Integer(80);
            f4.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
            f1.mergeFilter(f4, "or");
            FilterInfo f2 = new FilterInfo();
            bomType = new Integer(45);
            f2.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
            IsolatedRuleEnum isolatedRule = plan.getIsolatedRule();
            if (!IsolatedRuleEnum.NONE.equals((Object)isolatedRule)) {
                String projectId = null;
                if (this.prmtProject.getValue() != null && this.prmtProject.getValue() instanceof ProjectInfo) {
                    projectId = ((ProjectInfo)this.prmtProject.getValue()).getId().toString();
                }
                f2.getFilterItems().add(new FilterItemInfo("orderBomTP.projectId", projectId, CompareType.EQUALS));
            }
            if (IsolatedRuleEnum.ITEM_TRACKNO.equals((Object)isolatedRule)) {
                f2.getFilterItems().add(new FilterItemInfo("orderBomTP.trackId", (Object)trackId, CompareType.EQUALS));
            }
            f1.mergeFilter(f2, "or");
            filter.mergeFilter(f1, "and");
        } else if (ManufactureStrategyGroup.getTrackOrderBomStrategyIdSet().contains(strategyId)) {
            FilterInfo f1 = new FilterInfo();
            Integer bomType = new Integer(40);
            f1.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
            FilterInfo f3 = new FilterInfo();
            bomType = new Integer(50);
            f3.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
            f1.mergeFilter(f3, "or");
            FilterInfo f4 = new FilterInfo();
            bomType = new Integer(80);
            f4.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
            f1.mergeFilter(f4, "or");
            FilterInfo f2 = new FilterInfo();
            bomType = new Integer(45);
            f2.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
            f2.getFilterItems().add(new FilterItemInfo("orderBomTP.trackId", (Object)trackId, CompareType.EQUALS));
            f2.getFilterItems().add(new FilterItemInfo("orderBomTP.projectId", null, CompareType.EQUALS));
            f1.mergeFilter(f2, "or");
            filter.mergeFilter(f1, "and");
        } else if (ManufactureStrategyGroup.getNoOrderBomStrategyIdSet().contains(strategyId)) {
            Integer bomType = new Integer(40);
            filter.getFilterItems().add(new FilterItemInfo("bomType", (Object)bomType, CompareType.EQUALS));
        }
        return filter;
    }

    private MaterialPlanInfo getMaterialPlan(String materialId) {
        String orgId = this.mainOrgInfo.getId().toString();
        String key = orgId + materialId;
        MaterialPlanInfo plan = null;
        if (this.materialPlanMap.containsKey(key)) {
            plan = (MaterialPlanInfo)this.materialPlanMap.get(key);
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection selectorColl = new SelectorItemCollection();
            selectorColl.add("manufactureStrategy.id");
            selectorColl.add("isolatedRule");
            view.setSelector(selectorColl);
            try {
                MaterialPlanCollection coll = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
                if (coll != null && coll.size() > 0) {
                    plan = coll.get(0);
                    this.materialPlanMap.put(key, plan);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return plan;
    }
}

