/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.mo.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.zj.SqlExcFacadeFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.client.AbstractMergeTechMaterialViewUI;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MergeTechMaterialViewUI
extends AbstractMergeTechMaterialViewUI {
    public static final String COL_DT_DISTRIBUTIONQTY = "distributionQty";
    public static final String COL_DT_INVENTORY = "inventory";
    private static final long serialVersionUID = 9136743186815172714L;

    public MergeTechMaterialViewUI() throws Exception {
        this.lblDesc.setText(EASResource.getString((String)"com.kingdee.eas.mm.mo.EMMEMMoResource", (String)"0EMMMO-0079"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.detailTable.checkParsed();
        this.detailTable.setEditable(false);
        this.detailTable.getActionMap().remove("FocusChangeCol");
        this.detailTable.getActionMap().remove("FocusChangeColReverse");
        this.detailTable.getActionMap().remove("FocusChangeRow");
        this.detailTable.getActionMap().remove("FocusChangeRowReverse");
        this.detailTable.getSelectManager().setSelectMode(2);
        this.detailTable.getHead().getRow(0).getCell(9).setValue((Object)EASResource.getString((String)"com.kingdee.eas.mm.mo.EMMEMMoResource", (String)"0EMMMO-0079"));
        this.invTable.checkParsed();
        this.invTable.setEditable(false);
        this.fillDetailData();
    }

    protected void addDetailFootRow() {
        BigDecimal sumPlannedQty = BigDecimal.ZERO;
        BigDecimal sumCurStoreQty = BigDecimal.ZERO;
        int rowCount = this.detailTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.detailTable.getRow(i);
            BigDecimal plannedQty = (BigDecimal)row.getCell("plannedQty").getValue();
            BigDecimal curStoreQty = (BigDecimal)row.getCell("curStoreQty").getValue();
            sumPlannedQty = sumPlannedQty.add(plannedQty);
            sumCurStoreQty = sumCurStoreQty.add(curStoreQty);
        }
        IRow footRow = null;
        KDTFootManager footRowManager = this.detailTable.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(this.detailTable);
            footRowManager.addFootView();
            this.detailTable.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            this.detailTable.getIndexColumn().setWidthAdjustMode((short)1);
            this.detailTable.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        } else {
            footRow = footRowManager.getFootRow(0);
        }
        footRow.getCell("plannedQty").setValue((Object)sumPlannedQty);
        footRow.getCell("curStoreQty").setValue((Object)sumCurStoreQty);
        footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
    }

    protected void addInvFootRow() {
        BigDecimal sumCurStoreQty = BigDecimal.ZERO;
        int rowCount = this.invTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.invTable.getRow(i);
            BigDecimal curStoreQty = (BigDecimal)row.getCell("curStoreQty").getValue();
            sumCurStoreQty = sumCurStoreQty.add(curStoreQty);
        }
        IRow footRow = null;
        KDTFootManager footRowManager = this.invTable.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(this.invTable);
            footRowManager.addFootView();
            this.invTable.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            this.invTable.getIndexColumn().setWidthAdjustMode((short)1);
            this.invTable.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        } else {
            footRow = footRowManager.getFootRow(0);
        }
        footRow.getCell("curStoreQty").setValue((Object)sumCurStoreQty);
        footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        super.btnClose_actionPerformed(e);
        this.disposeUIWindow();
    }

    protected void fillDetailData() {
        try {
            Set datasKeySet;
            Iterator datasKeyIterator;
            Map contextMap = this.getUIContext();
            String mergeID = IndustryUtils.getMapStringData((Map)contextMap, (Object)"mergeID");
            if (IndustryUtils.isEmptyString((String)mergeID)) {
                return;
            }
            Locale locale = SysContext.getSysContext().getLocale();
            StringBuilder sql = new StringBuilder();
            sql.setLength(0);
            sql.append("Select\r\n");
            sql.append("MOS.FID FMOSID,\r\n");
            sql.append("Max(MO.FStorageOrgUnitID) FStorageOrgUnitID,\r\n");
            sql.append("Max(M.FID) FMaterialID,\r\n");
            sql.append("Max(M.FNumber) FMaterialNumber,\r\n");
            sql.append("Max(M.FName_").append(locale).append(") FMaterialName,\r\n");
            sql.append("Max(M.FModel) FMaterialModel,\r\n");
            sql.append("Max(U.FName_").append(locale).append(") FUnitName,\r\n");
            sql.append("Max(W.FID) FWarehouseID,\r\n");
            sql.append("Max(W.FName_").append(locale).append(") FWarehouseName,\r\n");
            sql.append("Max(MOS.FPlannedQty) FPlannedQty\r\n");
            sql.append("From T_MM_MFTOrderTechnics MOT \r\n");
            sql.append("Inner Join T_MM_MFTOrderStock MOS On\r\n");
            sql.append("1=1\r\n");
            sql.append("And MOS.FParentID=MOT.FParentID\r\n");
            sql.append("And MOS.FOperationNo=MOT.FOperationNo\r\n");
            sql.append("And MOS.FOperationID=MOT.FOperationID\r\n");
            sql.append("Inner Join T_MM_ManufactureOrder MO On MO.FID=MOT.FParentID\r\n");
            sql.append("Inner Join T_BD_Material M On M.FID=MOS.FMaterialID\r\n");
            sql.append("Left Join T_BD_MeasureUnit U On U.FID=MOS.FUnitID\r\n");
            sql.append("Left Join T_DB_Warehouse W On W.FID=MOS.FWarehouseID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MOT.FMergeID='").append(mergeID).append("'\r\n");
            sql.append("Group By\r\n");
            sql.append("MOS.FID\r\n");
            IRowSet rs = SqlExcFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
            if (IndustryUtils.isEmptyRowSet((IRowSet)rs)) {
                return;
            }
            HashMap<String, Map<String, BigDecimal>> datasMap = new HashMap<String, Map<String, BigDecimal>>();
            HashMap mosDistributionQtyMap = new HashMap();
            HashMap inventoryMap = new HashMap();
            ArrayList<String> materialIDList = new ArrayList<String>();
            ArrayList<String> warehouseIDList = new ArrayList<String>();
            ArrayList<String> mosIDList = new ArrayList<String>();
            ArrayList<String> souIDList = new ArrayList<String>();
            HashMap<String, BigDecimal> rtInventoryMap = new HashMap<String, BigDecimal>();
            while (rs.next()) {
                List<String> rSOUIDList;
                List<String> rMOSIDList;
                String key;
                BigDecimal plannedQty;
                String mosID = rs.getString("FMOSID");
                String souID = rs.getString("FStorageOrgUnitID");
                String materialID = rs.getString("FMaterialID");
                String materialNumber = rs.getString("FMaterialNumber");
                String materialName = rs.getString("FMaterialName");
                String model = rs.getString("FMaterialModel");
                String unitName = rs.getString("FUnitName");
                String warehouseID = rs.getString("FWarehouseID");
                String warehouseName = rs.getString("FWarehouseName");
                BigDecimal bigDecimal = plannedQty = rs.getBigDecimal("FPlannedQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPlannedQty");
                if (!IndustryUtils.isEmptyString((String)materialID) && !materialIDList.contains(materialID)) {
                    materialIDList.add(materialID);
                }
                if (!IndustryUtils.isEmptyString((String)warehouseID) && !warehouseIDList.contains(warehouseID)) {
                    warehouseIDList.add(warehouseID);
                }
                Map<String, BigDecimal> dataMap = IndustryUtils.getMapMapData(datasMap, (Object)(key = materialID + warehouseID)) == null ? new HashMap() : IndustryUtils.getMapMapData(datasMap, (Object)key);
                List list = rMOSIDList = IndustryUtils.getMapListData(dataMap, (Object)"mosIDList") == null ? new ArrayList() : IndustryUtils.getMapListData(dataMap, (Object)"mosIDList");
                if (!IndustryUtils.isEmptyString((String)mosID)) {
                    if (!rMOSIDList.contains(mosID)) {
                        rMOSIDList.add(mosID);
                        BigDecimal tPlannedQty = IndustryUtils.getMapBigDecimalData(dataMap, (Object)"plannedQty");
                        dataMap.put("plannedQty", plannedQty.add(tPlannedQty == null ? BigDecimal.ZERO : tPlannedQty));
                    }
                    if (!mosIDList.contains(mosID)) {
                        mosIDList.add(mosID);
                    }
                }
                dataMap.put("mosIDList", (BigDecimal)((Object)rMOSIDList));
                List list2 = rSOUIDList = IndustryUtils.getMapListData(dataMap, (Object)"souIDList") == null ? new ArrayList() : IndustryUtils.getMapListData(dataMap, (Object)"souIDList");
                if (!IndustryUtils.isEmptyString((String)souID)) {
                    if (!rSOUIDList.contains(souID)) {
                        rSOUIDList.add(souID);
                    }
                    if (!souIDList.contains(souID)) {
                        souIDList.add(souID);
                    }
                }
                dataMap.put("souIDList", (BigDecimal)((Object)rSOUIDList));
                dataMap.put("materialID", (BigDecimal)((Object)materialID));
                dataMap.put("materialNumber", (BigDecimal)((Object)materialNumber));
                dataMap.put("materialName", (BigDecimal)((Object)materialName));
                dataMap.put("model", (BigDecimal)((Object)model));
                dataMap.put("unitName", (BigDecimal)((Object)unitName));
                dataMap.put("warehouseID", (BigDecimal)((Object)warehouseID));
                dataMap.put("warehouseName", (BigDecimal)((Object)warehouseName));
                datasMap.put(key, dataMap);
            }
            rs.close();
            if (!IndustryUtils.isEmptyList(materialIDList) && !IndustryUtils.isEmptyList(warehouseIDList)) {
                sql.setLength(0);
                sql.append("Select\r\n");
                sql.append("FMaterialID FMaterialID,\r\n");
                sql.append("FWarehouseID FWarehouseID,\r\n");
                sql.append("Sum(FCurStoreQty) FRTInventory\r\n");
                sql.append("From T_IM_Inventory\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And FMaterialID In (\r\n");
                sql.append(SQLUtil.arrayToString((Object[])materialIDList.toArray())).append("\r\n");
                sql.append(")\r\n");
                sql.append("And FWarehouseID In (\r\n");
                sql.append(SQLUtil.arrayToString((Object[])warehouseIDList.toArray())).append("\r\n");
                sql.append(")\r\n");
                sql.append("Group By\r\n");
                sql.append("FMaterialID,\r\n");
                sql.append("FWarehouseID\r\n");
                IRowSet rtiRS = SqlExcFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
                while (rtiRS.next()) {
                    BigDecimal rtInventory;
                    String materialID = rtiRS.getString("FMaterialID");
                    String warehouseID = rtiRS.getString("FWarehouseID");
                    BigDecimal bigDecimal = rtInventory = rtiRS.getBigDecimal("FRTInventory") == null ? BigDecimal.ZERO : rtiRS.getBigDecimal("FRTInventory");
                    if (IndustryUtils.isEmptyString((String)materialID) || IndustryUtils.isEmptyString((String)warehouseID)) continue;
                    rtInventoryMap.put(materialID + warehouseID, rtInventory);
                }
                rtiRS.close();
            }
            if (!IndustryUtils.isEmptyList(mosIDList)) {
                this.getMOSDistributionQty(mosIDList, mosDistributionQtyMap, null);
            }
            if (!IndustryUtils.isEmptyList(souIDList)) {
                this.getSOUInventory(materialIDList, souIDList, inventoryMap);
            }
            Iterator iterator = datasKeyIterator = (datasKeySet = datasMap.keySet()) == null ? null : datasKeySet.iterator();
            if (datasKeyIterator == null) {
                return;
            }
            while (datasKeyIterator.hasNext()) {
                List rSOUIDList;
                List rMOSIDList;
                Map dataMap;
                Object keyObject = datasKeyIterator.next();
                String key = keyObject == null ? null : keyObject.toString();
                if (IndustryUtils.isEmptyString((String)key) || IndustryUtils.isEmptyMap((Map)(dataMap = IndustryUtils.getMapMapData(datasMap, (Object)key)))) continue;
                String materialID = IndustryUtils.getMapStringData((Map)dataMap, (Object)"materialID");
                String materialNumber = IndustryUtils.getMapStringData((Map)dataMap, (Object)"materialNumber");
                String materialName = IndustryUtils.getMapStringData((Map)dataMap, (Object)"materialName");
                String model = IndustryUtils.getMapStringData((Map)dataMap, (Object)"model");
                String unitName = IndustryUtils.getMapStringData((Map)dataMap, (Object)"unitName");
                String warehouseName = IndustryUtils.getMapStringData((Map)dataMap, (Object)"warehouseName");
                BigDecimal plannedQty = IndustryUtils.getMapBigDecimalData((Map)dataMap, (Object)"plannedQty") == null ? BigDecimal.ZERO : IndustryUtils.getMapBigDecimalData((Map)dataMap, (Object)"plannedQty");
                BigDecimal rtInventory = IndustryUtils.getMapBigDecimalData(rtInventoryMap, (Object)key) == null ? BigDecimal.ZERO : IndustryUtils.getMapBigDecimalData(rtInventoryMap, (Object)key);
                IRow addRow = this.detailTable.addRow();
                addRow.getCell("materialId").setValue((Object)materialID);
                addRow.getCell("materialNumber").setValue((Object)materialNumber);
                addRow.getCell("materialName").setValue((Object)materialName);
                addRow.getCell("model").setValue((Object)model);
                addRow.getCell("unitName").setValue((Object)unitName);
                addRow.getCell("warehouse").setValue((Object)warehouseName);
                addRow.getCell("plannedQty").setValue((Object)plannedQty);
                addRow.getCell("plannedQty").getStyleAttributes().setBackground(rtInventory.compareTo(plannedQty) >= 0 ? Color.GREEN : Color.RED);
                addRow.getCell("curStoreQty").setValue((Object)rtInventory);
                List list = rMOSIDList = IndustryUtils.getMapListData((Map)dataMap, (Object)"mosIDList") == null ? new ArrayList() : IndustryUtils.getMapListData((Map)dataMap, (Object)"mosIDList");
                if (!IndustryUtils.isEmptyList(rMOSIDList)) {
                    int rMOSIDListCount = rMOSIDList.size();
                    for (int index = 0; index < rMOSIDListCount; ++index) {
                        String rMOSID;
                        String string = rMOSID = rMOSIDList.get(index) == null ? null : rMOSIDList.get(index).toString();
                        if (IndustryUtils.isEmptyString((String)rMOSID)) continue;
                        BigDecimal dQty = IndustryUtils.getMapBigDecimalData(mosDistributionQtyMap, (Object)rMOSID);
                        Object cellValue = addRow.getCell(COL_DT_DISTRIBUTIONQTY).getValue();
                        BigDecimal qty = cellValue == null ? BigDecimal.ZERO : (cellValue instanceof BigDecimal ? (BigDecimal)cellValue : BigDecimal.ZERO);
                        addRow.getCell(COL_DT_DISTRIBUTIONQTY).setValue((Object)qty.add(dQty == null ? BigDecimal.ZERO : dQty));
                    }
                }
                if (IndustryUtils.isEmptyList(rSOUIDList = IndustryUtils.getMapListData((Map)dataMap, (Object)"souIDList") == null ? new ArrayList() : IndustryUtils.getMapListData((Map)dataMap, (Object)"souIDList")) || IndustryUtils.isEmptyString((String)materialID)) continue;
                List scousouIDList = this.getSameCOUSOUIDList(rSOUIDList, inventoryMap);
                int scousouIDListCount = scousouIDList == null ? 0 : scousouIDList.size();
                for (int index = 0; index < scousouIDListCount; ++index) {
                    String scousouID;
                    String string = scousouID = scousouIDList.get(index) == null ? null : scousouIDList.get(index).toString();
                    if (IndustryUtils.isEmptyString((String)scousouID)) continue;
                    BigDecimal inv = IndustryUtils.getMapBigDecimalData(inventoryMap, (Object)(materialID + scousouID));
                    Object cellValue = addRow.getCell(COL_DT_INVENTORY).getValue();
                    BigDecimal inventory = cellValue == null ? BigDecimal.ZERO : (cellValue instanceof BigDecimal ? (BigDecimal)cellValue : BigDecimal.ZERO);
                    addRow.getCell(COL_DT_INVENTORY).setValue((Object)inventory.add(inv == null ? BigDecimal.ZERO : inv));
                }
            }
            this.addDetailFootRow();
            this.detailTable.getSelectManager().select(0, 0, 0, this.detailTable.getColumnCount() - 1);
            this.fillInvData();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void fillInvData() {
        this.invTable.removeRows();
        if (!this.chkIsSelected.isSelected()) {
            return;
        }
        KDTSelectBlock block = this.detailTable.getSelectManager().get();
        if (null != block) {
            int top = block.getTop();
            IRow row = this.detailTable.getRow(top);
            String materialId = (String)row.getCell("materialId").getValue();
            if (null != materialId) {
                StringBuffer curStoreSql = new StringBuffer();
                curStoreSql.append("select t3.FName_l2,t4.FName_l2,t2.FName_l2,t1.FCurStoreQty ").append("\n");
                curStoreSql.append("from T_IM_Inventory t1").append("\n");
                curStoreSql.append("inner join T_ORG_Storage t2 on t2.FID = t1.FStorageOrgUnitID").append("\n");
                curStoreSql.append("inner join T_DB_WAREHOUSE t3 on t3.FID = t1.FWarehouseID").append("\n");
                curStoreSql.append("left join T_DB_LOCATION t4 on t4.FID = t1.FLocationID").append("\n");
                curStoreSql.append("where t1.FMaterialID = '" + materialId + "'").append("\n");
                try {
                    IRowSet curStoreRs = SqlExcFacadeFactory.getRemoteInstance().executeQuery(curStoreSql.toString());
                    while (curStoreRs.next()) {
                        String warehouse = curStoreRs.getString(1);
                        String location = curStoreRs.getString(2);
                        String storageOrgUnit = curStoreRs.getString(3);
                        BigDecimal curStoreQty = curStoreRs.getBigDecimal(4);
                        curStoreQty = curStoreQty == null ? BigDecimal.ZERO : curStoreQty;
                        IRow addRow = this.invTable.addRow();
                        addRow.getCell("warehouse").setValue((Object)warehouse);
                        addRow.getCell("location").setValue((Object)location);
                        addRow.getCell("curStoreQty").setValue((Object)curStoreQty);
                        addRow.getCell("storageOrgUnit").setValue((Object)storageOrgUnit);
                    }
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            this.addInvFootRow();
        }
    }

    protected void getMOSDistributionQty(List mosIDList, Map mosDistributionQtyMap, List sourceIDList) throws Exception {
        if (IndustryUtils.isEmptyList((List)mosIDList) || mosDistributionQtyMap == null) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("Select ");
        sql.append("id, ");
        sql.append("qty, ");
        sql.append("sourceBillEntryId ");
        sql.append("Where ");
        sql.append("sourceBillEntryId In ( ");
        sql.append(SQLUtil.arrayToString((Object[])(IndustryUtils.isEmptyList((List)sourceIDList) ? mosIDList.toArray() : sourceIDList.toArray()))).append(" ");
        sql.append(") ");
        sql.append("And parent.baseStatus=").append(4).append(" ");
        MaterialReqBillEntryCollection mrbec = MaterialReqBillEntryFactory.getRemoteInstance().getMaterialReqBillEntryCollection(sql.toString());
        if (mrbec == null) {
            return;
        }
        int mrbecc = mrbec.size();
        if (mrbecc == 0) {
            return;
        }
        List checkedSourceIDList = IndustryUtils.getMapListData((Map)mosDistributionQtyMap, (Object)"checkedSourceIDList") == null ? new ArrayList() : IndustryUtils.getMapListData((Map)mosDistributionQtyMap, (Object)"checkedSourceIDList");
        Map<String, String> idMap = IndustryUtils.getMapMapData((Map)mosDistributionQtyMap, (Object)"idMap") == null ? new HashMap() : IndustryUtils.getMapMapData((Map)mosDistributionQtyMap, (Object)"idMap");
        ArrayList<String> newSourceIDList = new ArrayList<String>();
        for (int index = 0; index < mrbecc; ++index) {
            String mosID;
            MaterialReqBillEntryInfo mrbei = mrbec.get(index);
            if (mrbei == null) continue;
            String id = mrbei.getId() == null ? null : mrbei.getId().toString();
            String sourceID = mrbei.getSourceBillEntryId();
            String string = mosID = IndustryUtils.isEmptyList((List)sourceIDList) ? sourceID : IndustryUtils.getMapStringData(idMap, (Object)sourceID);
            if (IndustryUtils.isEmptyString((String)id) || IndustryUtils.isEmptyString((String)sourceID) || IndustryUtils.isEmptyString((String)mosID) || checkedSourceIDList.contains(id)) continue;
            if (!newSourceIDList.contains(id)) {
                newSourceIDList.add(id);
            }
            idMap.put(id, mosID);
            BigDecimal dQty = IndustryUtils.getMapBigDecimalData((Map)mosDistributionQtyMap, (Object)mosID);
            BigDecimal qty = mrbei.getQty() == null ? BigDecimal.ZERO : mrbei.getQty();
            mosDistributionQtyMap.put(mosID, qty.add(dQty == null ? BigDecimal.ZERO : dQty));
        }
        mosDistributionQtyMap.put("idMap", idMap);
        if (IndustryUtils.isEmptyList((List)sourceIDList)) {
            checkedSourceIDList.addAll(mosIDList);
        } else {
            checkedSourceIDList.addAll(sourceIDList);
        }
        mosDistributionQtyMap.put("checkedSourceIDList", checkedSourceIDList);
        if (newSourceIDList.size() > 0) {
            this.getMOSDistributionQty(mosIDList, mosDistributionQtyMap, newSourceIDList);
        }
    }

    protected List getSameCOUSOUIDList(List souIDList, Map inventoryMap) throws Exception {
        if (IndustryUtils.isEmptyList((List)souIDList) || inventoryMap == null) {
            return null;
        }
        Map sourcouIDMap = IndustryUtils.getMapMapData((Map)inventoryMap, (Object)"sourcouIDMap");
        Map coursouIDMap = IndustryUtils.getMapMapData((Map)inventoryMap, (Object)"coursouIDMap");
        if (IndustryUtils.isEmptyMap((Map)sourcouIDMap) || IndustryUtils.isEmptyMap((Map)coursouIDMap)) {
            return null;
        }
        ArrayList<String> scousouIDList = new ArrayList<String>();
        int souIDListCount = souIDList.size();
        for (int souIDIndex = 0; souIDIndex < souIDListCount; ++souIDIndex) {
            int rcouIDListCount;
            String souID;
            String string = souID = souIDList.get(souIDIndex) == null ? null : souIDList.get(souIDIndex).toString();
            if (IndustryUtils.isEmptyString((String)souID)) continue;
            List rcouIDList = IndustryUtils.getMapListData((Map)sourcouIDMap, (Object)souID);
            int n = rcouIDListCount = rcouIDList == null ? 0 : rcouIDList.size();
            if (rcouIDListCount == 0) continue;
            for (int rcouIDIndex = 0; rcouIDIndex < rcouIDListCount; ++rcouIDIndex) {
                int rsouIDListCount;
                String rcouID;
                String string2 = rcouID = rcouIDList.get(rcouIDIndex) == null ? null : rcouIDList.get(rcouIDIndex).toString();
                if (IndustryUtils.isEmptyString((String)rcouID)) continue;
                List rsouIDList = IndustryUtils.getMapListData((Map)coursouIDMap, (Object)rcouID);
                int n2 = rsouIDListCount = rsouIDList == null ? 0 : rsouIDList.size();
                if (rsouIDListCount == 0) continue;
                for (int rsouIDIndex = 0; rsouIDIndex < rsouIDListCount; ++rsouIDIndex) {
                    String rsouID;
                    String string3 = rsouID = rsouIDList.get(rsouIDIndex) == null ? null : rsouIDList.get(rsouIDIndex).toString();
                    if (IndustryUtils.isEmptyString((String)rsouID) || scousouIDList.contains(rsouID)) continue;
                    scousouIDList.add(rsouID);
                }
            }
        }
        return scousouIDList;
    }

    protected void getSOUInventory(List materialIDList, List souIDList, Map inventoryMap) throws Exception {
        int coursoucc;
        int sourcoucc;
        if (IndustryUtils.isEmptyList((List)materialIDList) || IndustryUtils.isEmptyList((List)souIDList) || inventoryMap == null) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("Select ");
        sql.append("fromUnit.id, ");
        sql.append("toUnit.id ");
        sql.append("Where ");
        sql.append("fromUnit.id In ( ");
        sql.append(SQLUtil.arrayToString((Object[])souIDList.toArray())).append(" ");
        sql.append(") ");
        sql.append("And typeRelation.fromType=").append(4).append(" ");
        sql.append("And typeRelation.toType=").append(1).append(" ");
        OrgUnitRelationCollection sourcouc = OrgUnitRelationFactory.getRemoteInstance().getOrgUnitRelationCollection(sql.toString());
        int n = sourcoucc = sourcouc == null ? 0 : sourcouc.size();
        if (sourcoucc == 0) {
            return;
        }
        ArrayList<String> sourcouIDList = new ArrayList<String>();
        ArrayList<String> coursouIDList = new ArrayList<String>();
        HashMap<String, List<String>> sourcouIDMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> coursouIDMap = new HashMap<String, List<String>>();
        for (int index = 0; index < sourcoucc; ++index) {
            List<String> rcouIDList;
            String souID;
            OrgUnitRelationInfo sourcoui = sourcouc.get(index);
            if (sourcoui == null) continue;
            FullOrgUnitInfo coui = sourcoui.getToUnit();
            FullOrgUnitInfo soui = sourcoui.getFromUnit();
            if (coui == null || soui == null) continue;
            String couID = coui.getId() == null ? null : coui.getId().toString();
            String string = souID = soui.getId() == null ? null : soui.getId().toString();
            if (IndustryUtils.isEmptyString((String)couID) || IndustryUtils.isEmptyString((String)souID)) continue;
            List list = rcouIDList = IndustryUtils.getMapListData(sourcouIDMap, (Object)souID) == null ? new ArrayList() : IndustryUtils.getMapListData(sourcouIDMap, (Object)souID);
            if (!rcouIDList.contains(couID)) {
                rcouIDList.add(couID);
            }
            sourcouIDMap.put(souID, rcouIDList);
            if (sourcouIDList.contains(couID)) continue;
            sourcouIDList.add(couID);
        }
        if (IndustryUtils.isEmptyList(sourcouIDList)) {
            return;
        }
        sql.setLength(0);
        sql.append("Select ");
        sql.append("fromUnit.id, ");
        sql.append("toUnit.id ");
        sql.append("Where ");
        sql.append("toUnit.id In ( ");
        sql.append(SQLUtil.arrayToString((Object[])sourcouIDList.toArray())).append(" ");
        sql.append(") ");
        sql.append("And typeRelation.fromType=").append(4).append(" ");
        sql.append("And typeRelation.toType=").append(1).append(" ");
        OrgUnitRelationCollection coursouc = OrgUnitRelationFactory.getRemoteInstance().getOrgUnitRelationCollection(sql.toString());
        int n2 = coursoucc = coursouc == null ? 0 : coursouc.size();
        if (coursoucc == 0) {
            return;
        }
        for (int index = 0; index < coursoucc; ++index) {
            List<String> rsouIDList;
            String souID;
            OrgUnitRelationInfo coursoui = coursouc.get(index);
            if (coursoui == null) continue;
            FullOrgUnitInfo coui = coursoui.getToUnit();
            FullOrgUnitInfo soui = coursoui.getFromUnit();
            if (coui == null || soui == null) continue;
            String couID = coui.getId() == null ? null : coui.getId().toString();
            String string = souID = soui.getId() == null ? null : soui.getId().toString();
            if (IndustryUtils.isEmptyString((String)couID) || IndustryUtils.isEmptyString((String)souID)) continue;
            List list = rsouIDList = IndustryUtils.getMapListData(coursouIDMap, (Object)couID) == null ? new ArrayList() : IndustryUtils.getMapListData(coursouIDMap, (Object)couID);
            if (!rsouIDList.contains(souID)) {
                rsouIDList.add(souID);
            }
            coursouIDMap.put(couID, rsouIDList);
            if (coursouIDList.contains(souID)) continue;
            coursouIDList.add(souID);
        }
        if (IndustryUtils.isEmptyList(coursouIDList)) {
            return;
        }
        inventoryMap.put("sourcouIDMap", sourcouIDMap);
        inventoryMap.put("coursouIDMap", coursouIDMap);
        sql.setLength(0);
        sql.append("Select\r\n");
        sql.append("FMaterialID FMaterialID,\r\n");
        sql.append("FStorageOrgUnitID FStorageOrgUnitID,\r\n");
        sql.append("Sum(FCurStoreQty) FInventory\r\n");
        sql.append("From T_IM_Inventory\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And FMaterialID In (\r\n");
        sql.append(SQLUtil.arrayToString((Object[])materialIDList.toArray())).append("\r\n");
        sql.append(")\r\n");
        sql.append("And FStorageOrgUnitID In (\r\n");
        sql.append(SQLUtil.arrayToString((Object[])coursouIDList.toArray())).append("\r\n");
        sql.append(")\r\n");
        sql.append("Group By\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FStorageOrgUnitID\r\n");
        IRowSet iRS = SqlExcFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
        while (iRS.next()) {
            BigDecimal inventory;
            String materialID = iRS.getString("FMaterialID");
            String storageOrgUnitID = iRS.getString("FStorageOrgUnitID");
            BigDecimal bigDecimal = inventory = iRS.getBigDecimal("FInventory") == null ? BigDecimal.ZERO : iRS.getBigDecimal("FInventory");
            if (IndustryUtils.isEmptyString((String)materialID) || IndustryUtils.isEmptyString((String)storageOrgUnitID)) continue;
            inventoryMap.put(materialID + storageOrgUnitID, inventory);
        }
        iRS.close();
    }

    protected void initListener() {
        super.initListener();
        this.detailTable.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                MergeTechMaterialViewUI.this.fillInvData();
            }
        });
        this.chkIsSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeTechMaterialViewUI.this.fillInvData();
            }
        });
    }
}

