/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.schedule.client.util;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.report.schedule.TemplateSetEntryCollection;
import com.kingdee.eas.mm.report.schedule.TemplateSetEntryInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import org.apache.log4j.Logger;

public final class TemplateSetUtil {
    private static final Logger logger = CoreUIObject.getLogger(TemplateSetUtil.class);

    private TemplateSetUtil() {
    }

    public static void kdtColumnTemplateF7(KDTable kdt, String column) {
        String f7 = "com.kingdee.eas.mm.report.schedule.app.TemplateSetQuery";
        TemplateSetUtil.kdtColumnF7(kdt, column, f7, "$number$;$helpCode$", "$number$", "$number$", true, "$number$");
    }

    public static void kdtColumnF7(KDTable kdt, String column, String queryInfo, String commitFormat, String displayFormat, String editFormat, boolean editable, String dataFormat) {
        KDBizPromptBox prmtBox = new KDBizPromptBox();
        prmtBox.setQueryInfo(queryInfo);
        prmtBox.setCommitFormat(commitFormat);
        prmtBox.setDisplayFormat(displayFormat);
        prmtBox.setEditFormat(editFormat);
        prmtBox.setEditable(editable);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)prmtBox);
        if (kdt.getColumn(column) == null) {
            return;
        }
        kdt.getColumn(column).setEditor((ICellEditor)cellEditor);
        ObjectValueRender ovr = new ObjectValueRender();
        ovr.setFormat((IDataFormat)new BizDataFormat(dataFormat));
        kdt.getColumn(column).setRenderer((IBasicRender)ovr);
    }

    public static SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("storageOrg.*"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("product.*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.material.name"));
        sic.add(new SelectorItemInfo("entry.material.number"));
        sic.add(new SelectorItemInfo("entry.operation.name"));
        sic.add(new SelectorItemInfo("entry.operation.number"));
        return sic;
    }

    public static SelectorItemCollection getEntrySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.bizDate"));
        sic.add(new SelectorItemInfo("parent.storageOrg.*"));
        sic.add(new SelectorItemInfo("parent.product.*"));
        sic.add(new SelectorItemInfo("parent.project.*"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("operation.name"));
        sic.add(new SelectorItemInfo("operation.number"));
        return sic;
    }

    public static void replenishEntryNode(TemplateSetEntryCollection entries) {
        if (entries == null || entries.size() == 0) {
            return;
        }
        HashMap<String, TemplateSetEntryInfo> entryInfo = new HashMap<String, TemplateSetEntryInfo>();
        StringBuilder fids = new StringBuilder();
        for (int i = 0; i < entries.size(); ++i) {
            TemplateSetEntryInfo info = entries.get(i);
            if (info == null || !StringUtil.isEmpty((String)info.getNode())) continue;
            if (fids.length() != 0) {
                fids.append(",");
            }
            String id = info.getId().toString();
            fids.append("'").append(id).append("'");
            entryInfo.put(id, info);
        }
        try {
            IRowSet set = SQLExecutorFactory.getRemoteInstance((String)("select fid,fnode from T_MM_TemplateSetEntry where fid in (" + fids.toString() + ")")).executeSQL();
            while (set.next()) {
                String id = set.getString(1);
                String node = set.getString(2);
                TemplateSetEntryInfo info = (TemplateSetEntryInfo)entryInfo.get(id);
                info.setNode(node);
            }
        }
        catch (Exception e) {
            logger.error((Object)"replenish Entry Node is error", (Throwable)e);
        }
    }
}

