/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.emm.basedata.projectjch.ProjectJCHInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.sfc.CompletionReportAmountTimeInfo;
import com.kingdee.eas.mm.sfc.CompletionReportFactory;
import com.kingdee.eas.mm.sfc.QualityControlStatusEnum;
import com.kingdee.eas.mm.sfc.client.CompletionReportEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class QualityControlEditUI
extends CompletionReportEditUI {
    private String RESURL = "com.kingdee.eas.mm.sfc.EMMEMSfcResource";
    public static final String COL_AMOUNTTIME_QUALIFIEDAMOUNT = "qualifiedAmount";
    public static final String COL_AMOUNTTIME_QUALITYCONTROLSTATUS = "qualityControlStatus";
    public static final String COL_AMOUNTTIME_REPORTAMOUNT = "reportAmount";
    private static final Logger logger = CoreUIObject.getLogger(QualityControlEditUI.class);
    private static final long serialVersionUID = -1233349674653680660L;
    private final String qcStatusKey = "qualityControlStatus";
    protected KDWorkButton btnChecks;
    protected final Set<String> columnKey = new HashSet<String>();
    protected KDLabelContainer contProjectJCH = null;
    protected KDPanel hxContentPanel = null;
    protected KDBizPromptBox prmtProjectJCH = null;
    protected KDScrollPane spHXContent = null;
    protected KDTextArea txtHXContent = null;

    public QualityControlEditUI() throws Exception {
        this.columnKey.add(COL_AMOUNTTIME_QUALIFIEDAMOUNT);
        this.columnKey.add("yieldAmount");
        this.columnKey.add("materialScrapAm");
        this.columnKey.add("workScrapAmount");
        this.columnKey.add("repairAmount");
        this.columnKey.add(COL_AMOUNTTIME_REPORTAMOUNT);
        this.columnKey.add("scrapAmount");
        this.hxContentPanel = new KDPanel();
        this.hxContentPanel.setName("hxContentPanel");
        this.hxContentPanel.setToolTipText(EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0034"));
        this.spHXContent = new KDScrollPane();
        this.spHXContent.setName("spHXContent");
        this.spHXContent.setAutoscrolls(true);
        this.txtHXContent = new KDTextArea();
        this.txtHXContent.setName("txtHXContent");
        this.txtHXContent.setToolTipText(EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0034"));
        this.dataBinder.registerBinding("dmesOrder.remark", String.class, (Component)this.txtHXContent, "text");
        this.contProjectJCH = new KDLabelContainer();
        this.contProjectJCH.setName("contProjectJCH");
        this.contProjectJCH.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0035"));
        this.contProjectJCH.setBoundLabelLength(100);
        this.contProjectJCH.setBoundLabelUnderline(true);
        this.contProjectJCH.setVisible(true);
        this.contProjectJCH.setBoundLabelAlignment(7);
        this.contProjectJCH.setToolTipText(EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0035"));
        this.prmtProjectJCH = new KDBizPromptBox();
        this.prmtProjectJCH.setName("prmtProjectJCH");
        this.prmtProjectJCH.setQueryInfo("com.kingdee.eas.mm.project.app.ProjectJCHQuery");
        this.prmtProjectJCH.setVisible(true);
        this.prmtProjectJCH.setEditable(false);
        this.prmtProjectJCH.setDisplayFormat("$number$");
        this.prmtProjectJCH.setEditFormat("$number$");
        this.prmtProjectJCH.setCommitFormat("$number$");
        this.prmtProjectJCH.setEnabled(false);
        this.prmtProjectJCH.setToolTipText(EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0035"));
        this.contProjectJCH.setBoundEditor((JComponent)this.prmtProjectJCH);
        this.dataBinder.registerBinding("dmesOrder.projectJCH", ProjectJCHInfo.class, (Component)this.prmtProjectJCH, "data");
    }

    public void actionChecks_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkQty(0)) {
            SysUtil.abort();
        }
        this.storeFields();
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        if (user == null || user.getPerson() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0033"));
            SysUtil.abort();
        }
        this.editData.put("qualityPeople", (Object)user.getPerson());
        CompletionReportFactory.getRemoteInstance().submit((CoreBaseInfo)this.editData);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0036"));
        this.refreshCurPage();
    }

    public String getOprtState() {
        return super.getOprtState();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        if (sic == null) {
            sic = new SelectorItemCollection();
        }
        sic.add(new SelectorItemInfo(COL_AMOUNTTIME_QUALITYCONTROLSTATUS));
        sic.add(new SelectorItemInfo("AmountTime.qualityControlStatus"));
        sic.add(new SelectorItemInfo("dmesOrder.remark"));
        sic.add(new SelectorItemInfo("dmesOrder.projectJCH.id"));
        sic.add(new SelectorItemInfo("dmesOrder.projectJCH.number"));
        return sic;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDTabbedPane1.add((Component)this.hxContentPanel, (Object)EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0034"));
        this.hxContentPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.hxContentPanel.add((Component)this.spHXContent, (Object)"Center");
        this.spHXContent.getViewport().add((Component)this.txtHXContent, null);
        this.contProjectJCH.setBounds(new Rectangle(354, 230, 270, 19));
        this.baseinfopanel.add((Component)this.contProjectJCH, (Object)new KDLayout.Constraints(354, 230, 270, 19, 385));
    }

    public void initUIToolBarLayout() {
        this.initChecks();
        this.toolBar.add((Component)this.btnChecks);
    }

    @Override
    public void loadFields() {
        Object value;
        int rowIndex;
        super.loadFields();
        if (this.kdtAmountTime.getColumn("actualBegain") != null) {
            this.kdtAmountTime.getColumn("actualBegain").getStyleAttributes().setHided(true);
        }
        if (this.kdtAmountTime.getColumn("actualEnd") != null) {
            this.kdtAmountTime.getColumn("actualEnd").getStyleAttributes().setHided(true);
        }
        boolean existsWGDJ = false;
        for (rowIndex = 0; rowIndex < this.kdtAmountTime.getRowCount(); ++rowIndex) {
            value = this.kdtAmountTime.getCell(rowIndex, COL_AMOUNTTIME_QUALITYCONTROLSTATUS).getValue();
            if (value == null || !QualityControlStatusEnum.class.getName().equals(value.getClass().getName()) || !QualityControlStatusEnum.QUARANTINE.equals(value)) continue;
            existsWGDJ = true;
            break;
        }
        for (rowIndex = 0; rowIndex < this.kdtAmountTime.getRowCount(); ++rowIndex) {
            if (existsWGDJ) {
                this.kdtAmountTime.getCell(rowIndex, COL_AMOUNTTIME_QUALITYCONTROLSTATUS).setValue((Object)QualityControlStatusEnum.QUARANTINE);
            }
            if ((value = this.kdtAmountTime.getCell(rowIndex, COL_AMOUNTTIME_QUALITYCONTROLSTATUS).getValue()) == null || !QualityControlStatusEnum.class.getName().equals(value.getClass().getName()) || !QualityControlStatusEnum.QUARANTINE.equals(value)) continue;
            this.kdtAmountTime.getCell(rowIndex, COL_AMOUNTTIME_QUALIFIEDAMOUNT).setValue(this.kdtAmountTime.getCell(rowIndex, COL_AMOUNTTIME_REPORTAMOUNT).getValue());
        }
        this.initChecksData();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0027"));
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private boolean checkQty(int rowIndex) {
        IRow row = this.kdtAmountTime.getRow(rowIndex);
        BigDecimal report = this.getKdtAmountTimeRowValue(row, COL_AMOUNTTIME_REPORTAMOUNT);
        BigDecimal qualified = this.getKdtAmountTimeRowValue(row, COL_AMOUNTTIME_QUALIFIEDAMOUNT);
        BigDecimal yield = this.getKdtAmountTimeRowValue(row, "yieldAmount");
        BigDecimal ss = this.getKdtAmountTimeRowValue(row, "materialScrapAm");
        BigDecimal ws = this.getKdtAmountTimeRowValue(row, "workScrapAmount");
        BigDecimal repair = this.getKdtAmountTimeRowValue(row, "repairAmount");
        BigDecimal total = qualified.add(yield).add(ws).add(ss).add(repair);
        int c = report.compareTo(total);
        if (c != 0) {
            String strInfo = EASResource.getString((String)this.RESURL, (String)"DXH_INFO", (Object[])new Object[]{rowIndex + 1});
            MsgBox.showInfo((String)(strInfo + EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0037")));
            return false;
        }
        return true;
    }

    private BigDecimal getKdtAmountTimeRowValue(IRow row, String key) {
        Object o = row.getCell(key).getValue();
        if (o == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(o.toString());
    }

    private void initChecks() {
        this.btnChecks = new KDWorkButton();
        this.btnChecks.setName("btnChecks");
        this.btnChecks.setText(EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0038"));
        BtnListener btnlistener = new BtnListener();
        this.btnChecks.addActionListener((ActionListener)btnlistener);
    }

    private void initChecksData() {
        IColumn col = this.kdtAmountTime.getColumn(this.qcStatusKey);
        if (col != null) {
            col.getStyleAttributes().setHided(false);
        }
        this.kdtAmountTime.setEditable(true);
        this.kdtAmountTime.getStyleAttributes().setLocked(false);
        int cc = this.kdtAmountTime.getColumnCount();
        for (int i = 0; i < cc; ++i) {
            IColumn ic = this.kdtAmountTime.getColumn(i);
            String key = ic.getKey();
            if (this.columnKey.contains(key)) continue;
            ic.getStyleAttributes().setLocked(true);
        }
        for (String key : this.columnKey) {
            this.kdtAmountTime.getColumn(key).getStyleAttributes().setLocked(false);
        }
    }

    @Override
    protected void kdtEntries_CellActived(KDTActiveCellEvent e) {
        super.kdtEntries_CellActived(e);
        if (e.getSource().equals(this.kdtAmountTime)) {
            int row = e.getRowIndex();
            boolean lock = row != 0;
            for (String key : this.columnKey) {
                this.kdtAmountTime.getColumn(key).getStyleAttributes().setLocked(lock);
            }
        }
    }

    @Override
    protected void kdtEntries_Changed(KDTEditEvent e) throws Exception {
        if (e.getSource().equals(this.kdtAmountTime)) {
            int rowIndex = e.getRowIndex();
            IRow row = this.kdtAmountTime.getRow(rowIndex);
            String key = this.kdtAmountTime.getColumn(e.getColIndex()).getKey();
            Object o = row.getUserObject();
            CompletionReportAmountTimeInfo at = (CompletionReportAmountTimeInfo)o;
            if (COL_AMOUNTTIME_REPORTAMOUNT.equalsIgnoreCase(key)) {
                row.getCell(key).setValue(at.get(key));
                SysUtil.abort();
            } else if ("scrapAmount".equalsIgnoreCase(key)) {
                this.reRATTabCalScrapQty(rowIndex);
                SysUtil.abort();
            }
        }
        super.kdtEntries_Changed(e);
    }

    protected void registerValidator() {
        super.registerValidator();
        this.getValidateHelper().registerBindProperty("dmesOrder.remark", "Save");
        this.getValidateHelper().registerBindProperty("dmesOrder.projectJCH", "Save");
    }

    private class BtnListener
    implements ActionListener {
        private BtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource().equals(QualityControlEditUI.this.btnChecks)) {
                    QualityControlEditUI.this.actionChecks_actionPerformed(e);
                }
            }
            catch (Exception e1) {
                QualityControlEditUI.this.handUIException(e1);
            }
        }
    }
}

