/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.zj.SqlExcFacadeFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.zjbom.client.AbstractBusinessDivisionRepFilterUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class BusinessDivisionRepFilterUI
extends AbstractBusinessDivisionRepFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BusinessDivisionRepFilterUI.class);

    public void clear() {
        super.clear();
        StorageOrgUnitInfo storageOrgUnit = this.getStorageOrgUnitInfo();
        if (storageOrgUnit != null) {
            this.prmtStorageOrgUnit.setValue((Object)storageOrgUnit);
        }
        Date today = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        calendar.add(2, -1);
        this.pkFromBizDate.setValue((Object)calendar.getTime());
        this.pkToBizDate.setValue((Object)today);
        this.comboBaseStatus.removeAllItems();
        Object[] statusValue = new Object[]{BillBaseStatusEnum.getEnum(-1), BillBaseStatusEnum.getEnum(1), BillBaseStatusEnum.getEnum(2), BillBaseStatusEnum.getEnum(4)};
        this.comboBaseStatus.addItems(statusValue);
        this.comboBaseStatus.setSelectedIndex(0);
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.prmtStorageOrgUnit, (OrgType)OrgType.Storage, (String)"mm_operation_view");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter() == null ? new FilterItemCollection() : entityViewInfo.getFilter().getFilterItems();
        int iSet = 0;
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            String name = filterItemInfo.getPropertyName();
            if (name.equalsIgnoreCase("storageOrgUnit.name")) {
                this.prmtStorageOrgUnit.setValue(filterItemInfo.getCompareValue());
            }
            if (name.equalsIgnoreCase("bizDate")) {
                if (iSet == 0) {
                    this.pkFromBizDate.setValue(filterItemInfo.getCompareValue());
                } else {
                    this.pkToBizDate.setValue(filterItemInfo.getCompareValue());
                }
                ++iSet;
            }
            if (!name.equalsIgnoreCase("baseStatus")) continue;
            this.comboBaseStatus.setSelectedItem((Object)BillBaseStatusEnum.getEnum(Integer.valueOf(filterItemInfo.getCompareValue().toString())));
        }
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        super.setFilterInfo(filterInfo);
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        if (this.prmtStorageOrgUnit.getText().length() > 0) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.name", this.prmtStorageOrgUnit.getValue(), CompareType.EQUALS));
        }
        if (this.pkFromBizDate.getText().length() > 0) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", this.pkFromBizDate.getValue(), CompareType.GREATER_EQUALS));
        }
        if (this.pkToBizDate.getText().length() > 0) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", this.pkToBizDate.getValue(), CompareType.LESS_EQUALS));
        }
        if (this.comboBaseStatus.getSelectedItem() != null && !"".equals(this.comboBaseStatus.getSelectedItem().toString()) && !"NULL".equals(this.comboBaseStatus.getSelectedItem().toString().toUpperCase())) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)((BillBaseStatusEnum)((Object)this.comboBaseStatus.getSelectedItem())).getValue(), CompareType.EQUALS));
        }
        return this.filterInfo;
    }

    protected StorageOrgUnitInfo getStorageOrgUnitInfo() {
        String currUser = SysContext.getSysContext().getUserName();
        StorageOrgUnitInfo storageOrgUnit = SysContext.getSysContext().getCurrentStorageUnit();
        if (storageOrgUnit == null) {
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct po.forgid as fid from T_PM_OrgRange po\r\n");
            sql.append("inner join T_ORG_Storage tos\r\n");
            sql.append("on po.forgid = tos.fid\r\n");
            sql.append("inner join t_pm_user tu\r\n");
            sql.append("on po.fuserid = tu.fid\r\n");
            sql.append("where tu.fnumber='" + currUser + "'\r\n");
            sql.append("order by po.forgid\r\n");
            String unitId = null;
            try {
                IRowSet rowset = SqlExcFacadeFactory.getRemoteInstance().executeQuery(sql.toString());
                if (rowset.next()) {
                    unitId = rowset.getString("fid");
                }
            }
            catch (Exception ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (unitId != null) {
                try {
                    storageOrgUnit = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitId));
                }
                catch (Exception e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (BOSException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return storageOrgUnit;
    }
}

