/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.mm.basedata.MainTenanceLevelInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.util.MfgBomUtil;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.zjbom.ProcessBomBillFactory;
import com.kingdee.eas.zjbom.ProcessBomBillInfo;
import com.kingdee.eas.zjbom.ProcessBomBillSearchFacadeFactory;
import com.kingdee.eas.zjbom.client.AbstractProcessBomBackSearchUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ProcessBomBackSearchUI
extends AbstractProcessBomBackSearchUI {
    private static final Logger logger = CoreUIObject.getLogger(ProcessBomBackSearchUI.class);
    private String RESURL = "com.kingdee.eas.zjbom.BOMLanResource";
    private String oldString = null;

    private static final SelectorItemCollection getBomHeadSelectSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("batch"));
        sic.add(new SelectorItemInfo("portNo"));
        sic.add(new SelectorItemInfo("parentNo"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("mspec"));
        sic.add(new SelectorItemInfo("parentNo"));
        sic.add(new SelectorItemInfo("parentName"));
        sic.add(new SelectorItemInfo("PMUnit"));
        sic.add(new SelectorItemInfo("unit"));
        sic.add(new SelectorItemInfo("designMode.id"));
        sic.add(new SelectorItemInfo("designMode.number"));
        sic.add(new SelectorItemInfo("designMode.name"));
        sic.add(new SelectorItemInfo("designMode.project"));
        sic.add(new SelectorItemInfo("designMode.trackNumber"));
        sic.add(new SelectorItemInfo("mainTenanceLevel.id"));
        sic.add(new SelectorItemInfo("mainTenanceLevel.number"));
        sic.add(new SelectorItemInfo("mainTenanceLevel.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("beginCarno.id"));
        sic.add(new SelectorItemInfo("beginCarno.number"));
        sic.add(new SelectorItemInfo("beginCarno.name"));
        sic.add(new SelectorItemInfo("endCarno.id"));
        sic.add(new SelectorItemInfo("endCarno.number"));
        sic.add(new SelectorItemInfo("endCarno.name"));
        return sic;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkBaseStatusAudit.setSelected(true);
        this.txtCountRation.setHorizontalAlignment(4);
        if (this.getUIContext().get("processid") != null && !this.getUIContext().get("processid").equals("")) {
            String processid = this.getUIContext().get("processid").toString();
            ProcessBomBillInfo processBomInfo = ProcessBomBillFactory.getRemoteInstance().getProcessBomBillInfo((IObjectPK)new ObjectUuidPK(processid), ProcessBomBackSearchUI.getBomHeadSelectSic());
            this.txtMaterialNumber.setText(processBomInfo.getPortNo());
            this.txtChildMaName.setText(processBomInfo.getName());
            this.txtChildModel.setText(processBomInfo.getMspec());
            this.txtUnit.setText(processBomInfo.getUnit());
            this.prmtProject.setValue((Object)processBomInfo.getProject());
            this.prmtMainTenanceLevel.setValue((Object)processBomInfo.getMainTenanceLevel());
            this.prmtTrack.setValue((Object)processBomInfo.getBeginCarno());
            this.txtCountRation.setText(null);
        }
        UIHelper.registerProjectF7ForEdit(null, null, (KDBizPromptBox)this.prmtProject);
        UIHelper.registerTrackNumberF7ForEdit(null, null, (KDBizPromptBox)this.prmtProject, (KDBizPromptBox)this.prmtTrack, (boolean)false);
        MfgBomUtil.initPrmtMainTenanceFilters((KDBizPromptBox)this.prmtMainTenanceLevel);
        this.prmtProject.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object oldValue;
                if (e == null) {
                    return;
                }
                Object newValue = e.getNewValue();
                Boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)newValue, (Object)(oldValue = e.getOldValue()));
                if (!isDifferent.booleanValue()) {
                    return;
                }
                ProcessBomBackSearchUI.this.projectChange();
            }
        });
        this.prmtMainTenanceLevel.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object oldValue;
                if (e == null) {
                    return;
                }
                Object newValue = e.getNewValue();
                Boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)newValue, (Object)(oldValue = e.getOldValue()));
                if (!isDifferent.booleanValue()) {
                    return;
                }
                ProcessBomBackSearchUI.this.kdtEntrys.removeRows();
            }
        });
        this.prmtTrack.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                Object oldValue;
                if (e == null) {
                    return;
                }
                Object newValue = e.getNewValue();
                Boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)newValue, (Object)(oldValue = e.getOldValue()));
                if (!isDifferent.booleanValue()) {
                    return;
                }
                ProcessBomBackSearchUI.this.kdtEntrys.removeRows();
            }
        });
    }

    @Override
    protected void txtMaterialNumber_focusLost(FocusEvent e) throws Exception {
        if (this.txtMaterialNumber.getText() == null || "".equals(this.txtMaterialNumber.getText())) {
            this.kdtEntrys.removeRows();
            this.txtChildMaName.setText(null);
            this.txtChildModel.setText(null);
            this.txtUnit.setText(null);
            this.txtCountRation.setText(null);
            return;
        }
        String newString = this.txtMaterialNumber.getText();
        if (this.oldString != null && !this.oldString.equals(newString)) {
            this.txtChildMaName.setText(null);
            this.txtChildModel.setText(null);
            this.txtUnit.setText(null);
            this.kdtEntrys.removeRows();
            this.txtCountRation.setText(null);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)newString, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("model"));
            sic.add(new SelectorItemInfo("baseUnit.id"));
            sic.add(new SelectorItemInfo("baseUnit.name"));
            view.setSelector(sic);
            MaterialCollection coll = MaterialFactory.getRemoteInstance().getMaterialCollection(view);
            if (coll != null && coll.size() > 0) {
                MaterialInfo materialInfo = coll.get(0);
                this.txtChildMaName.setText(materialInfo.getName());
                this.txtChildModel.setText(materialInfo.getModel());
                this.txtUnit.setText(materialInfo.getBaseUnit().getName());
            }
        }
        this.oldString = newString;
    }

    @Override
    protected void txtParentNo_focusLost(FocusEvent e) throws Exception {
        super.txtParentNo_focusLost(e);
    }

    private void projectChange() {
        this.prmtTrack.setValue(null);
        this.kdtEntrys.removeRows();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        Component[] cps;
        LongTimeDialog dialog = new LongTimeDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){

            public void afterExec(Object result) throws Exception {
                ProcessBomBackSearchUI.this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.zjbom.BOMLanResource", (String)"GYBOMFCHWB_END"));
            }

            public Object exec() {
                try {
                    ProcessBomBackSearchUI.this.proBomBackSearch();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    ProcessBomBackSearchUI.this.handleException(e1);
                    SysUtil.abort();
                }
                return "";
            }
        });
        for (Component cp : cps = dialog.getContentPane().getComponents()) {
            if (!(cp instanceof JLabel)) continue;
            ((JLabel)cp).setText("\u6570\u636e\u53cd\u67e5\u4e2d\uff0c\u8bf7\u7a0d\u5019...");
        }
        dialog.show();
    }

    protected void proBomBackSearch() throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        this.kdtEntrys.removeRows();
        if (this.txtMaterialNumber.getText() == null || "".equals(this.txtMaterialNumber.getText())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESURL, (String)"WSHRLJBM_NOT_WRITE"));
            return;
        }
        paramMap.put("materialNumber", this.txtMaterialNumber.getText());
        if (this.prmtProject.getValue() != null) {
            paramMap.put("projectInfo", (ProjectInfo)this.prmtProject.getValue());
        }
        if (this.prmtTrack.getValue() != null) {
            paramMap.put("trackNumberInfo", (TrackNumberInfo)this.prmtTrack.getValue());
        }
        if (this.txtParentNo.getText() != null && !"".equals(this.txtParentNo.getText())) {
            paramMap.put("parentMaterialNumber", this.txtParentNo.getText());
        }
        if (this.prmtMainTenanceLevel.getValue() != null) {
            paramMap.put("mainTenanceLevelInfo", (MainTenanceLevelInfo)this.prmtMainTenanceLevel.getValue());
        }
        boolean bomBaseStatusIsAudit = false;
        if (this.chkBaseStatusAudit.isSelected()) {
            bomBaseStatusIsAudit = true;
        }
        paramMap.put("bomBaseStatusIsAudit", bomBaseStatusIsAudit);
        Map result = ProcessBomBillSearchFacadeFactory.getRemoteInstance().processBomBackExpand(paramMap);
        if (result.get("returnRowSet") != null) {
            IRowSet rs = (IRowSet)result.get("returnRowSet");
            BigDecimal ration = BigDecimal.ZERO;
            if (result.get("sumQty") != null) {
                ration = new BigDecimal(result.get("sumQty").toString());
            }
            while (rs.next()) {
                IRow row = this.kdtEntrys.addRow();
                row.getCell("level").setValue((Object)rs.getString("FLevel"));
                row.getCell("materialNum").setValue((Object)rs.getString("FmaterialNumber"));
                row.getCell("materialName").setValue((Object)rs.getString("FMaterialName"));
                row.getCell("model").setValue((Object)rs.getString("Fmodel"));
                row.getCell("unit").setValue((Object)rs.getString("Funitname"));
                row.getCell("qty").setValue((Object)rs.getString("Fqty"));
                row.getCell("storageOrgUnit").setValue((Object)rs.getString("FstorageorgUnitName"));
                row.getCell("projectNum").setValue((Object)rs.getString("FProjectNumber"));
                row.getCell("projectName").setValue((Object)rs.getString("FProjectName"));
                row.getCell("trackNum").setValue((Object)rs.getString("FTrackNumber"));
                row.getCell("trackName").setValue((Object)rs.getString("FTrackName"));
                row.getCell("designMode").setValue((Object)rs.getString("fdesignModeName"));
                row.getCell("mainTenanceLevelName").setValue((Object)rs.getString("FMainTenanceLevelName"));
            }
            this.txtCountRation.setText(ration.toString());
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public KDTable getTableForCommon() {
        return this.kdtEntrys;
    }

    protected void showSuccessMsg(String msgResource) {
        this.setMessageText(msgResource);
        this.showMessage();
    }

    @Override
    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPreview_actionPerformed(e);
        this.preparePrintPage(this.kdtEntrys);
        this.kdtEntrys.getPrintManager().printPreview();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.kdtEntrys);
        this.kdtEntrys.getPrintManager().print();
    }
}

