/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.clientUtil.ComponentUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.convert.BomConvertTypeRelationFactory;
import com.kingdee.eas.zjbom.convert.BomConvertTypeRelationInfo;
import com.kingdee.eas.zjbom.convert.client.AbstractBomConvertTypeRelationEditUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BomConvertTypeRelationEditUI
extends AbstractBomConvertTypeRelationEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BomConvertTypeRelationEditUI.class);
    private ItemListener cmbItemListener = null;
    private String RESOURCE_NAME = "com.kingdee.eas.zjbom.convert.BomConvertTypeRelationResource";

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.setBeforeBomTypeValue();
        this.setAfterBomTypeValue();
        this.addListener();
        this.initBtnEnabled();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BomConvertTypeRelationFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        BomConvertTypeRelationInfo objectValue = new BomConvertTypeRelationInfo();
        if (SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"ControlUnit")) != null && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"ControlUnit")).getBoolean("isBizUnit")) {
            objectValue.put("CU", SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"ControlUnit")));
        }
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setStatus(MMBaseStatusEnum.SAVED);
        objectValue.setBeforeDBomType(null);
        objectValue.setAfterDBomType(null);
        return objectValue;
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.btnCancel.setVisible(true);
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setVisible(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnSave.setVisible(false);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        ComponentUtil.setVisible((boolean)false, (Component[])new Component[]{this.menuItemSave});
    }

    protected void removeListener() {
        if (this.cmbItemListener != null) {
            this.beforeDBomType.removeItemListener(this.cmbItemListener);
            this.afterDBomType.removeItemListener(this.cmbItemListener);
        }
    }

    protected void addListener() {
        if (this.cmbItemListener == null) {
            this.cmbItemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        BomConvertTypeRelationEditUI.this.cmbItemStateChanged(e);
                    }
                    catch (Exception e1) {
                        BomConvertTypeRelationEditUI.this.handUIException(e1);
                    }
                }
            };
        }
        this.beforeDBomType.addItemListener(this.cmbItemListener);
        this.afterDBomType.addItemListener(this.cmbItemListener);
    }

    protected void cmbItemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            KDComboBox combBox;
            KDComboBox kDComboBox = e == null ? null : (e.getSource() == null ? null : (combBox = e.getSource() instanceof KDComboBox ? (KDComboBox)e.getSource() : null));
            if (combBox == null) {
                return;
            }
            String combName = combBox.getName();
            if (this.beforeDBomType.getName().equals(combName)) {
                this.setAfterBomTypeValue();
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.beforeDBomType.setRequired(true);
        this.afterDBomType.setRequired(true);
        if (this.editData.getId() == null) {
            this.status.setSelectedItem((Object)MMBaseStatusEnum.SAVED);
        }
    }

    private void setAfterBomTypeValue() {
        if (this.beforeDBomType.getSelectedItem() == null) {
            return;
        }
        this.afterDBomType.removeAllItems();
        DBOMTypeEnum sourceBomType = (DBOMTypeEnum)((Object)this.beforeDBomType.getSelectedItem());
        List<DBOMTypeEnum> targetBomTypeEnumList = this.getAfterBomTypeList(sourceBomType);
        if (targetBomTypeEnumList == null || targetBomTypeEnumList.size() < 1) {
            return;
        }
        for (int i = 0; i < targetBomTypeEnumList.size(); ++i) {
            this.afterDBomType.addItem((Object)targetBomTypeEnumList.get(i));
        }
    }

    private void setBeforeBomTypeValue() {
        this.beforeDBomType.removeAllItems();
        List<DBOMTypeEnum> beforeBomTypeEnumList = this.getBeforeBomTypeList();
        if (beforeBomTypeEnumList == null || beforeBomTypeEnumList.size() < 1) {
            return;
        }
        for (int i = 0; i < beforeBomTypeEnumList.size(); ++i) {
            this.beforeDBomType.addItem((Object)beforeBomTypeEnumList.get(i));
        }
    }

    private List<DBOMTypeEnum> getBeforeBomTypeList() {
        ArrayList<DBOMTypeEnum> returnList = new ArrayList<DBOMTypeEnum>();
        returnList.add(DBOMTypeEnum.DesignBOM);
        returnList.add(DBOMTypeEnum.DesignBomMiddle);
        returnList.add(DBOMTypeEnum.DesignTempBom);
        returnList.add(DBOMTypeEnum.ProcessBOM);
        return returnList;
    }

    private List<DBOMTypeEnum> getAfterBomTypeList(DBOMTypeEnum sourceBomType) {
        ArrayList<DBOMTypeEnum> returnList = new ArrayList<DBOMTypeEnum>();
        if (sourceBomType.equals((Object)DBOMTypeEnum.DesignTempBom)) {
            returnList.add(DBOMTypeEnum.DesignBOM);
            returnList.add(DBOMTypeEnum.MfgBom);
        } else if (sourceBomType.equals((Object)DBOMTypeEnum.DesignBOM)) {
            returnList.add(DBOMTypeEnum.DesignBomMiddle);
            returnList.add(DBOMTypeEnum.ProcessBOM);
            returnList.add(DBOMTypeEnum.MfgBom);
        } else if (sourceBomType.equals((Object)DBOMTypeEnum.DesignBomMiddle)) {
            returnList.add(DBOMTypeEnum.ProcessBOM);
        } else if (sourceBomType.equals((Object)DBOMTypeEnum.ProcessBOM)) {
            returnList.add(DBOMTypeEnum.MfgBom);
        }
        return returnList;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.checkEditData();
        if (this.editData != null && this.editData.getStatus() != null && this.editData.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"isUsed_NoSave"));
            SysUtil.abort();
        }
        this.status.setSelectedItem((Object)MMBaseStatusEnum.SAVED);
        super.actionSubmit_actionPerformed(e);
        this.refreshCurPage();
    }

    public void checkEditData() throws Exception {
        if (this.beforeDBomType.getSelectedItem() == null) {
            this.beforeDBomType.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"beforeDBomTypeNull"));
            SysUtil.abort();
        }
        if (this.afterDBomType.getSelectedItem() == null) {
            this.afterDBomType.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"afterDBomTypeNull"));
            SysUtil.abort();
        }
        DBOMTypeEnum beforeDBOMTypeEnum = (DBOMTypeEnum)((Object)this.beforeDBomType.getSelectedItem());
        DBOMTypeEnum afterDBOMTypeEnum = (DBOMTypeEnum)((Object)this.afterDBomType.getSelectedItem());
        String id = null;
        if (this.editData.getId() != null) {
            id = this.editData.getId().toString();
        }
        if (BomConvertTypeRelationFactory.getRemoteInstance().checkDataDouble(beforeDBOMTypeEnum, afterDBOMTypeEnum, id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"haveDoubleData"));
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getStatus() != null && this.editData.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"isUsed_NoEdit"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getStatus() != null && this.editData.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"isUsed_NoDelete"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getStatus() == null || !this.editData.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"isUnEnabled"));
            SysUtil.abort();
        }
        super.actionCancel_actionPerformed(e);
        this.refreshCurPage();
    }

    protected void initBtnEnabled() {
        if (this.editData == null || this.editData.getId() == null) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
        } else if (this.status.getSelectedItem().equals(MMBaseStatusEnum.ENABLE)) {
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.btnSave.setEnabled(false);
        } else {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.btnSubmit.setEnabled(true);
        }
    }

    protected void refreshCurPage() throws EASBizException, BOSException, Exception {
        if (this.editData.getId() != null) {
            ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
            IObjectValue iObjectValue = this.getValue((IObjectPK)iObjectPk);
            this.setDataObject(iObjectValue);
            this.loadFields();
            this.setSave(true);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkEditData();
        if (this.editData != null && this.editData.getStatus() != null && this.editData.getStatus().equals((Object)MMBaseStatusEnum.ENABLE)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE_NAME, (String)"isEnabled"));
            SysUtil.abort();
        }
        super.actionCancelCancel_actionPerformed(e);
        this.refreshCurPage();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.status.setSelectedItem((Object)MMBaseStatusEnum.SAVED);
        this.editData.setStatus(MMBaseStatusEnum.SAVED);
        this.btnSubmit.setEnabled(true);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.status.setSelectedItem((Object)MMBaseStatusEnum.SAVED);
        super.actionSave_actionPerformed(e);
        this.refreshCurPage();
    }
}

