/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.process;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.DesignBOMBillInfo;
import com.kingdee.eas.zjbom.convert.BomChangeBillAuditFacadeFactory;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.bomConvertFacadeFactory;
import com.kingdee.eas.zjbom.convert.process.BomConvertDesignBomBaseProcess;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import java.util.Locale;

public class BomConvert_DesignBom_Bom_Process
extends BomConvertDesignBomBaseProcess {
    @Override
    public void convert(Context ctx, BomConvertLogEntryInfo entryInfo, BomConvertLogInfo info) throws BOSException, EASBizException {
        super.convert(ctx, entryInfo, info);
        if (this.isException) {
            return;
        }
        if (!this.checkData_DesignBom(ctx)) {
            return;
        }
        if (bomConvertFacadeFactory.getLocalInstance(ctx).convertRequired(this.designBOMBillInfo, this.bomConvertLogInfo, this.bomConvertLogEntryInfo)) {
            this.afterConvert(ctx);
        }
    }

    protected static BomInfo addBomInfo(Context ctx, DesignBOMBillInfo dbomBillInfo, DesignModeInfo dsInfo, MaterialInfo parentMaterialInfo) throws BOSException, EASBizException {
        BomInfo bomInfo = BomUtil.addBomInfo(ctx, parentMaterialInfo, dbomBillInfo.getStorageOrgUnit(), dbomBillInfo.getProject(), dsInfo, dbomBillInfo.getParentQty(), BomConvert_DesignBom_Bom_Process.getMeasureUnitInfo(ctx, dbomBillInfo.getPMUnit(), parentMaterialInfo), null, null);
        return bomInfo;
    }

    protected static BomEntryInfo getBomEntryInfo(Context ctx, BomInfo bomInfo, DesignBOMBillInfo dbomBillInfo, MaterialInfo materialInfo) throws BOSException, EASBizException {
        BomEntryInfo bomEntryInfo = BomUtil.getBomEntryInfo(ctx, bomInfo, materialInfo, dbomBillInfo.getSupplyOrgUnit(), dbomBillInfo.getErpbatchno1(), dbomBillInfo.getErpbatchno2());
        return bomEntryInfo;
    }

    protected static BomEntryInfo addBomEntryInfo(Context ctx, BomInfo bomInfo, DesignBOMBillInfo dbomBillInfo, MaterialInfo materialInfo) throws BOSException, EASBizException {
        BomEntryInfo bomEntryInfo = BomUtil.addBomEntryInfo(ctx, bomInfo, materialInfo, BomConvert_DesignBom_Bom_Process.getMeasureUnitInfo(ctx, dbomBillInfo.getUnit(), materialInfo), dbomBillInfo.getQuantity(), dbomBillInfo.getSupplyOrgUnit(), dbomBillInfo.getErpbatchno1(), dbomBillInfo.getErpbatchno2(), dbomBillInfo.getMaterialAttr(), null, null);
        if (dbomBillInfo.getWeight() != null) {
            bomEntryInfo.setNetWeight(dbomBillInfo.getWeight());
        }
        bomEntryInfo.setBomFlow(dbomBillInfo.getMakeFlow());
        bomEntryInfo.setGtmeno(dbomBillInfo.getGtmeno());
        bomEntryInfo.setFixSeq(dbomBillInfo.getSeqNo());
        bomEntryInfo.setSourceBillEntryId(dbomBillInfo.getId().toString());
        bomEntryInfo.setSourceBillNumber(dbomBillInfo.getNumber());
        return bomEntryInfo;
    }

    protected static void setBomEntryInfo(Context ctx, BomEntryInfo bomEntryInfo, DesignBOMBillInfo dbomBillInfo) throws BOSException, EASBizException {
        bomEntryInfo.setConsumeFixBaseQty(dbomBillInfo.getQuantity());
        bomEntryInfo.setConsumeFixQty(dbomBillInfo.getQuantity());
        bomEntryInfo.setBomFlow(dbomBillInfo.getMakeFlow());
        bomEntryInfo.setGtmeno(dbomBillInfo.getGtmeno());
        bomEntryInfo.setSourceBillEntryId(dbomBillInfo.getId().toString());
        bomEntryInfo.setSourceBillNumber(dbomBillInfo.getNumber());
        if (dbomBillInfo.getWeight() != null) {
            bomEntryInfo.setNetWeight(dbomBillInfo.getWeight());
        }
        bomEntryInfo.setFixSeq(dbomBillInfo.getSeqNo());
        bomEntryInfo.setSourceBillEntryId(dbomBillInfo.getId().toString());
    }

    protected static boolean setBomInfovalue(Context ctx, BomInfo bomInfo, DesignBOMBillInfo dbomBillInfo) throws BOSException, EASBizException {
        boolean ischange = false;
        if (dbomBillInfo.getParentQty() != null) {
            if (bomInfo.getProductBaseQty().compareTo(dbomBillInfo.getParentQty()) != 0) {
                ischange = true;
            }
            bomInfo.setProductBaseQty(dbomBillInfo.getParentQty());
            bomInfo.setProductQty(dbomBillInfo.getParentQty());
        }
        if (dbomBillInfo.getPMUnit() != null && !"".equals(dbomBillInfo.getPMUnit())) {
            MeasureUnitInfo newUnitInfo = BomConvert_DesignBom_Bom_Process.getMeasureUnitInfo(ctx, dbomBillInfo.getPMUnit(), BomConvert_DesignBom_Bom_Process.getMaterialInfo(ctx, dbomBillInfo.getParentNo()));
            if (newUnitInfo != null && !newUnitInfo.getId().toString().equals(bomInfo.getUnit().getId().toString())) {
                ischange = true;
            }
            bomInfo.setUnit(newUnitInfo);
        }
        return ischange;
    }

    public static BomInfo convertBom(Context ctx, DesignBOMBillInfo dbomBillInfo, BomConvertLogInfo bclInfo, BomConvertLogEntryInfo bcleInfo) throws BOSException, EASBizException {
        MaterialInfo parentMaterialInfo = BomConvert_DesignBom_Bom_Process.getMaterialInfo(ctx, dbomBillInfo.getParentNo());
        MaterialInfo materialInfo = BomConvert_DesignBom_Bom_Process.getMaterialInfo(ctx, dbomBillInfo.getPartNo());
        boolean needUpdataNext = false;
        String fprojectid = null;
        if (dbomBillInfo.getProject() != null) {
            fprojectid = dbomBillInfo.getProject().getId().toString();
        }
        String ftrackID = null;
        if (dbomBillInfo.getErpbatchno1() != null) {
            ftrackID = dbomBillInfo.getErpbatchno1().getId().toString();
        }
        DBOMTypeEnum afterConvertBomType = dbomBillInfo.getConvertBomType();
        if (bclInfo != null) {
            afterConvertBomType = bclInfo.getAfterBomType();
        }
        BomInfo bomInfo = BomUtil.getBomInfo(ctx, parentMaterialInfo.getId().toString(), dbomBillInfo.getStorageOrgUnit().getId().toString(), fprojectid, dbomBillInfo.getDesignMode(), ftrackID, null);
        boolean isHeadChange = false;
        if (bomInfo == null) {
            bomInfo = BomConvert_DesignBom_Bom_Process.addBomInfo(ctx, dbomBillInfo, dbomBillInfo.getDesignMode(), parentMaterialInfo);
        } else {
            if (bomInfo.getBaseStatus().equals(4)) {
                needUpdataNext = true;
            }
            if (bclInfo != null) {
                int bomValidValue = BomUtil.checkBomisValid(ctx, dbomBillInfo.getParentQty(), BomConvert_DesignBom_Bom_Process.getMeasureUnitInfo(ctx, dbomBillInfo.getPMUnit(), parentMaterialInfo), bomInfo);
                if (bomValidValue == -1) {
                    throw new BOSException(ResourceBase.getString((String)RESURL, (String)"parent_Qty_NoValid", (Locale)ctx.getLocale(), (Object[])new String[]{parentMaterialInfo.getNumber(), bomInfo.getProductBaseQty().toString(), dbomBillInfo.getParentQty().toString()}));
                }
                if (bomValidValue == -2) {
                    throw new BOSException(ResourceBase.getString((String)RESURL, (String)"parent_Unit_NoValid", (Locale)ctx.getLocale(), (Object[])new String[]{parentMaterialInfo.getNumber(), bomInfo.getUnit().getName(), BomConvert_DesignBom_Bom_Process.getMeasureUnitInfo(ctx, dbomBillInfo.getPMUnit(), parentMaterialInfo).getName()}));
                }
            } else {
                isHeadChange = BomConvert_DesignBom_Bom_Process.setBomInfovalue(ctx, bomInfo, dbomBillInfo);
            }
        }
        BomEntryInfo bomEntryInfo = BomConvert_DesignBom_Bom_Process.getBomEntryInfo(ctx, bomInfo, dbomBillInfo, materialInfo);
        if (bomEntryInfo == null) {
            bomEntryInfo = BomConvert_DesignBom_Bom_Process.addBomEntryInfo(ctx, bomInfo, dbomBillInfo, materialInfo);
        }
        BomConvert_DesignBom_Bom_Process.setBomEntryInfo(ctx, bomEntryInfo, dbomBillInfo);
        bomEntryInfo.setParent(bomInfo);
        bomInfo.getEntrys().add(bomEntryInfo);
        BillBaseStatusEnum bomBaseStatusEnum = bomInfo.getBaseStatus();
        if (bomInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            bomInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            if (bomInfo.getId() != null) {
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("baseStatus"));
                BomFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)bomInfo, updateSic);
            }
        }
        if (bomInfo.getId() == null) {
            BomFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)bomInfo);
        } else {
            BomFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)bomInfo);
        }
        if (!bomBaseStatusEnum.equals((Object)bomInfo.getBaseStatus())) {
            bomInfo.setBaseStatus(bomBaseStatusEnum);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("baseStatus"));
            BomFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)bomInfo, updateSic);
        }
        if (needUpdataNext) {
            if (isHeadChange) {
                for (int i = 0; i < bomInfo.getEntrys().size(); ++i) {
                    BomChangeBillAuditFacadeFactory.getLocalInstance(ctx).updateNextDatasByBomEntrys(bomInfo.getEntrys().get(i), null, DBOMTypeEnum.DesignBOM);
                }
            } else {
                BomChangeBillAuditFacadeFactory.getLocalInstance(ctx).updateNextDatasByBomEntrys(bomEntryInfo, null, DBOMTypeEnum.DesignBOM);
            }
        }
        return bomInfo;
    }

    @Override
    public void afterConvert(Context ctx) throws BOSException, EASBizException {
        super.afterConvert(ctx);
    }
}

