/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.zjbom.util.BomUtil;
import java.math.BigDecimal;

public final class BomFieldUtil {
    public static void calculationOfSingleFixed(CoreUI coreUI, final KDFormattedTextField assemblyQty, final KDFormattedTextField singleFixed, final KDFormattedTextField fixed) {
        fixed.setEditable(false);
        assemblyQty.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null) {
                    assemblyQty.setValue((Object)BomUtil.ZERO);
                }
                BigDecimal fi = BomUtil.calculationOfFixed(fixed.getBigDecimalValue(), singleFixed.getBigDecimalValue(), assemblyQty.getBigDecimalValue());
                fixed.setValue((Object)fi);
            }
        });
        singleFixed.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null) {
                    assemblyQty.setValue((Object)BigDecimal.ONE);
                }
                BigDecimal fi = BomUtil.calculationOfFixed(fixed.getBigDecimalValue(), singleFixed.getBigDecimalValue(), assemblyQty.getBigDecimalValue());
                fixed.setValue((Object)fi);
            }
        });
    }

    public static void calculationOfSingleFixed(final KDTable kdt, String assemblyQty, String singleFixed, final String fixed) {
        final int assembly = kdt.getColumnIndex(assemblyQty);
        final int single = kdt.getColumnIndex(singleFixed);
        kdt.getColumn(fixed).getStyleAttributes().setLocked(true);
        kdt.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int col = e.getColIndex();
                if (col != assembly && col != single) {
                    return;
                }
                int rowIndex = e.getRowIndex();
                IRow row = kdt.getRow(rowIndex);
                BigDecimal fi = (BigDecimal)row.getCell(fixed).getValue();
                BigDecimal si = (BigDecimal)row.getCell(single).getValue();
                BigDecimal qty = (BigDecimal)row.getCell(assembly).getValue();
                fi = BomUtil.calculationOfFixed(fi, si, qty);
                BomFieldUtil.setTableColumnValue(row, fixed, fi);
            }
        });
    }

    private static void setTableColumnValue(IRow row, String column, Object value) {
        try {
            row.getCell(column).setValue(value);
        }
        catch (Exception e) {
            return;
        }
    }
}

