/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.zjreport.WorkshopMSAnalysisRPTFacadeFactory;
import com.kingdee.eas.zjreport.client.AbstractWorkshopMSAnalysisRPTUI;
import com.kingdee.eas.zjreport.client.WorkshopMSAnalysisRPTConditionUI;
import java.awt.Color;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class WorkshopMSAnalysisRPTUI
extends AbstractWorkshopMSAnalysisRPTUI {
    private static final Logger logger = CoreUIObject.getLogger(WorkshopMSAnalysisRPTUI.class);
    private static final long serialVersionUID = 1077048429827263669L;
    protected static final String[] COLS_SUM = new String[]{"planQty", "sendQty", "warehouseStock", "storageOrgUnitStock"};
    protected String assignStatus = "";
    protected String auditStatus = "";
    protected String endDate = "";
    protected String materialFrom = "";
    protected String materialTo = "";
    protected String process = "";
    protected String productFrom = "";
    protected String productTo = "";
    protected String projectNumberFrom = "";
    protected String projectNumberTo = "";
    protected RptRowSet rs = null;
    protected String saveStatus = "";
    protected String startDate = "";
    protected String storageOrgUnitFrom = "";
    protected String storageOrgUnitTo = "";
    protected String submitStatus = "";
    protected String traceNumberFrom = "";
    protected String traceNumberTo = "";

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.setColumnMoveable(true);
        this.enableExportExcel(this.tblMain);
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        try {
            int from = e.getFirstRow();
            String materialNumber = null;
            RptParams rp = new RptParams();
            rp.setString("storageOrgUnitFrom", this.storageOrgUnitFrom);
            rp.setString("storageOrgUnitTo", this.storageOrgUnitTo);
            rp.setString("projectNumberFrom", this.projectNumberFrom);
            rp.setString("projectNumberTo", this.projectNumberTo);
            rp.setString("traceNumberFrom", this.traceNumberFrom);
            rp.setString("traceNumberTo", this.traceNumberTo);
            rp.setString("startDate", this.startDate);
            rp.setString("endDate", this.endDate);
            rp.setString("materialFrom", this.materialFrom);
            rp.setString("materialTo", this.materialTo);
            rp.setString("productFrom", this.productFrom);
            rp.setString("productTo", this.productTo);
            rp.setString("process", this.process);
            rp.setString("saveStatus", this.saveStatus);
            rp.setString("submitStatus", this.submitStatus);
            rp.setString("auditStatus", this.auditStatus);
            rp.setString("assignStatus", this.assignStatus);
            rp.setObject("sumColumns", (Object)COLS_SUM);
            if (from == 0) {
                rp.setString("tempTable", this.getTempTable());
                rp = this.getRemoteInstance().createTempTable(rp);
                this.setTempTable(rp.getString("tempTable"));
                this.rs = (RptRowSet)rp.getObject("rowSet");
                this.tblMain.setRowCount(rp.getInt("rowCount"));
                this.setSumRow(rp);
            } else {
                rp.setString("tempTable", this.getTempTable());
            }
            KDTableUtil.insertRows((RptRowSet)this.rs, (int)from, (KDTable)this.tblMain);
            for (int row = from; row < this.tblMain.getRowCount(); ++row) {
                if (this.tblMain.getCell(row, "material.number") == null || (materialNumber = this.tblMain.getCell(row, "material.number").getValue() != null ? this.tblMain.getCell(row, "material.number").getValue().toString() : null) != null && materialNumber.trim().length() != 0) continue;
                this.tblMain.getRow(row).getStyleAttributes().setBackground(new Color(246, 246, 191));
            }
        }
        catch (Exception exp) {
            this.handUIException(exp);
        }
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    protected boolean enableTablePreferences() {
        return false;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new WorkshopMSAnalysisRPTConditionUI();
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return WorkshopMSAnalysisRPTFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected void query() {
        this.storageOrgUnitFrom = this.params.getObject("storageOrgUnitFrom").toString();
        this.storageOrgUnitTo = this.params.getObject("storageOrgUnitTo").toString();
        this.projectNumberFrom = this.params.getObject("projectNumberFrom").toString();
        this.projectNumberTo = this.params.getObject("projectNumberTo").toString();
        this.traceNumberFrom = this.params.getObject("traceNumberFrom").toString();
        this.traceNumberTo = this.params.getObject("traceNumberTo").toString();
        this.startDate = this.params.getObject("startDate").toString();
        this.endDate = this.params.getObject("endDate").toString();
        this.materialFrom = this.params.getObject("materialFrom").toString();
        this.materialTo = this.params.getObject("materialTo").toString();
        this.productFrom = this.params.getObject("productFrom").toString();
        this.productTo = this.params.getObject("productTo").toString();
        this.process = this.params.getObject("process").toString();
        this.saveStatus = this.params.getObject("saveStatus").toString();
        this.submitStatus = this.params.getObject("submitStatus").toString();
        this.auditStatus = this.params.getObject("auditStatus").toString();
        this.assignStatus = this.params.getObject("assignStatus").toString();
        this.txtStorageOrgUnitFrom.setText(this.storageOrgUnitFrom);
        this.txtStorageOrgUnitTo.setText(this.storageOrgUnitTo);
        this.txtProjectNumberFrom.setText(this.projectNumberFrom);
        this.txtProjectNumberTo.setText(this.projectNumberTo);
        this.txtTraceNumberFrom.setText(this.traceNumberFrom);
        this.txtTraceNumberTo.setText(this.traceNumberTo);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            this.pkStartDate.setValue((Object)df.parse(this.startDate));
            this.pkEndDate.setValue((Object)df.parse(this.endDate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.txtMaterialFrom.setText(this.materialFrom);
        this.txtMaterialTo.setText(this.materialTo);
        this.txtProductFrom.setText(this.productFrom);
        this.txtProductTo.setText(this.productTo);
        this.txtProcess.setText(this.process);
        if (Boolean.valueOf(this.saveStatus).booleanValue()) {
            this.cbxSave.setSelected(true);
        } else {
            this.cbxSave.setSelected(false);
        }
        if (Boolean.valueOf(this.submitStatus).booleanValue()) {
            this.cbxSubmit.setSelected(true);
        } else {
            this.cbxSubmit.setSelected(false);
        }
        if (Boolean.valueOf(this.auditStatus).booleanValue()) {
            this.cbxAudit.setSelected(true);
        } else {
            this.cbxAudit.setSelected(false);
        }
        if (Boolean.valueOf(this.assignStatus).booleanValue()) {
            this.cbxAssign.setSelected(true);
        } else {
            this.cbxAssign.setSelected(false);
        }
        this.tblMain.removeRows();
    }

    protected void setSumRow(RptParams rp) {
        KDTFootManager footRowManager = this.tblMain.getFootManager();
        if (footRowManager == null) {
            footRowManager = new KDTFootManager(this.tblMain);
            footRowManager.addFootView();
            this.tblMain.setFootManager(footRowManager);
        }
        IRow footRow = footRowManager.getFootRow(0);
        int number = 0;
        if (footRow == null) {
            String colFormat = "%{0.##########}f";
            footRow = footRowManager.addFootRow(0);
            this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
            this.tblMain.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total"));
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            for (number = 0; number < COLS_SUM.length; ++number) {
                footRow.getCell(COLS_SUM[number]).getStyleAttributes().setNumberFormat("%{0.##########}f");
                footRow.getCell(COLS_SUM[number]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                footRow.getCell(COLS_SUM[number]).getStyleAttributes().setFontColor(Color.BLACK);
            }
        }
        if (rp.getObject("sumData") != null && rp.getObject("sumData") instanceof RptRowSet) {
            RptRowSet rs = (RptRowSet)rp.getObject("sumData");
            if (!rs.next()) {
                return;
            }
            BigDecimal columnSum = null;
            for (number = 0; number < COLS_SUM.length; ++number) {
                columnSum = BigDecimal.ZERO;
                if (rs.getObject(COLS_SUM[number]) != null && rs.getObject(COLS_SUM[number]) instanceof BigDecimal) {
                    columnSum = rs.getBigDecimal(COLS_SUM[number]);
                }
                footRow.getCell(COLS_SUM[number]).setValue((Object)columnSum);
            }
        }
    }
}

