/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.zj.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignCollection;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.update8.Material8FacadeFactory;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import java.util.HashMap;
import java.util.Map;

public class ZJDefaultWarehouseUtils {
    public static final String DEFALUT_LOCATION_KEY = "DEFAULTLOCATION";
    public static final String PARAMKEY_OUTWAREHOUSE_PROJECTWAREHOUSE = "OUTWAREHOUSE_PROJECTWAREHOUSE";
    public static final String PARAMKEY_PURRECIVE_PROJECTWAREHOUSE = "PURRECIVE_PROJECTWAREHOUSE";
    public static Map paramMap = new HashMap();

    public static WarehouseInfo getDefaultWarehouse(StorageOrgUnitInfo sou, MaterialInfo material, ProjectInfo project, boolean isOut) throws EASBizException, BOSException {
        if (sou == null || material == null || project == null) {
            return null;
        }
        WarehouseInfo info = null;
        MaterialInventoryInfo minvInfo = Material8FacadeFactory.getRemoteInstance().getInventoryInfo(material.getId().toString(), sou.getId().toString());
        if (minvInfo.getDefaultWarehouse() != null) {
            info = WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(minvInfo.getDefaultWarehouse().getId()));
        }
        return info;
    }

    public static WarehouseInfo getDefaultWarehouse(StorageOrgUnitInfo sou, MaterialInfo material, ProjectInfo project, WorkCenterInfo workCenterInfo) throws EASBizException, BOSException {
        if (sou == null || material == null || project == null || workCenterInfo == null) {
            return null;
        }
        WarehouseInfo info = null;
        MaterialInventoryInfo minvInfo = Material8FacadeFactory.getRemoteInstance().getInventoryInfo(material.getId().toString(), sou.getId().toString());
        if (minvInfo.getDefaultWarehouse() != null) {
            info = WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(minvInfo.getDefaultWarehouse().getId()));
        }
        return info;
    }

    public static LocationInfo getDefLocationMaterial(MaterialInfo materialInfo, StorageOrgUnitInfo storageOrgInfo, WarehouseInfo warehouseInfo) throws EASBizException, BOSException {
        LocationInfo locationInfo = null;
        try {
            MaterialStorageAssignInfo msaInfo;
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("material.id");
            sic.add("storageOrg.id");
            sic.add("warehouse.id");
            sic.add("location.id");
            sic.add("location.name");
            sic.add("location.number");
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            if (materialInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString()));
            }
            if (storageOrgInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)storageOrgInfo.getId().toString()));
            }
            if (warehouseInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("warehouse.id", (Object)warehouseInfo.getId().toString()));
            }
            view.setFilter(filter);
            MaterialStorageAssignCollection msaColl = MaterialStorageAssignFactory.getRemoteInstance().getMaterialStorageAssignCollection(view);
            if (msaColl.size() > 0 && (msaInfo = msaColl.get(0)).isIsDefaultLocation()) {
                locationInfo = msaInfo.getLocation();
            }
            if (materialInfo == null) {
                locationInfo = null;
            }
            if (storageOrgInfo == null) {
                locationInfo = null;
            }
            if (warehouseInfo == null) {
                locationInfo = null;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return locationInfo;
    }

    public static WarehouseInfo getWarehouseSettingWarehouse(String storageOrgUnitID, String materialID) throws BOSException {
        if (storageOrgUnitID == null || materialID == null) {
            return null;
        }
        WarehouseInfo info = null;
        MaterialInventoryInfo minvInfo = null;
        try {
            minvInfo = Material8FacadeFactory.getRemoteInstance().getInventoryInfo(materialID.toString(), storageOrgUnitID.toString());
            if (minvInfo.getDefaultWarehouse() != null) {
                info = WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(minvInfo.getDefaultWarehouse().getId()));
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    public static boolean isProjectWarehouse(StorageOrgUnitInfo sou, String key) throws EASBizException, BOSException {
        return false;
    }
}

