/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.directDeliveryPlan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.directDeliveryPlan.AbstractSonDirectDeliveryPlanFacadeControllerBean;
import com.kingdee.eas.industry.directDeliveryPlan.DirectTypeEnum;
import com.kingdee.eas.industry.directDeliveryPlan.ManufactureOrderMatchHandler;
import com.kingdee.eas.industry.directDeliveryPlan.PurOrderMatchHandler;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryFBFacadeFactory;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanFactory;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanInfo;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanPurEntryCollection;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanPurEntryInfo;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanSPurEntryCollection;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanSPurEntryInfo;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanSingletonFactory;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanStockEntryCollection;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanStockEntryInfo;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryToFBFactory;
import com.kingdee.eas.industry.directDeliveryPlan.SonMftOrderSingleton;
import com.kingdee.eas.industry.directDeliveryPlan.SonPurOrderSingleton;
import com.kingdee.eas.industry.emm.common.MMSendToNextFacadeFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SonDirectDeliveryPlanFacadeControllerBean
extends AbstractSonDirectDeliveryPlanFacadeControllerBean {
    private static final long serialVersionUID = -4239765853748223170L;
    private String WAREHOUSE = "WAREHOUSE";
    private String SCHENE = "SCHENE";
    private long startTime = Long.MIN_VALUE;

    private void writeLog(Context ctx, String tableName, int index, boolean isEnd) throws BOSException, EASBizException {
        DecimalFormat df = new DecimalFormat("#.00");
        this.startTime = System.currentTimeMillis();
        String sqlinit = this.getInsertTableSQL(tableName) + " select 1 , '\u7f16\u5236\u5f00\u59cb' ,'\u5f00\u59cb\u7f16\u5236,\u6570\u636e\u51c6\u5907', 0 ,'\u672a\u5f00\u59cb', 0 ,'1', 0  FROM dual  UNION ALL   select 2 , '\u83b7\u53d6\u5206\u5b50\u516c\u53f8\u76f4\u9001\u8ba1\u5212\u9700\u6c42' ,'\u83b7\u53d6\u5206\u5b50\u516c\u53f8\u76f4\u9001\u8ba1\u5212\u9700\u6c42', 0 ,'\u672a\u5f00\u59cb', 0 ,'1',0 FROM dual  UNION ALL   select 3 , '\u5339\u914d\u91c7\u8d2d\u8ba2\u5355' ,'\u5339\u914d\u91c7\u8d2d\u8ba2\u5355', 0 ,'\u672a\u5f00\u59cb', 0 ,'1', 0 FROM dual  UNION ALL  select 4 , '\u5339\u914d\u751f\u4ea7\u8ba2\u5355','\u5339\u914d\u751f\u4ea7\u8ba2\u5355', 0 ,'\u672a\u5f00\u59cb', 0 ,'1', 0 FROM dual  UNION ALL  select 5 , '\u751f\u6210\u5206\u5b50\u516c\u53f8\u76f4\u9001\u8ba1\u5212' ,'\u751f\u6210\u5206\u5b50\u516c\u53f8\u76f4\u9001\u8ba1\u5212', 0 ,'\u672a\u5f00\u59cb', 0 ,'1', 0 FROM dual   UNION ALL  select 6 , '\u7f16\u5236\u5b8c\u6210' ,'\u7f16\u5236\u5b8c\u6210', 0 ,'\u672a\u5f00\u59cb', 0 ,'1', 0 FROM dual ";
        String sqlone = "update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 10  where findex = 1";
        String sqltwo = "update " + tableName + " set fstatus = '\u5904\u7406\u4e2d',fpercent = 0  where findex = 2";
        String sqlthree = null;
        String sqlfour = null;
        String sqlfive = null;
        String sqlsix = "update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 10  where findex = 5";
        String sqlseven = "update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 10  where findex = 6";
        if (isEnd) {
            double tmp;
            long endTime;
            if (index == 3) {
                endTime = System.currentTimeMillis();
                tmp = (double)(endTime - this.startTime) / 60000.0;
                sqlthree = "update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 35 ,ftime = " + df.format(tmp) + " where findex = 2";
            }
            if (index == 4) {
                endTime = System.currentTimeMillis();
                tmp = (double)(endTime - this.startTime) / 60000.0;
                sqlfour = "update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 70 ,ftime = " + df.format(tmp) + " where findex = 3";
            }
            if (index == 5) {
                endTime = System.currentTimeMillis();
                tmp = (double)(endTime - this.startTime) / 60000.0;
                sqlfive = "update " + tableName + " set fstatus = '\u5df2\u5b8c\u6210',fpercent = 90 ,ftime = " + df.format(tmp) + " where findex = 4";
            }
        }
        if (index == 0) {
            DbUtil.execute((Context)ctx, (String)sqlinit);
        }
        if (index == 1) {
            DbUtil.execute((Context)ctx, (String)sqlone);
        }
        if (index == 2) {
            DbUtil.execute((Context)ctx, (String)sqltwo);
        }
        if (index == 3) {
            DbUtil.execute((Context)ctx, sqlthree);
        }
        if (index == 4) {
            DbUtil.execute((Context)ctx, sqlfour);
        }
        if (index == 5) {
            DbUtil.execute((Context)ctx, sqlfive);
        }
        if (index == 6) {
            DbUtil.execute((Context)ctx, (String)sqlsix);
        }
        if (index == 7) {
            DbUtil.execute((Context)ctx, (String)sqlseven);
        }
    }

    @Override
    protected void _exec(Context ctx, String purgroupid, String purorgid, Date starttime, Date endtime, String tableName) throws BOSException, EASBizException {
        ctx.put((Object)"PURORGID", (Object)purorgid);
        ctx.put((Object)"PURGROUPID", (Object)purgroupid);
        this.writeLog(ctx, tableName, 0, false);
        this.writeLog(ctx, tableName, 1, false);
        ArrayList<SonDirectDeliveryPlanInfo> sonddpList = new ArrayList<SonDirectDeliveryPlanInfo>();
        this.deleteSonDirectDeliveryPlanByPurOrg(ctx, purorgid);
        HashSet<String> set = new HashSet<String>();
        set.add(purorgid);
        MMSendToNextFacadeFactory.getLocalInstance(ctx).delSondirectdeliveryPlanByOrg(set);
        this.writeLog(ctx, tableName, 99, false);
        List<PurOrderInfo> purorderList = this.queryPurOrderByCondition(ctx, purgroupid, purorgid, starttime, endtime);
        this.writeLog(ctx, tableName, 3, true);
        this.writeLog(ctx, tableName, 99, false);
        this.matchSonPurOrderByPurOrder(ctx, purorderList, sonddpList);
        this.writeLog(ctx, tableName, 4, true);
        this.writeLog(ctx, tableName, 99, false);
        this.rebuildSonDirectDeliveryToFB(ctx, purorgid);
        this.writeLog(ctx, tableName, 5, true);
        SonDirectDeliveryPlanSingletonFactory.getMftOrderSingleton(ctx).clear();
        SonDirectDeliveryPlanSingletonFactory.getPurOrderSignleton(ctx).clear();
        this.writeLog(ctx, tableName, 6, true);
        this.writeLog(ctx, tableName, 7, true);
        MMSendToNextFacadeFactory.getLocalInstance(ctx).autoSyncSondirectdeliveryPlanByOrg(set);
    }

    private void rebuildSonDirectDeliveryToFB(Context ctx, String purid) throws BOSException, EASBizException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("PURORGID", purid);
        SonDirectDeliveryFBFacadeFactory.getLocalInstance(ctx).refreshSupplyList(param);
    }

    private void deleteSonDirectDeliveryPlanByPurOrg(Context ctx, String purid) throws BOSException, EASBizException {
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("purorg.id", (Object)purid, CompareType.EQUALS));
        SonDirectDeliveryPlanFactory.getLocalInstance(ctx).delete(filterinfo);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purorgid", (Object)purid, CompareType.EQUALS));
        SonDirectDeliveryToFBFactory.getLocalInstance(ctx).delete(filter);
    }

    private void matchSonPurOrderByPurOrder(Context ctx, List<PurOrderInfo> purorderList, List<SonDirectDeliveryPlanInfo> sonddpList) throws BOSException, EASBizException {
        HashSet<String> materialList = new HashSet<String>();
        HashSet<String> projectList = new HashSet<String>();
        HashSet<String> trackList = new HashSet<String>();
        HashSet<String> storageList = new HashSet<String>();
        PurOrderMatchHandler purOrderHandler = new PurOrderMatchHandler();
        ManufactureOrderMatchHandler mftOrderHandler = new ManufactureOrderMatchHandler();
        purOrderHandler.setCtx(ctx);
        purOrderHandler.setHandler(mftOrderHandler);
        ArrayList<SonDirectDeliveryPlanInfo> sondirectdeliveryList = new ArrayList<SonDirectDeliveryPlanInfo>();
        for (int n = 0; n < purorderList.size(); ++n) {
            PurOrderInfo order = purorderList.get(n);
            PurOrderEntryCollection colls = order.getEntries();
            for (int m = 0; m < colls.size(); ++m) {
                PurOrderEntryInfo entry = colls.get(m);
                String materialid = entry.getMaterial().getId().toString();
                String projectid = entry.getProject() == null ? "" : entry.getProject().getId().toString();
                String tracknumberid = entry.getTrackNo() == null ? "" : entry.getTrackNo().getId().toString();
                String storageid = entry.getStorageOrgUnit().getId().toString();
                SonDirectDeliveryPlanInfo sondirectinfo = new SonDirectDeliveryPlanInfo();
                sondirectinfo.setBizDate(entry.getDeliveryDate() == null ? new Date() : entry.getDeliveryDate());
                sondirectinfo.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                sondirectinfo.setStorageOrgUnit(entry.getStorageOrgUnit());
                sondirectinfo.setPurorg(entry.getParent().getPurchaseOrgUnit());
                SonDirectDeliveryPlanSPurEntryInfo spurentry = new SonDirectDeliveryPlanSPurEntryInfo();
                spurentry.setOrderno(order.getNumber());
                spurentry.setPurentryid(entry.getId().toString());
                spurentry.setMaterial(entry.getMaterial());
                spurentry.setProject(entry.getProject());
                spurentry.setTracknumber(entry.getTrackNo());
                spurentry.setStorage(entry.getStorageOrgUnit());
                spurentry.setPurchaseorg(entry.getParent().getPurchaseOrgUnit());
                spurentry.setQty(entry.getQty().subtract(entry.getTotalReceiptQty()));
                spurentry.setSupplier(order.getSupplier());
                spurentry.setUnit(entry.getUnit());
                materialList.add(materialid);
                projectList.add(projectid);
                trackList.add(tracknumberid);
                storageList.add(storageid);
                SonDirectDeliveryPlanSPurEntryCollection spurcolls = new SonDirectDeliveryPlanSPurEntryCollection();
                spurcolls.add(spurentry);
                sondirectinfo.put("sPurEntrys", (Object)spurcolls);
                sondirectdeliveryList.add(sondirectinfo);
            }
        }
        ctx.put((Object)"PARAM", (Object)new Object[]{materialList, projectList, trackList, storageList});
        ArrayList<SonDirectDeliveryPlanInfo> planList = new ArrayList<SonDirectDeliveryPlanInfo>();
        for (int n = 0; n < sondirectdeliveryList.size(); ++n) {
            SonDirectDeliveryPlanInfo sondirectinfo = (SonDirectDeliveryPlanInfo)sondirectdeliveryList.get(n);
            purOrderHandler.setCoreInfo(sondirectinfo);
            purOrderHandler.handleRequest();
            List<SonDirectPlanResultVO> listResult = this.reorganizeSonDirectDeliveryPlanInfo(sondirectinfo);
            planList.addAll(this.createSonDirectDeliveryPlan(ctx, sondirectinfo, listResult));
        }
        for (SonDirectDeliveryPlanInfo obj : planList) {
            SonDirectDeliveryPlanFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)obj);
        }
    }

    private List<SonDirectDeliveryPlanInfo> createSonDirectDeliveryPlan(Context ctx, SonDirectDeliveryPlanInfo sondirectinfo, List<SonDirectPlanResultVO> listResult) throws BOSException, EASBizException {
        ArrayList<SonDirectDeliveryPlanInfo> addList = new ArrayList<SonDirectDeliveryPlanInfo>();
        for (SonDirectPlanResultVO vo : listResult) {
            String supplierid = vo.getSupplierid();
            String directType = vo.getDirectPlanType();
            BigDecimal[] values = vo.getArrays();
            BigDecimal spurQty = values[0];
            BigDecimal purQty = values[1];
            BigDecimal stockQty = values[2];
            SonDirectDeliveryPlanInfo addsondirectinfo = (SonDirectDeliveryPlanInfo)sondirectinfo.clone();
            addsondirectinfo.setDirectType(this.getDirectType(directType));
            addsondirectinfo.setNumber(this.getDefaultNumber(ctx, addsondirectinfo));
            SonDirectDeliveryPlanSPurEntryInfo spurEntry = addsondirectinfo.getSPurEntrys().get(0);
            spurEntry.setQty(spurQty);
            if (purQty.compareTo(BigDecimal.ZERO) > 0) {
                SonDirectDeliveryPlanPurEntryCollection purcoll = this.getSonDirectDeliveryPurEntry(ctx, sondirectinfo, purQty, supplierid);
                addsondirectinfo.put("purEntrys", purcoll.clone());
                if (purcoll.size() > 0) {
                    addsondirectinfo.setSupplier(purcoll.get(0).getSupplier());
                }
            } else {
                addsondirectinfo.put("purEntrys", null);
            }
            if (stockQty.compareTo(BigDecimal.ZERO) > 0) {
                SonDirectDeliveryPlanStockEntryCollection stockcoll = this.getSonDirectDeliveryStockEntry(ctx, sondirectinfo, stockQty);
                addsondirectinfo.put("stockEntrys", stockcoll.clone());
            } else {
                addsondirectinfo.put("stockEntrys", null);
            }
            addList.add(addsondirectinfo);
        }
        return addList;
    }

    private String getDefaultNumber(Context ctx, SonDirectDeliveryPlanInfo addsondirectinfo) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String storageUnitId = ContextUtil.getCurrentAdminUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentAdminUnit((Context)ctx).getId().toString();
        String number = iCodingRuleManager.getNumber((IObjectValue)addsondirectinfo, storageUnitId);
        return number;
    }

    private DirectTypeEnum getDirectType(String name) {
        List resList = DirectTypeEnum.getEnumList();
        DirectTypeEnum hitEnum = null;
        for (int n = 0; n < resList.size(); ++n) {
            DirectTypeEnum typeEnum = (DirectTypeEnum)((Object)resList.get(n));
            if (!name.equals(typeEnum.getName())) continue;
            hitEnum = typeEnum;
        }
        return hitEnum;
    }

    private SonDirectDeliveryPlanPurEntryCollection getSonDirectDeliveryPurEntry(Context ctx, SonDirectDeliveryPlanInfo sondirectinfo, BigDecimal purQty, String supplierid) throws BOSException, EASBizException {
        SonDirectDeliveryPlanPurEntryCollection coll = SonPurOrderSingleton.getInstance(ctx).backWritePurEntrySingleton(sondirectinfo, purQty, supplierid);
        return coll;
    }

    private SonDirectDeliveryPlanStockEntryCollection getSonDirectDeliveryStockEntry(Context ctx, SonDirectDeliveryPlanInfo sondirectinfo, BigDecimal purQty) throws BOSException, EASBizException {
        SonDirectDeliveryPlanStockEntryCollection coll = SonMftOrderSingleton.getInstance(ctx).backWriteMftEntrySingleton(sondirectinfo, purQty);
        return coll;
    }

    private List<SonDirectPlanResultVO> reorganizeSonDirectDeliveryPlanInfo(SonDirectDeliveryPlanInfo sondirectinfo) {
        SonDirectDeliveryPlanSPurEntryCollection spur_colls = sondirectinfo.getSPurEntrys();
        SonDirectDeliveryPlanSPurEntryInfo spurentry = spur_colls.get(0);
        ArrayList<SonDirectPlanResultVO> listResult = new ArrayList();
        BigDecimal sPurQty = spurentry.getQty();
        Map<String, BigDecimal> sumPurQtyMap = this.getPurEntrysCountGroupBySupplier(sondirectinfo.getPurEntrys());
        BigDecimal sumStockQty = this.getStockEntrysCount(sondirectinfo.getStockEntrys());
        listResult = this.loopCreateSonDirectPlan(sPurQty, sumPurQtyMap, sumStockQty);
        return listResult;
    }

    private List<SonDirectPlanResultVO> loopCreateSonDirectPlan(BigDecimal sPurQty, Map<String, BigDecimal> purQtys, BigDecimal sumStockQty) {
        ArrayList<SonDirectPlanResultVO> resultList = new ArrayList<SonDirectPlanResultVO>();
        BigDecimal purQty = BigDecimal.ZERO;
        SonDirectPurResultVO purvo = new SonDirectPurResultVO();
        while (sPurQty.compareTo(BigDecimal.ZERO) > 0 && this.getSumPurQty(purQtys).compareTo(BigDecimal.ZERO) > 0) {
            Object mixQty;
            Object[] arraysQty;
            SonDirectPlanResultVO vo;
            if (sumStockQty.compareTo(BigDecimal.ZERO) > 0) {
                vo = new SonDirectPlanResultVO();
                vo.setDirectPlanType(this.SCHENE);
                purvo = this.getPurQty(purvo.getSupplierid(), purQty, purQtys);
                vo.setSupplierid(purvo.getSupplierid());
                arraysQty = new BigDecimal[]{sPurQty, purvo.getPurqty(), sumStockQty};
                Arrays.sort((Object[])arraysQty);
                mixQty = arraysQty[0];
                BigDecimal[] sceneQtys = new BigDecimal[]{mixQty, mixQty, mixQty};
                vo.setArrays(sceneQtys);
                resultList.add(vo);
                sPurQty = sPurQty.subtract((BigDecimal)mixQty);
                purQty = purQty.subtract((BigDecimal)mixQty);
                sumStockQty = sumStockQty.subtract((BigDecimal)mixQty);
                continue;
            }
            vo = new SonDirectPlanResultVO();
            vo.setDirectPlanType(this.WAREHOUSE);
            purvo = this.getPurQty(purvo.getSupplierid(), purQty, purQtys);
            purQty = purvo.getPurqty();
            vo.setSupplierid(purvo.getSupplierid());
            arraysQty = new BigDecimal[]{sPurQty, purvo.getPurqty()};
            Arrays.sort((Object[])arraysQty);
            mixQty = arraysQty[0];
            BigDecimal[] warehouseQtys = new BigDecimal[]{mixQty, mixQty, BigDecimal.ZERO};
            vo.setArrays(warehouseQtys);
            resultList.add(vo);
            sPurQty = sPurQty.subtract((BigDecimal)mixQty);
            purQty = purQty.subtract((BigDecimal)mixQty);
        }
        return resultList;
    }

    private BigDecimal getSumPurQty(Map<String, BigDecimal> purQtys) {
        BigDecimal sumpurQty = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> obj : purQtys.entrySet()) {
            sumpurQty = sumpurQty.add(obj.getValue());
        }
        return sumpurQty;
    }

    private SonDirectPurResultVO getPurQty(String _supplierid, BigDecimal qty, Map<String, BigDecimal> map) {
        Iterator<Map.Entry<String, BigDecimal>> iter = map.entrySet().iterator();
        SonDirectPurResultVO vo = new SonDirectPurResultVO();
        String supplierid = _supplierid;
        if (iter.hasNext() && qty.compareTo(BigDecimal.ZERO) == 0) {
            Map.Entry<String, BigDecimal> obj = iter.next();
            supplierid = obj.getKey();
            BigDecimal purqty = obj.getValue();
            vo.setPurqty(purqty);
            vo.setSupplierid(supplierid);
        }
        map.remove(supplierid);
        return vo;
    }

    private Map<String, BigDecimal> getPurEntrysCountGroupBySupplier(SonDirectDeliveryPlanPurEntryCollection coll) {
        HashMap<String, BigDecimal> sumQtyMap = new HashMap<String, BigDecimal>();
        for (int n = 0; n < coll.size(); ++n) {
            SonDirectDeliveryPlanPurEntryInfo entryinfo = coll.get(n);
            SupplierInfo supplier = entryinfo.getSupplier();
            if (supplier == null) continue;
            String supplierid = supplier.getId().toString();
            if (sumQtyMap.get(supplierid) != null) {
                BigDecimal qty = ((BigDecimal)sumQtyMap.get(supplierid)).add(entryinfo.getQty());
                sumQtyMap.put(supplierid, qty);
                continue;
            }
            sumQtyMap.put(supplierid, entryinfo.getQty());
        }
        return sumQtyMap;
    }

    private BigDecimal getPurEntrysCount(SonDirectDeliveryPlanPurEntryCollection coll) {
        BigDecimal sumQty = BigDecimal.ZERO;
        for (int n = 0; n < coll.size(); ++n) {
            SonDirectDeliveryPlanPurEntryInfo entryinfo = coll.get(n);
            sumQty = sumQty.add(entryinfo.getQty());
        }
        return sumQty;
    }

    private BigDecimal getStockEntrysCount(SonDirectDeliveryPlanStockEntryCollection coll) {
        BigDecimal sumQty = BigDecimal.ZERO;
        for (int n = 0; n < coll.size(); ++n) {
            SonDirectDeliveryPlanStockEntryInfo entryinfo = coll.get(n);
            sumQty = sumQty.add(entryinfo.getQty());
        }
        return sumQty;
    }

    private SelectorItemCollection getPurOrderSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("entries.id"));
        selector.add(new SelectorItemInfo("entries.deliveryDate"));
        selector.add(new SelectorItemInfo("entries.material.id"));
        selector.add(new SelectorItemInfo("entries.project.id"));
        selector.add(new SelectorItemInfo("entries.trackNo.id"));
        selector.add(new SelectorItemInfo("entries.storageOrgUnit.id"));
        selector.add(new SelectorItemInfo("entries.qty"));
        selector.add(new SelectorItemInfo("entries.totalReceiptQty"));
        selector.add(new SelectorItemInfo("entries.unit.id"));
        selector.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("supplier.id"));
        selector.add(new SelectorItemInfo("supplier.isInternalCompany"));
        selector.add(new SelectorItemInfo("supplier.internalCompany"));
        return selector;
    }

    private FilterInfo getPurOrderFilter(Date starttime, Date endtime, String purorgid) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)starttime, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)endtime, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)purorgid, CompareType.EQUALS));
        return filter;
    }

    private List<PurOrderInfo> queryPurOrderByCondition(Context ctx, String purgroupid, String purorgid, Date starttime, Date endtime) throws BOSException, EASBizException {
        ArrayList<PurOrderInfo> result = new ArrayList<PurOrderInfo>();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(this.getPurOrderFilter(starttime, endtime, purorgid));
        view.setSelector(this.getPurOrderSelector());
        PurOrderCollection colls = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(view);
        OrgUnitCollection companys = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(purgroupid, 3, 1);
        CompanyOrgUnitInfo company = null;
        if (companys != null && companys.size() > 0) {
            company = (CompanyOrgUnitInfo)companys.get(0);
        }
        for (int n = 0; n < colls.size(); ++n) {
            PurOrderInfo purorder = colls.get(n);
            if (!this.matchSupplierCondition(ctx, purorder, company)) continue;
            result.add(purorder);
        }
        return result;
    }

    private boolean matchSupplierCondition(Context ctx, PurOrderInfo purorder, CompanyOrgUnitInfo company) {
        boolean isMatchSuccess = false;
        SupplierInfo supplier = purorder.getSupplier();
        if (supplier == null) {
            return isMatchSuccess;
        }
        boolean isInternal = supplier.isIsInternalCompany();
        if (!isInternal) {
            return isMatchSuccess;
        }
        CompanyOrgUnitInfo internalCompany = supplier.getInternalCompany();
        if (internalCompany != null && company != null && internalCompany.getId().toString().equals(company.getId().toString())) {
            isMatchSuccess = true;
        }
        return isMatchSuccess;
    }

    private void mergeSonDirectDeliveryPlan(Context ctx, List<SonDirectDeliveryPlanInfo> sonddpList) throws BOSException, EASBizException {
    }

    protected String getInsertTableSQL(String TableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(TableName).append("(Findex,FStep,Fcontent,Ftime,Fstatus,FlastIndex,fistop,Fpercent)");
        return sql.toString();
    }

    class SonDirectPlanResultVO {
        private BigDecimal[] arrays;
        private String supplierid;
        private String directPlanType;

        SonDirectPlanResultVO() {
        }

        public BigDecimal[] getArrays() {
            return this.arrays;
        }

        public void setArrays(BigDecimal[] arrays) {
            this.arrays = arrays;
        }

        public String getSupplierid() {
            return this.supplierid;
        }

        public void setSupplierid(String supplierid) {
            this.supplierid = supplierid;
        }

        public String getDirectPlanType() {
            return this.directPlanType;
        }

        public void setDirectPlanType(String directPlanType) {
            this.directPlanType = directPlanType;
        }
    }

    class SonDirectPurResultVO {
        private BigDecimal purqty;
        private String supplierid;

        SonDirectPurResultVO() {
        }

        public BigDecimal getPurqty() {
            return this.purqty;
        }

        public void setPurqty(BigDecimal purqty) {
            this.purqty = purqty;
        }

        public String getSupplierid() {
            return this.supplierid;
        }

        public void setSupplierid(String supplierid) {
            this.supplierid = supplierid;
        }
    }
}

