/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.directDeliveryPlan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanInfo;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanPurEntryCollection;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanPurEntryInfo;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanSPurEntryCollection;
import com.kingdee.eas.industry.directDeliveryPlan.SonDirectDeliveryPlanSPurEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SonPurOrderSingleton {
    private Context ctx;
    private static SonPurOrderSingleton instance;
    private Map<String, List<SonDirectDeliveryPlanPurEntryInfo>> grouppurMap = new HashMap<String, List<SonDirectDeliveryPlanPurEntryInfo>>();

    private SonPurOrderSingleton(Context _ctx) throws BOSException, EASBizException {
        this.ctx = _ctx;
        this.initSonPurOrderSingleton();
    }

    private void initSonPurOrderSingleton() throws BOSException, EASBizException {
        String purgroupid = (String)this.ctx.get((Object)"PURGROUPID");
        Object[] params = (Object[])this.ctx.get((Object)"PARAM");
        this.getPurOrderGroupByCondition(this.ctx, purgroupid, params);
    }

    public static synchronized SonPurOrderSingleton getInstance(Context ctx) throws BOSException, EASBizException {
        if (instance == null) {
            instance = new SonPurOrderSingleton(ctx);
        }
        return instance;
    }

    public void clear() {
        instance = null;
    }

    public void matchPurOrderQty(SonDirectDeliveryPlanInfo coreinfo) {
        SonDirectDeliveryPlanSPurEntryCollection colls = coreinfo.getSPurEntrys();
        for (int n = 0; n < colls.size(); ++n) {
            SonDirectDeliveryPlanSPurEntryInfo entryinfo = colls.get(n);
            String materialid = entryinfo.getMaterial().getId().toString();
            String projectid = entryinfo.getProject() == null ? "" : entryinfo.getProject().getId().toString();
            String tracknumberid = entryinfo.getTracknumber() == null ? "" : entryinfo.getTracknumber().getId().toString();
            String key = materialid + "@" + projectid + "@" + tracknumberid;
            List<SonDirectDeliveryPlanPurEntryInfo> entrys = this.grouppurMap.get(key);
            SonDirectDeliveryPlanPurEntryCollection purEntrycolls = new SonDirectDeliveryPlanPurEntryCollection();
            if (entrys != null) {
                for (int m = 0; m < entrys.size(); ++m) {
                    purEntrycolls.add(entrys.get(m));
                }
            }
            coreinfo.put("purEntrys", (Object)purEntrycolls);
        }
    }

    public SonDirectDeliveryPlanPurEntryCollection backWritePurEntrySingleton(SonDirectDeliveryPlanInfo coreinfo, BigDecimal qty, String supplierid) {
        SonDirectDeliveryPlanSPurEntryCollection colls = coreinfo.getSPurEntrys();
        SonDirectDeliveryPlanPurEntryCollection purEntrycolls = new SonDirectDeliveryPlanPurEntryCollection();
        for (int n = 0; n < colls.size(); ++n) {
            SonDirectDeliveryPlanSPurEntryInfo entryinfo = colls.get(n);
            String materialid = entryinfo.getMaterial().getId().toString();
            String projectid = entryinfo.getProject() == null ? "" : entryinfo.getProject().getId().toString();
            String tracknumberid = entryinfo.getTracknumber() == null ? "" : entryinfo.getTracknumber().getId().toString();
            String key = materialid + "@" + projectid + "@" + tracknumberid;
            List<SonDirectDeliveryPlanPurEntryInfo> entrys = this.grouppurMap.get(key);
            for (int m = 0; m < entrys.size(); ++m) {
                SonDirectDeliveryPlanPurEntryInfo info = entrys.get(m);
                String _supplierid = info.getSupplier().getId().toString();
                if (!_supplierid.equals(supplierid)) continue;
                info.setId(null);
                BigDecimal remainQty = info.getRemainqty();
                if (qty.compareTo(BigDecimal.ZERO) > 0) {
                    if (qty.compareTo(remainQty) >= 0) {
                        info.setRemainqty(BigDecimal.ZERO);
                        info.setQty(remainQty);
                        purEntrycolls.add(info);
                        qty = qty.subtract(remainQty);
                    } else {
                        remainQty = remainQty.subtract(qty);
                        info.setRemainqty(remainQty);
                        info.setQty(qty);
                        purEntrycolls.add(info);
                    }
                }
                entrys.set(m, info);
            }
            this.grouppurMap.put(key, entrys);
            coreinfo.put("purEntrys", (Object)purEntrycolls);
        }
        return purEntrycolls;
    }

    private SelectorItemCollection getPurOrderSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("material.id"));
        selector.add(new SelectorItemInfo("project.id"));
        selector.add(new SelectorItemInfo("trackNo.id"));
        selector.add(new SelectorItemInfo("storageOrgUnit.id"));
        selector.add(new SelectorItemInfo("qty"));
        selector.add(new SelectorItemInfo("totalReceiptQty"));
        selector.add(new SelectorItemInfo("unit.id"));
        selector.add(new SelectorItemInfo("parent.purchaseOrgUnit.id"));
        selector.add(new SelectorItemInfo("parent.number"));
        selector.add(new SelectorItemInfo("parent.supplier.id"));
        return selector;
    }

    private FilterInfo getPurOrderFilter(String purgroupid, Object[] params) {
        HashSet materialList = (HashSet)params[0];
        HashSet projectList = (HashSet)params[1];
        HashSet trackList = (HashSet)params[2];
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialList, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectList, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("trackNo.id", (Object)trackList, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)4, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.purchaseOrgUnit.id", (Object)purgroupid, CompareType.EQUALS));
        return filter;
    }

    private void getPurOrderGroupByCondition(Context ctx, String purgroupid, Object[] params) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(this.getPurOrderFilter(purgroupid, params));
        view.setSelector(this.getPurOrderSelector());
        PurOrderEntryCollection colls = PurOrderEntryFactory.getLocalInstance((Context)ctx).getPurOrderEntryCollection(view);
        StringBuffer purkey = new StringBuffer();
        for (int m = 0; m < colls.size(); ++m) {
            List<Object> objList;
            purkey.setLength(0);
            PurOrderEntryInfo purentry = colls.get(m);
            SonDirectDeliveryPlanPurEntryInfo sondirectinfo = new SonDirectDeliveryPlanPurEntryInfo();
            String materialid = purentry.getMaterial().getId().toString();
            String projectid = purentry.getProject() == null ? "" : purentry.getProject().getId().toString();
            String tracknumberid = purentry.getTrackNo() == null ? "" : purentry.getTrackNo().getId().toString();
            BigDecimal qty = purentry.getQty().subtract(purentry.getTotalReceiptQty());
            sondirectinfo.setMaterial(purentry.getMaterial());
            sondirectinfo.setOrderno(purentry.getParent().getNumber());
            sondirectinfo.setSeq(purentry.getSeq());
            sondirectinfo.setProject(purentry.getProject());
            sondirectinfo.setTracknumber(purentry.getTrackNo());
            sondirectinfo.setUnit(purentry.getUnit());
            sondirectinfo.setQty(qty);
            sondirectinfo.setRemainqty(qty);
            sondirectinfo.setPurentryid(purentry.getId().toString());
            sondirectinfo.setSupplier(purentry.getParent().getSupplier());
            purkey.append(materialid).append("@").append(projectid).append("@").append(tracknumberid);
            if (this.grouppurMap.get(purkey) != null) {
                objList = this.grouppurMap.get(purkey);
                objList.add(sondirectinfo);
                continue;
            }
            objList = new ArrayList<SonDirectDeliveryPlanPurEntryInfo>();
            objList.add(sondirectinfo);
            this.grouppurMap.put(purkey.toString(), objList);
        }
    }
}

