/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.qm.qc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.cm.util.SCMGroupClientUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.common.client.OprtState;
import com.kingdee.eas.industry.emm.common.utils.IndustryUIUtils;
import com.kingdee.eas.industry.emm.qm.qc.ClaimNoteFactory;
import com.kingdee.eas.industry.emm.qm.qc.ClaimNoteInfo;
import com.kingdee.eas.industry.emm.qm.qc.NCRreportFactory;
import com.kingdee.eas.industry.emm.qm.qc.NCRreportInfo;
import com.kingdee.eas.industry.emm.qm.qc.client.AbstractClaimNoteEditUI;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ClaimNoteEditUI
extends AbstractClaimNoteEditUI
implements DataChangeListener {
    private String RESOURCE_NAME = "com.kingdee.eas.industry.emm.qm.qc.NCRBizResource";
    private String SCM_GSPDLYYQTLXDNCRBG_BNXG = EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_GSPDLYYQTLXDNCRBG_BNXG");
    private String SCM_SPSL_ISNOTNULL = EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_SPSL_ISNOTNULL");
    private String SCM_FPSLBNDYNCRDJSL = EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_FPSLBNDYNCRDJSL");
    private String SCM_JHFHSJ_ISNOTNULL = EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_JHFHSJ_ISNOTNULL");
    private String SCM_JHPFSJ_ISNOTNULL = EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_JHPFSJ_ISNOTNULL");
    private String SCM_SPDSL = EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_SPDSL");
    private static final Logger logger = CoreUIObject.getLogger(ClaimNoteEditUI.class);
    private static final long serialVersionUID = 5107231190330355757L;
    protected static final BigDecimal ONE = new BigDecimal("1.0");
    CompanyOrgUnitInfo companyOrgInfo = null;
    ConvertModeEnum convertMode = ConvertModeEnum.DIRECTEXCHANGERATE;
    CurrencyInfo currencyHomeInfo = null;
    ExchangeRateInfo exchangeRateInfo = null;
    protected SelectorListener f7SelectorListener = null;

    public static String getResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)strKey);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        Boolean isFromOtherNCR = this.editData == null ? false : (this.editData.containsKey("isFromOtherNCR") ? (this.editData.get("isFromOtherNCR") == null ? false : (this.editData.get("isFromOtherNCR") instanceof Boolean ? (Boolean)this.editData.get("isFromOtherNCR") : false)) : false);
        if (isFromOtherNCR.booleanValue()) {
            MsgBox.showWarning((String)this.SCM_GSPDLYYQTLXDNCRBG_BNXG);
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        this.setOprtState(OprtState.EDIT);
        this.getMainOrgUnit().setAccessAuthority(0);
        this.getMainOrgUnit().setReadOnly(false);
        this.getMainOrgUnit().setEditable(true);
        if (this.editData.getSourceBillId() != null) {
            this.txtRejectQty.setEnabled(false);
            this.prmtAuditor.setEnabled(false);
            this.pkAuditTime.setEnabled(false);
            this.prmtModifier.setEnabled(false);
            this.pkModificationTime.setEnabled(false);
            this.prmtCreator.setEnabled(false);
            this.pkCreateTime.setEnabled(false);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.beforeDelete();
        super.actionRemove_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkEditData();
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkEditData();
        super.actionSubmit_actionPerformed(e);
    }

    public void beforeDelete() {
        BillTypeInfo billTypeInfo;
        if (!this.editData.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            MsgBox.showInfo((Component)((Object)this), (String)ClaimNoteEditUI.getResource("OrderIsNotSaveNotDel"));
            SysUtil.abort();
        }
        if (this.editData.getSourceBillType() != null && (billTypeInfo = this.editData.getSourceBillType()) != null && billTypeInfo.getNumber() != null && billTypeInfo.getNumber().equals("NCR")) {
            MsgBox.showInfo((String)ClaimNoteEditUI.getResource("isSourceNCRNotDel"));
            SysUtil.abort();
        }
    }

    public void checkEditData() {
        BigDecimal claimQty;
        if (this.prmtMaterial.getValue() == null) {
            this.prmtMaterial.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)ClaimNoteEditUI.getResource("ClaimMaterialIsNotNull"));
            SysUtil.abort();
        }
        if (this.prmtSupplier.getValue() == null) {
            this.prmtSupplier.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)ClaimNoteEditUI.getResource("ClaimSupplierIsNotNull"));
            SysUtil.abort();
        }
        if ((claimQty = (BigDecimal)this.txtClaimQty.getValue()) == null) {
            this.txtClaimQty.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.SCM_SPSL_ISNOTNULL);
            SysUtil.abort();
        }
        BigDecimal rejectQty = (BigDecimal)this.txtRejectQty.getValue();
        BigDecimal ncrQty = this.editData.getNcrQty();
        if (ncrQty != null && ncrQty.compareTo(BigDecimal.ZERO) > 0 && rejectQty.compareTo(ncrQty) > 0) {
            this.txtRejectQty.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)(this.SCM_FPSLBNDYNCRDJSL + ncrQty));
            SysUtil.abort();
        }
        if (this.pkPlanRetDate.getValue() == null) {
            this.pkPlanRetDate.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.SCM_JHFHSJ_ISNOTNULL);
            SysUtil.abort();
        }
        if (this.pkPlanSetDate.getValue() == null) {
            this.pkPlanSetDate.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)this.SCM_JHPFSJ_ISNOTNULL);
            SysUtil.abort();
        }
    }

    public void currencyChange(DataChangeEvent e) throws EASBizException, BOSException {
        CurrencyInfo newCurrencyInfo = (CurrencyInfo)e.getNewValue();
        CurrencyInfo oldCurrencyInfo = (CurrencyInfo)e.getOldValue();
        if (newCurrencyInfo == null || oldCurrencyInfo == null || newCurrencyInfo.equals((Object)oldCurrencyInfo)) {
            return;
        }
        this.setRateDisableWhenCurrencyIsHome();
        BigDecimal exchangeRate = null;
        if (this.currencyHomeInfo.getId().equals((Object)newCurrencyInfo.getId())) {
            exchangeRate = ONE;
            this.txtExchangeRate.setValue((Object)exchangeRate);
            this.txtExchangeRate.setPrecision(2);
        } else {
            ObjectUuidPK sourceCurrPK = null;
            ObjectUuidPK destCurrPK = null;
            sourceCurrPK = new ObjectUuidPK(newCurrencyInfo.getId());
            ExchangeRateInfo tempexRateInfo = SCMClientUtils.getExchangeRate((CompanyOrgUnitInfo)this.companyOrgInfo, (IObjectPK)sourceCurrPK, (IObjectPK)(destCurrPK = new ObjectUuidPK(this.currencyHomeInfo.getId())));
            if (tempexRateInfo != null) {
                this.exchangeRateInfo = tempexRateInfo;
                this.txtExchangeRate.setPrecision(this.exchangeRateInfo.getPrecision());
                this.txtExchangeRate.setValue((Object)this.exchangeRateInfo.getConvertRate());
                if (this.exchangeRateInfo != null && this.exchangeRateInfo.getExchangeAux() != null && this.exchangeRateInfo.getExchangeAux().getConvertMode() != null) {
                    this.convertMode = this.exchangeRateInfo.getExchangeAux().getConvertMode();
                }
            }
        }
    }

    public void dataChanged(DataChangeEvent e) {
        if (e.getSource().equals(this.prmtMaterial)) {
            this.materialChange();
        }
        if (e.getSource().equals(this.prmtCurrency)) {
            try {
                this.currencyChange(e);
            }
            catch (Exception e1) {
                this.handUIException(e1);
            }
        }
    }

    public KDBizPromptBox getMainOrgUnit() {
        return this.prmtPurchaseOrgUnit;
    }

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public String getOprtState() {
        if (this.oprtState == null) {
            this.oprtState = "ADDNEW";
        }
        return this.oprtState;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectItem = super.getSelectors();
        selectItem.add(new SelectorItemInfo("sourceBillId"));
        selectItem.add(new SelectorItemInfo("ncrQty"));
        selectItem.add(new SelectorItemInfo("isFromOtherNCR"));
        selectItem.add(new SelectorItemInfo("*"));
        return selectItem;
    }

    public void initControl() {
        PurchaseOrgUnitInfo purChaseOrg = (PurchaseOrgUnitInfo)this.prmtPurchaseOrgUnit.getValue();
        this.pkBizDate.setRequired(true);
        this.txtNumber.setRequired(true);
        this.f7Manager.registerBizMaterialF7(this.prmtMaterial, null, null, (OrgUnitInfo)purChaseOrg, false);
        this.prmtMaterial.setRequired(true);
        this.prmtSupplier.setDisplayFormat("$name$");
        this.prmtSupplier.setEditFormat("$name$");
        this.prmtSupplier.setRequired(true);
        this.f7Manager.registerBizSupplierF7(this.prmtSupplier, null, null, (OrgUnitInfo)purChaseOrg);
        this.prmtSupplier.setDisplayFormat("$name$");
        this.prmtSupplier.setEditFormat("$name$");
        if (this.getOprtState().equals("ADDNEW")) {
            if (this.editData.getNcrQty() == null) {
                this.txtRejectQty.setValue((Object)BigDecimal.ZERO);
            } else {
                this.txtRejectQty.setValue((Object)this.editData.getNcrQty());
            }
        }
        try {
            if (this.editData.getSourceBillId() != null) {
                StringBuilder sql = new StringBuilder();
                sql.append("/*dialect*/ select * from T_EMM_NCRreport");
                sql.append(" where fid = '").append("" + this.editData.getSourceBillId() + "'");
                IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                Object fid = null;
                while (rs.next()) {
                    if (rs.size() <= 0) continue;
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("project.*"));
                    NCRreportInfo ncrreportInfo = NCRreportFactory.getRemoteInstance().getNCRreportInfo((IObjectPK)new ObjectUuidPK(this.editData.getSourceBillId()), sic);
                    this.prmtPorject.setValue((Object)ncrreportInfo.getProject());
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        UIHelper.registerProjectF7ForEdit((KDBizPromptBox)this.prmtPurchaseOrgUnit, (KDBizPromptBox)this.prmtPurchaseOrgUnit, (KDBizPromptBox)this.prmtPorject);
        this.prmtPorject.setDisplayFormat("$number$");
        this.prmtPorject.setEnabled(false);
        this.txtRejectQty.setNegatived(false);
        this.txtRejectQty.setEnabled(false);
        this.contClaimQty.setBoundLabelText(this.SCM_SPDSL);
        this.txtClaimQty.setNegatived(false);
        this.txtClaimQty.setRequired(true);
        this.txtClaimAmount.setNegatived(false);
        this.txtClaimAmount.setPrecision(this.currencyHomeInfo.getPrecision());
        this.txtExchangeRate.setPrecision(this.currencyHomeInfo.getPrecision());
        this.pkPlanRetDate.setRequired(true);
        this.pkPlanSetDate.setRequired(true);
        this.prmtCreator.setQueryInfo("com.kingdee.eas.base.permission.app.F7UserQuery");
        this.prmtCreator.setDisplayFormat("$name$");
        this.prmtCreator.setEnabled(false);
        this.pkCreateTime.setEnabled(false);
        this.prmtModifier.setQueryInfo("com.kingdee.eas.base.permission.app.F7UserQuery");
        this.prmtModifier.setDisplayFormat("$name$");
        this.prmtModifier.setEnabled(false);
        this.pkModificationTime.setEnabled(false);
        this.prmtAuditor.setQueryInfo("com.kingdee.eas.base.permission.app.F7UserQuery");
        this.prmtAuditor.setDisplayFormat("$name$");
        this.prmtAuditor.setEnabled(false);
        this.pkAuditTime.setEnabled(false);
        for (Component comp : this.toolBar.getComponents()) {
            if ("generateBarcode".equals(comp.getName())) {
                comp.setVisible(false);
            }
            if (!"btnReservationQuery".equals(comp.getName())) continue;
            comp.setEnabled(false);
            comp.setVisible(false);
            this.toolBar.remove((Component)this.btnReservationQuery);
        }
    }

    public void initHomeCurrency() {
        CompanyOrgUnitInfo couInfo = null;
        try {
            couInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (couInfo == null) {
            return;
        }
        this.companyOrgInfo = couInfo;
        if (this.companyOrgInfo.getBaseCurrency() != null) {
            try {
                this.currencyHomeInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.companyOrgInfo.getBaseCurrency().getId()));
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public void initListener() {
        this.prmtMaterial.addDataChangeListener((DataChangeListener)this);
        this.prmtCurrency.addDataChangeListener((DataChangeListener)this);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initControl();
        if (this.getOprtState() == "ADDNEW") {
            this.pkModificationTime.setValue(null);
            this.pkAuditTime.setValue(null);
        } else {
            this.pkCreateTime.setValue((Object)this.editData.getCreateTime());
            this.pkModificationTime.setValue((Object)this.editData.getModificationTime());
            this.pkAuditTime.setValue((Object)this.editData.getAuditTime());
        }
    }

    public void materialChange() {
        if (this.prmtMaterial.getValue() == null) {
            this.txtMaterialName.setText(null);
            this.txtModel.setText(null);
            this.txtUnit.setText(null);
        }
        MaterialInfo materialInfo = (MaterialInfo)this.prmtMaterial.getValue();
        this.txtMaterialName.setText(materialInfo.getName());
        this.txtModel.setText(materialInfo.getModel());
        this.txtUnit.setText(materialInfo.getBaseUnit().getName());
    }

    public static boolean hasPermission(String permItemName, ObjectUuidPK orgIdPK) throws EASBizException, BOSException {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        return PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgIdPK, permItemName);
    }

    public void onLoad() throws Exception {
        IndustryUIUtils.put((CoreUIObject)this);
        this.initHomeCurrency();
        if (this.f7SelectorListener == null) {
            this.f7SelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        EntityViewInfo entityViewInfo = new EntityViewInfo();
                        FilterInfo filterInfo = new FilterInfo();
                        String pk_org = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
                        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pk_org, CompareType.NOTINCLUDE));
                        if (filterInfo.getFilterItems() != null && filterInfo.getFilterItems().size() > 0) {
                            entityViewInfo.setFilter(filterInfo);
                        }
                        KDBizPromptBox prmtorgUnit = (KDBizPromptBox)e.getSource();
                        prmtorgUnit.setEntityViewInfo(entityViewInfo);
                        prmtorgUnit.getQueryAgent().resetRuntimeEntityView();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
        }
        super.onLoad();
        if (this.editData != null && this.editData.getSourceBillId() != null) {
            this.txtRejectQty.setEnabled(false);
        }
        if (this.editData != null && this.editData.getSourceBillId() != null) {
            this.prmtPorject.setEnabled(false);
            this.txtRejectQty.setEnabled(false);
        } else {
            this.prmtPorject.setEnabled(true);
            this.txtRejectQty.setEnabled(true);
        }
        this.setPurchaseOrgFilterInfo();
    }

    public void removeListener() {
        this.prmtMaterial.removeDataChangeListener((DataChangeListener)this);
        this.prmtCurrency.removeDataChangeListener((DataChangeListener)this);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setRateDisableWhenCurrencyIsHome() {
        CurrencyInfo currentCurrencyInfo = (CurrencyInfo)this.prmtCurrency.getValue();
        if (currentCurrencyInfo != null && this.currencyHomeInfo != null) {
            if (currentCurrencyInfo.getName().equals(this.currencyHomeInfo.getName())) {
                this.txtExchangeRate.setEnabled(false);
            } else {
                this.txtExchangeRate.setEnabled(true);
            }
        }
    }

    protected IObjectValue createNewData() {
        ClaimNoteInfo claimNote = new ClaimNoteInfo();
        claimNote.setPurchaseOrgUnit((PurchaseOrgUnitInfo)this.getDefaultMainBizOrg());
        claimNote.setBaseStatus(BillBaseStatusEnum.ADD);
        claimNote.setBizDate(new Date());
        claimNote.setCurrency(this.currencyHomeInfo);
        claimNote.setExchangeRate(ONE);
        claimNote.setClaimAmount(SCMClientUtils.ZERO);
        return claimNote;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ClaimNoteFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return new KDTable();
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtPurchaseOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    private void setPurchaseOrgFilterInfo() throws EASBizException, BOSException {
        FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (String)"ClaimNote_addnew");
        PurchaseOrgUnitInfo info = null;
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            if (!PurchaseOrgUnitFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(collection.get(i).getId().toString())) || (info = PurchaseOrgUnitFactory.getRemoteInstance().getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(collection.get(i).getId().toString()))) == null || !info.isIsBizUnit()) continue;
            keys.add(collection.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(keys), CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtPurchaseOrgUnit.setEntityViewInfo(view);
    }
}

