/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.qm.qc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.qm.qc.AuditFlagEnum;
import com.kingdee.eas.industry.emm.qm.qc.NCRAuditPersonCollection;
import com.kingdee.eas.industry.emm.qm.qc.NCRAuditPersonFactory;
import com.kingdee.eas.industry.emm.qm.qc.NCRAuditPersonInfo;
import com.kingdee.eas.industry.emm.qm.qc.NCRAuditerCollection;
import com.kingdee.eas.industry.emm.qm.qc.NCRAuditerFactory;
import com.kingdee.eas.industry.emm.qm.qc.NCRAuditerInfo;
import com.kingdee.eas.industry.emm.qm.qc.NCRreportInfo;
import com.kingdee.eas.industry.emm.qm.qc.client.AbstractNCRAuditerSetUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class NCRAuditerSetUI
extends AbstractNCRAuditerSetUI {
    private static final Logger logger = CoreUIObject.getLogger(NCRAuditerSetUI.class);
    private String RESOURCE_NAME = "com.kingdee.eas.industry.emm.qm.qc.NCRBizResource";
    private String SCM_BCCG = EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_BCCG");
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String AUDITERID = "auditerId";
    public static final String AUDITEFLAG = "auditeFlag";
    public static final String AUDITENUM = "auditeNum";
    public static final String AUDITENAME = "auditeName";
    public static final String ISPASS = "isPass";
    public static final String AUDITEDESC = "auditeDesc";
    public static final String AUDITEDATE = "auditeDate";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void initListener() {
        super.initListener();
        BtnListener btnlistener = new BtnListener();
        this.btnAdd.addActionListener((ActionListener)btnlistener);
        this.btnDelete.addActionListener((ActionListener)btnlistener);
        this.btnSave.addActionListener((ActionListener)btnlistener);
        this.btnClose.addActionListener((ActionListener)btnlistener);
        this.btnQuery.addActionListener((ActionListener)btnlistener);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        Icon addIcon = EASResource.getIcon((String)"imgTbtn_move_right");
        this.btnAdd.setIcon(addIcon);
        Icon deleteIcon = EASResource.getIcon((String)"imgTbtn_move_left");
        this.btnDelete.setIcon(deleteIcon);
    }

    protected void addPersonAudite(ActionEvent e) {
        int size = this.kdtAuditerPerson.getSelectManager().size();
        PersonCollection personColl = new PersonCollection();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock block = this.kdtAuditerPerson.getSelectManager().get(i);
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                PersonInfo personInfo = (PersonInfo)this.kdtAuditerPerson.getCell(j, NAME).getValue();
                personColl.add(personInfo);
            }
        }
        PersonInfo personInfo = null;
        for (int i = 0; i < personColl.size(); ++i) {
            personInfo = personColl.get(i);
            boolean flag = false;
            for (int j = 0; j < this.kdtAuditerBill.getRowCount(); ++j) {
                BOSUuid auditeId = (BOSUuid)this.kdtAuditerBill.getCell(j, AUDITERID).getValue();
                if (!personInfo.getId().equals((Object)auditeId)) continue;
                flag = true;
            }
            if (flag) continue;
            IRow row = this.kdtAuditerBill.addRow();
            row.getCell(AUDITERID).setValue((Object)personInfo.getId());
            row.getCell(AUDITEFLAG).setValue((Object)AuditFlagEnum.UNAUDITE);
            row.getCell(AUDITENUM).setValue((Object)personInfo.getNumber());
            row.getCell(AUDITENAME).setValue((Object)personInfo);
            row.getCell(ISPASS).setValue((Object)false);
        }
    }

    protected void deletePersonAudite(ActionEvent e) {
        int i;
        int size = this.kdtAuditerBill.getSelectManager().size();
        ArrayList<Integer> listRow = new ArrayList<Integer>();
        for (i = 0; i < size; ++i) {
            KDTSelectBlock block = this.kdtAuditerBill.getSelectManager().get(i);
            for (int j = block.getBottom(); j >= block.getTop(); --j) {
                listRow.add(j);
            }
        }
        for (i = 0; i < listRow.size(); ++i) {
            this.kdtAuditerBill.removeRow(Integer.parseInt(listRow.get(i).toString()));
        }
    }

    protected void saveAuditer(ActionEvent e) {
        NCRreportInfo ncrreportInfo = (NCRreportInfo)this.getUIContext().get("ncrreportInfo");
        CoreBaseCollection ncrAuditerColl = new CoreBaseCollection();
        HashSet<String> pkList = new HashSet<String>();
        for (int i = 0; i < this.kdtAuditerBill.getRowCount(); ++i) {
            IRow curRow = this.kdtAuditerBill.getRow(i);
            BOSUuid id = (BOSUuid)curRow.getCell(ID).getValue();
            NCRAuditerInfo ncrAuditerInfo = new NCRAuditerInfo();
            ncrAuditerInfo.setNcrReport(ncrreportInfo);
            if (id != null) {
                ncrAuditerInfo.setId(id);
                pkList.add(id.toString());
            }
            ncrAuditerInfo.setAuditer((PersonInfo)curRow.getCell(AUDITENAME).getValue());
            ncrAuditerInfo.setAuditFlag((AuditFlagEnum)((Object)curRow.getCell(AUDITEFLAG).getValue()));
            ncrAuditerInfo.setIsPass((Boolean)curRow.getCell(ISPASS).getValue());
            ncrAuditerInfo.setDescription((String)curRow.getCell(AUDITEDESC).getValue());
            ncrAuditerInfo.setAuditeDate((Timestamp)curRow.getCell(AUDITEDATE).getValue());
            ncrAuditerColl.add((CoreBaseInfo)ncrAuditerInfo);
        }
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("ncrReport.number", (Object)ncrreportInfo.getNumber(), CompareType.INCLUDE));
            if (pkList.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo(ID, pkList, CompareType.NOTINCLUDE));
            }
            NCRAuditerFactory.getRemoteInstance().delete(filter);
            NCRAuditerFactory.getRemoteInstance().save(ncrAuditerColl);
            MsgBox.showInfo((Component)((Object)this), (String)this.SCM_BCCG);
            SysUtil.abort();
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
    }

    protected void closeWindow(ActionEvent e) {
        this.getUIWindow().close();
    }

    protected void queryBill(ActionEvent e) {
        try {
            String name;
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo(ID));
            sic.add(new SelectorItemInfo("person.*"));
            viewInfo.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            String number = this.txtNumber.getText();
            if (number != null && !number.equals("")) {
                filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + number + "%"), CompareType.LIKE));
            }
            if ((name = this.txtName.getText()) != null && !name.equals("")) {
                filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + name + "%"), CompareType.LIKE));
            }
            viewInfo.setFilter(filter);
            NCRAuditPersonCollection ncrAuditPerColl = NCRAuditPersonFactory.getRemoteInstance().getNCRAuditPersonCollection(viewInfo);
            this.kdtAuditerPerson.removeRows();
            for (int i = 0; i < ncrAuditPerColl.size(); ++i) {
                NCRAuditPersonInfo ncrAuditPerInfo = ncrAuditPerColl.get(i);
                PersonInfo personInfo = ncrAuditPerInfo.getPerson();
                IRow row = this.kdtAuditerPerson.addRow();
                row.getCell(ID).setValue((Object)personInfo.getId());
                row.getCell(NUMBER).setValue((Object)personInfo.getNumber());
                row.getCell(NAME).setValue((Object)personInfo);
            }
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initData();
    }

    public void initData() throws BOSException {
        this.kdtAuditerPerson.getSelectManager().setSelectMode(10);
        this.kdtAuditerPerson.getColumn(ID).getStyleAttributes().setLocked(true);
        this.kdtAuditerPerson.getColumn(NUMBER).getStyleAttributes().setLocked(true);
        this.kdtAuditerPerson.getColumn(NAME).getStyleAttributes().setLocked(true);
        this.kdtAuditerBill.getSelectManager().setSelectMode(10);
        this.kdtAuditerBill.getColumn(AUDITERID).getStyleAttributes().setLocked(true);
        this.kdtAuditerBill.getColumn(AUDITEFLAG).getStyleAttributes().setLocked(true);
        this.kdtAuditerBill.getColumn(AUDITENUM).getStyleAttributes().setLocked(true);
        this.kdtAuditerBill.getColumn(AUDITENAME).getStyleAttributes().setLocked(true);
        this.kdtAuditerBill.getColumn(ISPASS).getStyleAttributes().setLocked(true);
        this.kdtAuditerBill.getColumn(AUDITEDESC).getStyleAttributes().setLocked(true);
        this.kdtAuditerBill.getColumn(AUDITEDATE).getStyleAttributes().setLocked(true);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(ID));
        sic.add(new SelectorItemInfo("person.*"));
        viewInfo.setSelector(sic);
        NCRAuditPersonCollection ncrAuditPerColl = NCRAuditPersonFactory.getRemoteInstance().getNCRAuditPersonCollection(viewInfo);
        for (int i = 0; i < ncrAuditPerColl.size(); ++i) {
            NCRAuditPersonInfo ncrAuditPerInfo = ncrAuditPerColl.get(i);
            PersonInfo personInfo = ncrAuditPerInfo.getPerson();
            IRow row = this.kdtAuditerPerson.addRow();
            row.getCell(ID).setValue((Object)personInfo.getId());
            row.getCell(NUMBER).setValue((Object)personInfo.getNumber());
            row.getCell(NAME).setValue((Object)personInfo);
        }
        NCRreportInfo ncrreportInfo = (NCRreportInfo)this.getUIContext().get("ncrreportInfo");
        EntityViewInfo aviewInfo = new EntityViewInfo();
        SelectorItemCollection asic = new SelectorItemCollection();
        asic.add(new SelectorItemInfo(ID));
        asic.add(new SelectorItemInfo("auditer.id"));
        asic.add(new SelectorItemInfo("auditer.number"));
        asic.add(new SelectorItemInfo("auditer.name"));
        asic.add(new SelectorItemInfo("ncrReport.id"));
        asic.add(new SelectorItemInfo("auditFlag"));
        asic.add(new SelectorItemInfo(ISPASS));
        asic.add(new SelectorItemInfo(AUDITEDATE));
        asic.add(new SelectorItemInfo("description"));
        aviewInfo.setSelector(asic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ncrReport.id", (Object)ncrreportInfo.getId()));
        aviewInfo.setFilter(filter);
        NCRAuditerCollection ncrAuditerColl = NCRAuditerFactory.getRemoteInstance().getNCRAuditerCollection(aviewInfo);
        for (int i = 0; i < ncrAuditerColl.size(); ++i) {
            NCRAuditerInfo ncrAuditerInfo = ncrAuditerColl.get(i);
            IRow row = this.kdtAuditerBill.addRow();
            row.getCell(ID).setValue((Object)ncrAuditerInfo.getId());
            row.getCell(AUDITERID).setValue((Object)ncrAuditerInfo.getAuditer().getId());
            row.getCell(AUDITEFLAG).setValue((Object)ncrAuditerInfo.getAuditFlag());
            row.getCell(AUDITENUM).setValue((Object)ncrAuditerInfo.getAuditer().getNumber());
            row.getCell(AUDITENAME).setValue((Object)ncrAuditerInfo.getAuditer());
            row.getCell(ISPASS).setValue((Object)ncrAuditerInfo.isIsPass());
            row.getCell(AUDITEDESC).setValue((Object)ncrAuditerInfo.getDescription());
            row.getCell(AUDITEDATE).setValue((Object)ncrAuditerInfo.getAuditeDate());
        }
        String str = (String)this.getUIContext().get("readOnly");
        if (str != null) {
            this.btnSave.setVisible(false);
            this.btnClose.setVisible(false);
        }
    }

    private class BtnListener
    implements ActionListener {
        private BtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(NCRAuditerSetUI.this.btnAdd)) {
                NCRAuditerSetUI.this.addPersonAudite(e);
            }
            if (e.getSource().equals(NCRAuditerSetUI.this.btnDelete)) {
                NCRAuditerSetUI.this.deletePersonAudite(e);
            }
            if (e.getSource().equals(NCRAuditerSetUI.this.btnSave)) {
                NCRAuditerSetUI.this.saveAuditer(e);
            }
            if (e.getSource().equals(NCRAuditerSetUI.this.btnClose)) {
                NCRAuditerSetUI.this.closeWindow(e);
            }
            if (e.getSource().equals(NCRAuditerSetUI.this.btnQuery)) {
                NCRAuditerSetUI.this.queryBill(e);
            }
        }
    }
}

